<?php
// $Id: content_typed.class.php,v 1.13 2004/02/04 23:23:46 rcastley Exp $
/**
* Administrator menu typed content event handler
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License: http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.13 $
**/

// ensure this file is being included by a parent file
defined( '_VALID_MOS' ) or die( '      ' );

/**
*/
class content_typed_menu {
	/**
	* Compiles information to add or edit content
	* @param database A database connector object
	* @param string The name of the category section
	* @param integer The unique id of the category to edit (0 if new)
	*/
	function edit( $uid, $menutype, $option ) {
		global $database, $my, $acl;
		global $mosConfig_absolute_path, $mosConfig_live_site;

		$menu = new mosMenu( $database );
		$menu->load( $uid );

		$row = new mosContent( $database );
		// load the row from the db table
		$row->load( $menu->componentid );

		// fail if checked out not by 'me'
		if ($row->checked_out && $row->checked_out <> $my->id) {
			echo "<script>alert('The module $row->title is currently being edited by another administrator'); document.location.href='index2.php?option=$option'</script>\n";
			exit(0);
		}

		$lists = array();

		if ($uid) {
			$row->checkout( $my->id );
			$menu->checkout( $my->id );
			if (trim( $row->images )) {
				$row->images = explode( "\n", $row->images );
			} else {
				$row->images = array();
			}
			if (trim( $row->publish_down ) == "0000-00-00 00:00:00") {
				$row->publish_down = " ";
			}
			$row->ordering = $menu->ordering;
		} else {
			// initialise values for a new item
			$row->version = 0;
			$row->state = 0;
			$row->images = array();
			$row->publish_up = date( "Y-m-d", time() );
			$row->publish_down = " ";

			$menu->type = 'content_typed';
			$menu->menutype = $menutype;
			$menu->parent = intval( mosGetParam( $_POST, 'parent', 0 ) );
			$menu->ordering = 9999;
		}

		// get list of images
		$imgFiles = mosReadDirectory( "$mosConfig_absolute_path/images/stories" );
		$images = array();
		$folders = array();
		$folders[] = mosHTML::makeOption( "/" );
		foreach ($imgFiles as $file) {
			if (is_dir( "$mosConfig_absolute_path/images/stories/$file" )) {
				$folders[] = mosHTML::makeOption( "/$file" );
				$folder = mosReadDirectory( "$mosConfig_absolute_path/images/stories/$file" );
				foreach ($folder as $file2) {
					if (eregi( "bmp|gif|jpg|png", $file2 )
							&& is_file( "$mosConfig_absolute_path/images/stories/$file/$file2" )) {
						$images["/$file"][] = mosHTML::makeOption( "$file/$file2" );
					}
				}

			} else if (eregi( "bmp|gif|jpg|png", $file )
					&& is_file( "$mosConfig_absolute_path/images/stories/$file" )) {
				$images['/'][] = mosHTML::makeOption( $file );
			}
		}

		$lists['imagefiles'] = mosHTML::selectList( $images['/'], 'imagefiles', "class=\"inputbox\" size=\"10\" multiple=\"multiple\""
		. " onchange=\"previewImage('imagefiles','view_imagefiles','$mosConfig_live_site/images/stories/')\"",
		'value', 'text', null );

		$lists['folders'] = mosHTML::selectList( $folders, 'folders', "class=\"inputbox\" size=\"1\" "
		."onchange=\"changeDynaList('imagefiles',folderimages, document.adminForm.folders.options[document.adminForm.folders.selectedIndex].value, 0, 0)\"",
		'value', 'text', '/' );

		// make the list of saved images
		$images2 = array();
		foreach ($row->images as $file) {
			$temp = explode( '|', $file );
			$images2[] = mosHTML::makeOption( $file, $temp[0] );
		}

		$lists['imagelist'] = mosHTML::selectList( $images2, 'imagelist', "class=\"inputbox\" size=\"10\""
		. " onchange=\"showImageProps('$mosConfig_live_site/images/stories/')\"",
		'value', 'text', null );

		// make the select list for the image positions
		$pos[] = mosHTML::makeOption( 'left' );
		$pos[] = mosHTML::makeOption( 'center' );
		$pos[] = mosHTML::makeOption( 'right' );

		// build the html select list
		$lists['_align'] = mosHTML::selectList( $pos, '_align', 'class="inputbox" size="3"',
		'value', 'text', null );

		// get list of groups
		$database->setQuery( "SELECT id AS value, name AS text FROM #__groups ORDER BY id" );
		$groups = $database->loadObjectList();

		// build the html select list
		$lists['access'] = mosHTML::selectList( $groups, 'access', 'class="inputbox" size="1"',
		'value', 'text', intval( $row->access ) );
		/* This is how it will be done in the future
		$groups = $acl->get_group_children_tree( null, 'Public Frontend', true );
		$lists['access'] = mosHTML::selectList( $groups, 'access', 'class="inputbox" size="1"', 'value', 'text', intval( $row->access ) );
		*/

		// build the html select list for ordering
		if ($uid) {
			// build the html select list for ordering
			$order = mosGetOrderingList( "SELECT ordering AS value, name AS text"
				. "\nFROM #__menu"
				. "\nWHERE menutype='$menu->menutype' AND parent='$menu->parent'"
				. "\nORDER BY ordering"
			);
			$lists['ordering'] = mosHTML::selectList( $order, 'ordering', 'class="inputbox" size="1"',
			'value', 'text', intval( $row->ordering ) );
		} else {
			$lists['ordering'] = "<input type=\"hidden\" name=\"ordering\" value=\"$menu->ordering\" />"
			. "      ";
		}

		// menu parent item
		// get a list of the menu items
		$database->setQuery( "SELECT m.*"
		. "\nFROM #__menu m"
		. "\nWHERE menutype='$menu->menutype'"
		. "\nORDER BY ordering"
		);
		$mitems = $database->loadObjectList();

		// establish the hierarchy of the menu
		$children = array();
		// first pass - collect children
		foreach ($mitems as $v ) {
			$pt = $v->parent;
			$list = @$children[$pt] ? $children[$pt] : array();
			array_push( $list, $v );
			$children[$pt] = $list;
		}
		// second pass - get an indent list of the items
		$list = mosTreeRecurse( 0, '', array(), $children );

		// assemble menu items to the array
		$mitems = array();
		$mitems[] = mosHTML::makeOption( '0', '' );
		$this_treename = '';
		foreach ($list as $item) {
			if ($this_treename) {
				if ($item->id != $menu->id && strpos( $item->treename, $this_treename ) === false) {
					$mitems[] = mosHTML::makeOption( $item->id, $item->treename );
				}
			} else {
				if ($item->id != $menu->id) {
					$mitems[] = mosHTML::makeOption( $item->id, $item->treename );
				} else {
					$this_treename = "$item->treename/";
				}
			}
		}

		// build the html select list
		$lists['parent'] = mosHTML::selectList( $mitems, 'parent', 'class="inputbox" size="1"',
		'value', 'text', $menu->parent );

		if ($uid) {
			$database->setQuery( "SELECT name from #__users"
			. "\nWHERE id=$row->created_by"
			);
			$row->creator = $database->loadResult();
			$database->setQuery( "SELECT name from #__users"
			. "\nWHERE id=$row->modified_by"
			);
			$row->modifier = $database->loadResult();
		} else {
			$row->creator = '';
			$row->modifier = '';
		}

		content_menu_html::edit( $menu, $row, $images, $lists, $my->id, $option );
	}

	/**
	* Saves the content item an edit form submit
	* @param database A database connector object
	*/
	function save( $option ) {
		global $database, $my;

		$row = new mosContent( $database );
		if (!$row->bind( $_POST )) {
			echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
			exit();
		}

		$isNew = false;
		if ($row->id) {
			$row->modified = date( "Y-m-d H:i:s" );
			$row->modified_by = $my->id;
		} else {
			$isNew = true;
			$row->created = date( "Y-m-d H:i:s" );
			$row->created_by = $my->id;
		}
		if (trim( $row->publish_down ) == "Never") {
			$row->publish_down = "0000-00-00 00:00:00";
		}

		if (!$row->check()) {
			echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
			exit();
		}
		if (!$row->store()) {
			echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
			exit();
		}
		$row->checkin();
		//$row->updateOrder();

		$menuid = mosGetParam( $_REQUEST, 'menuid', 0 );
		$menu = new mosMenu( $database );
		$menu->load( $menuid );

		// inherit/synchonise some properties from the content form
		$menu->name = mosGetParam( $_REQUEST, 'name', 'No Name' );
		if (get_magic_quotes_gpc()) {
			$menu->name = stripslashes( $menu->name );
		}

		$menu->link = "index.php?option=content&task=view&id=$row->id";
		$menu->componentid = $row->id;
		$menu->ordering = $isNew ? 9999 : $row->ordering;
		$menu->menutype = mosGetParam( $_REQUEST, 'menutype', '' );;
		$menu->parent = mosGetParam( $_REQUEST, 'parent', 0 );;
		$menu->type = 'content_typed';
		$menu->access = $row->access;

		if ($menu->parent) {
			$pmenu = new MosMenu( $database );
			$pmenu->load( $menu->parent );
			$menu->sublevel = $pmenu->sublevel + 1;
		} else {
			$menu->sublevel = 0;
		}


		if (!$menu->check()) {
			echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
			exit();
		}
		if (!$menu->store()) {
			echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
			exit();
		}
		$menu->checkin();

		$menu->updateOrder( "parent='$menu->parent' AND menutype='$menu->menutype'" );

		mosRedirect( "index2.php?option=$option&menutype=$menu->menutype" );
	}

	/**
	* Publishes a content item refered to by a menu object
	*/
	function publish( &$menu, $publish=1 ) {
		global $database;

		if ($menu->componentid) {
			$item = new mosContent( $database );
			$item->load( $menu->componentid );
			$item->state = intval( $publish );

			if (!$item->check()) {
				return $item->getError();
			}
			if (!$item->store()) {
				return $item->getError();
			}
		}
		return null;
	}

	/**
	*/
	function remove( &$menu ) {
		global $database;

		if ($menu->componentid) {
			$item = new mosContent( $database );
			if (!$item->delete( $menu->componentid )) {
				return $item->getError();
			}
		}
		return null;
	}
}
?>
