<?php
// $Id: content_category.class.php,v 1.6 2004/03/04 23:02:13 eddieajau Exp $
/**
* Administrator menu content section class
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License: http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.6 $
**/

// ensure this file is being included by a parent file
defined( '_VALID_MOS' ) or die( '      ' );

/**
*/
class content_category_menu {
/**
* @param database A database connector object
* @param integer The unique id of the category to edit (0 if new)
*/
	function editCategory( $id, $menutype, $option ) {
		global $database, $my;
		global $mosConfig_absolute_path;

		$menu = new mosMenu( $database );
		$menu->load( $id );

		// fail if checked out not by 'me'
		if ($menu->checked_out && $menu->checked_out <> $my->id) {
			echo "<script>alert('The module $menu->title is currently being edited by another administrator'); document.location.href='index2.php?option=$option'</script>\n";
			exit(0);
		}

		if ($id) {
			$menu->checkout( $my->id );
		} else {
			$menu->type = 'content_category';
			$menu->menutype = $menutype;
			$menu->ordering = 9999;
			$menu->parent = intval( mosGetParam( $_POST, 'parent', 0 ) );
		}

	// build the html select list for ordering
		if ($id) {
			$order = mosGetOrderingList( "SELECT ordering AS value, name AS text"
				. "\nFROM #__menu"
				. "\nWHERE menutype='$menu->menutype' AND parent='$menu->parent'"
				. "\nORDER BY ordering"
			);
			$olist = mosHTML::selectList( $order, 'ordering', 'class="inputbox" size="1"',
				'value', 'text', intval( $menu->ordering ) );
		} else {
			$olist = "<input type=\"hidden\" name=\"ordering\" value=\"$menu->ordering\" />"
				. "      ";
		}

	// build the html select list for section/caetgory
		$database->setQuery( "SELECT c.id AS `value`, c.section AS `id`, "
			. "\n	CONCAT_WS('/',s.title,c.title) AS `text`"
			. "\nFROM #__sections AS s"
			. "\nINNER JOIN #__categories AS c ON c.section = s.id"
			. "\nWHERE s.scope='content'"
			. "\nORDER BY s.name,c.name"
		);
		$rows = $database->loadObjectList();

		// build the html select list
		$sectCatList = mosHTML::selectList( $rows, 'componentid', 'class="inputbox" size="8"',
		'value', 'text', $menu->componentid );

	// get list of groups
		$database->setQuery( "SELECT id AS value, name AS text FROM #__groups ORDER BY id" );
		$groups = $database->loadObjectList();

	// build the html select list for the group access
		$glist = mosHTML::selectList( $groups, 'access', 'class="inputbox" size="5"',
			'value', 'text', intval( $menu->access ) );

	// menu parent item
	// get a list of the menu items
		$database->setQuery( "SELECT m.*"
			. "\nFROM #__menu m"
			. "\nWHERE menutype='$menu->menutype'"
			. "\nORDER BY ordering"
		);
		$mitems = $database->loadObjectList();

	// establish the hierarchy of the menu
		$children = array();
	// first pass - collect children
		foreach ($mitems as $v ) {
			$pt = $v->parent;
			$list = @$children[$pt] ? $children[$pt] : array();
			array_push( $list, $v );
			$children[$pt] = $list;
		}
	// second pass - get an indent list of the items
		$list = mosTreeRecurse( 0, '', array(), $children );

	// assemble menu items to the array
		$mitems = array();
		$mitems[] = mosHTML::makeOption( '0', '' );
		$this_treename = '';
		foreach ($list as $item) {
			if ($this_treename) {
				if ($item->id != $menu->id && strpos( $item->treename, $this_treename ) === false) {
					$mitems[] = mosHTML::makeOption( $item->id, $item->treename );
				}
			} else {
				if ($item->id != $menu->id) {
					$mitems[] = mosHTML::makeOption( $item->id, $item->treename );
				} else {
					$this_treename = "$item->treename/";
				}
			}
		}

	// build the html select list
		$parlist = mosHTML::selectList( $mitems, 'parent', 'class="inputbox" size="1"',
			'value', 'text', $menu->parent );

		content_category_menu_html::editCategory( $menu, $sectCatList, $olist, $glist, $parlist, $option );
	}
}
?>