<?php
// $Id: components.class.php,v 1.7 2003/12/15 04:01:18 eddieajau Exp $
/**
* Administrator menu component item class
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License: http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.7 $
**/

// ensure this file is being included by a parent file
defined( '_VALID_MOS' ) or die( '      ' );

/**
*/
class components_menu {
/**
* @param database A database connector object
* @param integer The unique id of the category to edit (0 if new)
*/
	function edit( $uid, $menutype, $option ) {

		global $database, $my;
		global $mosConfig_absolute_path;

		$menu = new mosMenu( $database );
		$menu->load( $uid );

		$row = new mosContent( $database );
		// load the row from the db table
		$row->load( $menu->componentid );

		$lists = array();

		// fail if checked out not by 'me'
		if ($menu->checked_out && $menu->checked_out <> $my->id) {
			echo "<script>alert('The module $menu->title is currently being edited by another administrator'); document.location.href='index2.php?option=$option'</script>\n";
			exit(0);
		}

		if ($uid) {
			// do stuff for existing item
			$menu->checkout( $my->id );

		} else {
			// do stuff for new item
			$menu->type = 'components';
			$menu->menutype = $menutype;
			$menu->browserNav = 0;
			$menu->ordering = 9999;
			$menu->parent = intval( mosGetParam( $_POST, 'parent', 0 ) );
		}

	// build the html select list for ordering
		if ($uid) {
			$order = mosGetOrderingList( "SELECT ordering AS value, name AS text"
				. "\nFROM #__menu"
				. "\nWHERE menutype='$menu->menutype' AND parent='$menu->parent'"
				. "\nORDER BY ordering"
			);
			$lists['ordering'] = mosHTML::selectList( $order, 'ordering', 'class="inputbox" size="1"',
				'value', 'text', intval( $menu->ordering ) );
		} else {
			$lists['ordering'] = "<input type=\"hidden\" name=\"ordering\" value=\"$menu->ordering\" />"
			. "      ";
		}

	// get list of groups
		$database->setQuery( "SELECT id AS value, name AS text FROM #__groups ORDER BY id" );
		$groups = $database->loadObjectList();

	// build the html select list for the group access
		$lists['access'] = mosHTML::selectList( $groups, 'access', 'class="inputbox" size="5"',
			'value', 'text', intval( $menu->access ) );

	// get list of UNUSED components in menu
		$database->setQuery( "SELECT c.id AS value, c.name AS text,c.link from #__components as c "
				."\nLEFT JOIN #__menu as m ON ((c.id = m.componentid) AND m.type = 'components')"
				."\nWHERE componentid is NULL AND TRIM(c.link) <> '' ORDER BY c.name"
		);
		$types = $database->loadObjectList();

// add current component to list
		if ($menu->id > 0) {
			$database->setQuery( "SELECT c.id AS value, c.name AS text,c.link from #__components as c "
				."\nLEFT JOIN #__menu as m ON ((c.id = m.componentid) AND m.type = 'components')"
				."\nWHERE m.id= $menu->id"
			);
		$types = array_merge( $types,$database->loadObjectList() );
		}

		// fail if no more components available
		if (count($types) == 0) {
			echo "<script>alert('    '); document.location.href='index2.php?option=$option'</script>\n";
			exit(0);
		}

	// build the html select list for the components
		$lists['componentid'] = '';
		if ($uid) {
			// existing component, just show name
			foreach ($types as $type) {
				if ($type->value == $menu->componentid) {
					$lists['componentid'] = "$type->text";
				}
			}
			$lists['componentid'] .= " <input type=\"hidden\" name=\"componentid\" value=\"$menu->componentid\" />";
		} else {
			$lists['componentid'] = mosHTML::selectList( $types, 'componentid', 'class="inputbox" size="5"',
				'value', 'text', intval( $menu->componentid ) );
		}
	// get a list of the menu items
		$database->setQuery( "SELECT m.*"
			. "\nFROM #__menu m"
			. "\nWHERE menutype='$menu->menutype'"
			. "\nORDER BY ordering"
		);
		$mitems = $database->loadObjectList();

	// establish the hierarchy of the menu
		$children = array();
	// first pass - collect children
		foreach ($mitems as $v ) {
			$pt = $v->parent;
			$list = @$children[$pt] ? $children[$pt] : array();
			array_push( $list, $v );
			$children[$pt] = $list;
		}
	// second pass - get an indent list of the items
		$list = mosTreeRecurse( 0, '', array(), $children );

	// assemble menu items to the array
		$mitems = array();
		$mitems[] = mosHTML::makeOption( '0', '' );
		$this_treename = '';
		foreach ($list as $item) {
			if ($this_treename) {
				if ($item->id != $menu->id && strpos( $item->treename, $this_treename ) === false) {
					$mitems[] = mosHTML::makeOption( $item->id, $item->treename );
				}
			} else {
				if ($item->id != $menu->id) {
					$mitems[] = mosHTML::makeOption( $item->id, $item->treename );
				} else {
					$this_treename = "$item->treename/";
				}
			}
		}
	// build the html select list
		$lists['parent'] = mosHTML::selectList( $mitems, 'parent', 'class="inputbox" size="1"',
			'value', 'text', $menu->parent );

		components_menu_html::edit( $menu, $types, $lists, $option );
	}
}
?>
