<?php
// $Id: admin.massmail.php,v 1.15 2003/12/15 23:51:09 eddieajau Exp $
/**
* Administrator mass mail event handler
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License: http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.15 $
**/

// ensure this file is being included by a parent file
defined( '_VALID_MOS' ) or die( '      ' );

// ensure user has access to this function
if (!$acl->acl_check( 'administration', 'manage', 'users', $my->usertype, 'components', 'com_massmail' )) {
	mosRedirect( 'index2.php', _NOT_AUTH );
}

require_once( $mainframe->getPath( 'admin_html' ) );

switch ($task) {
	case 'send':
		sendMail();
		break;

	case 'cancel':
		mosRedirect( "index2.php" );
		break;

	default:
		messageForm( $option );
		break;
}

function messageForm( $option ) {
	global $database, $acl;

	$gtree = array(
		mosHTML::makeOption( 0, '- All User Groups -' )
	);

	// get list of groups
	$lists = array();
	$gtree = array_merge( $gtree, $acl->get_group_children_tree( null, 'USERS', false ) );
	$lists['gid'] = mosHTML::selectList( $gtree, 'mm_group', 'size="10"', 'value', 'text', 0 );

	HTML_massmail::messageForm( $lists, $option );
}

function sendMail() {
	global $database, $my, $acl, $mosDebug;
	global $mosConfig_sitename, $mosConfig_debug;

	$n=0;
	$message	= mosGetParam( $_POST, "mm_message", '' );
	$subject	= mosGetParam( $_POST, "mm_subject", '' );
	$gou		= mosGetParam( $_POST, "mm_group", null );
	$recurse	= mosGetParam( $_POST, "mm_recurse", "NO_RECURSE" );

	if (!$message || !$subject || $gou === null) {
		mosRedirect( "index2.php?option=com_massmail&mosmsg=Please fill in the form correctly" );
	}

	// get users in the group out of the acl
	$to = $acl->get_group_objects( $gou, 'ARO', $recurse );

	$rows = array();
	if (count( $to['users'] ) || $gou === '0') {
		// Get sending email address
		$database->setQuery( "SELECT email FROM #__users WHERE id='$my->id'" );
		$my->email = $database->loadResult();
		echo $database->getErrorMsg();

		// Get all users email and group except for senders
		$database->setQuery( "SELECT email FROM #__users"
			. "\nWHERE id != '$my->id'"
			. ($gou !== '0' ? " AND id IN (" . implode( ',', $to['users'] ) . ")" : "")
		);
		$rows = $database->loadObjectList();
		echo $database->getErrorMsg();
		$mosDebug->message( "SQL=" . $database->getQuery(), false );
		$mosDebug->showvar( $rows );

		// Build e-mail message format
		$headers = "";
		$message = "This is a mail from ".$mosConfig_sitename."\r \n \r \nMessage:\r \n".stripslashes($message);
		$subject = $mosConfig_sitename." :: ".stripslashes($subject);
		$headers .= "From: ".$mosConfig_sitename." <".$my->email.">\r\n";
		$headers .= "Reply-To: ".$mosConfig_sitename." <".$my->email.">\r\n";
		$headers .= "X-Priority: 3\r\n";
		$headers .= "X-MSMail-Priority: Low\r\n";
		$headers .= "X-Mailer: Mambo Open Source 4.5\r\n";

		//Send email
		foreach ($rows as $row) {
			$mosDebug->message( "Email sent to: [$row->email]" );
			mail( $row->email, $subject, $message, $headers );
		}
	}
	mosRedirect( "index2.php", "E-mail sent to ".count( $rows )." users" );
}
?>
