<?php
// $Id: admin.admisc.html.php,v 1.23 2004/01/13 00:57:16 eddieajau Exp $
/**
* Admin miscellaneous functions presentation layer
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License: http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.23 $
**/

class HTML_admin_misc {
	function system_info( $version, $option ) {
		global $mosConfig_editor, $mosConfig_absolute_path;
		$tab = mosGetParam( $_REQUEST, 'tab', 'tab1' );
		$width = 400;	// width of 100%

		function get_php_setting($val) {
			$r =  (ini_get($val) == '1' ? 1 : 0);
			return $r ? 'ON' : 'OFF';
		}

		function get_server_software() {
			if (isset($_SERVER['SERVER_SOFTWARE'])) {
				return $_SERVER['SERVER_SOFTWARE'];
			} else if (($sf = getenv('SERVER_SOFTWARE'))) {
				return $sf;
			} else {
				return 'n/a';
			}
		}
?>

<table dir=rtl cellpadding="4" cellspacing="0" border="0" width="100%">
  <tr>
    <td width="100%" class="sectionname"><img src="images/mos_gel.png" width="70" height="67" align="middle"> </td>
  </tr>
</table>
<script language="javascript" src="js/dhtml.js"></script>
<table dir=rtl cellpadding="3" cellspacing="0" border="0" width="100%">
  <tr>
    <td width="" class="tabpadding">&nbsp;</td>
    <td id="tab1" class="offtab" onClick="dhtml.cycleTab(this.id)"> </td>
    <td id="tab2" class="offtab" onClick="dhtml.cycleTab(this.id)"> PHP</td>
    <td width="90%" class="tabpadding">&nbsp;</td>
  </tr>
</table>
<div id="page1" class="pagetext">
  <table cellpadding="4" cellspacing="0" border="0" width="100%" class="adminform">
    <tr>
      <th colspan="2">System Information</th>
    </tr>
    <tr>
      <td valign="top" width="250"><b>PHP built On:</b></td>
      <td><?php echo php_uname(); ?></td>
    </tr>
    <tr>
      <td><b>Database Version:</b></td>
      <td><?php echo mysql_get_server_info(); ?> </tr>
    <tr>
      <td><b>PHP Version:</b></td>
      <td><?php echo phpversion(); ?></td>
    </tr>
    <tr>
      <td><b>Web Server:</b></td>
      <td><?php echo get_server_software(); ?></td>
    </tr>
    <tr>
      <td><b>WebServer to PHP interface:</b></td>
      <td><?php echo php_sapi_name(); ?></td>
    </tr>
    <tr>
      <td><b>Mambo Open Source Version:</b></td>
      <td><?php echo $version; ?></td>
    </tr>
    <tr>
      <td><b>User Agent:</b></td>
      <td><?php echo phpversion() <= "4.2.1" ? getenv( "HTTP_USER_AGENT" ) : $_SERVER['HTTP_USER_AGENT'];?></td>
    </tr>
    <tr>
      <td valign="top"><b>Relevent PHP Settings:</b></td>
      <td> <table dir=rtl cellspacing="1" cellpadding="1" border="0">
          <tr>
            <td>Safe Mode:</td>
            <td><?php echo get_php_setting('safe_mode'); ?></td>
          </tr>
          <tr>
            <td>Open basedir:</td>
            <td><?php echo (($ob = ini_get('open_basedir')) ? $ob : 'none'); ?></td>
          </tr>
          <tr>
            <td>Display Errors:</td>
            <td><?php echo get_php_setting('display_errors'); ?></td>
          </tr>
	  <tr>
	    <td>Short Open Tags:</td>
	    <td><?php echo get_php_setting('short_open_tag'); ?></td>
	  </tr>
          <tr>
            <td>File Uploads:</td>
            <td><?php echo get_php_setting('file_uploads'); ?></td>
          </tr>
          <tr>
            <td>Magic Quotes:</td>
            <td><?php echo get_php_setting('magic_quotes_gpc'); ?></td>
          </tr>
          <tr>
            <td>Register Globals:</td>
            <td><?php echo get_php_setting('register_globals'); ?></td>
          </tr>
          <tr>
            <td>Output Buffering:</td>
            <td><?php echo get_php_setting('output_buffering'); ?></td>
          </tr>
          <tr>
            <td>Session save path:</td>
            <td><?php echo (($sp=ini_get('session.save_path'))?$sp:'none'); ?></td>
          </tr>
          <tr>
            <td>Session auto start:</td>
            <td><?php echo intval( ini_get( 'session.auto_start' ) ); ?></td>
          </tr>
		  <tr>
		    <td>XML enabled:</td>
            <td><?php echo extension_loaded('xml')?'Yes':'No'; ?></td>
          </tr>
		  <tr>
		    <td>Zlib enabled:</td>
            <td><?php echo extension_loaded('zlib')?'Yes':'No'; ?></td>
          </tr>
		  <tr>
		    <td>Disabled Functions:</td>
            <td><?php echo (($df=ini_get('disable_functions'))?$df:'none'); ?></td>
          </tr>
		  <?php
if ($mosConfig_editor != '') {
	$editor = $mosConfig_editor;
} else {
	$editor = "htmlarea2";
}
		?>
          <tr>
            <td>WYSIWYG Editor:</td>
            <td><?php echo $editor; ?></td>
          </tr>
		  </table></td>
    </tr>
    <tr>
      <td valign="top"><b>Configuration File:</b></td>
      <td>
<?php
	$cf = file( "$mosConfig_absolute_path/configuration.php" );
	foreach ($cf as $k=>$v) {
		if (eregi( 'mosConfig_host', $v)) {
			$cf[$k] = '$mosConfig_host = \'xxxxxx\'';
		} else if (eregi( 'mosConfig_user', $v)) {
			$cf[$k] = '$mosConfig_user = \'xxxxxx\'';
		} else if (eregi( 'mosConfig_password', $v)) {
			$cf[$k] = '$mosConfig_password = \'xxxxxx\'';
		} else if (eregi( 'mosConfig_db ', $v)) {
			$cf[$k] = '$mosConfig_db = \'xxxxxx\'';
		} else if (eregi( '<?php', $v)) {
			$cf[$k] = '&lt;?php';
		}
	}
	echo implode( "<br />", $cf );
?>
	  </td>
	</tr>
  </table>
</div>
<div id="page2" class="pagetext">
  <table  cellpadding="4" cellspacing="0" border="0" width="100%" class="adminform">
    <tr>
      <th colspan="2">PHP Information</th>
    </tr>
    <tr>
	  <td>
	    <?php
		ob_start();
		phpinfo(INFO_GENERAL | INFO_CONFIGURATION | INFO_MODULES);
		$phpinfo = ob_get_contents();
		ob_end_clean();
		preg_match_all('#<body[^>]*>(.*)</body>#siU', $phpinfo, $output);
		$output = preg_replace('#<table dir=rtl#', '<table dir=rtl class="adminlist" align="center"', $output[1][0]);
		$output = preg_replace('#(\w),(\w)#', '\1, \2', $output);
		$output = preg_replace('#border="0" cellpadding="3" width="600"#', 'border="0" cellspacing="1" cellpadding="4" width="95%"', $output);
		$output = preg_replace('#<hr />#', '', $output);
		echo $output;
	?>
	</td>
    </tr>
  </table>
</div>
<script language="javascript" type="text/javascript">
	dhtml.cycleTab('tab1');
	</script>

<?php }

function support() {
	global $mosConfig_live_site;
?>

<table  cellpadding="4" cellspacing="0" border="0" width="100%">
  <tr>
    <td width="100%"><span class="sectionname"><img src="images/mos_gel.png" width="70" height="67" align="middle">Support</span></td>
  </tr>
</table>
<table  cellpadding="5" cellspacing="0" width="100%" class="adminform">
  <tr>
    <th class="title">Mambo Open Source Official Sites</th>
  </tr>
  <tr>
    <td>&nbsp;</td>
  </tr>
  <tr>
    <td><ul>

        <li>Main Site : <a href="http://www.mamboserver.com" target="_blank">http://www.mamboserver.com</a></li>
        <li>BugTracker : <a href="http://www.mamboserver.com/bugtrack" target="_blank">http://www.mamboserver.com/bugtrack</a></li>
        <li>Forum : <a href="http://forum.mamboserver.com" target="_blank">http://forum.mamboserver.com</a></li>
        <li>Documentation Project : <a href="http://mosdoc.mamboserver.com" target="_blank">http://mosdoc.mamboserver.com</a></li>
        <li>Sourceforge : <a href="http://sourceforge.net/projects/mambo" target="_blank">http://sourceforge.net/projects/mambo</a></li>
        <li>Downloads & Patches : <a href="http://sourceforge.net/project/showfiles.php?group_id=25577" target="_blank">http://sourceforge.net/project/showfiles.php?group_id=25577</a></li>
      </ul></td>
  </tr>
</table>
<br />

<table cellpadding="5" cellspacing="0" width="100%" class="adminform">
  <tr>
    <th class="title">ChangeLog</th>
  </tr>
  <tr>
    <td>&nbsp;</td>
  </tr>
  <tr>
    <td><ul>
        <li>ChangeLog : <a href="<?php echo $mosConfig_live_site;?>/documentation/Changelog-4.5" target="_blank"><?php echo $mosConfig_live_site;?>/documentation/Changelog-4.5</a></li>
      </ul></td>
  </tr>
</table>
<?php
}

	function credits( $version ) { ?>
<table width="100%" border="0" align="center" cellpadding="0" cellspacing="0">
  <tr>
    <td bgcolor="#FFFFFF"> <table dir=rtl width="100%" border="0" align="center" cellpadding="2" cellspacing="0">
        <tr>
          <td align="center"> <img src="images/top_logo.png" alt="MOS Logo" /><br />
            <span ><?php echo $version; ?> </td>
        </tr>
        <tr>
          <td align="center"><b>Credits</b><br />
            <br /></td>
        <tr>
          <td align="center">
<script language="JavaScript1.2">

/*
Fading Scroller- By DynamicDrive.com
For full source code, and usage terms, visit http://www.dynamicdrive.com
This notice MUST stay intact for use
*/

var delay=1000 //set delay between message change (in miliseconds)
var fcontent=new Array()
begintag='' //set opening tag, such as font declarations
fcontent[0]="<h3>Nicole Anderson<br /></h3>Original Design and Development"
fcontent[1]="<h3>Danny Younes<br /></h3>Original Design and Development"
fcontent[2]="<h3>Robert 'Code Sniffer' Castley<br /></h3>Open Source Project Manager"
fcontent[3]="<h3>Emir Sakic<br /></h3>Open Source Lead Developer"
fcontent[4]="<h3>Andrew 'Wizard of Oz' Eddie<br /></h3>Open Source Lead Developer"
fcontent[5]="<h3>Matt Smith<br /></h3>Open Source Lead Developer"
fcontent[6]="<h3>Steen Rabol<br /></h3>Open Source Lead Developer"
fcontent[7]="<h3>Ron Bakker<br /></h3>Open Source Lead Developer"
fcontent[8]="<h3>Phil 'Coffee' Taylor<br /></h3>Open Source Developer"
fcontent[9]="<h3>Nick Designer<br /></h3>Web Design and Testing"
fcontent[10]="<h3>James Logan<br /></h3>Database Backup/Restore"
fcontent[11]="<h3>Alexander Labunets<br /></h3>Open Source Developer"
closetag=''

var fwidth='250px' //set scroller width
var fheight='100px' //set scroller height

var fadescheme=0 //set 0 to fade text color from (white to black), 1 for (black to white)
var fadelinks=1 //should links inside scroller content also fade like text? 0 for no, 1 for yes.

///No need to edit below this line/////////////////

var hex=(fadescheme==0)? 255 : 0
var startcolor=(fadescheme==0)? "rgb(255,255,255)" : "rgb(0,0,0)"
var endcolor=(fadescheme==0)? "rgb(0,0,0)" : "rgb(255,255,255)"

var ie4=document.all&&!document.getElementById
var ns4=document.layers
var DOM2=document.getElementById
var faderdelay=0
var index=0

if (DOM2)
faderdelay=2000

//function to change content
function changecontent(){
	if (index>=fcontent.length)
		index=0
		if (DOM2){
			document.getElementById("fscroller").style.color=startcolor
			document.getElementById("fscroller").innerHTML=begintag+fcontent[index]+closetag
			linksobj=document.getElementById("fscroller").getElementsByTagName("A")
			if (fadelinks)
				linkcolorchange(linksobj)
				colorfade()
			} else if (ie4)
				document.all.fscroller.innerHTML=begintag+fcontent[index]+closetag
			else if (ns4){
			document.fscrollerns.document.fscrollerns_sub.document.write(begintag+fcontent[index]+closetag)
			document.fscrollerns.document.fscrollerns_sub.document.close()
		}
	index++
	setTimeout("changecontent()",delay+faderdelay)
}

// colorfade() partially by Marcio Galli for Netscape Communications.  ////////////
// Modified by Dynamicdrive.com

frame=20;

function linkcolorchange(obj){
	if (obj.length>0){
		for (i=0;i<obj.length;i++)
			obj[i].style.color="rgb("+hex+","+hex+","+hex+")"
		}
	}

function colorfade() {
// 20 frames fading process
if(frame>0) {
	hex=(fadescheme==0)? hex-12 : hex+12 // increase or decrease color value depd on fadescheme
	document.getElementById("fscroller").style.color="rgb("+hex+","+hex+","+hex+")"; // Set color value.
	if (fadelinks)
		linkcolorchange(linksobj)
		frame--;
		setTimeout("colorfade()",20);
	} else {
		document.getElementById("fscroller").style.color=endcolor;
		frame=20;
		hex=(fadescheme==0)? 255 : 0
	}
}

if (ie4||DOM2)
	document.write('<div id="fscroller" style="border:0px solid black;width:'+fwidth+';height:'+fheight+';padding:2px"></div>')
	window.onload=changecontent
</script>
<ilayer id="fscrollerns" width=&{fwidth}; height=&{fheight};>
            <layer id="fscrollerns_sub" width=&{fwidth}; height=&{fheight}; left=0 top=0></layer>
            </ilayer></td>
        </tr>
      </table></td>
  </tr>
</table>
<table  width="50%" border="0" align="center" cellpadding="4" cellspacing="0" class="adminform">
  <tr>
    <th>Application</th>
    <th>URL</th>
    <th>Version</th>
  </tr>
  <tr>
    <td>HTMLArea</td>
    <td><a href="http://www.interactivetools.com" target="_blank">http://www.interactivetools.com</a></td>
    <td>2.0.3</td>
  </tr>
  <tr>
    <td>JSCookMenu</td>
    <td><a href="http://www.cs.ucla.edu/%7Eheng/JSCookMenu/index.html" target="_blank">http://www.cs.ucla.edu/~heng/JSCookMenu/index.html</a></td>
    <td>1.23</td>
  </tr>
  <tr>
    <td>miniXML</td>
    <td><a href="http://minixml.psychogenic.com" target="_blank">http://minixml.psychogenic.com</a></td>
    <td>1.2.6</td>
  </tr>
  <tr>
    <td>PCLZip/PLCTar</td>
    <td><a href="http://www.phpconcept.net" target="_blank">http://www.phpconcept.net</a></td>
    <td>2.0-rc1</td>
  </tr>
  <tr>
    <td>phpGACL</td>
    <td><a href="http://phpgacl.sf.net" target="_blank">http://phpgacl.sf.net</a></td>
    <td>3.2.2</td>
  </tr>
  <tr>
    <td>Calendar</td>
    <td><a href="http://dynarch.com/mishoo/calendar.epl" target="_blank">http://dynarch.com/mishoo/calendar.epl</a></td>
    <td>0.9.2</td>
  </tr>
    <tr>
    <td>overLIB</td>
    <td><a href="http://www.bosrup.com/web/overlib" target="_blank">http://www.bosrup.com/web/overlib</a></td>
    <td>3.51</td>
  </tr>
    <tr>
    <td>ezPDF</td>
    <td><a href="http://www.ros.co.nz/pdf" target="_blank">http://www.ros.co.nz/pdf</a></td>
    <td>0.0.9</td>
  </tr>
      <tr>
    <td>RSS Parser</td>
    <td><a href="http://fase4.com" target="_blank">http://fase4.com</a></td>
    <td>1.6</td>
  </tr>
  <tr>
    <td>Icons</td>
    <td><a href="http://www.foood.net" target="_blank">http://www.foood.net</a></td>
    <td>N/A</td>
  </tr>
</table>
<?php	}
	function license() { ?>
<table width="100%" cellpadding="0" cellspacing="0" border="0" class="adminform">
  <tr>
    <td>
	  <pre>
	  <?php include ("../documentation/LICENSE"); ?>
	  </pre>
	  </td>
  </tr>
</table>
<?php
	}

	function ListComponents() {
	global $database, $acl, $my;
		// cache some acl checks
		$canConfig = $acl->acl_check( 'administration', 'config', 'users', $my->usertype );

		$manageDB = $acl->acl_check( 'administration', 'manage', 'users', $my->usertype, 'components', 'com_dbadmin' );
		$manageTemplates = $acl->acl_check( 'administration', 'manage', 'users', $my->usertype, 'components', 'com_templates' );
		$manageLanguages = $acl->acl_check( 'administration', 'manage', 'users', $my->usertype, 'components', 'com_languages' );
		$installModules = $acl->acl_check( 'administration', 'install', 'users', $my->usertype, 'modules', 'all' );
		$editAllModules = $acl->acl_check( 'administration', 'edit', 'users', $my->usertype, 'modules', 'all' );
		$installComponents = $acl->acl_check( 'administration', 'install', 'users', $my->usertype, 'components', 'all' );
		$editAllComponents = $acl->acl_check( 'administration', 'edit', 'users', $my->usertype, 'components', 'all' );

		$canMassMail = $acl->acl_check( 'administration', 'manage', 'users', $my->usertype, 'components', 'com_massmail' );
		$canManageUsers = $acl->acl_check( 'administration', 'manage', 'users', $my->usertype, 'components', 'com_users' );

	$database->setQuery( "SELECT * FROM #__components ORDER BY ordering,name" );
	$comps = $database->loadObjectList();	// component list

	echo "<div align=\"left\"><form name=\"adminForm\" method=\"post\" action=\"index2.php\">\n\n";
	echo "<input type=\"hidden\" name=\"option\" value=\"com_admisc\">\n\n";
	echo "<input type=\"hidden\" name=\"task\" value=\"redirect\">\n\n";
	echo "<select name=\"link\" size=25 class=\"inputbox\">\n\n";

	$subs = array();	// sub menus

		// first pass to collect sub-menu items
		foreach ($comps as $row) {
			if ($row->parent) {
				if (!array_key_exists( $row->parent, $subs )) {
					$subs[$row->parent] = array();
				}
				$subs[$row->parent][] = $row;
			}
		}

		$topLevelLimit = 100; //You can get 19 top levels on a 800x600 Resolution
		$i = 0;
		foreach ($comps as $row) {

			if ($editAllComponents | $acl->acl_check( 'administration', 'edit', 'users', $my->usertype,
					'components', $row->option )) {

				if ($row->parent == 0 && (trim( $row->admin_menu_link ) || array_key_exists( $row->id, $subs ))) {

					if ($i >= $topLevelLimit) {
							if ($i == $topLevelLimit) {

								echo "\t<option value=\"Err\">Error!</option>";
								$i = 1000;
							}
					} else {
						if ($i < $topLevelLimit ) {
							$i++;
								$name = addslashes( $row->name );
								$alt = addslashes( $row->admin_menu_alt );
								$link = $row->admin_menu_link ? "index2.php?$row->admin_menu_link" : "null";
								echo "\n\t <option value=\"$link\">-$name</option> <BR>";
								if (array_key_exists( $row->id, $subs )) {

									foreach ($subs[$row->id] as $sub) {//print_r($row);
										$name = addslashes( $sub->name );
										$alt = addslashes( $sub->admin_menu_alt );
										$link = $sub->admin_menu_link ? "index2.php?$sub->admin_menu_link" : "null";
										echo "\n\t\t <option value=\"$link\">&nbsp;&nbsp;&nbsp;&nbsp;$name</option> <BR>";
									}
								}

							echo "\n	";

							}//
						}
				}
			}

		}
		echo "</select> <input type=\"submit\" name=\"Submit\" value=\"Go...\" class=\"button\"></form>";
		echo "</div>";
	}
}
?>
