<?php
// $Id: index2.php,v 1.43 2004/03/28 21:40:38 rcastley Exp $
/**
* Support file to display an operation clear of the template
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.43 $
**/

define( "_VALID_MOS", 1 );

include_once ("globals.php");
require_once ("configuration.php");
require_once ("classes/mambo.php");
require_once ("includes/sef.php");
require_once ("includes/frontend.php");

$database = new database( $mosConfig_host, $mosConfig_user, $mosConfig_password, $mosConfig_db, $mosConfig_dbprefix );

// mainframe is an API workhorse, lots of 'core' interaction routines
$mainframe = new mosMainFrame( $database, $option, '.' );

// Support for simple debug
if ($mosConfig_debug) {
	include_once($mosConfig_absolute_path . "/includes/debug.php");
	$mosDebug = new mosDebug($mosConfig_debug);
}

// retrieve some expected url (or form) arguments
$option = trim( strtolower( mosGetParam( $_REQUEST, 'option' ) ) );
$no_html = intval( mosGetParam( $_REQUEST, 'no_html', 0 ) );
$Itemid = strtolower( trim( mosGetParam( $_REQUEST, 'Itemid',0 ) ) );
$act = mosGetParam( $_REQUEST, 'act', '' );

$mainframe->initSession();

if ($mosConfig_lang=='') {
	$mosConfig_lang='english';
}
include_once ('language/'.$mosConfig_lang.'.php');

if ($mosConfig_offline == 1){
	include( 'offline.php' );
	exit();
}

if ($option == "login") {
	$mainframe->login();
	mosRedirect('index.php');
} else if ($option == "logout") {
	$mainframe->logout();
	mosRedirect( "index.php" );
}

if (isset($do_pdf) && $do_pdf!=""){
	include ("includes/pdf.php");
	exit();
}

$acl = new gacl_api();

// get the information about the current user from the sessions table
$my = $mainframe->getUser();

$mainframe->detect();

$gid = intval( $my->gid );
/** Bug #39 fixed
//$t = new mosTemplate( $database );
//$t->load( 0 );
//$cur_template = $t->cur_template;
**/
$cur_template = $mainframe->getTemplate();

ob_start();
// start basic HTML
if ($no_html==0) {?>
	<?php echo "<?xml version=\"1.0\" encoding=\"windows-1256\"?".">"; ?>
	<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
	<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
	<title><?php echo $mosConfig_sitename; ?></title>
	<link rel="stylesheet" href="templates/<?php echo $cur_template;?>/css/template_css.css" type="text/css" />
	<meta http-equiv="Content-Type" content="text/html; <?php echo _ISO; ?>" />
	</head>
	<body class="contentpane">
	<?php include ("mainbody.php"); ?>
	</body>
	</html>
<?php
} else {
	include ("mainbody.php");
}
ob_end_flush();
?>
