<?php
// $Id: weblinks.class.php,v 1.5 2004/03/19 17:41:13 rcastley Exp $
/**
* Content code
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.5 $
**/

defined( '_VALID_MOS' ) or die( '      ' );

/**
* Web Links Class
* @package Weblinks
* @copyright 2000-2003 Miro International Pty Ltd
* @license http://www.gnu.org/copyleft/gpl.html GNU Public License
* @version $Revision: 1.5 $
*/

/**
* Category database table class
*/
class mosWeblink extends mosDBTable {
	/** @var int Primary key */
	var $id=null;
	/** @var int */
	var $catid=null;
	/** @var int */
	var $sid=null;
	/** @var string */
	var $title=null;
	/** @var string */
	var $url=null;
	/** @var string */
	var $description=null;
	/** @var datetime */
	var $date=null;
	/** @var int */
	var $hits=null;
	/** @var int */
	var $published=null;
	/** @var boolean */
	var $checked_out=null;
	/** @var time */
	var $checked_out_time=null;
	/** @var int */
	var $ordering=null;
	/** @var int */
	var $archived=null;
	/** @var int */
	var $approved=null;

	/**
	* @param database A database connector object
	*/
	function mosWeblink( &$db ) {
		$this->mosDBTable( '#__weblinks', 'id', $db );
	}
	// overloaded check function
	function check() {
		// check for valid name
		if (trim( $this->title ) == '') {
			$this->_error = _WEBLINK_TITLE;
			return false;
		}

		if (!(eregi("http://", $this->url) || (eregi("https://",$this->url)))) {
			$this->url = "http://".$this->url;
		}

		// check for existing name
		$this->_db->setQuery( "SELECT id FROM #__weblinks "
		. "\nWHERE title='$this->title' AND catid='$this->catid'"
		);

		$xid = intval( $this->_db->loadResult() );
		if ($xid && $xid != intval( $this->id )) {
			$this->_error = _WEBLINK_EXIST;
			return false;
		}
		return true;
	}

	/**
	* @param string Target search string
	*/
	function search( $text, $state='', $sectionPrefix='' ) {
		$text = trim( $text );
		if ($text == '') {
			return array();
		}

		$this->_db->setQuery( "SELECT date AS created, title,"
		. "\n	url AS href, description AS text, '1' AS browsernav, '{$sectionPrefix} ' AS section"
		. "\nFROM #__weblinks WHERE (title LIKE '%$text%'"
		. "\n OR description LIKE '%$text%')"
		. "\n ORDER BY created DESC"
		);

		return $this->_db->loadObjectList();
	}
}
?>
