<?php
// $Id: index2.php,v 1.52 2004/03/28 21:40:38 rcastley Exp $
/**
* Administrator authenticated index page
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License: http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.52 $
**/

// aim to have code so that following line is on without errors
// and not have regglobals include
//error_reporting( E_ALL );
//$mosConfig_debug = false;

define( "_VALID_MOS", 1 );

if (!file_exists( "../configuration.php" )) {
	header( "Location: ../installation/index.php" );
	exit();
}

require_once( "../globals.php" );
require_once( "../configuration.php" );
require_once( "../classes/mambo.php" );
include_once( "../language/".$mosConfig_lang.".php" );
require_once( "classes/admin.php" );
include_once( $mosConfig_absolute_path . "/includes/debug.php" );
include_once( "../editor/editor.php" );

$database = new database( $mosConfig_host, $mosConfig_user, $mosConfig_password, $mosConfig_db, $mosConfig_dbprefix );
$acl = new gacl_api();

$option = trim( strtolower( mosGetParam( $_REQUEST, 'option', '' ) ) );

// must start the session before we create the mainframe object
session_name( 'mosadmin' );
session_start();

// mainframe is an API workhorse, lots of 'core' interaction routines
$mainframe = new mosMainFrame( $database, $option, '..' );

// Support for simple debug
$mosDebug = new mosDebug( $mosConfig_debug );

// initialise some common request directives
$task = trim( mosGetParam( $_REQUEST, 'task', '' ) );
$act = trim( strtolower( mosGetParam( $_REQUEST, 'act', '' ) ) );
$section = trim( mosGetParam( $_REQUEST, 'section', '' ) );
$mosmsg = trim( strip_tags( mosGetParam( $_REQUEST, 'mosmsg', '' ) ) );
$no_html = strtolower( trim( mosGetParam( $_REQUEST, 'no_html', '' ) ) );

if ($option == 'logout') {
	require 'logout.php';
	exit();
}

// restore some session variables
$my = new mosUser( $database );
$my->id = mosGetParam( $_SESSION, 'session_user_id', '' );
$my->username = mosGetParam( $_SESSION, 'session_username', '' );
$my->usertype = mosGetParam( $_SESSION, 'session_usertype', '' );
$my->gid = mosGetParam( $_SESSION, 'session_gid', '' );

$session_id = mosGetParam( $_SESSION, 'session_id', '' );
$logintime = mosGetParam( $_SESSION, 'session_logintime', '' );

// check against db record of session
if ($session_id == md5( $my->id.$my->username.$my->usertype.$logintime )) {
	$database->setQuery( "SELECT * FROM #__session"
	. "\nWHERE session_id='$session_id'"
	//. "\n	AND (usertype='administrator' OR usertype='superadministrator')"
	);
	if (!$result = $database->query()) {
		echo $database->stderr();
	}
	if ($database->getNumRows( $result ) <> 1) {
		echo "<script>document.location.href='index.php'</script>\n";
		exit();
	}
} else {
	echo "<script>document.location.href='$mosConfig_live_site/administrator/index.php'</script>\n";
	exit();
}

// update session timestamp
$current_time = time();
$database->setQuery( "UPDATE #__session SET time='$current_time'"
. "\nWHERE session_id='$session_id'"
);
$database->query();

// timeout old sessions
$past = time()-1800;
$database->setQuery( "DELETE FROM #__session WHERE time < '$past'" );
$database->query();

// check for database backup
if (($option == "com_dbadmin") && ($task == "doBackup")) {
	$OutDest = mosGetParam( $_REQUEST, "OutDest", '' );
	if ($OutDest == "remote") {
		include_once ("components/com_dbadmin/admin.dbadmin.php");
		exit();
	}
}

// start the html output
if ($no_html) {
	if ($path = $mainframe->getPath( "admin" )) {
		require $path;
	}
	exit;
}
$do_gzip_compress = FALSE;
if ($mosConfig_gzip==1) {
	$phpver = phpversion();
	$useragent = (isset($_SERVER["HTTP_USER_AGENT"]) ) ? $_SERVER["HTTP_USER_AGENT"] : $HTTP_USER_AGENT;

	if ( $phpver >= '4.0.4pl1' && ( strstr($useragent,'compatible') || strstr($useragent,'Gecko') ) )
	{
		if ( extension_loaded('zlib') )
		{
			ob_start('ob_gzhandler');
		}
	}
	else if ( $phpver > '4.0' )
	{
		if ( strstr($HTTP_SERVER_VARS['HTTP_ACCEPT_ENCODING'], 'gzip') )
		{
			if ( extension_loaded('zlib') )
			{
				$do_gzip_compress = TRUE;
				ob_start();
				ob_implicit_flush(0);

				header('Content-Encoding: gzip');
			}
		}
	}
} else {
        ob_start();
}
$tstart = mosProfiler::getmicrotime();
?>
<?php echo "<?xml version=\"1.0\"?>"; ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title><?php echo $mosConfig_sitename; ?> ::  </title>
<meta http-equiv="Content-Type" content="text/html; <?php echo _ISO; ?>" />
<link rel="stylesheet" href="css/admin.css" type="text/css" />
<link rel="stylesheet" href="../includes/js/ThemeOffice/theme.css" type="text/css" />
<script language="JavaScript" src="../includes/js/JSCookMenu.js" type="text/javascript"></script>
<script language="JavaScript" src="js/ThemeOffice/theme.js" type="text/javascript"></script>
<script language="JavaScript1.2" src="js/rollover.js" type="text/javascript"></script>
<script language="JavaScript" src="../includes/js/mambojavascript.js" type="text/javascript"></script>
<?php
initEditor();
?>
</head>
<body onload="MM_preloadImages('images/help_f2.png','images/approve_f2.png','images/archive_f2.png','images/back_f2.png','images/cancel_f2.png','images/delete_f2.png','images/edit_f2.png','images/new_f2.png','images/preview_f2.png','images/publish_f2.png','images/save_f2.png','images/unarchive_f2.png','images/unpublish_f2.png','images/upload_f2.png')">
<?php
$mosDebug->showvar( $_REQUEST );

//Reset cookie for hiding the toolbar and footer if the option is not set - provides additional support for 3rd party integration
if (!$option && !$reset) {
		setcookie("menu_hide", "0");
		setcookie("footer_hide", "0");
		mosRedirect ("index2.php?reset=1");
}

// pull in the menu bar
if (@!$menu_hide){
require_once( "menubar.php" );
}
if ($mosmsg) {
	if (!get_magic_quotes_gpc()) {
		$mosmsg = addslashes( $mosmsg );
	}
	//echo "\n<script language=\"javascript\" type=\"text/javascript\">alert('$mosmsg');</script>";
	echo "\n<div class=\"message\">$mosmsg</div>";
}
?>
<table width="98%" border="0" align="center" cellpadding="0" cellspacing="0">
  <tr>
    <td width="10" height="10" background="images/top_left_corner.png"></td>
    <td background="images/top_line.png"></td>
    <td width="10" height="10" background="images/top_right_corner.png"></td>
  </tr>
  <tr>
    <td background="images/left_line.png"></td>
    <td valign="middle" align="center">
      <?php

// Show list of items to edit or delete or create new
if ($path = $mainframe->getPath( 'admin' )) {
	require $path;
} else {
	?>
      <img src="images/mos_logo.png" border="0" alt="MOS Logo" />&nbsp; <br />
      <?php
}
?>
    </td>
    <td background="images/right_line.png"></td>
  </tr>
  <tr>
    <td width="10" height="10" background="images/bottom_left_corner.png"></td>
    <td background="images/bottom_line.png"></td>
    <td width="10" height="10" background="images/bottom_right_corner.png"></td>
  </tr>
</table>
<table width="100%" border="0">
<tr>
<td align="center"><?php
if (@!$footer_hide){
  include ("../includes/footer.php");
 }
echo ("<h6>");
$tend = mosProfiler::getmicrotime();
$totaltime = ($tend - $tstart);
printf ("   %f ", $totaltime);
echo ("</h6>");
echo ("<span dir=rtl><a target=\"_blank\" href=\"http://www.dndon.com\"> <span> Fuga</span>  </a></span>");
 ?>
</td></tr></table>
</body>
</html>
<?php
if ( $do_gzip_compress )
{
	//
	// Borrowed from php.net!
	//
	$gzip_contents = ob_get_contents();
	ob_end_clean();

	$gzip_size = strlen($gzip_contents);
	$gzip_crc = crc32($gzip_contents);

	$gzip_contents = gzcompress($gzip_contents, 9);
	$gzip_contents = substr($gzip_contents, 0, strlen($gzip_contents) - 4);

	echo "\x1f\x8b\x08\x00\x00\x00\x00\x00";
	echo $gzip_contents;
	echo pack('V', $gzip_crc);
	echo pack('V', $gzip_size);
} else {
        ob_end_flush();
}
?>
