<?php
// $Id: admin.newsfeeds.php,v 1.11 2003/12/15 23:51:10 eddieajau Exp $
/**
* Newsfeed admin component code
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License: http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.11 $
**/

// ensure this file is being included by a parent file
defined( '_VALID_MOS' ) or die( '      ' );

// ensure user has access to this function
if (!($acl->acl_check( 'administration', 'edit', 'users', $my->usertype, 'components', 'all' )
		| $acl->acl_check( 'administration', 'edit', 'users', $my->usertype, 'components', 'com_newsfeeds' ))) {
	mosRedirect( 'index2.php', _NOT_AUTH );
}

require_once( $mainframe->getPath( 'admin_html' ) );
require_once( $mainframe->getPath( 'class' ) );

$task = mosGetParam( $_REQUEST, 'task', array(0) );
$cid = mosGetParam( $_POST, 'cid', array(0) );
if (!is_array( $cid )) {
	$cid = array(0);
}

switch ($task) {

	case "new":
		editNewsFeed( 0, $option );
		break;

	case "edit":
		editNewsFeed( $cid[0], $option );
		break;

	case "save":
		saveNewsFeed( $option );
		break;

	case "publish":
		publishNewsFeeds( $cid, 1, $option );
		break;

	case "unpublish":
		publishNewsFeeds( $cid, 0, $option );
		break;

	case "remove":
		removeNewsFeeds( $cid, $option );
		break;

	case "cancel":
		cancelNewsFeed( $option );
		break;

	case "orderup":
		orderNewsFeed( $cid[0], -1, $option );
		break;

	case "orderdown":
		orderNewsFeed( $cid[0], 1, $option );
		break;

	default:
		showNewsFeeds( $option );
		break;
}

/**
* List the records
* @param string The current GET/POST option
*/
function showNewsFeeds( $option ) {
	global $database, $mainframe;

	$catid = $mainframe->getUserStateFromRequest( "catid{$option}", 'catid', 0 );
	$limit = $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', 10 );
	$limitstart = $mainframe->getUserStateFromRequest( "view{$option}limitstart", 'limitstart', 0 );

	// get the total number of records
	$database->setQuery( "SELECT count(*) FROM #__newsfeeds"
	. ($catid ? "\nWHERE catid='$catid'" : "")
	);

	$total = $database->loadResult();
	echo $database->getErrorMsg();

	require_once("includes/pageNavigation.php");
	$pageNav = new mosPageNav( $total, $limitstart, $limit );

	// get the subset (based on limits) of required records
	$database->setQuery( "SELECT a.*, c.name AS catname, u.name AS editor"
	. "\nFROM #__newsfeeds AS a"
	. "\nLEFT JOIN #__categories AS c ON c.id = a.catid"
	. "\nLEFT JOIN #__users AS u ON u.id = a.checked_out"
	. ($catid ? "\nWHERE a.catid='$catid'" : "")
	. "\nORDER BY a.ordering"
	. "\nLIMIT $pageNav->limitstart,$pageNav->limit"
	);

	$rows = $database->loadObjectList();
	if ($database->getErrorNum()) {
		echo $database->stderr();
		return false;
	}

	// get list of categories
	$categories[] = mosHTML::makeOption( '0', ' ' );
	$categories[] = mosHTML::makeOption( '0', '-  ' );
	$database->setQuery( "SELECT id AS value, title AS text FROM #__categories"
	. "\nWHERE section='$option' ORDER BY ordering" );
	$categories = array_merge( $categories, $database->loadObjectList() );

	$catlist = mosHTML::selectList( $categories, 'catid', 'class="inputbox" size="1" onchange="document.adminForm.submit();"',
	'value', 'text', $catid );
	unset( $categories );

	HTML_newsfeeds::showNewsFeeds( $rows, $catlist, $pageNav, $option );
}

/**
* Creates a new or edits and existing user record
* @param int The id of the user, 0 if a new entry
* @param string The current GET/POST option
*/
function editNewsFeed( $id, $option ) {
	global $database, $my;

	$catid = intval( mosGetParam( $_REQUEST, 'catid', 0 ) );

	$row = new mosNewsFeed( $database );
	// load the row from the db table
	$row->load( $id );

	if ($id) {
		// do stuff for existing records
		$row->checkout( $my->id );
	} else {
		// do stuff for new records
		$row->ordering = 9999;
	}

	// get list of categories
	$categories[] = mosHTML::makeOption( '0', ' ' );
	$database->setQuery( "SELECT id AS value, title AS text FROM #__categories"
	. "\nWHERE section='$option' ORDER BY ordering" );
	$categories = array_merge( $categories, $database->loadObjectList() );

	$catlist = mosHTML::selectList( $categories, 'catid', 'class="inputbox" size="1"',
	'value', 'text', $row->catid );
	unset( $categories );

	if ($id) {
		// build the html select list for ordering
		$order = mosGetOrderingList( "SELECT a.ordering AS value, a.name AS text"
			. "\nFROM #__newsfeeds AS a"
			. "\nORDER BY a.ordering"
		);
		$orderlist = mosHTML::selectList( $order, 'ordering', 'class="inputbox" size="1"',
		'value', 'text', intval( $row->ordering ) );
	} else {
		$orderlist = "<input type=\"hidden\" name=\"ordering\" value=\"$row->ordering\" />"
		. "      ";
	}

	HTML_newsfeeds::editNewsFeed( $row, $catlist, $orderlist, $option );
}

/**
* Saves the record from an edit form submit
* @param string The current GET/POST option
*/
function saveNewsFeed( $option ) {
	global $database, $my;

	$row = new mosNewsFeed( $database );
	if (!$row->bind( $_POST )) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}

	// pre-save checks
	if (!$row->check()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}

	// save the changes
	if (!$row->store()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	$row->checkin();
	$row->updateOrder();

	mosRedirect( "index2.php?option=$option" );
}

/**
* Publishes or Unpublishes one or more modules
* @param array An array of unique category id numbers
* @param integer 0 if unpublishing, 1 if publishing
* @param string The current GET/POST option
*/
function publishNewsFeeds( $cid, $publish, $option ) {
	global $database;

	if (count( $cid ) < 1) {
		$action = $publish ? 'publish' : 'unpublish';
		echo "<script> alert('Select a module to $action'); window.history.go(-1);</script>\n";
		exit;
	}

	$cids = implode( ',', $cid );

	$database->setQuery( "UPDATE #__newsfeeds SET published='$publish'"
	. "\nWHERE id IN ($cids) AND (checked_out=0 OR (checked_out='$my->id'))"
	);
	if (!$database->query()) {
		echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		exit();
	}

	if (count( $cid ) == 1) {
		$row = new mosNewsFeed( $database );
		$row->checkin( $cid[0] );
	}

	mosRedirect( "index2.php?option=$option" );
}

/**
* Removes records
* @param array An array of id keys to remove
* @param string The current GET/POST option
*/
function removeNewsFeeds( &$cid, $option ) {
	global $database;

	if (!is_array( $cid ) || count( $cid ) < 1) {
		echo "<script> alert('Select an item to delete'); window.history.go(-1);</script>\n";
		exit;
	}
	if (count( $cid )) {
		$cids = implode( ',', $cid );
		$database->setQuery( "DELETE FROM #__newsfeeds WHERE id IN ($cids) AND checked_out='0'" );
		if (!$database->query()) {
			echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		}
	}

	mosRedirect( "index2.php?option=$option" );
}

/**
* Cancels an edit operation
* @param string The current GET/POST option
*/
function cancelNewsFeed( $option ) {
	global $database;

	$row = new mosNewsFeed( $database );
	$row->bind( $_POST );
	$row->checkin();
	mosRedirect( "index2.php?option=$option" );
}

/**
* Moves the order of a record
* @param integer The id of the record to move
* @param integer The direction to reorder, +1 down, -1 up
* @param string The current GET/POST option
*/
function orderNewsFeed( $id, $inc, $option ) {
	global $database;

	$limit = mosGetParam( $_REQUEST, 'limit', 0 );
	$limitstart = mosGetParam( $_REQUEST, 'limitstart', 0 );
	$catid = intval( mosGetParam( $_REQUEST, 'catid', 0 ) );

	$row = new mosNewsFeed( $database );
	$row->load( $id );
	$row->move( $inc );

	mosRedirect( "index2.php?option=$option" );
}
?>