<?php
// $Id: content_blog_category.class.php,v 1.1 2003/11/13 22:27:10 rcastley Exp $
/**
* Administrator menu content blog category class by ChipJack
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License: http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.1 $
**/

// ensure this file is being included by a parent file
defined( '_VALID_MOS' ) or die( '      ' );

class content_blog_category_menu {
/**
* @param database A database connector object
* @param integer The unique id of the category to edit (0 if new)
*/
   function edit( &$uid, $menutype, $option ) {
      global $database, $my;

      $menu = new mosMenu( $database );
      $menu->load( $uid );

      // fail if checked out not by 'me'
      if ($menu->checked_out && $menu->checked_out <> $my->id) {
         echo "<script>alert('The module $menu->title is currently being edited by another administrator'); document.location.href='index2.php?option=$option'</script>\n";
         exit(0);
      }

      if ($uid) {
         $menu->checkout( $my->id );
      } else {
         $menu->type = 'content_blog_category'; /* chipjack: was 'content_blog_section' */
         $menu->menutype = $menutype;
         $menu->ordering = 9999;
         $menu->parent = intval( mosGetParam( $_POST, 'parent', 0 ) );
      }

   // build the html select list for ordering
      if ($uid) {
         $database->setQuery( "SELECT ordering, name FROM #__menu WHERE menutype='$menu->menutype' AND parent='$menu->parent'"
            . "\nORDER BY ordering"
         );
         if (!($orders = $database->loadObjectList())) {
            echo $database->stderr();
            return false;
         }
         for ($i=0, $n=count( $orders ); $i < $n; $i++) {
            $order[] = mosHTML::makeOption( $i+1, ($i+1).' before '.$orders[$i]->name );
         }
         if ($uid == 0) {
            $order[] = mosHTML::makeOption( $i, $i.' last' );
         }
         $olist = mosHTML::selectList( $order, 'ordering', 'class="inputbox" size="1"',
            'value', 'text', intval( $menu->ordering ) );
      } else {
         $olist = "<input type=\"hidden\" name=\"ordering\" value=\"$menu->ordering\" />"
            . "      ";
      }

      $database->setQuery( "SELECT c.id AS `value`,"
         . "\n   CONCAT_WS('/',s.title,c.title) AS `text`"
         . "\nFROM #__sections AS s"
         . "\nINNER JOIN #__categories AS c ON c.section = s.id"
         . "\nWHERE s.scope='content'"
         . "\nORDER BY s.name,c.name"
      );
      $rows = $database->loadObjectList();

      // build the html select list
      $sectCatList = mosHTML::selectList( $rows, 'componentid', 'class="inputbox" size="8"',
      'value', 'text', $menu->componentid );

	  // get list of groups
      $database->setQuery( "SELECT id AS value, name AS text FROM #__groups ORDER BY id" );
      $groups = $database->loadObjectList();

      // build the html select list for the group access
      $glist = mosHTML::selectList( $groups, 'access', 'class="inputbox" size="5"',
         'value', 'text', intval( $menu->access ) );

      // menu parent item
   	  // get a list of the menu items
      $database->setQuery( "SELECT m.*"
         . "\nFROM #__menu m"
         . "\nWHERE menutype='$menu->menutype'"
         . "\nORDER BY ordering"
      );
      $mitems = $database->loadObjectList();

   // establish the hierarchy of the menu
      $children = array();
   // first pass - collect children
      foreach ($mitems as $v ) {
         $pt = $v->parent;
         $list = @$children[$pt] ? $children[$pt] : array();
         array_push( $list, $v );
         $children[$pt] = $list;
      }
   // second pass - get an indent list of the items
      $list = mosTreeRecurse( 0, '', array(), $children );

   // assemble menu items to the array
      $mitems = array();
      $mitems[] = mosHTML::makeOption( '0', '' );
      $this_treename = '';
      foreach ($list as $item) {
         if ($this_treename) {
            if ($item->id != $menu->id && strpos( $item->treename, $this_treename ) === false) {
               $mitems[] = mosHTML::makeOption( $item->id, $item->treename );
            }
         } else {
            if ($item->id != $menu->id) {
               $mitems[] = mosHTML::makeOption( $item->id, $item->treename );
            } else {
               $this_treename = "$item->treename/";
            }
         }
      }

   // build the html select list
      $parlist = mosHTML::selectList( $mitems, 'parent', 'class="inputbox" size="1"',
         'value', 'text', $menu->parent );

      /* chipjack: passing $sectCatList (categories) instead of $slist (sections) */
      content_blog_category_menu_html::edit( $menu, $sectCatList, $olist, $glist, $parlist, $option );
   }
}
?>