<?php
// $Id: categories.php,v 1.19 2004/02/22 08:43:34 rcastley Exp $
/**
* Administrator categories event handler
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License: http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.19 $
**/

// ensure this file is being included by a parent file
defined( '_VALID_MOS' ) or die( '      ' );

require_once("classes/html/HTML_categories.php");

// get parameters from the URL or submitted form
$section = mosGetParam( $_REQUEST, 'section', '' );
$cid = mosGetParam( $_REQUEST, 'cid', array(0) );
if (!is_array( $cid )) {
	$cid = array(0);
}

switch ($task) {
	case "new":
		editCategory( 0, $section );
		break;

	case "edit":
		editCategory( intval( $cid[0] ) );
		break;

	case "save":
		saveCategory();
		break;

	case "remove":
		removeCategories( $section, $cid );
		break;

	case "publish":
		publishCategories( $section, $id, $cid, 1 );
		break;

	case "unpublish":
		publishCategories( $section, $id, $cid, 0 );
		break;

	case "cancel":
		cancelCategory();
		break;

	case "orderup":
		orderCategory( $cid[0], -1 );
		break;

	case "orderdown":
		orderCategory( $cid[0], 1 );
		break;

	default:
		showCategories( $section );
		break;
}

/**
* Compiles a list of categories for a section
* @param string The name of the category section
* @param string The name of the current user
*/
function showCategories( $section ) {
	global $database, $my, $mainframe;

	$limit = $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', 10 );
	$limitstart = $mainframe->getUserStateFromRequest( "view{$section}limitstart", 'limitstart', 0 );

	$section_name = '';
	if (intval( $section ) > 0) {
		$table = 'content';

		$database->setQuery( "SELECT name FROM #__sections WHERE id='$section'" );
		$section_name = $database->loadResult();
		echo $database->getErrorMsg();
		$section_name .= ' ';
	} else if (strpos( $section, 'com_' ) === 0) {
		$table = substr( $section, 4 );

		$database->setQuery( "SELECT name FROM #__components WHERE link='option=$section'" );
		$section_name = $database->loadResult();
		echo $database->getErrorMsg();
	} else {
		$table = $section;
	}

	// get the total number of records
	$database->setQuery( "SELECT count(*) FROM #__categories WHERE section='$section'" );
	$total = $database->loadResult();
	echo $database->getErrorMsg();

	require_once( "includes/pageNavigation.php" );
	$pageNav = new mosPageNav( $total, $limitstart, $limit );

	$database->setQuery( "SELECT  c.*, g.name AS groupname, u.name AS editor,"
	. "COUNT(DISTINCT s2.checked_out) AS checked_out, COUNT(DISTINCT s1.id) AS num"
	. "\nFROM #__categories AS c"
	. "\nLEFT JOIN #__users AS u ON u.id = c.checked_out"
	. "\nLEFT JOIN #__groups AS g ON g.id = c.access"
	. "\nLEFT JOIN #__$table AS s1 ON s1.catid = c.id"
	. "\nLEFT JOIN #__$table AS s2 ON s2.catid = c.id AND s2.checked_out > 0"
	. "\nWHERE section='$section'"
	. "\nGROUP BY c.id"
	. "\nORDER BY c.ordering, c.name"
	. "\nLIMIT $pageNav->limitstart,$pageNav->limit"
	);

	$rows = $database->loadObjectList();
	if ($database->getErrorNum()) {
		echo $database->stderr();
		return false;
	}

	categories_html::show( $rows, $section, $section_name, $my->id, $pageNav );
}

/**
* Compiles information to add or edit a category
* @param string The name of the category section
* @param integer The unique id of the category to edit (0 if new)
* @param string The name of the current user
*/
function editCategory( $uid=0, $section='' ) {
	global $database, $my;
	global $mosConfig_absolute_path, $mosConfig_live_site, $mosConfig_editor;

	$row = new mosCategory( $database );
	// load the row from the db table
	$row->load( $uid );

	// fail if checked out not by 'me'
	if ($row->checked_out && $row->checked_out <> $my->id) {
		mosRedirect( "index2.php?option=categories&section=$row->section",
		"The category $row->title is currently being edited by another administrator" );
	}

	if ($uid) {
		// existing record
		$row->checkout( $my->id );
	} else {
		// new record
		$row->section = $section;
	}

	// make order list
	$order = array();
	$database->setQuery( "SELECT COUNT(*) FROM #__categories WHERE section='$row->section'" );
	$max = intval( $database->loadResult() ) + 1;

	for ($i=1; $i < $max; $i++) {
		$order[] = mosHTML::makeOption( $i );
	}

	$ipos[] = mosHTML::makeOption( 'left' );
	$ipos[] = mosHTML::makeOption( 'right' );

	$iposlist = mosHTML::selectList( $ipos, 'image_position', 'class="inputbox" size="1"',
	'value', 'text', $row->image_position ? $row->image_position : 'left' );

	$imgFiles = mosReadDirectory( "$mosConfig_absolute_path/images/stories" );
	$images = array( mosHTML::makeOption( '', ' ') );
	foreach ($imgFiles as $file) {
		if (eregi( "bmp|gif|jpg|png", $file )) {
			$images[] = mosHTML::makeOption( $file );
		}
	}

	$imagelist = mosHTML::selectList( $images, 'image', "class=\"inputbox\" size=\"1\""
	. " onchange=\"javascript:if (document.forms[0].image.options[selectedIndex].value!='') {document.imagelib.src='../images/stories/' + document.forms[0].image.options[selectedIndex].value} else {document.imagelib.src='../images/M_images/blank.png'}\"",
	'value', 'text', $row->image );

	$orderlist = mosHTML::selectList( $order, 'ordering', 'class="inputbox" size="1"',
	'value', 'text', $row->ordering );

	// get list of groups
	$database->setQuery( "SELECT id AS value, name AS text FROM #__groups ORDER BY id" );
	$groups = $database->loadObjectList();

	$glist = mosHTML::selectList( $groups, 'access', 'class="inputbox" size="1"',
	'value', 'text', intval( $row->access ) );

	categories_html::edit( $row, $imagelist, $iposlist, $orderlist, $glist, $section );
}

/**
* Saves the catefory after an edit form submit
* @param string The name of the category section
*/
function saveCategory() {
	global $database;

	$row = new mosCategory( $database );
	if (!$row->bind( $_POST )) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	if (!$row->check()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}

	if (!$row->store()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	$row->checkin();
	$row->updateOrder( "section='$row->section'" );

	if ($oldtitle = mosGetParam( $_POST, 'oldtitle', null )) {
		if ($oldtitle != $row->title) {
			$database->setQuery( "UPDATE #__menu SET name='$row->title' WHERE name='$oldtitle' AND type='content_category'" );
			$database->query();
		}
	}

	// Update Section Count
	if ($row->section != "com_weblinks") {
		$database->setQuery( "UPDATE #__sections SET count=count+1"
			. "\nWHERE id = '$row->section'"
		);
	}

	if (!$database->query()) {
		echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		exit();
	}

	mosRedirect( "index2.php?option=categories&section=$row->section" );
}
/**
* Deletes one or more categories from the categories table
* @param string The name of the category section
* @param array An array of unique category id numbers
*/
function removeCategories( $section, $cid ) {
	global $database;

	if (count( $cid ) < 1) {
		echo "<script> alert('Select a category to delete'); window.history.go(-1);</script>\n";
		exit;
	}

	$cids = implode( ',', $cid );

	//Get Section ID prior to removing Category, in order to update counts
	$database->setQuery( "SELECT section FROM #__categories WHERE id IN ($cids)" );
	$secid = $database->loadResult();

	if (intval( $section ) > 0) {
		$table = 'content';
	} else if (strpos( $section, 'com_' ) === 0) {
		$table = substr( $section, 4 );
	} else {
		$table = $section;
	}

	$database->setQuery( "SELECT c.id, c.name,COUNT(s.catid) AS numcat"
	. "\nFROM #__categories AS c"
	. "\nLEFT JOIN #__$table AS s ON s.catid=c.id"
	. "\nWHERE c.id IN ($cids)"
	. "\nGROUP BY c.id"
	);

	if (!($rows = $database->loadObjectList())) {
		echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
	}

	$err = array();
	$cid = array();
	foreach ($rows as $row) {
		if ($row->numcat == 0) {
			$cid[] = $row->id;
		} else {
			$err[] = $row->name;
		}
	}

	if (count( $cid )) {
		$cids = implode( ',', $cid );
		$database->setQuery( "DELETE FROM #__categories WHERE id IN ($cids)" );
		if (!$database->query()) {
			echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		}
	}

	if (count( $err )) {
		$cids = implode( "\', \'", $err );
		mosRedirect( "index2.php?option=categories&section=$section"
			. "&mosmsg=Category(s): $cids cannot be removed as they contain records"
		);
	}

	mosRedirect( "index2.php?option=categories&section=$section" );
}

/**
* Publishes or Unpublishes one or more categories
* @param string The name of the category section
* @param integer A unique category id (passed from an edit form)
* @param array An array of unique category id numbers
* @param integer 0 if unpublishing, 1 if publishing
* @param string The name of the current user
*/
function publishCategories( $section, $categoryid=null, $cid=null, $publish=1 ) {
	global $database, $my;

	if (!is_array( $cid )) {
		$cid = array();
	}
	if ($categoryid) {
		$cid[] = $categoryid;
	}

	if (count( $cid ) < 1) {
		$action = $publish ? 'publish' : 'unpublish';
		echo "<script> alert('Select a category to $action'); window.history.go(-1);</script>\n";
		exit;
	}

	$cids = implode( ',', $cid );

	$database->setQuery( "UPDATE #__categories SET published='$publish'"
	. "\nWHERE id IN ($cids) AND (checked_out=0 OR (checked_out='$my->id'))"
	);
	if (!$database->query()) {
		echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		exit();
	}

	if (count( $cid ) == 1) {
		$row = new mosCategory( $database );
		$row->checkin( $cid[0] );
	}

	mosRedirect( "index2.php?option=categories&section=$section" );
}

/**
* Cancels an edit operation
* @param string The name of the category section
* @param integer A unique category id
*/
function cancelCategory() {
	global $database;

	$row = new mosCategory( $database );
	$row->bind( $_POST );
	$row->checkin();
	mosRedirect( "index2.php?option=categories&section=$row->section" );
}

/**
* Moves the order of a record
* @param integer The increment to reorder by
*/
function orderCategory( $uid, $inc ) {
	global $database;

	$row = new mosCategory( $database );
	$row->load( $uid );
	$row->move( $inc, "section='$row->section'" );
	mosRedirect( "index2.php?option=categories&section=$row->section" );
}
?>
