<?php
// Invision Power Board v1.1.x / v1.2.x
error_reporting(7);
require ("./../admin/bbimport.php");

if ($perpage=="") {
	$perpage = 50;
}
	
// ####################################################################################
// HTML2vBCode CONVERT FUNCTIONS
// ####################################################################################
	function unconvert_size($size="", $text="") {
		switch($size) {
		   case '21':
		      $size=4;
		      break;
		   case '14':
		      $size=3;
		      break;
		   case '8':
		      $size=1;
		      break;
		   default:
		      $size=2;
		      break;
		}
		return '[SIZE='.$size.']'.$text.'[/SIZE]';
	}
	function unconvert($post="") {
	   $post = preg_replace('#<u>([^"]*)</u>#siU', '[u]\\1[/u]', $post);
	   $post = preg_replace('#<b>([^"]*)</b>#siU', '[b]\\1[/b]', $post);
	   $post = preg_replace('#<i>([^"]*)</i>#siU', '[i]\\1[/i]', $post);
	   $post = preg_replace('#<span style=\'font-family:([^"]*)\'>([^"]*)</span>#siU', '[font=\\1]\\2[/font]', $post);
	   $post = preg_replace('#<span style=\'color:([^"]*)\'>([^"]*)</span>#siU', '[color=\\1]\\2[/color]', $post);
	   $post = preg_replace('#<a href=\'(http://|https://|ftp://|news://)([^"]*)\' target=\'_blank\'>([^"]*)</a>#siU', '[url=\\1\\2]\\3[/url]', $post);
	   $post = preg_replace('#<img src=\'([^"]*)\' border=\'0\' alt=\'user posted image\'>#siU', '[img]\\1[/img]', $post);
	   $post = preg_replace('#<a href=\'mailto:([^"]*)\'>([^"]*)</a>#siU', '[email=\\1]\\2[/email]', $post);
	   $post = preg_replace('#<ul>#siU', '[list]', $post);
	   $post = preg_replace('#<li>#siU', '[*]', $post);
	   $post = preg_replace('#</ul>#siU', '[/list]', $post);
	   $post = preg_replace('#<!--emo&([^"]*)-->([^"]*)<!--endemo-->#siU', '\\1', $post);
	   $post = preg_replace('#<!--c1-->([^"]*)<!--ec1-->#siU', '[code]', $post);
	   $post = preg_replace('#<!--c2-->([^"]*)<!--ec2-->#siU', '[/code]', $post);
	   $post = preg_replace('#<!--QuoteBegin-->([^"]*)<!--QuoteEBegin-->#siU', '[quote][b]', $post);
	   $post = preg_replace('#<!--QuoteBegin--([^"]*)\+-->([^"]*)<!--QuoteEBegin-->#siU', '[quote][i]Originally posted by \\1[/i]<br>[b]', $post);
	   $post = preg_replace('#<!--QuoteBegin--([^"]*)\+([^"]*)-->([^"]*)<!--QuoteEBegin-->#siU', '[quote][i]Originally posted by \\1[/i]@\\2<br>[b]', $post);
	   $post = preg_replace('#<!--QuoteEnd-->([^"]*)<!--QuoteEEnd-->#siU', '[/b][/quote]', $post);
	   $post = preg_replace('#<span style=\'font-size:(.+?)pt;line-height:100%\'>(.+?)</span>#e', 'unconvert_size("\\1", "\\2")', $post);
	   $post = str_replace("<br>","\n",$post);
	   $post = str_replace("&amp;","&",$post);
      $post = str_replace("&lt;","<",$post);
      $post = str_replace("&gt;",">",$post);
      $post = str_replace("&quot;","\"",$post);
      $post = str_replace("&#039;","'",$post);
      $post = str_replace("&#033;","!",$post);
      $post = str_replace("&#124;","|",$post);

	   return trim(stripslashes($post));
	}
	
// ####################################################################################

// ####################################################################################
// DO CLEAN UP
// ####################################################################################

if ($action=="docleanup") {

	cleandb();
	header("Location: ../admin/misc.php?s=$session[sessionhash]");
	exit;

}

// ####################################################################################

//suppress gzipping
$nozip=1;
cpheader("<title>Invision Power Board v1.1.x / v1.2.x &raquo; vBulletin 2.3.x Importer</title>");

// ####################################################################################

echo "<table width='100%' border='0'><tr><td><b>Invision Power Board v1.1.x / v1.2.x &raquo; vBulletin 2.3.x Importer</b></td><td align='right'>\n";
echo makelinkcode("empty temp tables","bbimport_invib.php?s=$session[sessionhash]&action=emptytemp&idbname=$idbname");
//echo makelinkcode("restart","../admin/bbimport.php?s=$session[sessionhash]");
echo makelinkcode("kill posts","bbimport_invib.php?s=$session[sessionhash]&action=killposts&idbname=$idbname");
echo makelinkcode("reset users","bbimport_invib.php?s=$session[sessionhash]&action=resetusers&idbname=$idbname");
echo "</td>\n</tr></table><hr>\n\n\n";

// ####################################################################################
// START - get paths
// ####################################################################################

if ($action=="start") {

	require ("./../admin/config.php");
	echo "<p>Specify some variables for the Invision Power Board Database</p>\n";

	doformheader("bbimport_invib","initdb");
	maketableheader("Step 1: Initialize Database For vBulletin Import");
	makedescription("At the present time, the Invision Power Board database must be located on the same MySQL server as the main vBulletin database.<br>The MySQL username and password must be the same for both the vBulletin and the Invision Power Board database!");
	//makeinputcode("Server Address of Invision Power Board database","iserver",$servername,1,60);
	makeinputcode("Name of Invision Power Board Database","idbname","databasename",1,60);
	makeinputcode("Invision Power Board Table Prefix","idbprefix","ibf_",1,60);
	makeinputcode("Path to IPB uploads folder (for attachments) (no trailing slash)", "ipbuploads", "", 1, 60);
	//makeinputcode("mySQL username for Invision Power Board Database","iuser",$dbusername,1,60);
	//makeinputcode("mySQL password for Invision Power Board Database","ipasswd",$dbpassword,1,60);
	//makeinputcode("URL of your Invision Power Board Forums<br>This can be either a relative path from your vBulletin 2 installation, or a full http:// address. Do not add a trailing slash to the address.","relativepath","../ibf",1,60);
	doformfooter("Start Import","Reset Paths");

}

// ####################################################################################
// INITIALISE DATABASE FOR IMPORT
// ####################################################################################

if ($action=="initdb") {

	initdb();
	
	$DB_site->query("DROP TABLE IF EXISTS ipmimport");
	$DB_site->query("CREATE TABLE ipmimport (
                                 importuserid int(10) unsigned NOT NULL,
                                 vid varchar(32) NOT NULL DEFAULT '',
                                 folderid smallint(6) NOT NULL default '0',
                                 PRIMARY KEY  (importuserid, vid)
                                 )");

	$action = "usergroups";

}

// ####################################################################################
// IMPORT USERGROUPS
// ####################################################################################

if ($action=="usergroups") {

	doformheader("bbimport_invib","dousergroups");
	makehiddencode("iserver","$iserver");
	makehiddencode("idbname","$idbname");
	makehiddencode("idbprefix","$idbprefix");
	makehiddencode("iuser","$iuser");
	makehiddencode("ipasswd","$ipasswd");
	makehiddencode("ipbuploads","$ipbuploads");

	maketableheader("Step 2: Import Invision Power Board Usergroups");
	makedescription("<p>We will now import all your Invision Power Board usergroups into the vBulletin database.<br><br>After the import is complete you need to set all forum permissions of the usergroups. These are not imported!</p>");

	doformfooter("Import usergroups");

}

// ####################################################################################
// DO IMPORT USERGROUPS
// ####################################################################################

if ($action=="dousergroups") {


	echo "<p>Importing usergroups ....</p>\n\n";
	flush();

   //import standard usergroup settings
   $susergroups=$DB_site->query("SELECT g_id AS importusergroupid,g_view_board AS canview,g_mem_info AS canviewmembers,
                                 g_other_topics AS canviewothers,g_use_search AS cansearch,g_email_friend AS canemail,
                                 g_edit_profile AS canmodifyprofile,g_post_new_topics AS canpostnew,
                                 g_reply_own_topics AS canreplyown,g_reply_other_topics AS canreplyothers,
                                 g_edit_posts AS caneditpost,g_delete_own_posts AS candeleteownpost,
                                 g_open_close_posts AS canopenclose,g_delete_own_topics AS candeletethread,
                                 g_post_polls AS canpostpoll,g_vote_polls AS canvote,g_use_pm AS canusepm,
                                 g_is_supmod AS ismoderator,g_access_cp AS cancontrolpanel,g_title AS title,
                                 g_max_mass_pm AS maxbuddypm
                                 FROM $idbname.".$idbprefix."groups
                                 ORDER BY importusergroupid
                                 LIMIT 0,4");
   
   if ($DB_site->num_rows($susergroups)) {
		while ($susergroup = $DB_site->fetch_array($susergroups)) {
		   switch ($susergroup['importusergroupid']) {
				case "4" :
					//Administrator
					$susergroupid = 6;
					break;
				case "3" :
					//Registered Member
					$susergroupid = 2;
					break;
				case "2" :
					//Guest/Unregistered
					$susergroupid = 1;
					break;
				case "1" :
					//Awaiting Confirmation
					$susergroupid = 3;
					break;
			}
					   
		   $result = $DB_site->query("UPDATE usergroup SET		      
		     cancontrolpanel='".checkdef($susergroup[cancontrolpanel],0)."',
    	     canmodifyprofile='".checkdef($susergroup[canmodifyprofile],1)."',
    	     canviewmembers='".checkdef($susergroup[canviewmembers],1)."',
     	     canview='".checkdef($susergroup[canview],1)."',
		     showgroup='".checkdef($susergroup[showgroup],0)."',
    	     cansearch='".checkdef($susergroup[cansearch],1)."',
    	     canemail='".checkdef($susergroup[canemail],1)."',
		     canpostnew='".checkdef($susergroup[canpostnew],1)."',
		     canmove='".checkdef($susergroup[canmove],0)."',
		     canopenclose='".checkdef($susergroup[canopenclose],0)."',
		     candeletethread='".checkdef($susergroup[candeletethread],0)."',
		     canreplyown='".checkdef($susergroup[canreplyown],1)."',
		     canreplyothers='".checkdef($susergroup[canreplyothers],1)."',
    	     canviewothers='".checkdef($susergroup[canviewothers],1)."',
		     caneditpost='".checkdef($susergroup[caneditpost],1)."',
		     candeletepost='".checkdef($susergroup[candeletepost],0)."',
		     canusepm='".checkdef($susergroup[canusepm],1)."',
		     canpostpoll='".checkdef($susergroup[canpostpoll],1)."',
		     canvote='".checkdef($susergroup[canvote],1)."',
		     canpostattachment='".checkdef($susergroup[canpostattachment],1)."',
		     ismoderator='".checkdef($susergroup[ismoderator],0)."',
		     canpublicedit='".checkdef($susergroup[canpublicedit],0)."',
		     canpublicevent='".checkdef($susergroup[canpublicevent],0)."',
		     canthreadrate='".checkdef($susergroup[canthreadrate],1)."',
		     cantrackpm='".checkdef($susergroup[cantrackpm],1)."',
		     candenypmreceipts='".checkdef($susergroup[candenypmreceipts],1)."',
		     maxbuddypm='".checkdef($susergroup[maxbuddypm],5)."',
		     maxforwardpm='".checkdef($susergroup[maxforwardpm],5)."',
		     canwhosonline='".checkdef($susergroup[canwhosonline],1)."',
		     canwhosonlineip='".checkdef($susergroup[canwhosonlineip],0)."',
		     cangetattachment='".checkdef($susergroup[cangetattachment],1)."',
    	     importusergroupid=$susergroup[importusergroupid]
		     WHERE usergroupid=$susergroupid");
		}
   }

	if ($startat=="") {
		$startat = 4;
	}
	$perpage = 10;

	$iusergroups=$DB_site->query("SELECT g_id AS importusergroupid,g_view_board AS canview,g_mem_info AS canviewmembers,
                                 g_other_topics AS canviewothers,g_use_search AS cansearch,g_email_friend AS canemail,
                                 g_edit_profile AS canmodifyprofile,g_post_new_topics AS canpostnew,
                                 g_reply_own_topics AS canreplyown,g_reply_other_topics AS canreplyothers,
                                 g_edit_posts AS caneditpost,g_delete_own_posts AS candeleteownpost,
                                 g_open_close_posts AS canopenclose,g_delete_own_topics AS candeletethread,
                                 g_post_polls AS canpostpoll,g_vote_polls AS canvote,g_use_pm AS canusepm,
                                 g_is_supmod AS ismoderator,g_access_cp AS cancontrolpanel,g_title AS title,
                                 g_max_mass_pm AS maxbuddypm
                                 FROM $idbname.".$idbprefix."groups
                                 ORDER BY importusergroupid
                                 LIMIT $startat,$perpage");
	if ($DB_site->num_rows($iusergroups)) {
		while ($iusergroup = $DB_site->fetch_array($iusergroups)) {
		   
		   $result = $DB_site->query("INSERT into usergroup
		      (usergroupid,title,usertitle,cancontrolpanel,canmodifyprofile,canviewmembers,canview,showgroup,cansearch,canemail,canpostnew,canmove,canopenclose,candeletethread,canreplyown,canreplyothers,canviewothers,caneditpost,candeletepost,canusepm,canpostpoll,canvote,canpostattachment,ismoderator,canpublicevent,canpublicedit,canthreadrate,cantrackpm,candenypmreceipts,maxbuddypm,maxforwardpm,canwhosonline,canwhosonlineip,cangetattachment,importusergroupid)
		     VALUES (
		     '',
		     '".addslashes($iusergroup[title])."',
		     '".checkdef(addslashes($iusergroup[usertitle]),addslashes($iusergroup[title]))."',
		     '".checkdef($iusergroup[cancontrolpanel],0)."',
    	     '".checkdef($iusergroup[canmodifyprofile],1)."',
    	     '".checkdef($iusergroup[canviewmembers],1)."',
     	     '".checkdef($iusergroup[canview],1)."',
		     '".checkdef($iusergroup[showgroup],0)."',
    	     '".checkdef($iusergroup[cansearch],1)."',
    	     '".checkdef($iusergroup[canemail],1)."',
		     '".checkdef($iusergroup[canpostnew],1)."',
		     '".checkdef($iusergroup[canmove],0)."',
		     '".checkdef($iusergroup[canopenclose],0)."',
		     '".checkdef($iusergroup[candeletethread],0)."',
		     '".checkdef($iusergroup[canreplyown],1)."',
		     '".checkdef($iusergroup[canreplyothers],1)."',
    	     '".checkdef($iusergroup[canviewothers],1)."',
		     '".checkdef($iusergroup[caneditpost],1)."',
		     '".checkdef($iusergroup[candeletepost],0)."',
		     '".checkdef($iusergroup[canusepm],1)."',
		     '".checkdef($iusergroup[canpostpoll],1)."',
		     '".checkdef($iusergroup[canvote],1)."',
		     '".checkdef($iusergroup[canpostattachment],1)."',
		     '".checkdef($iusergroup[ismoderator],0)."',
		     '".checkdef($iusergroup[canpublicevent],0)."',
		     '".checkdef($iusergroup[canpublicedit],0)."',
		     '".checkdef($iusergroup[canthreadrate],1)."',
		     '".checkdef($iusergroup[cantrackpm],1)."',
		     '".checkdef($iusergroup[candenypmreceipts],1)."',
		     '".checkdef($iusergroup[maxbuddypm],5)."',
		     '".checkdef($iusergroup[maxforwardpm],5)."',
		     '".checkdef($iusergroup[canwhosonline],1)."',
		     '".checkdef($iusergroup[canwhosonlineip],0)."',
		     '".checkdef($iusergroup[cangetattachment],1)."',
    	     $iusergroup[importusergroupid]
		     )");
		     
		  $usergroupid = $DB_site->insert_id($result);
		   
		  echo "<i>".htmlspecialchars($iusergroup[title])."</i> inserted sucessfully".iif($pause,makelinkcode("edit","../admin/usergroup.php?s=$session[sessionhash]&action=edit&usergroupid=$usergroupid",1),"")."</p>\n\n";
                  flush();
                  unset ($iusergroup);
		   
		}

		$iserver = urlencode($iserver);
		$idbname = urlencode($idbname);
		$idbprefix = urlencode($idbprefix);
		$iuser = urlencode($iuser);
		$ipasswd = urlencode($ipasswd);
		$ipbuploads = urlencode($ipbuploads);

		$startat+=$perpage;

		echo iif(!$pause,"<script language=\"javascript\">window.location=\"bbimport_invib.php?s=$session[sessionhash]&action=dousergroups&startat=$startat&perpage=$perpage&pause=$pause&iserver=$iserver&idbname=$idbname&idbprefix=$idbprefix&iuser=$iuser&ipasswd=$ipasswd&ipbuploads=$ipbuploads\";</script>\b","");
		echo "<hr><b>&raquo; <a href=\"bbimport_invib.php?s=$session[sessionhash]&action=dousergroups&startat=$startat&perpage=$perpage&pause=$pause&iserver=$iserver&idbname=$idbname&idbprefix=$idbprefix&iuser=$iuser&ipasswd=$ipasswd&ipbuploads=$ipbuploads\">Click here to continue importing usergroups</a> &laquo;</b>\n";

	} else {
		echo "<p>Usergroups imported sucessfully.</p>";
		$action = "associateusers";
	}

}

// ####################################################################################
// ASSOCIATE USERS
// ####################################################################################

if ($action=="associateusers") {

	doformheader("bbimport_invib","associate");
	makehiddencode("iserver","$iserver");
	makehiddencode("idbname","$idbname");
	makehiddencode("idbprefix","$idbprefix");
	makehiddencode("iuser","$iuser");
	makehiddencode("ipasswd","$ipasswd");
	makehiddencode("ipbuploads","$ipbuploads");

	maketableheader("Step 3: Associate Invision Power Board Users");
	makedescription("<p>Before you import the Invision Power Board users into the vBulletin database,
        you may want to instruct the importer to associate users from the Invision Power Board
        with existing users in the vBulletin database (such as yourself), in order to prevent duplication,
        which can be difficult to correct at a later date.</p>
        <p>This step is optional, and you may proceed to the members import at any time by clicking the link displayed on every page.</p>
        <p>You may use the association section as many times as you wish, in order to set up all the associations you want.</p>
        <p>A complete listing of all existing vBulletin users, along with their user id number is available for your reference.</p>");

	doformfooter("Associate users");

}

// ####################################################################################
// DO ASSOCIATE USERS
// ####################################################################################

if ($action == "doassociate") {

    if (is_array($ipbuserid)) {

        $users = $DB_site->query("SELECT userid FROM user");
        while ($user = $DB_site->fetch_array($users)) { $userlist .= "|$user[userid]"; }
        $userlist .= "|";

        echo "<font size='1'>\n";
        while (list($ipbuid,$vbuid)=each($ipbuserid)) {
            if ($vbuid!="") {
                echo "&raquo; Associating vBulletin user $vbuid with Invision Power Board user $ipbuid ....\n";
                if (strstr($userlist,"|$vbuid|")) {
                    $result = $DB_site->query("UPDATE user SET importuserid='$ipbuid' WHERE userid='$vbuid'");
                    echo "ok.<br>\n";
                } else {
                    echo "no such user in vBulletin database!<br>\n";
                }
            }
        }
        echo "</font><hr>\n";
    }
    $action = "associate";

}

// ####################################################################################
// ASSOCIATE
// ####################################################################################

if ($action == "associate") {
    
    if ($startat == "") {
        $startat = 0;
    }
    if ($perpage == "") {
        $perpage = 10;
    }
    if ($page == "") {
        $page = 1;
    }

    $vbuserid = getuserids();

    $membercounts = $DB_site->query_first("SELECT COUNT(*) AS count FROM $idbname.".$idbprefix."members");
    $membercount = $membercounts['count'];

    echo "<p><font size='1'>If you want to associate a Invision Power Board user (in the left column) with an existing vBulletin user,
    enter the user id number of the vBulletin user in the box provided, and click the <i>'Associate Users'</i> button.<br>
    <br>
    To view the list of existing vBulletin users, together with their userid,".
    makelinkcode("click here","../admin/bbimport.php?s=$session[sessionhash]&action=listvbusers",1)."</font></p>\n\n";

    //print users with same name
    $problemusers = $DB_site->query("SELECT userid,username,id
    											FROM user AS user
												LEFT JOIN $idbname.".$idbprefix."members AS members ON (username = members.name)
												WHERE username = members.name
													AND importuserid=0
												ORDER BY username");
	if ($DB_site->num_rows($problemusers)) {
    	doformheader("bbimport_invib","doassociate");
    	makehiddencode("iserver","$iserver");
	 	makehiddencode("idbname","$idbname");
	 	makehiddencode("idbprefix","$idbprefix");
	 	makehiddencode("iuser","$iuser");
	 	makehiddencode("ipasswd","$ipasswd");
	 	makehiddencode("ipbuploads","$ipbuploads");

	 	maketableheader("Duplicate Users found !!");
	 	makedescription("If you start importing now you will have duplicate users in your vBulletin because one or more users in your Invision Power Board have the same name like existing ones in your vBulletin.<br><b>This would be a severe problem!</b><br><br>You should associate an Invision Power Board user with an existing vBulletin user or rename the vBulletin user before starting the import process.<br><br>If you know that the users are the same you can use the shown vBulletin userid for association.<br><br>If they are not the same you should rename the vBulletin now and then click 'Associate Users' once afterwards to update the duplicate users list.");
		echo "<tr class='tblhead'>
    			<td><font size='1'><b><span class='tblhead'>Invision Power Board Username</span></b></font></td>
    			<td><font size='1'><b><span class='tblhead'>Associate with vBulletin Userid</span></b></font></td>\n</tr>\n";
	 	while ($problemuser = $DB_site->fetch_array($problemusers)) {
	 		makeinputcode("$problemuser[username]<br><font size='1'><a href=\"../admin/user.php?s=$session[sessionhash]&action=edit&userid=$problemuser[userid]\" target=\"_blank\">rename vBulletin user</a>, vBulletin userid: $problemuser[userid]</font>", "ipbuserid[$problemuser[id]]", $vbuserid[$user['uid']],1,8);
	 	}
	 
	 	doformfooter("Associate users");
	 }

    $pages = ceil($membercount/$perpage);
    echo "Page $page of $pages\n";
    $startat = ($perpage * ($page-1));
    echo "<form method='bbimport_invib.php' method='post'><b>Jump to page</b>: <input type='text' name='page' value='$page' size='5'> <input type='submit' value=' Go '>";
    makehiddencode("startat",$startat);
    makehiddencode("perpage",$perpage);
    makehiddencode("action", "doassociate");
	 makehiddencode("iserver","$iserver");
	 makehiddencode("idbname","$idbname");
	 makehiddencode("idbprefix","$idbprefix");
	 makehiddencode("iuser","$iuser");
	 makehiddencode("ipasswd","$ipasswd");
	 makehiddencode("ipbuploads","$ipbuploads");
    echo "</font></center></form>\n";

    // end page nav

    doformheader("bbimport_invib","doassociate");
    makedescription("<center>".
	 makelinkcode(" <b>Click here when you have finished associating users</b> ",
        "bbimport_invib.php?s=$session[sessionhash]&action=users&startat=$startat&perpage=$perpage&pause=$pause&iserver=$iserver&idbname=$idbname&idbprefix=$idbprefix&iuser=$iuser&ipasswd=$ipasswd&ipbuploads=$ipbuploads")."</center>");
    restarttable();


    makehiddencode("startat",$startat);
    makehiddencode("perpage",$perpage);
    makehiddencode("iserver","$iserver");
	 makehiddencode("idbname","$idbname");
	 makehiddencode("idbprefix","$idbprefix");
	 makehiddencode("iuser","$iuser");
	 makehiddencode("ipasswd","$ipasswd");
	 makehiddencode("ipbuploads","$ipbuploads");
    echo "<tr class='tblhead'>
    <td><font size='1'><b><span class='tblhead'>Invision Power Board Username</span></b></font></td>
    <td><font size='1'><b><span class='tblhead'>Associate with vBulletin Userid</span></b></font></td>\n</tr>\n";

    $users = $DB_site->query("SELECT * FROM $idbname.".$idbprefix."members LIMIT $startat,$perpage");
    while ($user = $DB_site->fetch_array($users)) {
        makeinputcode("$user[name]", "ipbuserid[$user[id]]", $vbuserid[$user['uid']],1,8);

    }
    doformfooter("Associate Users");

}

// ####################################################################################
// IMPORT USERS
// ####################################################################################

if ($action=="users") {

	doformheader("bbimport_invib","dousers");
	makehiddencode("iserver","$iserver");
	makehiddencode("idbname","$idbname");
	makehiddencode("idbprefix","$idbprefix");
	makehiddencode("iuser","$iuser");
	makehiddencode("ipasswd","$ipasswd");
	makehiddencode("ipbuploads","$ipbuploads");

	maketableheader("Step 4: Import Invision Power Board Users");
	makedescription("<p>We will now import all your Invision Power Board users into the vBulletin database.</p>");
	makeinputcode("Path to IPB avatars folder (for avatars) (no trailing slash)", "ipbavatars", "", 1, 60);
	makeinputcode("Users to import per cycle", "perpage", "50");
	makeyesnocode("Would you like to pause the import after each page so you can edit individual users?","pause",0);
   makeyesnocode("Would you like to empty your existing vBulletin members database? (this will delete all users except for the user you are currently logged on as)","clearusers",0);

	doformfooter("Import users");

}

// ####################################################################################
// DO IMPORT USERS
// ####################################################################################

if ($action=="dousers") {

	echo "<p>Importing users ....</p>\n\n";
	flush();

	if ($startat=="") {
		$startat = 0;
	}
	
	if ($perpage=="") {
		$perpage = 50;
	}
	
   if ($clearusers == "1") {
   	$users = $DB_site->query("SELECT userid FROM user WHERE userid != '$bbuserinfo[userid]'");
      while ($user = $DB_site->fetch_array($users)) {
          $userstodelete .= ", $user[userid]";
      }
      $DB_site->query("DELETE FROM user WHERE userid IN (0$userstodelete)");
      $DB_site->query("DELETE FROM userfield WHERE userid IN (0$userstodelete)");
		$DB_site->query("DELETE FROM privatemessage WHERE userid IN (0$userstodelete)");
		$DB_site->query("DELETE FROM customavatar WHERE userid IN (0$userstodelete)");
		$DB_site->query("DELETE FROM access WHERE userid IN (0$userstodelete)");
		$DB_site->query("DELETE FROM calendar_events WHERE userid IN (0$userstodelete)");
		$DB_site->query("DELETE FROM moderator WHERE userid IN (0$userstodelete)");
		$DB_site->query("DELETE FROM subscribeforum WHERE userid IN (0$userstodelete)");
		$DB_site->query("DELETE FROM subscribethread WHERE userid IN (0$userstodelete)");
		$DB_site->query("DELETE FROM session WHERE userid IN (0$userstodelete)");
		$DB_site->query("DELETE FROM useractivation WHERE userid IN (0$userstodelete)");
      echo("Existing vBulletin member database emptied...<br><br>\n");
    }

	$doneusers = $DB_site->query("SELECT userid,username,importuserid FROM user WHERE importuserid<>0");
	while ($doneuser = $DB_site->fetch_array($doneusers)) {
		$doneuserids .= "|$doneuser[importuserid]";
	}
	$doneuserids .= "|";

	$iusers = $DB_site->query("SELECT name AS username,password AS password,email AS email,posts AS posts,last_visit AS lastvisit,last_activity AS lastactivity,last_post AS lastpost,coppa_user AS coppauser, website AS homepage,interests AS hobbies,aim_name AS aim,icq_number AS icq,yahoo AS yahoo,location AS location,signature AS signature,id AS importuserid,joined AS joindate,avatar AS avatar,ip_address AS ipaddress,mgroup AS importusergroupid,hide_email AS showemail, $idbname.".$idbprefix."members.title AS usertitle,time_offset AS timezoneoffset,usergroupid,bday_day,bday_month,bday_year,interests,LENGTH(interests) AS interestslength FROM $idbname.".$idbprefix."members LEFT JOIN usergroup on ($idbname.".$idbprefix."members.mgroup = usergroup.importusergroupid) WHERE NOT(importusergroupid=1 AND usergroupid!=3) ORDER BY importuserid LIMIT $startat,$perpage");
	if ($DB_site->num_rows($iusers)) {
		while ($iuser = $DB_site->fetch_array($iusers)) {
			
			//usernames need to be reconverted so that vb can convert them when inserting
			$searcharray = array(
				"'&lt;'i",
				"'&gt;'i",
				"'&quot;'i",
				"'&#39;'i",
				"'&amp;'i"
				);
			$replacearray = array(
				"<",
				">",
				"\"",
				"'",
				"&"
				);
			$iuser['username'] = preg_replace($searcharray, $replacearray, $iuser['username']);
			
			if (strstr($doneuserids,"|".intval($iuser[importuserid])."|")) {
					echo "Member <i>$iuser[username]</i> already associated with a vBulletin user.</p>\n";
					continue;
			}
		   switch ($iuser['importusergroupid']) {
				case "4" :
					//Administrator
					$iuser['usergroupid'] = 6;
					break;
				case "3" :
					//Registered Member
					$iuser['usergroupid'] = 2;
					break;
				case "2" :
					//Guest/Unregistered
					$iuser['usergroupid'] = 1;
					break;
				case "1" :
					//Awaiting Confirmation
					$iuser['usergroupid'] = 3;
					break;
		   }
		   $iuser['birthday'] = $iuser['bday_year'].'-'.iif(strlen($iuser['bday_month'])==1,"0".$iuser['bday_month'],$iuser['bday_month']).'-'.$iuser['bday_day'];
		   $iuser['interests'] = str_replace('<br>',' ',$iuser['interests']);
		   $iuser['interests'] = iif($iuser['interestslength']<251,$iuser['interests'],substr($iuser['interests'],0,250));
		   $iuser[signature] = unconvert($iuser[signature]);
		   $iuser[showemail] = iif($iuser[showemail]==1,0,1);
		   
		   if ($iuser['importusergroupid']=='' OR $iuser['importusergroupid']=='0' OR !isset($iuser['importusergroupid'])) {
		      if ($iuser[username] != $lastuser) {
		         $iuser['usergroupid'] = 4;
		         if ($iuser['importuserid'] != 0) {
		      		$userid=importuser($iuser,0);
		      	}
		         $notimported .= "User: <b>$iuser[username]</b>,  IPB mgroupid: <b>$iuser[importusergroupid]</b><br>";
		      }
		      $lastuser = $iuser[username];
		   } else {
		   	if ($iuser['importuserid'] != 0) {
		      	$userid=importuser($iuser,0);
		      }
		   }
		   
		   // avatar import
		   if ($iuser['avatar'] != "noavatar" and $iuser['avatar'] != "") {
		   	if (substr($iuser['avatar'],0,4) == "http") {
		   		importcustomavatar($userid,$iuser['avatar']);
		   	} elseif (substr($iuser['avatar'],0,7) == "upload:") {
		   		$iuser['avatar'] = substr($iuser['avatar'],7);
		   		$file = fopen(($ipbuploads."/".$iuser['avatar']) ,'rb');
					if($file) {
						$iavatar['filedata'] = fread($file, filesize(($ipbuploads."/".$iuser['avatar'])));
						fclose($file);
						$DB_site->query("INSERT INTO customavatar VALUES ($userid,'".addslashes($iavatar[filedata])."',".time().",'".addslashes($iuser[avatar])."')");
						}
		   	} else {
		   		$file = fopen(($ipbavatars."/".$iuser['avatar']) ,'rb');
					if($file) {
						$iavatar['filedata'] = fread($file, filesize(($ipbavatars."/".$iuser['avatar'])));
						fclose($file);
						$DB_site->query("INSERT INTO customavatar VALUES ($userid,'".addslashes($iavatar[filedata])."',".time().",'".addslashes($iuser[avatar])."')");
		   		}
		   	}
		   }
		}

		$iserver = urlencode($iserver);
		$idbname = urlencode($idbname);
		$idbprefix = urlencode($idbprefix);
		$iuser = urlencode($iuser);
		$ipasswd = urlencode($ipasswd);
		$ipbuploads = urlencode($ipbuploads);

		$startat+=$perpage;

		echo iif(!$pause,"<script language=\"javascript\">window.location=\"bbimport_invib.php?s=$session[sessionhash]&action=dousers&startat=$startat&perpage=$perpage&pause=$pause&iserver=$iserver&idbname=$idbname&idbprefix=$idbprefix&iuser=$iuser&ipasswd=$ipasswd&notimported=$notimported&ipbuploads=$ipbuploads\";</script>\b","");
		echo "<hr><b>&raquo; <a href=\"bbimport_invib.php?s=$session[sessionhash]&action=dousers&startat=$startat&perpage=$perpage&pause=$pause&iserver=$iserver&idbname=$idbname&idbprefix=$idbprefix&iuser=$iuser&ipasswd=$ipasswd&notimported=$notimported&ipbuploads=$ipbuploads\">Click here to continue importing users</a> &laquo;</b>\n";

	} else {
		// do banned users:
		if ($bannedgroup=$DB_site->query_first("SELECT usergroupid FROM usergroup WHERE title='Imported Banned Users'")) {

			$ibannedusers = $DB_site->query("SELECT name AS username FROM $idbname.".$idbprefix."members
			                                 LEFT JOIN $idbname.".$idbprefix."groups ON ($idbname.".$idbprefix."groups.g_id=$idbname.".$idbprefix."members.mgroup)
			                                 WHERE $idbname.".$idbprefix."groups.g_title LIKE '%banned%'");
			while ($ibanned = $DB_site->fetch_array($ibannedusers)) {
				$DB_site->query("UPDATE user SET usergroupid=$bannedgroup[usergroupid] WHERE username='".addslashes($ibanned['username'])."'");
			}
		}
		echo "<p>Users imported sucessfully.</p>";
		if ($notimported) {
			echo "The following users could not be imported correctly because of invalid database entries.<br>You can find them in the \"(COPPA) Users Awaiting Moderation\" usergroup:<br>".$notimported;
		}
		$action = "buddylists";
	}

}

// ####################################################################################
// IMPORT BUDDY LISTS
// ####################################################################################

if ($action=="buddylists") {

	doformheader("bbimport_invib","dobuddylists");
	makehiddencode("iserver","$iserver");
	makehiddencode("idbname","$idbname");
	makehiddencode("idbprefix","$idbprefix");
	makehiddencode("iuser","$iuser");
	makehiddencode("ipasswd","$ipasswd");
	makehiddencode("ipbuploads","$ipbuploads");

	maketableheader("Step 5: Import Invision Power Board Contact Lists");
	makedescription("<p>We will now import all your Invision Power Board Contact Lists into the vBulletin database.</p>");

	doformfooter("Import Contact Lists");

}

// ####################################################################################
// DO IMPORT BUDDY LISTS
// ####################################################################################

if ($action=="dobuddylists") {


	echo "<p>Importing Contact Lists ....</p>\n\n";
	flush();

	if ($startat=="") {
		$startat = 0;
	}

	$ibuddys=$DB_site->query("SELECT contact_id AS buddyid,allow_msg,userid
                             FROM $idbname.".$idbprefix."contacts,user
                             WHERE user.importuserid=".$idbprefix."contacts.member_id
                             ORDER BY ".$idbprefix."contacts.member_id LIMIT $startat,$perpage");
	if ($DB_site->num_rows($ibuddys)) {
		while ($ibuddy = $DB_site->fetch_array($ibuddys)) {
		   $realuserid=$DB_site->query_first("SELECT userid FROM user WHERE importuserid=$ibuddy[buddyid]");
		   if ($ibuddy['allow_msg'] == 1) {
		   	$ibuddy[buddylist]=$realuserid[userid];
		   }
		   elseif ($ibuddy['allow_msg'] == 0) {
		   	$ibuddy[ignorelist]=$realuserid[userid];
		   }
			importbuddyignore($ibuddy);
		}

		$iserver = urlencode($iserver);
		$idbname = urlencode($idbname);
		$idbprefix = urlencode($idbprefix);
		$iuser = urlencode($iuser);
		$ipasswd = urlencode($ipasswd);
		$ipbuploads = urlencode($ipbuploads);

		$startat+=$perpage;

		echo iif(!$pause,"<script language=\"javascript\">window.location=\"bbimport_invib.php?s=$session[sessionhash]&action=dobuddylists&startat=$startat&perpage=$perpage&pause=$pause&iserver=$iserver&idbname=$idbname&idbprefix=$idbprefix&iuser=$iuser&ipasswd=$ipasswd&ipbuploads=$ipbuploads\";</script>\b","");
		echo "<hr><b>&raquo; <a href=\"bbimport_invib.php?s=$session[sessionhash]&action=dobuddylists&startat=$startat&perpage=$perpage&pause=$pause&iserver=$iserver&idbname=$idbname&idbprefix=$idbprefix&iuser=$iuser&ipasswd=$ipasswd&ipbuploads=$ipbuploads\">Click here to continue importing Contact Lists</a> &laquo;</b>\n";

	} else {
		echo "<p>Contact Lists imported sucessfully.</p>";
		$action = "pmfolders";
	}

}

// ####################################################################################
// IMPORT PM FOLDERS
// ####################################################################################

if ($action=="pmfolders") {

	doformheader("bbimport_invib","dopmfolders");
	makehiddencode("iserver","$iserver");
	makehiddencode("idbname","$idbname");
	makehiddencode("idbprefix","$idbprefix");
	makehiddencode("iuser","$iuser");
	makehiddencode("ipasswd","$ipasswd");
	makehiddencode("ipbuploads","$ipbuploads");

	maketableheader("Step 6: Import Invision Power Board private message folders");
	makedescription("<p>We will now import all your Invision Power Board private messages folders into the vBulletin database.</p>");

	doformfooter("Import private message folders");

}
// ####################################################################################
// DO IMPORT PM FOLDERS
// ####################################################################################

if ($action=="dopmfolders") {

	echo "<p>Importing private message folders ....</p>\n\n";
	flush();

	if ($startat=="") {
		$startat = 0;
	}

	$ipmfolders=$DB_site->query("SELECT id, vdirs, pmfolders
	                             FROM $idbname.".$idbprefix."members AS members
	                             LEFT JOIN user on (members.id=importuserid)
	                             WHERE id != 0
	                             LIMIT $startat, $perpage");
	if ($DB_site->num_rows($ipmfolders)) {
		while ($ipmfolder = $DB_site->fetch_array($ipmfolders)) {
			$foldercount = 0;
			$highestnum = 0;
			if ($ipmfolder['pmfolders']) {
				$allfolders = explode("\n", trim($ipmfolder['pmfolders']));
    				$foldercount = 0;
				while (list($key,$val) = each($allfolders)) {
      					$folder = explode("|||", $val);
      					$foldercount++;
      					$highestnum = $folder[0];
    				}
    			}
		   	foreach( explode("|", $ipmfolder['vdirs']) as $folder) {
		   		list ($folderipb, $foldername) = explode( ":", $folder );
			   	$folderid = substr($folderipb, 4);
			   	if ($folderid != "" and $highestnum) {
			   		$folderid = $folderid + $highestnum -1;
			   	} elseif ($highestnum == 0) {
			   		$folderid -= 1;
			   	}
			   	if ($folderid > 0) {
			   		$ipmfolder['pmfolders'] .= "\n$folderid|||$foldername";
	        		} elseif ($folderid > 0 and !$highestnum) {
	          			$ipmfolder['pmfolders'] = "$folderid|||$foldername";
	        		}
	        		if ($folderipb != "in" and $folderipb != "sent" and $folderipb) {
		        		$DB_site->query("INSERT INTO ipmimport
	   	     			(importuserid, vid, folderid)
	      	  			VALUES (
	        				'$ipmfolder[id]',
	        				'$folderipb',
	        				'".++$folderid."'
	        				)");
	        		}
	        			
	        		$ipmfolderasso[$ipmfolder[id]][$folderipb] = $folderid + 1;
		   	}
		   	if ($ipmfolder['pmfolders']) {
		   		$DB_site->query("UPDATE user
		   			  SET pmfolders='".addslashes($ipmfolder['pmfolders'])."'
		   			  WHERE importuserid='$ipmfolder[id]'");
		   	}
		}

		$iserver = urlencode($iserver);
		$idbname = urlencode($idbname);
		$idbprefix = urlencode($idbprefix);
		$iuser = urlencode($iuser);
		$ipasswd = urlencode($ipasswd);
		$ipbuploads = urlencode($ipbuploads);

		$startat+=$perpage;

		echo iif(!$pause,"<script language=\"javascript\">window.location=\"bbimport_invib.php?s=$session[sessionhash]&action=dopmfolders&startat=$startat&perpage=$perpage&pause=$pause&iserver=$iserver&idbname=$idbname&idbprefix=$idbprefix&iuser=$iuser&ipasswd=$ipasswd&ipbuploads=$ipbuploads\";</script>\b","");
		echo "<hr><b>&raquo; <a href=\"bbimport_invib.php?s=$session[sessionhash]&action=dopmfolders&startat=$startat&perpage=$perpage&pause=$pause&iserver=$iserver&idbname=$idbname&idbprefix=$idbprefix&iuser=$iuser&ipasswd=$ipasswd&ipbuploads=$ipbuploads\">Click here to continue importing private messages</a> &laquo;</b>\n";

	} else {
		echo "<p>Private message folders imported sucessfully.</p>";
		$action = "pms";
	}

}

// ####################################################################################
// IMPORT PMS
// ####################################################################################

if ($action=="pms") {

	doformheader("bbimport_invib","dopms");
	makehiddencode("iserver","$iserver");
	makehiddencode("idbname","$idbname");
	makehiddencode("idbprefix","$idbprefix");
	makehiddencode("iuser","$iuser");
	makehiddencode("ipasswd","$ipasswd");
	makehiddencode("ipbuploads","$ipbuploads");

	maketableheader("Step 7: Import Invision Power Board private messages");
	makedescription("<p>We will now import all your Invision Power Board private messages into the vBulletin database.</p>");

	doformfooter("Import private messages");

}

// ####################################################################################
// DO IMPORT PMS
// ####################################################################################

if ($action=="dopms") {

	echo "<p>Importing private messages ....</p>\n\n";
	flush();

	if ($startat=="") {
		$startat = 0;
	}

	//needed to speed up the import!!!	
	$DB_site->query("OPTIMIZE TABLE user");

	$ipms=$DB_site->query("SELECT touser.userid AS userid,touser.userid AS touserid,title AS title,fromuser.userid AS fromuserid,message AS message,msg_date AS dateline,msg_id AS importpmid,$idbname.".$idbprefix."messages.vid AS folderid, read_date AS readtime,ipmimport.folderid AS ifolderid
								FROM $idbname.".$idbprefix."messages,user AS touser,user AS fromuser
								LEFT JOIN ipmimport ON ($idbname.".$idbprefix."messages.vid=ipmimport.vid AND touser.importuserid=ipmimport.importuserid)
								WHERE touser.importuserid=member_id AND fromuser.importuserid=from_id
								ORDER BY msg_id
								LIMIT $startat,$perpage");
	if ($DB_site->num_rows($ipms)) {
		while ($ipm = $DB_site->fetch_array($ipms)) {
			if ($ipm['folderid'] == "in") {
				$ipm['folderid'] = 0;
			} elseif ($ipm['folderid'] == "sent") {
				$ipm['folderid'] = -1;
			} else {
				$ipm['folderid'] = $ipm['ifolderid'];
			}
		   if ($ipm['readtime'] != "") $ipm['messageread'] = 1;
		   $ipm['message'] = str_replace("<br>","\n",$ipm['message']);
			importpm($ipm);
		}

		$iserver = urlencode($iserver);
		$idbname = urlencode($idbname);
		$idbprefix = urlencode($idbprefix);
		$iuser = urlencode($iuser);
		$ipasswd = urlencode($ipasswd);
		$ipbuploads = urlencode($ipbuploads);

		$startat+=$perpage;

		echo iif(!$pause,"<script language=\"javascript\">window.location=\"bbimport_invib.php?s=$session[sessionhash]&action=dopms&startat=$startat&perpage=$perpage&pause=$pause&iserver=$iserver&idbname=$idbname&idbprefix=$idbprefix&iuser=$iuser&ipasswd=$ipasswd&ipbuploads=$ipbuploads\";</script>\b","");
		echo "<hr><b>&raquo; <a href=\"bbimport_invib.php?s=$session[sessionhash]&action=dopms&startat=$startat&perpage=$perpage&pause=$pause&iserver=$iserver&idbname=$idbname&idbprefix=$idbprefix&iuser=$iuser&ipasswd=$ipasswd&ipbuploads=$ipbuploads\">Click here to continue importing private messages</a> &laquo;</b>\n";

	} else {
		echo "<p>Private messages imported sucessfully.</p>";
		$DB_site->query("DROP TABLE ipmimport");
		$action = "forums";
	}

}

// ####################################################################################
// IMPORT FORUMS
// ####################################################################################

if ($action=="forums") {

	doformheader("bbimport_invib","doforums");
	makehiddencode("iserver","$iserver");
	makehiddencode("idbname","$idbname");
	makehiddencode("idbprefix","$idbprefix");
	makehiddencode("iuser","$iuser");
	makehiddencode("ipasswd","$ipasswd");
	makehiddencode("newstyleid","$newstyleid");
	makehiddencode("ipbuploads","$ipbuploads");

	maketableheader("Step 8: Import Invision Power Board Forums");
	makedescription("<p>We will now import all your Invision Power Board forums and categories into the vBulletin database.</p>");

	doformfooter("Import Forums");

}

// ####################################################################################
// DO IMPORT FORUMS
// ####################################################################################

if ($action=="doforums") {

	echo "<p>Creating parent category <i>$categoryname</i> ....\n";
	flush();

  $icategories = $DB_site->query("SELECT * FROM $idbname.".$idbprefix."categories WHERE id != '-1' ORDER BY id");
	while ($icategory = $DB_site->fetch_array($icategories)) {

    echo "<p>Category: <i>$icategory[name]</i> ,...\n";
    flush();

		$category['title'] = $icategory['name'];
		$category['displayorder'] = $icategory['position'];
		$category['importcategoryid'] = $icategory['id'];
		$category['description'] = $icategory['description'];

		$categoryid = importcategory($category);

		$forum['parentid']=$categoryid;

		$iforums = $DB_site->query("SELECT * FROM $idbname.".$idbprefix."forums WHERE category = '$icategory[id]' ORDER BY id");
		while ($iforum = $DB_site->fetch_array($iforums)) {

			echo "<p>Forum: <i>$iforum[name]</i> ....\n";
			flush();
         $forum['title'] = $iforum['name'];
         $forum['description'] = $iforum['description'];
         $forum['allowhtml'] = $iforum['use_html'];
         $forum['allowbbcode'] = $iforum['use_ibc'];
         $forum['displayorder'] = $iforum['position'];
         $forum['moderatenew'] = $iforum['preview_post'];
         $forum['moderateattach'] = $forum['moderatenew'];
			$forum['importforumid'] = $iforum['id'];
			if ($iforum['password'] != '') {
			  $forum['private']=1;
			} else {
			  $forum['private']=0;
			}
			$forumid=importforum($forum);

      $imoderators=$DB_site->query("SELECT userid,forumid
                                    FROM $idbname.".$idbprefix."moderators,user
                                    LEFT JOIN forum ON (forum.importforumid=forum_id)
                                    WHERE forumid=$forumid AND member_id=importuserid AND forum_id=importforumid");

      while ($imoderator=$DB_site->fetch_array($imoderators)) {
				if ($iforum['preview_post']) {
					$imoderator['newthreademail']=1;
					$imoderator['newpostemail']=1;
				}

				echo "<p>Moderator ";
				importmoderator($imoderator);
			}
		}
  }

   //get the forumids of the vB forums which will be the parents
   $iparents = $DB_site->query("SELECT DISTINCT forumid, $idbname.".$idbprefix."forums.parent_id AS ipb_parentid
                                FROM forum
                                LEFT JOIN $idbname.".$idbprefix."forums ON $idbname.".$idbprefix."forums.parent_id=importforumid
                                WHERE $idbname.".$idbprefix."forums.parent_id IS NOT NULL");
   while ($iparent=$DB_site->fetch_array($iparents)) {
      $parentid[$iparent[ipb_parentid]] = $iparent[forumid];
   }
   
   //here we get the forumids of the childforums together with the corresponding IPB parentid
   $children = $DB_site->query("SELECT forumid,$idbname.".$idbprefix."forums.parent_id AS ipb_parentid
                                  FROM forum
                                  LEFT JOIN $idbname.".$idbprefix."forums ON $idbname.".$idbprefix."forums.id = importforumid
                                  WHERE $idbname.".$idbprefix."forums.parent_id != -1");
   while ($child=$DB_site->fetch_array($children)) {
      $vbparentid=$parentid[$child[ipb_parentid]];
      $DB_site->query("UPDATE forum
                       SET parentid=$vbparentid
                       WHERE forumid=$child[forumid]");
   }

	$action = "threads";

}

// ####################################################################################
// IMPORT THREADS & POSTS
// ####################################################################################

if ($action=="threads") {

	doformheader("bbimport_invib","dothreads");
	makehiddencode("iserver","$iserver");
	makehiddencode("idbname","$idbname");
	makehiddencode("idbprefix","$idbprefix");
	makehiddencode("iuser","$iuser");
	makehiddencode("ipasswd","$ipasswd");
	makehiddencode("ipbuploads","$ipbuploads");

	maketableheader("Step 9: Import Invision Power Board Threads & Posts");
	makedescription("<p>We will now import all your Invision Power Board threads and posts into the vBulletin database.</p>");
	makeinputcode("Number of threads to import per cycle:","perpage",25);
	makeyesnocode("Would you like to pause the import after each page so you can edit individual threads?","pause",0);

	doformfooter("Import Thread &amp; Posts");

}

// ####################################################################################
// DO IMPORT THREADS & POSTS
// ####################################################################################

if ($action=="dothreads") {

	echo "<p>Importing threads &amp; posts....</p>\n\n";
	flush();

	if ($startat=="") {
		$startat = 0;
	}

	$vbforumid = getforumids();
	$vbuserid = getuserids();
	$vbpollid = getpollids();

	$ithreads = $DB_site->query("SELECT forum_id AS forumid,tid AS importthreadid,start_date AS dateline,starter_id AS userid,starter_name AS postusername,title AS title,IF(state='open',1,0) AS open,icon_id AS iconid,pinned AS sticky,views AS views, moved_to FROM $idbname.".$idbprefix."topics ORDER BY importthreadid LIMIT $startat,$perpage");
	if ($DB_site->num_rows($ithreads)) {
		while ($ithread = $DB_site->fetch_array($ithreads)) {
			echo "<p>Thread: ....\n";
			$ithread['forumid'] = $vbforumid[$ithread['forumid']];
			$ithread['userid'] = $vbuserid[$ithread['userid']];
         $ithread['iconid'] = 0;

			$ithread['visible']=1;
			$ithread['open']=option2bin($ithread['open']);
			$ithread['sticky']=option2bin($ithread['sticky']);

			if ($ithread['poll']!="") {
				$ithread['pollid']=$vbpollid[$ithread['poll']];
			}
			
			$ithread['moved_to'] = preg_replace('/([0-9]*)\&([0-9]*)/i', '\1', $ithread['moved_to']);
			if ($ithread['moved_to'] != "") {
				$imovedto = $DB_site->query_first("SELECT threadid FROM thread WHERE importthreadid=$ithread[moved_to]");
				$ithread['pollid'] = $imovedto['threadid'];
				$ithread['open'] = 10;
			}
			$threadid = importthread($ithread);

			$iposts = $DB_site->query("SELECT pid AS importpostid,$threadid AS threadid,post_date AS dateline,author_id AS userid,author_name AS username,ip_address AS ipaddress,post_title AS title,post AS pagetext,icon_id AS iconid, attach_id AS attachid, attach_file AS attachfile, attach_hits AS counter FROM $idbname.".$idbprefix."posts WHERE $idbname.".$idbprefix."posts.topic_id='$ithread[importthreadid]' ORDER BY importpostid");
			while ($ipost = $DB_site->fetch_array($iposts)) {
				$ipost['userid'] = $vbuserid[$ipost['userid']];
				$ipost['visible']=option2bin($ipost['visible']);
				$ipost['pagetext']=unconvert($ipost['pagetext']);
				
				$attach_post = importpost($ipost);
				
				if($ipost['attachid']) {
					if(file_exists(($ipbuploads."/".$ipost['attachid']))) {
						$iattach['userid'] = $ipost['userid'];
						$iattach['dateline'] = $ipost['dateline'];
						$iattach['filename'] = $ipost['attachfile'];
						$iattach['visible'] = 1;
						$iattach['counter'] = $ipost['counter'];
						$iattach['postid'] = $attach_post;
						
						$file = fopen(($ipbuploads."/".$ipost['attachid']) ,'rb');
						if($file) {
							$iattach['filedata'] = fread($file, filesize(($ipbuploads."/".$ipost['attachid'])));
							fclose($file);
							$attachmentid = importattachment($iattach);
							$DB_site->query("UPDATE attachment SET counter=$ipost[counter] WHERE attachmentid=$attachmentid");
							$DB_site->query("UPDATE thread SET attach = attach + 1 WHERE threadid = '$threadid'");
							echo "<i> Attached File - ".htmlspecialchars($iattach['filename'])."</i> (to post ".$attach_post.") sucessfully<br>\n";
						}
					}
				}
			}
		}

		$iserver = urlencode($iserver);
		$idbname = urlencode($idbname);
		$idbprefix = urlencode($idbprefix);
		$iuser = urlencode($iuser);
		$ipasswd = urlencode($ipasswd);
		$ipbuploads = urlencode($ipbuploads);

		$startat+=$perpage;

		echo iif(!$pause,"<script language=\"javascript\">window.location=\"bbimport_invib.php?s=$session[sessionhash]&action=dothreads&startat=$startat&perpage=$perpage&pause=$pause&iserver=$iserver&idbname=$idbname&idbprefix=$idbprefix&iuser=$iuser&ipasswd=$ipasswd&ipbuploads=$ipbuploads\";</script>\b","");
		echo "<hr><b>&raquo; <a href=\"bbimport_invib.php?s=$session[sessionhash]&action=dothreads&startat=$startat&perpage=$perpage&pause=$pause&iserver=$iserver&idbname=$idbname&idbprefix=$idbprefix&iuser=$iuser&ipasswd=$ipasswd&ipbuploads=$ipbuploads\">Click here to continue importing threads</a> &laquo;</b>\n";

	} else {
		echo "<p>Threads and posts imported sucessfully.</p>";
		$action = "subscribedthreads";
	}

}

// ####################################################################################
// IMPORT SUBSCRIBED THREADS
// ####################################################################################

if ($action=="subscribedthreads") {

	doformheader("bbimport_invib","dosubscribedthreads");
	makehiddencode("iserver","$iserver");
	makehiddencode("idbname","$idbname");
	makehiddencode("idbprefix","$idbprefix");
	makehiddencode("iuser","$iuser");
	makehiddencode("ipasswd","$ipasswd");
	makehiddencode("ipbuploads","$ipbuploads");

	maketableheader("Step 10: Import Invision Power Board subscribed threads");
	makedescription("<p>We will now import all your Invision Power Board subscribed threads into the vBulletin database.</p>");

	doformfooter("Import subscribed threads");

}

// ####################################################################################
// DO IMPORT SUBSCRIBED THREADS
// ####################################################################################

if ($action=="dosubscribedthreads") {


	echo "<p>Importing subscribed threads ....</p>\n\n";
	flush();

	if ($startat=="") {
		$startat = 0;
	}

	$ithreads=$DB_site->query("SELECT threadid,userid FROM $idbname.".$idbprefix."tracker,user,thread WHERE user.importuserid=member_id AND topic_id=importthreadid ORDER BY trid LIMIT $startat,$perpage");
	if ($DB_site->num_rows($ithreads)) {
		while ($ithread = $DB_site->fetch_array($ithreads)) {
			importsubscription($ithread['threadid'],$ithread['userid']);
		}

		$iserver = urlencode($iserver);
		$idbname = urlencode($idbname);
		$idbprefix = urlencode($idbprefix);
		$iuser = urlencode($iuser);
		$ipasswd = urlencode($ipasswd);
		$ipbuploads = urlencode($ipbuploads);

		$startat+=$perpage;

		echo iif(!$pause,"<script language=\"javascript\">window.location=\"bbimport_invib.php?s=$session[sessionhash]&action=dosubscribedthreads&startat=$startat&perpage=$perpage&pause=$pause&iserver=$iserver&idbname=$idbname&idbprefix=$idbprefix&iuser=$iuser&ipasswd=$ipasswd&ipbuploads=$ipbuploads\";</script>\b","");
		echo "<hr><b>&raquo; <a href=\"bbimport_invib.php?s=$session[sessionhash]&action=dosubscribedthreads&startat=$startat&perpage=$perpage&pause=$pause&iserver=$iserver&idbname=$idbname&idbprefix=$idbprefix&iuser=$iuser&ipasswd=$ipasswd&ipbuploads=$ipbuploads\">Click here to continue importing subscribed threads</a> &laquo;</b>\n";

	} else {
		echo "<p>Subscribed threads imported sucessfully.</p>";
		$action = "subscribedforums";
	}

}

// ####################################################################################
// IMPORT SUBSCRIBED FORUMS
// ####################################################################################

if ($action=="subscribedforums") {

	doformheader("bbimport_invib","dosubscribedforums");
	makehiddencode("iserver","$iserver");
	makehiddencode("idbname","$idbname");
	makehiddencode("idbprefix","$idbprefix");
	makehiddencode("iuser","$iuser");
	makehiddencode("ipasswd","$ipasswd");
	makehiddencode("ipbuploads","$ipbuploads");

	maketableheader("Step 11: Import Invision Power Board subscribed forums");
	makedescription("<p>We will now import all your Invision Power Board subscribed forums into the vBulletin database.</p>");

	doformfooter("Import subscribed forums");

}

// ####################################################################################
// DO IMPORT SUBSCRIBED FORUMS
// ####################################################################################

if ($action=="dosubscribedforums") {


	echo "<p>Importing subscribed forums ....</p>\n\n";
	flush();

	if ($startat=="") {
		$startat = 0;
	}

	$iforums=$DB_site->query("SELECT forumid,userid FROM $idbname.".$idbprefix."forum_tracker,user,forum WHERE user.importuserid=member_id AND forum_id=importforumid ORDER BY frid LIMIT $startat,$perpage");
	if ($DB_site->num_rows($iforums)) {
		while ($iforum = $DB_site->fetch_array($iforums)) {
			importforumsubscription($iforum['forumid'],$iforum['userid']);
		}

		$iserver = urlencode($iserver);
		$idbname = urlencode($idbname);
		$idbprefix = urlencode($idbprefix);
		$iuser = urlencode($iuser);
		$ipasswd = urlencode($ipasswd);
		$ipbuploads = urlencode($ipbuploads);

		$startat+=$perpage;

		echo iif(!$pause,"<script language=\"javascript\">window.location=\"bbimport_invib.php?s=$session[sessionhash]&action=dosubscribedforums&startat=$startat&perpage=$perpage&pause=$pause&iserver=$iserver&idbname=$idbname&idbprefix=$idbprefix&iuser=$iuser&ipasswd=$ipasswd&ipbuploads=$ipbuploads\";</script>\b","");
		echo "<hr><b>&raquo; <a href=\"bbimport_invib.php?s=$session[sessionhash]&action=dosubscribedforums&startat=$startat&perpage=$perpage&pause=$pause&iserver=$iserver&idbname=$idbname&idbprefix=$idbprefix&iuser=$iuser&ipasswd=$ipasswd&ipbuploads=$ipbuploads\">Click here to continue importing subscribed forums</a> &laquo;</b>\n";

	} else {
		echo "<p>Subscribed forums imported sucessfully.</p>";
		$action = "polls";
	}

}

// ####################################################################################
// IMPORT POLLS
// ####################################################################################

if ($action=="polls") {

	doformheader("bbimport_invib","dopolls");
	makehiddencode("iserver","$iserver");
	makehiddencode("idbname","$idbname");
	makehiddencode("idbprefix","$idbprefix");
	makehiddencode("iuser","$iuser");
	makehiddencode("ipasswd","$ipasswd");
	makehiddencode("ipbuploads","$ipbuploads");

	maketableheader("Step 12: Import Invision Power Board polls");
	makedescription("<p>We will now import all your Invision Power Board polls into the vBulletin database.</p>");

	doformfooter("Import polls");

}

// ####################################################################################
// DO IMPORT POLLS
// ####################################################################################

if ($action=="dopolls") {


	echo "<p>Importing polls ....</p>\n\n";
	flush();

	if ($startat=="") {
		$startat = 0;
	}

	$ipolls=$DB_site->query("SELECT pid AS importpollid,$idbname.".$idbprefix."polls.tid AS importthreadid,$idbname.".$idbprefix."polls.start_date AS dateline,choices,$idbname.".$idbprefix."polls.starter_id importuserid,votes AS votecount,
                            IFNULL(poll_question,$idbname.".$idbprefix."topics.title) AS question
                            FROM $idbname.".$idbprefix."polls,$idbname.".$idbprefix."topics
                            WHERE $idbname.".$idbprefix."polls.tid = $idbname.".$idbprefix."topics.tid
                            ORDER BY pid LIMIT $startat,$perpage");
                           
   if ($DB_site->num_rows($ipolls)) {
		while ($ipoll=$DB_site->fetch_array($ipolls)) {
		   $poll_answers = unserialize(stripslashes($ipoll['choices']));
		   $ipoll['active']=1;
		   $ipoll['numberoptions']=count($poll_answers);
         $ipoll['timeout']=0;
         $ipoll['multiple']=0;
         $ipoll['voters']=0;
         $optionsstring="";
         $votesstring="";
         
		   while ($pollinfo = each($poll_answers)) {
		      $optionsstring .= "|||".unhtmlspecialchars($pollinfo['1']['1']);
		      // sanity check for votes count
	         $votesbit = intval($pollinfo['1']['2']);
	         if ($votesbit < 0) {
	            $votesbit = 0;
	         }
		      $votesstring .= "|||".$votesbit;
		   }
		   
		   if (substr($optionsstring,0,3)=="|||") {
		      $ipoll['options']=substr($optionsstring,3);
         }
         if (substr($votesstring,0,3)=="|||") {
            $ipoll['votes']=substr($votesstring,3);
         }
                           
         $pollid = importpoll($ipoll);
         $DB_site->query("UPDATE thread SET pollid=$pollid WHERE importthreadid=$ipoll[importthreadid]");

			//import voters
			$ivoters = $DB_site->query("SELECT vote_date AS votedate,userid
					FROM $idbname.".$idbprefix."voters
					LEFT JOIN user ON (member_id=importuserid)
					WHERE tid=$ipoll[importthreadid]
				");
			if ($DB_site->num_rows($ivoters)) {
				while ($ivoter=$DB_site->fetch_array($ivoters)) {
					$DB_site->query("INSERT INTO pollvote (pollvoteid,pollid,userid,votedate,voteoption) VALUES (
						'',
						'$pollid',
						'$ivoter[userid]',
						'$ivoter[votedate]',
						'7646'
						)"); // 7646 for voteoption because ipb does not save this info
				}
			}

		}
		
		$iserver = urlencode($iserver);
		$idbname = urlencode($idbname);
		$idbprefix = urlencode($idbprefix);
		$iuser = urlencode($iuser);
		$ipasswd = urlencode($ipasswd);
		$ipbuploads = urlencode($ipbuploads);

		$startat+=$perpage;

		echo iif(!$pause,"<script language=\"javascript\">window.location=\"bbimport_invib.php?s=$session[sessionhash]&action=dopolls&startat=$startat&perpage=$perpage&pause=$pause&iserver=$iserver&idbname=$idbname&idbprefix=$idbprefix&iuser=$iuser&ipasswd=$ipasswd&ipbuploads=$ipbuploads\";</script>\b","");
		echo "<hr><b>&raquo; <a href=\"bbimport_invib.php?s=$session[sessionhash]&action=dopolls&startat=$startat&perpage=$perpage&pause=$pause&iserver=$iserver&idbname=$idbname&idbprefix=$idbprefix&iuser=$iuser&ipasswd=$ipasswd&ipbuploads=$ipbuploads\">Click here to continue importing polls</a> &laquo;</b>\n";

	} else {
		echo "<p>polls imported sucessfully.</p>";
		$action = "cleanup";
	}

}
// ####################################################################################
// CLEAN UP
// ####################################################################################

if ($action=="cleanup") {

	doformheader("bbimport_invib","docleanup");
	maketableheader("Final Step: Clean up database & Rebuild Counters");
	makedescription("<p>Importing of your Invision Power Board is now complete.
		Clicking the button below will remove all temporary fields from the database,
		and forward you to the 'update counters' section, where you should run the maintenance scripts in the following order:</p>
		<ol>
			<li>Rebuild search index</li>
			<li>Update Thread Info</li>
			<li>Update Forums Info</li>
			<li>Update Users Info</li>
		</ol>
		<p>This will finalize your Invision Power Board import.</p>
		<p>Things you want to do before going online with your vBulletin:
		<ul>
		   <li><a href=\"../admin/usergroup.php?action=modify&s=$session[sessionhash]\" target=\"_blank\">Modify usergroup rights</a> and <a href=\"../admin/forumpermission.php?action=modify&s=$session[sessionhash]\" target=\"_blank\">usergroup forum permissions</a></li>
		</ul></p>
		<p>Thank you for using vBulletin.</p>");

	doformfooter("Clean-up database",0);

}

// ####################################################################################
// FINISHED!
// ####################################################################################

cpfooter();
?>