<?php
/**
 * Language file to handle email templates
 *
 * This file has the email messages necessary for mail sending for various
 * pages. The admin can change the email template values from the admin interface.
 *
 * PHP version 5.0
 *
 * @category	###Framework###
 * @package		###Common/Email_templates###
 * @copyright 	Copyright (c) 2008 {@link http://www.agriya.com Agriya Infoway}
 */

/**
 * @var string Photo file activated
 * @cfg_label Photo file activated subject -- {site_name}
 * @cfg_key photo_activate_subject
 */
$LANG['photo_activate_subject'] = 'Photo activated - {site_name}';
/**
 * @var string Photo file activated
 * @cfg_label Photo file activated content -- {user_name}{photo_title}{photo_link}{link}{site_name}
 * @cfg_key photo_activate_content
 */
$LANG['photo_activate_content'] = 'Dear {user_name},

Your Photo {thumb_image}({photo_title}) is activated,

{photo_link}

To learn more, please visit {link}
Regards,
{site_name}';

/**
 * @var string Deleted Photo
 * @cfg_label Deleted your photo subject -- {site_name}
 * @cfg_key photo_delete_subject
 */
$LANG['photo_delete_subject'] = 'Delete your photo - {site_name}';
/**
 * @var string Deleted Photo
 * @cfg_label Deleted your photo content -- {user_name}{photo_title}{link}{site_name}
 * @cfg_key photo_delete_content
 */
$LANG['photo_delete_content'] = 'Dear {user_name},

Sorry, some problem in your photo, so we have to delete your photo({photo_title})

To learn more, please visit {link}
Regards,
{site_name}';

/**
 * @var string Photo
 * @cfg_label Share photo subject -- {user_name}
 * @cfg_key photo_share_subject
 */
$LANG['photo_share_subject'] = '{user_name} sent you a photo!';
/**
 * @var string Photo
 * @cfg_label Share Photo content -- {user_name}{photo_image}{photo_description}{personal_message}{link}{user_name}{site_name}
 * @cfg_key photo_share_content
 */
$LANG['photo_share_content'] = '{user_name} wants to share the following photo with you:

{photo_image}

<b>Photo Description</b>

{photo_description}

<b>Personal Message</b>

{personal_message}

To learn more, please visit {link}

Regards,
{user_name}
{site_name}';

/**
 * @var string Photo
 * @cfg_label Flagged photo subject -- {user_name}{photo_title}
 * @cfg_key photo_flagged_subject
 */
$LANG['photo_flagged_subject'] = '{user_name} flagged this photo {photo_title}!';
/**
 * @var string Photo
 * @cfg_label Flagged photo content -- {user_name}{photo_image}{photo_title}{photo_description}{flagged_title}{flagged_content}{user_name}{site_name}
 * @cfg_key photo_flagged_content
 */
$LANG['photo_flagged_content'] = '

{photo_image}

<b>Photo Title</b>
{photo_title}
<b>Photo Description</b>

{photo_description}

{flagged_title}

{flagged_content}

By,
<b>{user_name}</b>
{site_name}
';
/**
 * @var string Photo
 * @cfg_label Tagged photo subject -- {site_name}
 * @cfg_key photo_tagged_subject
 */
$LANG['photo_tagged_subject'] = 'Your photo(s) tagged on {site_name}!';
/**
 * @var string Photo
 * @cfg_label Tagged photo content -- {user_name}{photolink}{link}{site_name}
 * @cfg_key photo_tagged_content
 */
$LANG['photo_tagged_content'] = '

<b>Hi {user_name} </b>

The following photo(s) tagged on {site_name}.

{photoz}

To learn more, please visit {link}

By,
{site_name}
';
/**
 * @var string Photo
 * @cfg_label Tagged photo subject -- {user_name}{site_name}
 * @cfg_key photo_tagged_subject
 */
$LANG['photo_tagged_associated_subject'] = '{user_name} tagged you in a photo!';
/**
 * @var string Photo
 * @cfg_label Tagged photo content -- {user_name}{tagname}{photolink}{link}{site_name}
 * @cfg_key photo_tagged_content
 */
$LANG['photo_tagged_associated_content'] = '

<b>Hi</b>

{user_name} tagged you in a photo on {site_name}.

{photo_image}

Click here to view the photo : {photolink}

To learn more, please visit {link}

By,
{site_name}
';
?>