<?php
if ($block == 'threadstarter' AND $vbulletin->options['dbtech_infopanel_threadstarter_enabled'])
{
	// Add New Posts
	$xml->add_tag('header' . $blockid, $vbphrase['dbtech_infopanel_top_thread_starters']);
	
	if (!is_array($threadstarters))
	{
		$threadstarters = fetch_vbo_cache('threadstarters');
		if ($threadstarters === false)
		{
			$threadstarters = array();
			$threadstarters_q = $db->query_read_slave("
				SELECT COUNT(thread.threadid) AS threads, thread.postuserid, thread.dateline, user.userid, user.usergroupid, user.displaygroupid, user.username
				FROM " . TABLE_PREFIX . "thread AS thread
				LEFT JOIN " . TABLE_PREFIX . "user AS user ON (thread.postuserid = user.userid)
				LEFT JOIN " . TABLE_PREFIX . "forum AS forum ON (forum.forumid = thread.forumid)
				WHERE thread.visible = 1
					AND (forum.options & 4096)
					AND user.userid > 0
					$excludegroups
				GROUP BY thread.postuserid
				ORDER BY threads DESC
				LIMIT " . $vbulletin->options['dbtech_infopanel_limit']
			);
			while ($threadstarters_r = $db->fetch_array($threadstarters_q))
			{
				// Strip tags from username
				$threadstarters_r['fullusername'] = $threadstarters_r['username'] = strip_tags($threadstarters_r['username']);
				
				if ($vbulletin->options['dbtech_infopanel_trimusername'])
				{
					// Trim the username
					$threadstarters_r['username'] = fetch_trimmed_title($threadstarters_r['username'], $vbulletin->options['dbtech_infopanel_trimusername']);
				}
				
				// Fetch coloured username
				$threadstarters_r['musername'] = fetch_musername($threadstarters_r);
				
				// Restore username for SEO Link purposes
				$threadstarters_r['username'] = $threadstarters_r['fullusername'];

				// Number formatting
				$threadstarters_r['threads'] = vb_number_format($threadstarters_r['threads']);
				
				// Store this
				$threadstarters[] = $threadstarters_r;
			}
			$db->free_result($threadstarters_q);
			unset($threadstarters_r);

			// Set the cache
			set_vbo_cache('threadstarters', $threadstarters, (TIMENOW + ($vbulletin->options['dbtech_infopanels_counter_ttl'] * 60)));
		}
	}
	
	$bit = '';
	foreach ($threadstarters as $post)
	{
		$templater = vB_Template::create('dbtech_infopanel_block_threadstarter_bit');
			$templater->register('post', $post);
		$bit .= $templater->render();
	}
	
	// Create the template
	$templater = vB_Template::create('dbtech_infopanel_block_threadstarter');
		$templater->register('bit', $bit);
	
	// Add New Posts
	$xml->add_tag('block' . $blockid, $templater->render());
}
?>