<?php

// ++=========================================================================++
// || certific degree v1.1.3 - 1
// || Copyright  2008-2009 Drive Thru Online, Inc. All Rights Reserved.
// || This file may not be redistributed in whole or significant part, or
// || used on web site without licensing of the enclosed code,
// || and software features.
// || http://www.drivethruonline.com | info@drivethruonline.com
// || Downloaded 12:29, Wed Oct 7th 2009
// || 224278701_409535961079
// ++ ========================================================================++

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'certific_degree');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array(
	'user', 'postbit', 'infractionlevel', 'certific_degree'
);

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array(
	'USERCP_SHELL',
	'usercp_nav_folderbit',
);

// pre-cache templates used by specific actions
$actiontemplates = array(
    'index' => array(			    // Index
        'certific_degree_index',
        'certific_degree_index_row',
        'certific_degree_index_row_bits'    
	),
	'viewvehicle' => array(
		'certific_degree_ownerbit',
		'certific_degree_popup_menu',
		'certific_degree_popup_menubit',
		'postbit_onlinestatus',
		'certific_degree_vehicle_view',
		'certific_degree_vehicle_view_imagebits'
	),
	'editdegree' => array(
		'certific_degree_vehicle_addimagebits',
		'certific_degree_vehicle_addimagepopupbits',
		'certific_degree_vehicle_detail',
		'certific_degree_vehicle_imagebits',
		'certific_degree_vehicle_list',
		'certific_degree_vehicle_listbits',
	),	 
	'editvehicle' => array(	
		'certific_degree_vehicle_addimagebits',
		'certific_degree_vehicle_addimagepopupbits',
		'certific_degree_vehicle_detail',
		'certific_degree_vehicle_imagebits',
	),
	'add' => array(	
		'certific_degree_vehicle_addimagebits',
		'certific_degree_vehicle_addimagepopupbits',
		'certific_degree_vehicle_detail',
		'certific_degree_vehicle_imagebits',
	)		
);

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once('./includes/functions_bigthree.php');
require_once('./includes/functions.php');
require_once('./includes/class_bbcode.php');
require_once('./includes/functions_user.php');
require_once('./includes/adminfunctions.php');
require_once('./includes/functions_certific_degree_common.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

// If no type of actino is requested just exit
if (empty($_REQUEST['do'])) { 
  $_REQUEST['do'] = 'index';						 
}

// ############################################################################
// ############################### INDEX degree ################################
// ############################################################################


if ($_REQUEST['do'] == 'index')  // Index page
{
	// Default page variables
	$perpage = $vbulletin->input->clean_gpc('r', 'perpage', TYPE_UINT);
	$pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);  
					
    degree_index($perpage, $pagenumber, $pagenav, $indexRows);  // This returns pageNav and indexRows that are used in results template
  	
    $navbits = array();   
    $navbits['certific_degree.php?' . $vbulletin->session->vars['sessionurl']. "do=index"] = ' ';
    $certific_degree_title = 'degrees';
    $indexName = "$certific_degree_title";    
    $navbits[''] = '';
    $navbits = construct_navbits($navbits);   
    
    eval('$navbar = "' . fetch_template('navbar') . '";');
    eval('print_output("' . fetch_template('certific_degree_index') . '");');    
}

// ############################################################################
// ############################### EDIT degree ################################
// ############################################################################

if ($_REQUEST['do'] == 'editdegree')
{		
	// Make sure the user has permission to be here	
	if(!degreePerms($vbulletin->userinfo))
      print_no_permission(); 
	
	$degree_num_vehicles = degree_num_vehicles_for_user($vbulletin->userinfo);
    
	// Initialize the bits
	$listbits = '';
				
	$vehicles = $db->query_read("SELECT vehicle_id, name, year, make, model, display FROM " . 
		TABLE_PREFIX . "certific_degree_vehicle WHERE userid = ". $vbulletin->userinfo['userid'] );

	$num_vehicles = $db->num_rows($vehicles);
	$num_spots_left = $degree_num_vehicles - $num_vehicles;
	if($num_spots_left < 0)
	  $num_spots_left = 0;
	
	$bg = 1;
	
	while ($vehicle = $db->fetch_Array($vehicles))
	{		
	    // Set up the alternating background color for the row
	    if ($bg % 2)
	      $bgclass="alt1";
	    else $bgclass="alt2";
	    
	    $vehicle_id = $vehicle['vehicle_id'];
		$vehicle['name'] = htmlspecialchars_uni($vehicle['name']);
		$vehicle['year'] = htmlspecialchars_uni($vehicle['year']);
		$vehicle['make'] = htmlspecialchars_uni($vehicle['make']);
		$vehicle['model'] = htmlspecialchars_uni($vehicle['model']);
		
		// Retrieve the main image (if any)
	    if( $image = $db->query_first("SELECT userid, image_id, caption FROM " . TABLE_PREFIX . "certific_degree_image WHERE vehicle_id=". $vehicle_id . " AND showinsections='main'")) {
			$image_id = $image['image_id'];
			$image_userid = $image['userid'];
			$image_caption = htmlspecialchars_uni($image['caption']);
	    	$filename = $vbulletin->options['bburl']. "/" .$vbulletin->options['certific_degree_imagedir']. "/" .$image_userid. "/" .$image_id. "t.jpg";
	    	$caption = unhtmlspecialchars($image_caption); 
	    }
	    else {	// No main image has been saved for the vehicle...put up a default and encourage the user to add one
	      $filename = $vbulletin->options['bburl']. "/images/certific_degree/images/no_image.jpg";
	      $caption = "";
	    } 
	    
		// Determine how many/if any comments there are for this vehicle
		$comments =  $db->query_first("SELECT COUNT(*) as cnt FROM " . TABLE_PREFIX . "certific_degree_comment WHERE vehicle_id=". $vehicle_id );
		
		$numcomments = $comments['cnt'];
		
		eval('$listbits .= "' . fetch_template('certific_degree_vehicle_listbits') . '";');
		
		$bg++;
	}

   $navbits = construct_navbits(array('' => ' '));
   
   // build the cp nav
   construct_usercp_nav('certific_degree_manage');

   eval('$navbar = "' . fetch_template('navbar') . '";');
   eval('$HTML = "' . fetch_template('certific_degree_vehicle_list') . '";');
   eval('print_output("' . fetch_template('USERCP_SHELL') . '");');
}

if ($_REQUEST['do'] == 'add')
{
	// Make sure the user has permission to be here
	if(!degreePerms($vbulletin->userinfo))
      print_no_permission(); 
	
	$degree_num_vehicles = degree_num_vehicles_for_user($vbulletin->userinfo);	
	

	// Make sure there are degree spaces left...if not kick the user out
	$results = $db->query_first("SELECT count(*) as cnt FROM " . 
		TABLE_PREFIX . "certific_degree_vehicle WHERE userid = ". $vbulletin->userinfo['userid'] );
	
    
	$num_vehicles = $results['cnt'];
    	
	if($num_vehicles >= $degree_num_vehicles) {
		$vbulletin->url = $vbulletin->options[bburl] . "/certific_degree.php?do=editdegree";
		eval(print_standard_redirect('redirect_certific_degree_degree_full', true, true));		
	}
	
   $navbits = array();   
   $navbits['certific_degree.php?' . $vbulletin->session->vars['sessionurl']. "do=add"] = '';
   $navbits[''] = " ";
   $navbits = construct_navbits($navbits);   
   
   $vehicle['vehicle_id'] = -1;  // Denotes a new record so that if an image is added before any text is save it will save everything as a new record
   $vehicle['make'] = $vbulletin->options['certific_degree_default_make'];
   
   $vehicle['year'] = date("Y");  // Default to current year
   $vehicle['display'] = 1;
   $vehicle['allowcomments'] = 0;
   
   // Settings for all image uploads
   $maxuploadsize = ini_get('upload_max_filesize');   // Should return information in M(Bytes)
   $maxuploadsize .= "B";
	
   $image_count=1;
   
   // Main image
   $section = "main";
   $display_order = 10;  
    for($i=1; $i<= 1; $i++) {
	  $sectionhdr = "add_image".$image_count;
	  $sectionhdr_menu = $sectionhdr."_menu";
		
	  eval('$main_imagebits .= "' . fetch_template('certific_degree_vehicle_addimagebits') . '";'); 
	  eval('$imageaddpopups .= "' .  fetch_template('certific_degree_vehicle_addimagepopupbits') . '";');    
	  $image_count++;
    }	
   
   // General Images
   $section = "general";
   for($i=1; $i<= 3; $i++) {
	 $sectionhdr = "add_image".$image_count;
	 $sectionhdr_menu = $sectionhdr."_menu";
		
	 eval('$general_imagebits .= "' . fetch_template('certific_degree_vehicle_addimagebits') . '";'); 
	 eval('$imageaddpopups .= "' .  fetch_template('certific_degree_vehicle_addimagepopupbits') . '";');    

     $image_count++;
   } 
   
   // Exterior Images
   $section = "exteriormods";
   for($i=1; $i<= 3; $i++) {
	 $sectionhdr = "add_image".$image_count;
	 $sectionhdr_menu = $sectionhdr."_menu";
		
	 eval('$exterior_imagebits .= "' . fetch_template('certific_degree_vehicle_addimagebits') . '";'); 
	 eval('$imageaddpopups .= "' .  fetch_template('certific_degree_vehicle_addimagepopupbits') . '";');    

     $image_count++;
   }  

   // Interior Images
   $section = "interiormods";
   for($i=1; $i<= 3; $i++) {
	 $sectionhdr = "add_image".$image_count;
	 $sectionhdr_menu = $sectionhdr."_menu";
		
	 eval('$interior_imagebits .= "' . fetch_template('certific_degree_vehicle_addimagebits') . '";'); 
	 eval('$imageaddpopups .= "' .  fetch_template('certific_degree_vehicle_addimagepopupbits') . '";');    

     $image_count++;
   } 

   // ICE Images
   $section = "icemods";
   for($i=1; $i<= 3; $i++) {
	 $sectionhdr = "add_image".$image_count;
	 $sectionhdr_menu = $sectionhdr."_menu";
		
	 eval('$ice_imagebits .= "' . fetch_template('certific_degree_vehicle_addimagebits') . '";'); 
	 eval('$imageaddpopups .= "' .  fetch_template('certific_degree_vehicle_addimagepopupbits') . '";');    

     $image_count++;
   } 

   // Drivetrain Images
   $section = "drivetrainmods";
   for($i=1; $i<= 3; $i++) {
	 $sectionhdr = "add_image".$image_count;
	 $sectionhdr_menu = $sectionhdr."_menu";
		
	 eval('$drivetrain_imagebits .= "' . fetch_template('certific_degree_vehicle_addimagebits') . '";'); 
	 eval('$imageaddpopups .= "' .  fetch_template('certific_degree_vehicle_addimagepopupbits') . '";');    

     $image_count++;
   }  

   // Suspension Images
   $section = "suspensionmods";
   for($i=1; $i<= 3; $i++) {
	 $sectionhdr = "add_image".$image_count;
	 $sectionhdr_menu = $sectionhdr."_menu";
		
	 eval('$suspension_imagebits .= "' . fetch_template('certific_degree_vehicle_addimagebits') . '";'); 
	 eval('$imageaddpopups .= "' .  fetch_template('certific_degree_vehicle_addimagepopupbits') . '";');    

     $image_count++;
   } 

    // Wheels and Tire Images
   $section = "wheelsandtires";
   for($i=1; $i<= 3; $i++) {
	 $sectionhdr = "add_image".$image_count;
	 $sectionhdr_menu = $sectionhdr."_menu";
		
	 eval('$wheels_imagebits .= "' . fetch_template('certific_degree_vehicle_addimagebits') . '";'); 
	 eval('$imageaddpopups .= "' .  fetch_template('certific_degree_vehicle_addimagepopupbits') . '";');    

     $image_count++;
   }    
   
   // build the cp nav
   construct_usercp_nav('certific_degree_vehicle_add');
   
   $add_vehicle = true;
   
   eval('$navbar = "' . fetch_template('navbar') . '";');
   eval('$HTML = "' . fetch_template('certific_degree_vehicle_detail') . '";');
   eval('print_output("' . fetch_template('USERCP_SHELL') . '");');
}

if ($_REQUEST['do'] == 'delimage')
{
  // Make sure the user has permission to be here
  if(!degreePerms($vbulletin->userinfo))
    print_no_permission(); 
    
  $vbulletin->input->clean_array_gpc('g', array(
 	    'id' => TYPE_INT, 	
	    'v' => TYPE_INT,
  ));   
      
  $vehicle_id = &$vbulletin->GPC['v'];   
  $image_id = &$vbulletin->GPC['id'];
  
  // Get the display order out of the database for this image 
  $image = $db->query_first("SELECT userid, display_order from ". TABLE_PREFIX ."certific_degree_image WHERE image_id=$image_id AND vehicle_id=$vehicle_id");
  
  if(!$image) {
		$vbulletin->url = $vbulletin->options[bburl] . "/certific_degree.php?do=editdegree";
		eval(print_standard_redirect('redirect_certific_degree_invalid_image_vehicle', true, true));	  	
  }

  $userid = $image['userid'];  
  $display_order = $image['display_order'];

  // Make sure that image_id that is being deleted is associated with a vehicle that this user manages 
  if($userid != $vbulletin->userinfo['userid'])
    print_no_permission(); 
        
  // Use the display order to find all the images displayed afterward (in this section) and update their display order
  $result = $db->query_write("UPDATE ". TABLE_PREFIX . "certific_degree_image SET display_order=display_order-10 WHERE display_order > $display_order");
    
   // Remove the image information from the database 
   $result = $db->query("DELETE FROM ". TABLE_PREFIX ."certific_degree_image WHERE image_id=$image_id");
  
   // Remove the file and thumb from disk
   $filename = DIR . "/" .$vbulletin->options['certific_degree_imagedir']. "/" .$vbulletin->userinfo['userid']. "/". $image_id .".jpg";   
   $thumb = DIR . "/" .$vbulletin->options['certific_degree_imagedir']. "/" .$vbulletin->userinfo['userid']. "/" .$image_id. "t.jpg";
   unlink($filename);
   unlink($thumb);
      
   Header("Location: " . $vbulletin->options[bburl] . "/certific_degree.php?do=editvehicle&v=$vehicle_id");  
}

if ($_REQUEST['do'] == 'editvehicle')
{
	// Make sure the user has permission to be here
	if(!degreePerms($vbulletin->userinfo))
      print_no_permission();       
      	
  	$vbulletin->input->clean_array_gpc('g', array(	
		    'v' => TYPE_INT,
		    'preview' => TYPE_INT,
	  		));   
      
	$vehicle_id = &$vbulletin->GPC['v'];

	if($vbulletin->GPC['preview'])
	  $launchPreview = true;
		
	// Get the vehicle information
	$vehicle = $db->query_first("SELECT vehicle_id, userid, name, year, make, model, color, packages, history, exteriormods, interiormods,
		icemods, drivetrainmods, suspensionmods, wheelsandtires, display, allowcomments FROM " . 
		TABLE_PREFIX . "certific_degree_vehicle WHERE vehicle_id = $vehicle_id");
		
	if(!$vehicle) {
		$vbulletin->url = $vbulletin->options[bburl] . "/certific_degree.php?do=editdegree";
		eval(print_standard_redirect('redirect_certific_degree_invalid_vehicle', true, true));	  	
	}		
	
	// Do a check to see if this user has permission to edit this vehicle (ie - its theirs)
	// If its not then exit

	if($vehicle['userid'] != $vbulletin->userinfo['userid'] )
	  print_no_permission(); 	  

	$vehicle['name'] = htmlspecialchars_uni($vehicle['name']);
	$vehicle['year'] = htmlspecialchars_uni($vehicle['year']);
	$vehicle['make'] = htmlspecialchars_uni($vehicle['make']);
	$vehicle['model'] = htmlspecialchars_uni($vehicle['model']);
	$vehicle['color'] = htmlspecialchars_uni($vehicle['color']);
	$vehicle['packages'] = htmlspecialchars_uni($vehicle['packages']);
	$vehicle['history'] = htmlspecialchars_uni($vehicle['history']);
	$vehicle['exteriormods'] = htmlspecialchars_uni($vehicle['exteriormods']);
	$vehicle['interiormods'] = htmlspecialchars_uni($vehicle['interiormods']);
	$vehicle['icemods'] = htmlspecialchars_uni($vehicle['icemods']);
	$vehicle['drivetrainmods'] = htmlspecialchars_uni($vehicle['drivetrainmods']);
	$vehicle['suspensionmods'] = htmlspecialchars_uni($vehicle['suspensionmods']);
	$vehicle['wheelsandtires'] = htmlspecialchars_uni($vehicle['wheelsandtires']);
	$vehicle['display'] = intval($vehicle['display']);
	$vehicle['allowcomments'] = intval($vehicle['allowcomments']);
	
	//
	// Retrieve the main images - 1
	//
	$section = "main";
	
	$images = $db->query_read("SELECT image_id, userid, caption, showinsections, display_order FROM " . TABLE_PREFIX . "certific_degree_image 
		WHERE vehicle_id = $vehicle_id AND showinsections = '$section' ORDER BY display_order");
	
	$image_count=1;
	// If images were found then output them using the certific_degree_imagebits template
	if($db->num_rows($images)) {
	    $i=0;
		while ($image = $db->fetch_Array($images)) {
		  $image_id = $image['image_id'];		
		  $filename = $vbulletin->options['bburl']. "/" .$vbulletin->options['certific_degree_imagedir']. "/" .$image['userid']. "/" .$image['image_id']. "t.jpg";
		  $caption = htmlspecialchars_uni($image['caption']);
		  $section = htmlspecialchars_uni($image['showinsections']);
		  $display_order = $image['display_order']; 
		  
		  eval('$main_imagebits .= "' . fetch_template('certific_degree_vehicle_imagebits') . '";');
		 
		  $image_count++;
		}      
	}

	// If any image slots are left then output the add image links using the certific_degree_addimage_bits template

	/// Settings for all image uploads
	$maxuploadsize = ini_get('upload_max_filesize');   // Should return information in M(Bytes)
	$maxuploadsize .= "B";


    // so we just want to set it as the next available slot display-wise
    $display_order = ($db->num_rows($images)+1) * 10;  
    for($i=$db->num_rows($images)+1; $i<= 1; $i++) {
	  $sectionhdr = "add_image".$image_count;
	  $sectionhdr_menu = $sectionhdr."_menu";
		
	  eval('$main_imagebits .= "' . fetch_template('certific_degree_vehicle_addimagebits') . '";'); 
	  eval('$imageaddpopups .= "' .  fetch_template('certific_degree_vehicle_addimagepopupbits') . '";'); 
	  $image_count++;   
    }	


	//
	// Retrieve all the general images 2-4
	//
	$section = "general";
	
	$images = $db->query_read("SELECT image_id, userid, caption, showinsections, display_order FROM " . TABLE_PREFIX . "certific_degree_image 
		WHERE vehicle_id = $vehicle_id AND showinsections = '$section' ORDER BY display_order");
	
	
	// If images were found then output them using the certific_degree_imagebits template
	if($db->num_rows($images)) {
		while ($image = $db->fetch_Array($images)) {
		  $image_id = $image['image_id'];		
		  $filename = $vbulletin->options['bburl']. "/" .$vbulletin->options['certific_degree_imagedir']. "/" .$image['userid']. "/" .$image['image_id']. "t.jpg";
		  $caption = htmlspecialchars_uni($image['caption']);
		  $section = htmlspecialchars_uni($image['showinsections']);
		  $display_order = $image['display_order']; 
		  
		  eval('$general_imagebits .= "' . fetch_template('certific_degree_vehicle_imagebits') . '";');
		  $image_count++;
		}      
	}
	
	// If any image slots are left then output the add image links using the certific_degree_addimage_bits template
    
    // If we have some slots left use the same display_order for all the pop-ups.  This is because only one can be processed one at a
    // so we just want to set it as the next available slot display-wise
    $display_order = ($db->num_rows($images)+1) * 10;  
    for($i=$db->num_rows($images)+1; $i<= 3; $i++) {
	  $sectionhdr = "add_image".$image_count;
	  $sectionhdr_menu = $sectionhdr."_menu";
		
	  eval('$general_imagebits .= "' . fetch_template('certific_degree_vehicle_addimagebits') . '";'); 
	  eval('$imageaddpopups .= "' .  fetch_template('certific_degree_vehicle_addimagepopupbits') . '";');    

      $image_count++;
    }
    
 	//
	// Retrieve all the Exterior images 5-7
	//
	$section = "exteriormods";
	
	$images = $db->query_read("SELECT image_id, userid, caption, showinsections, display_order FROM " . TABLE_PREFIX . "certific_degree_image 
		WHERE vehicle_id = $vehicle_id AND showinsections = '$section' ORDER BY display_order");
	
    $num_images = $db->num_rows($images);

	// If images were found then output them using the certific_degree_imagebits template
	if($num_images) {
		while ($image = $db->fetch_Array($images)) {
		  $image_id = $image['image_id'];		
		  $filename = $vbulletin->options['bburl']. "/" .$vbulletin->options['certific_degree_imagedir']. "/" .$image['userid']. "/" .$image['image_id']. "t.jpg";
		  $caption = htmlspecialchars_uni($image['caption']);
		  $section = htmlspecialchars_uni($image['showinsections']);
		  $display_order = $image['display_order']; 
		  
		  eval('$exterior_imagebits .= "' . fetch_template('certific_degree_vehicle_imagebits') . '";');
		  $image_count++;
		}      
	}
	
	// If any image slots are left then output the add image links using the certific_degree_addimage_bits template
    
    // If we have some slots left use the same display_order for all the pop-ups.  This is because only one can be processed one at a
    // so we just want to set it as the next available slot display-wise
    $display_order = ($num_images+1) * 10;  
    for($i=$num_images+1; $i<= 3; $i++) {

	  $sectionhdr = "add_image".$image_count;
	  $sectionhdr_menu = $sectionhdr."_menu";
		
	  eval('$exterior_imagebits .= "' . fetch_template('certific_degree_vehicle_addimagebits') . '";'); 
	  eval('$imageaddpopups .= "' .  fetch_template('certific_degree_vehicle_addimagepopupbits') . '";');    
	  $image_count++;
    }   

 	//
	// Retrieve all the Interior images 8-10
	//
	$section = "interiormods";
	
	$images = $db->query_read("SELECT image_id, userid, caption, showinsections, display_order FROM " . TABLE_PREFIX . "certific_degree_image 
		WHERE vehicle_id = $vehicle_id AND showinsections = '$section' ORDER BY display_order");
	
	// If images were found then output them using the certific_degree_imagebits template
	if($db->num_rows($images)) {
		while ($image = $db->fetch_Array($images)) {
		  $image_id = $image['image_id'];		
		  $filename = $vbulletin->options['bburl']. "/" .$vbulletin->options['certific_degree_imagedir']. "/" .$image['userid']. "/" .$image['image_id']. "t.jpg";
		  $caption = htmlspecialchars_uni($image['caption']);
		  $section = htmlspecialchars_uni($image['showinsections']);
		  $display_order = $image['display_order']; 
		  
		  eval('$interior_imagebits .= "' . fetch_template('certific_degree_vehicle_imagebits') . '";');
		  $image_count++;
		}      
	}
	
	// If any image slots are left then output the add image links using the certific_degree_addimage_bits template
    
    // If we have some slots left use the same display_order for all the pop-ups.  This is because only one can be processed one at a
    // so we just want to set it as the next available slot display-wise
    $display_order = ($db->num_rows($images)+1) * 10;  
    for($i=$db->num_rows($images)+1; $i<= 3; $i++) {
	  $sectionhdr = "add_image".$image_count;
	  $sectionhdr_menu = $sectionhdr."_menu";
		
	  eval('$interior_imagebits .= "' . fetch_template('certific_degree_vehicle_addimagebits') . '";'); 
	  eval('$imageaddpopups .= "' .  fetch_template('certific_degree_vehicle_addimagepopupbits') . '";');    
	  $image_count++;
    } 
    
  	//
	// Retrieve all the ICE images 11-13
	//
	$section = "icemods";
	
	$images = $db->query_read("SELECT image_id, userid, caption, showinsections, display_order FROM " . TABLE_PREFIX . "certific_degree_image 
		WHERE vehicle_id = $vehicle_id AND showinsections = '$section' ORDER BY display_order");
	
	// If images were found then output them using the certific_degree_imagebits template
	if($db->num_rows($images)) {
		while ($image = $db->fetch_Array($images)) {
		  $image_id = $image['image_id'];		
		  $filename = $vbulletin->options['bburl']. "/" .$vbulletin->options['certific_degree_imagedir']. "/" .$image['userid']. "/" .$image['image_id']. "t.jpg";
		  $caption = htmlspecialchars_uni($image['caption']);
		  $section = htmlspecialchars_uni($image['showinsections']);
		  $display_order = $image['display_order']; 
		  
		  eval('$ice_imagebits .= "' . fetch_template('certific_degree_vehicle_imagebits') . '";');
		  $image_count++;
		}      
	}
	
	// If any image slots are left then output the add image links using the certific_degree_addimage_bits template
    
    // If we have some slots left use the same display_order for all the pop-ups.  This is because only one can be processed one at a
    // so we just want to set it as the next available slot display-wise
    $display_order = ($db->num_rows($images)+1) * 10;  
    for($i=$db->num_rows($images)+1; $i<= 3; $i++) {
	  $sectionhdr = "add_image".$image_count;
	  $sectionhdr_menu = $sectionhdr."_menu";
		
	  eval('$ice_imagebits .= "' . fetch_template('certific_degree_vehicle_addimagebits') . '";'); 
	  eval('$imageaddpopups .= "' .  fetch_template('certific_degree_vehicle_addimagepopupbits') . '";');    
	  $image_count++;
    }    
 
   	//
	// Retrieve all the Drivetrain images 14-16
	//
	$section = "drivetrainmods";
	
	$images = $db->query_read("SELECT image_id, userid, caption, showinsections, display_order FROM " . TABLE_PREFIX . "certific_degree_image 
		WHERE vehicle_id = $vehicle_id AND showinsections = '$section' ORDER BY display_order");
	
	// If images were found then output them using the certific_degree_imagebits template
	if($db->num_rows($images)) {
		while ($image = $db->fetch_Array($images)) {
		  $image_id = $image['image_id'];		
		  $filename = $vbulletin->options['bburl']. "/" .$vbulletin->options['certific_degree_imagedir']. "/" .$image['userid']. "/" .$image['image_id']. "t.jpg";
		  $caption = htmlspecialchars_uni($image['caption']);
		  $section = htmlspecialchars_uni($image['showinsections']);
		  $display_order = $image['display_order']; 
		  
		  eval('$drivetrain_imagebits .= "' . fetch_template('certific_degree_vehicle_imagebits') . '";');
		  $image_count++;
		}      
	}
	
	// If any image slots are left then output the add image links using the certific_degree_addimage_bits template
    
    // If we have some slots left use the same display_order for all the pop-ups.  This is because only one can be processed one at a
    // so we just want to set it as the next available slot display-wise
    $display_order = ($db->num_rows($images)+1) * 10;  
    for($i=$db->num_rows($images)+1; $i<= 3; $i++) {
	  $sectionhdr = "add_image".$image_count;
	  $sectionhdr_menu = $sectionhdr."_menu";
		
	  eval('$drivetrain_imagebits .= "' . fetch_template('certific_degree_vehicle_addimagebits') . '";'); 
	  eval('$imageaddpopups .= "' .  fetch_template('certific_degree_vehicle_addimagepopupbits') . '";');    
	  $image_count++;
    }
      
   	//
	// Retrieve all the Suspension images 17-19
	//
	$section = "suspensionmods";
	
	$images = $db->query_read("SELECT image_id, userid, caption, showinsections, display_order FROM " . TABLE_PREFIX . "certific_degree_image 
		WHERE vehicle_id = $vehicle_id AND showinsections = '$section' ORDER BY display_order");
	
	// If images were found then output them using the certific_degree_imagebits template
	if($db->num_rows($images)) {
		while ($image = $db->fetch_Array($images)) {
		  $image_id = $image['image_id'];		
		  $filename = $vbulletin->options['bburl']. "/" .$vbulletin->options['certific_degree_imagedir']. "/" .$image['userid']. "/" .$image['image_id']. "t.jpg";
		  $caption = htmlspecialchars_uni($image['caption']);
		  $section = htmlspecialchars_uni($image['showinsections']);
		  $display_order = $image['display_order']; 
		  
		  eval('$suspension_imagebits .= "' . fetch_template('certific_degree_vehicle_imagebits') . '";');
		  $image_count++;
		}      
	}
	
	// If any image slots are left then output the add image links using the certific_degree_addimage_bits template
    
    // If we have some slots left use the same display_order for all the pop-ups.  This is because only one can be processed one at a
    // so we just want to set it as the next available slot display-wise
    $display_order = ($db->num_rows($images)+1) * 10;  
    for($i=$db->num_rows($images)+1; $i<= 3; $i++) {
	  $sectionhdr = "add_image".$image_count;
	  $sectionhdr_menu = $sectionhdr."_menu";
		
	  eval('$suspension_imagebits .= "' . fetch_template('certific_degree_vehicle_addimagebits') . '";'); 
	  eval('$imageaddpopups .= "' .  fetch_template('certific_degree_vehicle_addimagepopupbits') . '";');    
      $image_count++;
    } 
    
   	//
	// Retrieve all the Wheel & Tire images 20-22
	//
	$section = "wheelsandtires";
	
	$images = $db->query_read("SELECT image_id, userid, caption, showinsections, display_order FROM " . TABLE_PREFIX . "certific_degree_image 
		WHERE vehicle_id = $vehicle_id AND showinsections = '$section' ORDER BY display_order");
	
	// If images were found then output them using the certific_degree_imagebits template
	if($db->num_rows($images)) {
		while ($image = $db->fetch_Array($images)) {
		  $image_id = $image['image_id'];		
		  $filename = $vbulletin->options['bburl']. "/" .$vbulletin->options['certific_degree_imagedir']. "/" .$image['userid']. "/" .$image['image_id']. "t.jpg";
		  $caption = htmlspecialchars_uni($image['caption']);
		  $section = htmlspecialchars_uni($image['showinsections']);
		  $display_order = $image['display_order']; 
		  
		  eval('$wheels_imagebits .= "' . fetch_template('certific_degree_vehicle_imagebits') . '";');
		  $image_count++;
		}      
	}
	
	// If any image slots are left then output the add image links using the certific_degree_addimage_bits template
    
    // If we have some slots left use the same display_order for all the pop-ups.  This is because only one can be processed one at a
    // so we just want to set it as the next available slot display-wise
    $display_order = ($db->num_rows($images)+1) * 10;  
    for($i=$db->num_rows($images)+1; $i<= 3; $i++) {
	  $sectionhdr = "add_image".$image_count;
	  $sectionhdr_menu = $sectionhdr."_menu";
		
	  eval('$wheels_imagebits .= "' . fetch_template('certific_degree_vehicle_addimagebits') . '";'); 
	  eval('$imageaddpopups .= "' .  fetch_template('certific_degree_vehicle_addimagepopupbits') . '";');    
	  $image_count++;
    }         
           
   $navbits = array();   
   $navbits['certific_degree.php?' . $vbulletin->session->vars['sessionurl']. "do=editdegree"] = ' ';
   if($vehicle['name'] != "")
     $navbits[''] = $vehicle['name'];
   else 
     $navbits[''] = $vehicle['year'] . " " . $vehicle['make'] . " " . $vehicle['model'];
   $navbits = construct_navbits($navbits);   
  
   // build the cp nav
   construct_usercp_nav('certific_degree_manage');    
   
   eval('$navbar = "' . fetch_template('navbar') . '";');
   eval('$HTML = "' . fetch_template('certific_degree_vehicle_detail') . '";');
   eval('print_output("' . fetch_template('USERCP_SHELL') . '");');
}

if ($_REQUEST['do'] == 'savevehicle')
{	
	// Make sure the user has permission to be here
	if(!degreePerms($vbulletin->userinfo))
      print_no_permission(); 
      
    $vars = array(
	    'vehicle_id' 	=> TYPE_INT,
	    'display' 		=> TYPE_INT,
	    'comments' 		=> TYPE_INT,
		'vname' 		=> TYPE_STR,
		'vyear' 		=> TYPE_STR,
		'vmake' 		=> TYPE_STR,
		'vmodel' 		=> TYPE_STR,
		'vcolor' 		=> TYPE_STR,
		'vpackages' 	=> TYPE_STR,
		'vhistory' 		=> TYPE_STR,
		'exteriormods' 	=> TYPE_STR,
		'interiormods' 	=> TYPE_STR,
		'icemods' 		=> TYPE_STR,
		'drivetrainmods'=> TYPE_STR,
		'suspensionmods'=> TYPE_STR,
		'wheelsandtires'=> TYPE_STR,
	);

	// Set up for scrubbing all the image pop-ups
	$image_files = array();
			
	for($i=1; $i<=22; $i++) {
		$subinfo = array(
		'url'. $i			=> TYPE_STR,
		'caption'. $i 		=> TYPE_STR,
		'section'. $i 		=> TYPE_STR,
		'display_order'. $i => TYPE_INT		
		);
		
		$vars = array_merge($vars, $subinfo);	
		
		$subfiles = array(
		'image'. $i			=> TYPE_FILE	
		);
		
		$image_files = array_merge($image_files, $subfiles);	
				
	}

	// Clean all the input
 	$vbulletin->input->clean_array_gpc('p', $vars);	
 	$vbulletin->input->clean_array_gpc('f', $image_files);	
 	
 	$userid = $vbulletin->userinfo['userid'];
	$vehicle_id = $vbulletin->GPC['vehicle_id'];
		
	if($vehicle_id != -1) {
					
		// Get the userid out of the database to insure the update is on a vehicle that this user manages
		$verify = $db->query_first("SELECT userid from ". TABLE_PREFIX ."certific_degree_vehicle WHERE vehicle_id=$vehicle_id");

		if(!$verify) {
			$vbulletin->url = $vbulletin->options[bburl] . "/certific_degree.php?do=editdegree";

			eval(print_standard_redirect('redirect_certific_degree_invalid_vehicle', true, true));	  	
		}
	
		// Make sure that image_id that is being deleted is associated with a vehicle that this user manages 
		if($verify['userid'] != $vbulletin->userinfo['userid'])
		  print_no_permission(); 	
	}
	
 	$display = $vbulletin->GPC['display'];
 	$comments = $vbulletin->GPC['comments'];
	$name =  $vbulletin->GPC['vname'];
	$year =  $vbulletin->GPC['vyear'];
	$make =  $vbulletin->GPC['vmake'];
	$model = $vbulletin->GPC['vmodel'];
	$color =  $vbulletin->GPC['vcolor'];
	$packages =  $vbulletin->GPC['vpackages'];
	$history =  $vbulletin->GPC['vhistory'];
	$exteriormods =  $vbulletin->GPC['exteriormods'];
	$interiormods =  $vbulletin->GPC['interiormods'];
	$icemods =  $vbulletin->GPC['icemods'];
	$drivetrainmods =  $vbulletin->GPC['drivetrainmods'];
	$suspensionmods =  $vbulletin->GPC['suspensionmods'];
	$wheelsandtires =  $vbulletin->GPC['wheelsandtires'];
	
	if(isset($vehicle_id) && ($vehicle_id != -1)) {
    		
		// Update an existing record
		$sql = "UPDATE ". TABLE_PREFIX . "certific_degree_vehicle SET  
	      name =  '" . $db->escape_string($name) . "',
	      year =  '" . $db->escape_string($year) . "',
	      make =  '" . $db->escape_string($make) . "',
	      model =  '" . $db->escape_string($model) . "',
	      color =  '" . $db->escape_string($color) . "',
	      packages =  '" . $db->escape_string($packages) . "',
	      history =  '" . $db->escape_string($history) . "',
	      exteriormods =  '" . $db->escape_string($exteriormods) . "',
	      interiormods =  '" . $db->escape_string($interiormods) . "',
	      icemods =  '" . $db->escape_string($icemods) . "',
	      drivetrainmods =  '" . $db->escape_string($drivetrainmods) . "',
	      suspensionmods =  '" . $db->escape_string($suspensionmods) . "',
	      wheelsandtires =  '" . $db->escape_string($wheelsandtires) . "',
	      time_modified = NOW(),
	      display =  $display,
	      allowcomments =  $comments
	      WHERE vehicle_id = $vehicle_id
	      AND userid = $userid";
		
		//echo "$sql<br>";  
	      
	    $db->query_write($sql);
	}
	else {
	    // Create a new record
	    $sql = "INSERT INTO ". TABLE_PREFIX ."certific_degree_vehicle (
	      userid, 
	      name, 
	      year, 
	      make, 
	      model, 
	      color, 
	      packages, 
	      history, 
	      exteriormods,
	      interiormods,
	      icemods,
	      drivetrainmods,
	      suspensionmods,
	      wheelsandtires,
	      time_modified,
	      time_added,
	      display,
	      allowcomments) VALUES (
	      $userid,'". 
	      $db->escape_string($name) ."',
	      '". $db->escape_string($year) ."',
	      '". $db->escape_string($make) ."',
	      '". $db->escape_string($model) ."',
	      '". $db->escape_string($color) ."',
	      '". $db->escape_string($packages) ."',
	      '". $db->escape_string($history) ."',
	      '". $db->escape_string($exteriormods) ."',
	      '". $db->escape_string($interiormods) ."',
	      '". $db->escape_string($icemods) ."',
	      '". $db->escape_string($drivetrainmods) ."',
	      '". $db->escape_string($suspensionmods) ."',
	      '". $db->escape_string($wheelsandtires) ."',
	      NOW(),
	      NOW(),
	      $display,
	      $comments)";
		//echo "$sql<br>";
	      
	    $db->query_write($sql);
	    
	    $vehicle_id = $db->insert_id();
	}

	// Since we have a valid vehicle set up the redirect URL in the event there is an error during save or image processing so that the user is notified and then redirected back to degree edit
	$vbulletin->url = $vbulletin->options[bburl] . "/certific_degree.php?do=editvehicle&amp;v=$vehicle_id";
	
	// Identify any images that were set for upload in a section
	// IDENTIFY IMAGES
	$images = null;
	for ($i=1; $i<=22; $i++) {
				
		if (!empty($vbulletin->GPC['image'.$i]['tmp_name']))
		{
		  $images[] = array('file'=> $vbulletin->GPC['image'.$i],
		  				'url' => "",
						'caption' => $vbulletin->GPC['caption'.$i],
						'section' =>  $vbulletin->GPC['section'.$i],
						'display_order' => $vbulletin->GPC['display_order'.$i]);
		}	
		else if (!empty($vbulletin->GPC['url'.$i]) && ($vbulletin->GPC['url'.$i] != "http://www."))
		{		  
		  $images[] = array('file'=> "",
		  				'url' => $vbulletin->GPC['url'.$i],
						'caption' => $vbulletin->GPC['caption'.$i],
						'section' =>  $vbulletin->GPC['section'.$i],
						'display_order' => $vbulletin->GPC['display_order'.$i]);
		}		
	}
		
	if ($images) {
					
		foreach($images as $image) {
			
			
			// Check to see if file was uploaded....if so, then ignore URL that may have been entered
			if($image['file']) {
				
				$start_image = $image['file'];
				
				$badImage = false;
				
				switch ($start_image['type']) {
					case "image/jpeg": case "image/pjpeg":
					case 2:
						$tmp_image = imagecreatefromjpeg($start_image['tmp_name']);
						break;
					case "image/gif":
						$tmp_image = imagecreatefromgif($start_image['tmp_name']);
						break;
					case "image/png":
						$tmp_image = imagecreatefrompng($start_image['tmp_name']);
						break;
					default:
					    $badImage = true;
					    break;
				}
				unlink($start_image['tmp_name']);
				
				if($badImage)
				  eval(print_standard_redirect('redirect_certific_degree_invalid_image', true, true));	  					
			}
			else if ($image['url']) {   // A URL is being used	
										
			  	// Make sure a real URL was entered
			  	if($image['url'] == 'http://www.') {
			       eval(print_standard_redirect('redirect_certific_degree_no_url', true, true));      
			  	}
			  	
			  	// Make sure it can be retrieved
			    if(($handle = @fopen($image['url'], "rb")) === FALSE) {
			       eval(print_standard_redirect('redirect_certific_degree_could_not_open_url', true, true));      
				}
				
			    if(!$handle)
			      $contents = '';
			      
			    while (!feof($handle)) {
			      $contents .= fread($handle, 8192);
			    }
			    fclose($handle);
			
			    $tempfname = tempnam("/tmp", "degree");
			    $handle = fopen($tempfname, "w");
			    fwrite($handle, $contents);
			    fclose($handle);
			
			    // Determine what type of image it is
			    list($width, $height, $type, $attr, $orgsize) = getimagesize($tempfname);			    
			 
			    if($type < 1 || $type > 3) {
				  unlink($tempfname);
				  eval(print_standard_redirect('redirect_certific_degree_invalid_image_url', true, true));
			    }
			    
			    $badImage = false;
			    switch ($type) {
					case "image/jpeg": 
					case "image/pjpeg":
					case IMAGETYPE_JPEG:
						$tmp_image = imagecreatefromjpeg($tempfname);
						break;
					case "image/gif":
					case IMAGETYPE_GIF:
						$tmp_image = imagecreatefromgif($tempfname);
						break;
					case "image/png":
					case IMAGETYPE_PNG:	
						$tmp_image = imagecreatefrompng($tempfname);
						break;
					default:
					    $badImage = true;
					    break;						
				}
				unlink($tempfname);
				
				if($badImage)
				  eval(print_standard_redirect('redirect_certific_degree_invalid_image_url', true, true));	  					
				
			  }
			  else { // No data was entered ... redirect back to page
			      eval(print_standard_redirect('redirect_certific_degree_unknown_upload_error', true, true));
			  }				
			
			// Insert the image info into the database and retrieve the index to build the name		
			$sql = "INSERT INTO ". TABLE_PREFIX ."certific_degree_image (
				vehicle_id,
				userid, 
				caption, 
				showinsections, 
				display_order, 
				time_added) 
				VALUES (
				'" . $vehicle_id . "',			
				'" . $userid . "',
				'" . $db->escape_string($image['caption']) . "',
				'" . $db->escape_string($image['section']) . "', 
				" . $image['display_order'] .", 
				NOW() )";
			
			$db->query_write($sql);
			
			$imagename = $db->insert_id();
			
			// set final image dimension based on image options for certific degree
			$start_w = $new_w = imagesx($tmp_image);
			$start_h = $new_h = imagesy($tmp_image);
			if ($new_w > $vbulletin->options['certific_degree_max_image_width'])
			{
				$ratio = $vbulletin->options['certific_degree_max_image_width'] / $new_w;
				$new_w = $vbulletin->options['certific_degree_max_image_width'];
				$new_h *= $ratio;
			}
			if ($new_h > $vbulletin->options['certific_degree_max_image_width'])
			{
				$ratio = $vbulletin->options['certific_degree_max_image_width'] / $new_h;
				$new_w *= $ratio;
				$new_h = $vbulletin->options['certific_degree_max_image_width'];
			}
				
			// copy the tmp_image to a new image variable with new dimensions
			$final_image = imagecreatetruecolor($new_w, $new_h);
			imagecopyresampled($final_image, $tmp_image, 0, 0, 0, 0, $new_w, $new_h, $start_w, $start_h);
	
			// Check to insure that the user image subdirectory exists...if not create
			$dir = DIR ."/".$vbulletin->options['certific_degree_imagedir']."/".$userid;
			if(!file_exists($dir))
			  mkdir($dir);
			
			$filepath = "$dir/$imagename.jpg";
			
			imagejpeg($final_image, $filepath);
			
			
			// Generate the thumbnail
			$start_w = $new_w = imagesx($final_image);
			$start_h = $new_h = imagesy($final_image);
			if ($new_w > $vbulletin->options['certific_degree_max_thumb_width'])
			{
				$ratio = $vbulletin->options['certific_degree_max_thumb_width'] / $new_w;
				$new_w = $vbulletin->options['certific_degree_max_thumb_width'];
				$new_h *= $ratio;
			}
	
			$thumb_image = imagecreatetruecolor($new_w, $new_h);
			
			imagecopyresampled($thumb_image, $final_image, 0, 0, 0, 0, $new_w, $new_h, $start_w, $start_h);
			$filepath =DIR ."/".$vbulletin->options['certific_degree_imagedir']."/".$userid."/$imagename". "t.jpg";
			
			imagejpeg($thumb_image, $filepath);
	
			// Clean up
			imagedestroy($final_image);
			imagedestroy($thumb_image);
					
			// Be sure to remove original uploaded file
		
	  }
	}	
	
	if($_REQUEST['savePreview'])
	  Header("Location: " . $vbulletin->options[bburl] . "/certific_degree.php?do=editvehicle&v=$vehicle_id&preview=1");
	else
	  Header("Location: " . $vbulletin->options[bburl] . "/certific_degree.php?do=editvehicle&v=$vehicle_id");
}

if($_REQUEST['do'] == 'delvehicle') {

	// Make sure the user has permission to be here
	if(!degreePerms($vbulletin->userinfo))
      print_no_permission(); 
      
	$vbulletin->input->clean_array_gpc('r', array(
		'vehicle_id' 		=> TYPE_INT
	));
	
	$vehicle_id = &$vbulletin->GPC['vehicle_id'];
	$userid = $vbulletin->userinfo['userid'];
		
	// Get the userid of the person owning this vehicle information
	$vehicle = $db->query_first("SELECT userid FROM " . 
		TABLE_PREFIX . "certific_degree_vehicle WHERE vehicle_id = $vehicle_id");

	// If nothing retrieved flag it as a bad record specified
	if(!$vehicle) {
		$vbulletin->url = $vbulletin->options[bburl] . "/certific_degree.php?do=editdegree";
		eval(print_standard_redirect('redirect_certific_degree_invalid_vehicle', true, true));	  	
	}		
	
	$vehicle_userid = $vehicle['userid'];
	
	// Do a check to see if this user has permission to edit this degree (ie - its theirs)
	// If its not then exit
	if($vehicle_userid != $userid)
	  print_no_permission(); 	
	
	// Delete the vehicle
	$result = $db->query_write("DELETE FROM " . TABLE_PREFIX . "certific_degree_vehicle
		WHERE vehicle_id = $vehicle_id AND userid=$userid");

    // Determine all the images associated with this vehicle	
	$images = $db->query_read("SELECT image_id FROM " . TABLE_PREFIX . "certific_degree_image
		WHERE vehicle_id = $vehicle_id AND userid=$userid");

    // Remove all the image files from disk
	if($db->num_rows($images)) {
		while ($image = $db->fetch_Array($images)) {
		  $imageid = $image['image_id'];
		  $filename =DIR ."/".$vbulletin->options['certific_degree_imagedir']."/".$userid."/". $imageid . ".jpg";
		  unlink($filename);
		  
		  $thumb =DIR ."/".$vbulletin->options['certific_degree_imagedir']."/".$userid."/". $imageid . "t.jpg";
		  unlink($thumb);
		}      
	}		
	
	// Delete any image information associated with this vehicle
	$rows = $db->query_read("DELETE FROM " . TABLE_PREFIX . "certific_degree_image
		WHERE vehicle_id = $vehicle_id AND userid=$userid");
		
	// Delete any comments associated with this vehicle
	$rows = $db->query_read("DELETE FROM " . TABLE_PREFIX . "certific_degree_comment
		WHERE vehicle_id = $vehicle_id");

   // Redirect back to the degree list
	Header("Location: " . $vbulletin->options[bburl] . "/certific_degree.php?do=editdegree");	
}


// ############################################################################
// ############################### VIEW degree ################################
// ############################################################################

if ($_REQUEST['do'] == 'viewvehicle')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'vehicle_id' 		=> TYPE_INT
	));
	
	// Save the info regarding who is viewing the degree...this is needed for promotion determination later
	$viewerinfo = $vbulletin->userinfo;
	
	$vehicle_id = &$vbulletin->GPC['vehicle_id'];
	
	// Get the vehicle information
	$vehicle = $db->query_first("SELECT userid, name, year, make, model, color, packages, history, exteriormods,
		interiormods, icemods, drivetrainmods, suspensionmods, wheelsandtires, display FROM " . 
		TABLE_PREFIX . "certific_degree_vehicle WHERE vehicle_id = $vehicle_id");
		
	// If nothing retrieved flag it as a bad record specified
	if(!$vehicle) {
		eval(print_standard_redirect('redirect_certific_degree_invalid_vehicle', true, true));	  	
	}			

	// Check to see that degree is visible - if not then put up error if its not the degree owner trying to view it
	if(!$vehicle['display'] && ($vbulletin->userinfo['userid'] != $vehicle['userid']))
	  eval(print_standard_redirect('redirect_certific_degree_invalid_vehicle', true, true));	  	
			
    require_once(DIR . '/includes/class_bbcode.php');
    $bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

	$vehicle['name'] = htmlspecialchars_uni($vehicle['name']);
	$vehicle['year'] = htmlspecialchars_uni($vehicle['year']);
	$vehicle['make'] = htmlspecialchars_uni($vehicle['make']);
	$vehicle['model'] = htmlspecialchars_uni($vehicle['model']);
	$vehicle['color'] = htmlspecialchars_uni($vehicle['color']);
	$vehicle['packages'] = htmlspecialchars_uni($vehicle['packages']);	
    $vehicle['history'] = $bbcode_parser->parse($vehicle['history']);

    $vehicle['show_exterior'] = false;
    $vehicle['show_interior'] = false;
    $vehicle['show_ice'] = false;
    $vehicle['show_drivetrain'] = false;
    $vehicle['show_suspension'] = false;
    $vehicle['show_wheels'] = false;
    
    $vehicle['exteriormods'] = $bbcode_parser->parse($vehicle['exteriormods']);
    $vehicle['interiormods'] = $bbcode_parser->parse($vehicle['interiormods']);
    $vehicle['icemods'] = $bbcode_parser->parse($vehicle['icemods']);
    $vehicle['drivetrainmods'] = $bbcode_parser->parse($vehicle['drivetrainmods']);
    $vehicle['suspensionmods'] = $bbcode_parser->parse($vehicle['suspensionmods']);
    $vehicle['wheelsandtires'] = $bbcode_parser->parse($vehicle['wheelsandtires']);

    if($vehicle['exteriormods']) $vehicle['show_exterior'] = true;
    if($vehicle['interiormods']) $vehicle['show_interior'] = true;
    if($vehicle['icemods']) $vehicle['show_ice'] = true;
    if($vehicle['drivetrainmods']) $vehicle['show_drivetrain'] = true;
    if($vehicle['suspensionmods']) $vehicle['show_suspension'] = true;
    if($vehicle['wheelsandtires']) $vehicle['show_wheels'] = true;   
      
    // Get the vehicle owner's userinfo
    $degreeowner = fetch_userinfo($vehicle['userid']);
    
    //echo "viewerinfo.username=". $viewerinfo[username]. "<br>";
    
	fetch_online_status($degreeowner, true);   

   	$userperms = cache_permissions($degreeowner, false);
   	   
    // Build the page title
    $degree_name = construct_phrase($vbphrase['xs_degree'], $degreeowner['username']);
    
    if($vehicle['name'] != "")
        $certific_page_title = $degree_name. " :: ". $vehicle['name'];
    else
        $certific_page_title = $degree_name. " :: ". $vehicle['year']. " " .$vehicle['make']. " " .$vehicle['model'];

    $displaypromotion = degree_promo($viewerinfo);
    
	//
	// Retrieve the main images - 1
	//
	$section = "main";
		
	$images = $db->query_read("SELECT image_id, userid, caption FROM " . TABLE_PREFIX . "certific_degree_image 
		WHERE vehicle_id = $vehicle_id AND showinsections = '$section' ORDER BY display_order");	
	
	// If images were found then output them using the certific_degree_imagebits template
	if($db->num_rows($images)) {
		$show['images_main'] = true;
		while ($image = $db->fetch_Array($images)) {	
		  $imageuserid = $image['userid'];
		  $imageid = $image['image_id'];	  	
		  $thumbname = $vbulletin->options['bburl']. "/" .$vbulletin->options['certific_degree_imagedir']. "/" .$imageuserid. "/" .$imageid. "t.jpg";
		  $filename = $vbulletin->options['bburl']. "/" .$vbulletin->options['certific_degree_imagedir']. "/" .$imageuserid. "/" .$imageid. ".jpg";
		  $caption = htmlspecialchars_uni($image['caption']);
		  
		  eval('$main_imagebits .= "' . fetch_template('certific_degree_vehicle_view_imagebits') . '";');
		}      
	}


	//
	// Retrieve all the general images 2-4
	//
	$section = "general";
	
	$images = $db->query_read("SELECT image_id, userid, caption FROM " . TABLE_PREFIX . "certific_degree_image 
		WHERE vehicle_id = $vehicle_id AND showinsections = '$section' ORDER BY display_order");	
	
	// If images were found then output them using the certific_degree_imagebits template
	if($db->num_rows($images)) {
		$show['images_general'] = true;
		while ($image = $db->fetch_Array($images)) {		
		  $imageuserid = $image['userid'];
		  $imageid = $image['image_id'];	  	
		  $thumbname = $vbulletin->options['bburl']. "/" .$vbulletin->options['certific_degree_imagedir']. "/" .$imageuserid. "/" .$imageid. "t.jpg";
		  $filename = $vbulletin->options['bburl']. "/" .$vbulletin->options['certific_degree_imagedir']. "/" .$imageuserid. "/" .$imageid. ".jpg";
		  $caption = htmlspecialchars_uni($image['caption']);
		  
		  eval('$general_imagebits .= "' . fetch_template('certific_degree_vehicle_view_imagebits') . '";');
		}      
	}

	    
 	//
	// Retrieve all the Exterior images 5-7
	//
	$section = "exteriormods";
	
	$images = $db->query_read("SELECT image_id, userid, caption FROM " . TABLE_PREFIX . "certific_degree_image 
		WHERE vehicle_id = $vehicle_id AND showinsections = '$section' ORDER BY display_order");	
	
	// If images were found then output them using the certific_degree_imagebits template
	if($db->num_rows($images)) {
		$show['images_exterior'] = true;
		while ($image = $db->fetch_Array($images)) {		
		  $imageuserid = $image['userid'];
		  $imageid = $image['image_id'];	  	
		  $thumbname = $vbulletin->options['bburl']. "/" .$vbulletin->options['certific_degree_imagedir']. "/" .$imageuserid. "/" .$imageid. "t.jpg";
		  $filename = $vbulletin->options['bburl']. "/" .$vbulletin->options['certific_degree_imagedir']. "/" .$imageuserid. "/" .$imageid. ".jpg";
		  $caption = htmlspecialchars_uni($image['caption']);
		  
		  eval('$exterior_imagebits .= "' . fetch_template('certific_degree_vehicle_view_imagebits') . '";');
		}      
	}  
	  
 	//
	// Retrieve all the Interior images 8-10
	//
	$section = "interiormods";
	
	$images = $db->query_read("SELECT image_id, userid, caption FROM " . TABLE_PREFIX . "certific_degree_image 
		WHERE vehicle_id = $vehicle_id AND showinsections = '$section' ORDER BY display_order");	
	
	// If images were found then output them using the certific_degree_imagebits template
	if($db->num_rows($images)) {
		$show['images_interior'] = true;
		while ($image = $db->fetch_Array($images)) {		
		  $imageuserid = $image['userid'];
		  $imageid = $image['image_id'];	  	
		  $thumbname = $vbulletin->options['bburl']. "/" .$vbulletin->options['certific_degree_imagedir']. "/" .$imageuserid. "/" .$imageid. "t.jpg";
		  $filename = $vbulletin->options['bburl']. "/" .$vbulletin->options['certific_degree_imagedir']. "/" .$imageuserid. "/" .$imageid. ".jpg";
		  $caption = htmlspecialchars_uni($image['caption']);
		  
		  eval('$interior_imagebits .= "' . fetch_template('certific_degree_vehicle_view_imagebits') . '";');
		}      
	}
	
    
  	//
	// Retrieve all the ICE images 11-13
	//
	$section = "icemods";
	
	$images = $db->query_read("SELECT image_id, userid, caption FROM " . TABLE_PREFIX . "certific_degree_image 
		WHERE vehicle_id = $vehicle_id AND showinsections = '$section' ORDER BY display_order");	
	
	// If images were found then output them using the certific_degree_imagebits template
	if($db->num_rows($images)) {
		$show['images_ice'] = true;
		while ($image = $db->fetch_Array($images)) {		
		  $imageuserid = $image['userid'];
		  $imageid = $image['image_id'];	  	
		  $thumbname = $vbulletin->options['bburl']. "/" .$vbulletin->options['certific_degree_imagedir']. "/" .$imageuserid. "/" .$imageid. "t.jpg";
		  $filename = $vbulletin->options['bburl']. "/" .$vbulletin->options['certific_degree_imagedir']. "/" .$imageuserid. "/" .$imageid. ".jpg";
		  $caption = htmlspecialchars_uni($image['caption']);
		  
		  eval('$ice_imagebits .= "' . fetch_template('certific_degree_vehicle_view_imagebits') . '";');
		}      
	}   
 
   	//
	// Retrieve all the Drivetrain images 14-16
	//
	$section = "drivetrainmods";
	
	$images = $db->query_read("SELECT image_id, userid, caption FROM " . TABLE_PREFIX . "certific_degree_image 
		WHERE vehicle_id = $vehicle_id AND showinsections = '$section' ORDER BY display_order");	
	
	// If images were found then output them using the certific_degree_imagebits template
	if($db->num_rows($images)) {
		$show['images_drivetrain'] = true;
		while ($image = $db->fetch_Array($images)) {		
		  $imageuserid = $image['userid'];
		  $imageid = $image['image_id'];	  	
		  $thumbname = $vbulletin->options['bburl']. "/" .$vbulletin->options['certific_degree_imagedir']. "/" .$imageuserid. "/" .$imageid. "t.jpg";
		  $filename = $vbulletin->options['bburl']. "/" .$vbulletin->options['certific_degree_imagedir']. "/" .$imageuserid. "/" .$imageid. ".jpg";
		  $caption = htmlspecialchars_uni($image['caption']);
		  
		  eval('$drivetrain_imagebits .= "' . fetch_template('certific_degree_vehicle_view_imagebits') . '";');
		}      
	}
	
   	//
	// Retrieve all the Suspension images 17-19
	//
	$section = "suspensionmods";
	
	$images = $db->query_read("SELECT image_id, userid, caption FROM " . TABLE_PREFIX . "certific_degree_image 
		WHERE vehicle_id = $vehicle_id AND showinsections = '$section' ORDER BY display_order");	
	
	// If images were found then output them using the certific_degree_imagebits template
	if($db->num_rows($images)) {
		$show['images_suspension'] = true;
		while ($image = $db->fetch_Array($images)) {		
		  $imageuserid = $image['userid'];
		  $imageid = $image['image_id'];	  	
		  $thumbname = $vbulletin->options['bburl']. "/" .$vbulletin->options['certific_degree_imagedir']. "/" .$imageuserid. "/" .$imageid. "t.jpg";
		  $filename = $vbulletin->options['bburl']. "/" .$vbulletin->options['certific_degree_imagedir']. "/" .$imageuserid. "/" .$imageid. ".jpg";
		  $caption = htmlspecialchars_uni($image['caption']);
		  
		  eval('$suspension_imagebits .= "' . fetch_template('certific_degree_vehicle_view_imagebits') . '";');
		}      
	}
	    
   	//
	// Retrieve all the Wheel & Tire images 20-22
	//
	$section = "wheelsandtires";
	
	$images = $db->query_read("SELECT image_id, userid, caption FROM " . TABLE_PREFIX . "certific_degree_image 
		WHERE vehicle_id = $vehicle_id AND showinsections = '$section' ORDER BY display_order");	
	
	// If images were found then output them using the certific_degree_imagebits template
	if($db->num_rows($images)) {
		$show['images_tire_wheel'] = true;
		
		while ($image = $db->fetch_Array($images)) {		
		  $imageuserid = $image['userid'];
		  $imageid = $image['image_id'];	  	
		  $thumbname = $vbulletin->options['bburl']. "/" .$vbulletin->options['certific_degree_imagedir']. "/" .$imageuserid. "/" .$imageid. "t.jpg";
		  $filename = $vbulletin->options['bburl']. "/" .$vbulletin->options['certific_degree_imagedir']. "/" .$imageuserid. "/" .$imageid. ".jpg";
		  $caption = htmlspecialchars_uni($image['caption']);
		  
		  eval('$wheels_imagebits .= "' . fetch_template('certific_degree_vehicle_view_imagebits') . '";');
		}      
	}
	
    if($show['images_exterior']) $vehicle['show_exterior'] = true;
    if($show['images_interior']) $vehicle['show_interior'] = true;
    if($show['images_ice']) $vehicle['show_ice'] = true;
    if($show['images_drivetrain']) $vehicle['show_drivetrain'] = true;
    if($show['images_suspension']) $vehicle['show_suspension'] = true;
    if($show['images_tire_wheel']) $vehicle['show_wheels'] = true;  	
                     
    if($vehicle['show_exterior'] || $vehicle['show_interior'] || $vehicle['show_ice'] || $vehicle['show_drivetrain'] || $vehicle['show_suspension'] || $vehicle['show_wheels'])
      $vehicle['showmods'] = true;
    else 
      $vehicle['showmods'] = false;

    // Build the User info block     
	// JOIN DATE & POSTS PER DAY
	$degreeowner['datejoined'] = vbdate($vbulletin->options['registereddateformat'], $degreeowner['joindate']);
	
	$jointime = (TIMENOW - $degreeowner['joindate']) / 86400; // Days Joined
	if ($jointime < 1)
	{ // User has been a member for less than one day.
		$degreeowner['posts'] = vb_number_format($degreeowner['posts']);
	}
	else
	{
		$degreeowner['posts'] = vb_number_format($degreeowner['posts']);
	}

	$show['profile'] = true;
	$show['search'] = true;
	$show['buddy'] = true;
	
	// EMAIL
	$show['emaillink'] = ( $degreeowner['showemail'] AND $vbulletin->options['displayemails'] AND (
                                !$vbulletin->options['secureemail'] OR (
                                        $vbulletin->options['secureemail'] AND $vbulletin->options['enableemail']
                                ) 
                        ) AND $vbulletin->userinfo['permissions']['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canemailmember']
                        AND $vbulletinuserinfo['userid']);
          	
	// HOMEPAGE
	$show['homepage'] = ($degreeowner['homepage'] != '' AND $degreeowner['homepage'] != 'http://');
	
	// PRIVATE MESSAGE
	$show['pmlink'] = ($vbulletin->options['enablepms'] AND $vbulletin->userinfo['permissions']['pmquota'] AND ($vbulletin->userinfo['permissions']['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']
	 					OR ($degreeowner['receivepm'] AND $userperms['pmquota'])
	 				)) ? true : false;

	// IM icons
	$show['hasimicons'] = false;

   	// AVATAR
 	$avatarurl = fetch_avatar_url($degreeowner['userid']);
           	
	if ($avatarurl == '' OR !$vbulletin->options['avatarenabled'] OR ($avatarurl['hascustom'] AND !($degreeowner['permissions']['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canuseavatar']) AND !$degreeowner['adminavatar']))
	{
		$show['avatar'] = false;
	}
	else
	{
		$show['avatar'] = true;
		$degreeowner['avatarsize'] = $avatarurl[1];
		$degreeowner['avatarurl'] = $avatarurl[0];
	}

    if (($vbulletin->options['templateversion'] >= '3.6') && ($vbulletin->options['templateversion'] < '3.7')) {
      $buddyphrase = construct_phrase($vbphrase['add_x_to_buddy_list'], $degreeowner['username']);
    }
    else {
      $buddyphrase = construct_phrase($vbphrase['add_x_to_contacts'], $degreeowner['username']);
    }
          
   // Build the degree popup menu for this user
   $certific_degree_popup_menu = generate_degree_popup_menu($degreeowner, false, true, false);
  
   $navbits = array();   
   $navbits['certific_degree.php?' . $vbulletin->session->vars['sessionurl']. "do=index"] = '';
   
   $navbits[''] = $certific_page_title;
   $navbits = construct_navbits($navbits);   
   
   eval('$navbar = "' . fetch_template('navbar') . '";');
   eval('$ownerbit ="' . fetch_template('certific_degree_ownerbit'). '";');
   eval('print_output("' . fetch_template('certific_degree_vehicle_view') . '");');
}

?>
