<?php
class vBShop_Item_usertitlechange extends vBShop_Item_Core
{	
	/**
	* The constructor
	*
	* @param	vBulletin	vBulletin registry
	* @param	vBShop		vBShop registry
	* @param	array		Item info
	*/	
	public function __construct(&$registry, $vbshop, &$item)
	{
		parent::__construct($registry, $vbshop, $item);
		
		// Set purchase template
		$this->config['purchasetemplate'] = 'dbtech_vbshop_purchase_usertitlechange';
	}
	
	/**
	* Load item info
	*/	
	public function load_item_info()
	{
		return array(
			'name' 					=> 'User Title Change',
			'description' 			=> 'Change others\' usernames.',
			'icon' 					=> '',
			'price' 				=> 10
		);
	}
	
	/**
	* Function to call before every action
	*/	
	public function action()
	{
		if (!parent::action())
		{
			// This type is inactive
			return false;
		}
		
		// We made it!
		return true;
	}
	
	
	/**
	* Purchasing an item
	*
	* @param	array		User info
	* @param	array		Recipient user info
	*/	
	protected function pre_purchase(&$buyer, &$recipient)
	{
		global $vbphrase;
		
		$noalter = explode(',', $this->registry->config['SpecialUsers']['undeletableusers']);
		if (!is_array($noalter))
		{
			$noalter = array();
		}

		if ($buyer['userid'] != $recipient['userid'] AND in_array($recipient['userid'], $noalter))
		{
			// Woups, immune
			eval(standard_error(fetch_error('dbtech_vbshop_error_x', $vbphrase['dbtech_vbshop_recipient_immune'])));
		}
		
		// Ensure we have the necessary files
		require_once(DIR . '/includes/adminfunctions.php');
		require_once(DIR . '/includes/adminfunctions_options.php');
		
		$bitfielddefs =& fetch_bitfield_definitions('nocache|dbtech_vbshop_immunity');
		foreach ($bitfielddefs AS $key => $val)
		{
			if ($key == 'dbtech_vbshop_' . $this->config['itemtype'] AND $recipient['userid'] != $buyer['userid'] AND ($recipient['dbtech_vbshop_immunity'] & $val))
			{
				// Woups, immune
				eval(standard_error(fetch_error('dbtech_vbshop_error_x', $vbphrase['dbtech_vbshop_recipient_immune'])));
			}
		}
		
		// Get the form code
		$code = $this->registry->input->clean_gpc('p', 'code', TYPE_ARRAY);
		
		if (!$code['usertitle'])
		{
			// Work around a template bug
			$code['usertitle'] = $this->registry->input->clean_gpc('p', 'usertitle', TYPE_STR);
		}
		
		// Change the username
		$userdata =& datamanager_init('User', $this->registry, ERRTYPE_STANDARD);
		$userdata->set_existing($recipient);
		$userdata->set_usertitle($code['usertitle'], false, array(), true, false);
		$userdata->save();
	}	
}
?>