<?php

  /************************************************************\
  *
  *	  PHP Array Pagination Copyright 2007 - Derek Harvey
  *	  www.lotsofcode.com
  *
  *	  This file is part of PHP Array Pagination .
  *
  *	  PHP Array Pagination is free software; you can redistribute it and/or modify
  *	  it under the terms of the GNU General Public License as published by
  *	  the Free Software Foundation; either version 2 of the License, or
  *	  (at your option) any later version.
  *
  *	  PHP Array Pagination is distributed in the hope that it will be useful,
  *	  but WITHOUT ANY WARRANTY; without even the implied warranty of
  *	  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
  *	  GNU General Public License for more details.
  *
  *	  You should have received a copy of the GNU General Public License
  *	  along with PHP Array Pagination ; if not, write to the Free Software
  *	  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
  *
  \************************************************************/

  class pagination
  {
    var $num = 1; // Current num
    var $pernum = 10; // Items on each num, defaulted to 10
    var $showFirstAndLast = false; // if you would like the first and last num options.
    
    function generate($array, $pernum = 10)
    {
      // Assign the items per num variable
      if (!empty($pernum))
        $this->pernum = $pernum;
      
      // Assign the num variable
      if (!empty($_GET['num'])) {
        $this->num = $_GET['num']; // using the get method
      } else {
        $this->num = 1; // if we don't have a num number then assume we are on the first num
      }
      
      // Take the length of the array
      $this->length = count($array);
      
      // Get the number of nums
      $this->nums = ceil($this->length / $this->pernum);
      
      // Calculate the starting point 
      $this->start  = ceil(($this->num - 1) * $this->pernum);
      
      // Return the part of the array we have requested
      return array_slice($array, $this->start, $this->pernum);
    }
    
    function links()
    {
      // Initiate the links array
      $plinks = array();
      $links = array();
      $slinks = array();
      
      // Concatenate the get variables to add to the num numbering string
      if (count($_GET)) {
        $queryURL = '';
        foreach ($_GET as $key => $value) {
          if ($key != 'num') {
            $queryURL .= '&'.$key.'='.$value;
          }
        }
      }
      
      // If we have more then one nums
      if (($this->nums) > 1)
      {
        // Assign the 'previous num' link into the array if we are not on the first num
        if ($this->num != 1) {
          if ($this->showFirstAndLast) {
            $plinks[] = ' <a href="?num=1'.$queryURL.'">&laquo;&laquo; الاولى </a> ';
          }
          $plinks[] = ' <a href="?num='.($this->num - 1).$queryURL.'">&laquo; السابق</a> ';
        }
        
        // Assign all the num numbers & links to the array
        for ($j = 1; $j < ($this->nums + 1); $j++) {
          if ($this->num == $j) {
            $links[] = ' <a class="selected"><strong>'.$j.'</strong></a> '; // If we are on the same num as the current item
          } else {
            $links[] = ' <a href="?num='.$j.$queryURL.'">'.$j.'</a> '; // add the link to the array
          }
        }
  
        // Assign the 'next num' if we are not on the last num
        if ($this->num < $this->nums) {
          $slinks[] = ' <a href="?num='.($this->num + 1).$queryURL.'"> التالى &raquo; </a> ';
          if ($this->showFirstAndLast) {
            $slinks[] = ' <a href="?num='.($this->nums).$queryURL.'"> الاخير &raquo;&raquo; </a> ';
          }
        }
        
        // Push the array into a string using any some glue
        return implode(' ', $plinks).implode($this->implodeBy, $links).implode(' ', $slinks);
      }
      return;
    }
  }
?>