<?php
/*======================================================================*\
|| #################################################################### ||
|| # Advanced Editing Options for Mods & Admins for vBulletin 3.5.x - 3.8.x by Psionic Vision (Original by Xenon)
|| #################################################################### ||
|| # Copyright 2009 Anton Kanevsky (ankan925@gmail.com) aka Psionic Vision. All Rights Reserved.
|| # This file may redistributed under GPL license for non-commercial purposes only.
|| #################################################################### ||
\*======================================================================*/

######################################################################################
error_reporting(E_ALL & ~E_NOTICE);

######################################################################################
$phrasegroups = array('cpuser', 'user');
$specialtemplates = array();

######################################################################################
require_once('./global.php');

######################################################################################
if (!can_administer('canadminusers'))
{
	print_cp_no_permission();
}

?>
<style type="text/css">
.editlevel_higher {color: red;}
.editlevel_equal {color: yellow;}
.editlevel_lower {color: gray;}
</style>
<?php

#################################################################################################################################
#################################################################################################################################
#################################################################################################################################

$users = $db->query_read("
	SELECT userid, username, usergroupid, membergroupids, advedit_masterlevel
	FROM " . TABLE_PREFIX . "user
	WHERE advedit_masterlevel <> -1
	ORDER BY username
");

if (!$db->num_rows($users))
{
	// no users found!
	print_stop_message('no_users_matched_your_query');
}
	
######################################################################################
print_cp_header($vbphrase['user_manager']);

######################################################################################
print_form_header('', '');
print_table_header($vbphrase['advedit_override_editlevel']);
print_description_row('
	<div class="darkbg" style="border: 2px inset; padding-bottom: 15px;"><ul class="darkbg">
	<li><b>' . $vbphrase['color_key'] . '</b></li>
	<li class="editlevel_higher">' . $vbphrase['advedit_editlevel_higher'] . '</li>
	<li class="editlevel_equal">' . $vbphrase['advedit_editlevel_equal'] . '</li>
	<li class="editlevel_lower">' . $vbphrase['advedit_editlevel_lower'] . '</li>
	</ul></div>
');
print_table_footer();

######################################################################################
print_form_header('', '');
print_cells_row(array($vbphrase['username'], $vbphrase['advedit_system_defined_editlevel'], $vbphrase['advedit_override_defined_editlevel']), 1);

######################################################################################
while ($user = $db->fetch_array($users))
{
	cache_permissions($user, false);
	$user['editlevel'] = get_editlevels(0, $user);

	$cell = array();
	$cell[] = "<a href=\"user.php?" . $vbulletin->session->vars['sessionurl'] . "do=edit&u=$user[userid]\"><b>$user[username]</b></a>&nbsp;";
	
	if ($user['advedit_masterlevel'] > $user['editlevel'])
	{
		$pfx = '<span class="editlevel_higher"><strong>';
		$sfx = '</strong></span>';
	}
	else if ($user['advedit_masterlevel'] == $user['editlevel'])
	{
		$pfx = '<span class="editlevel_equal"><strong>';
		$sfx = '</strong></span>';
	}
	else
	{
		$pfx = '<span class="editlevel_lower"><strong>';
		$sfx = '</strong></span>';
	}
		
	switch ($user['editlevel'])
	{
		case EDITLEVEL_AUTHOR:
			$data01 = $vbphrase['advedit_editlevel_author'];
			break;
		case EDITLEVEL_MOD:
			$data01 = $vbphrase['advedit_editlevel_mod'];
			break;
		case EDITLEVEL_SMOD:
			$data01 = $vbphrase['advedit_editlevel_smod'];
			break;
		case EDITLEVEL_ADMIN:
			$data01 = $vbphrase['advedit_editlevel_admin'];
			break;
		case EDITLEVEL_SADMIN:
			$data01 = $vbphrase['advedit_editlevel_sadmin'];
			break;
	}
		
	switch ($user['advedit_masterlevel'])
	{
		case EDITLEVEL_AUTHOR:
			$data02 = $vbphrase['advedit_editlevel_author'];
			break;
		case EDITLEVEL_MOD:
			$data02 = $vbphrase['advedit_editlevel_mod'];
			break;
		case EDITLEVEL_SMOD:
			$data02 = $vbphrase['advedit_editlevel_smod'];
			break;
		case EDITLEVEL_ADMIN:
			$data02 = $vbphrase['advedit_editlevel_admin'];
			break;
		case EDITLEVEL_SADMIN:
			$data02 = $vbphrase['advedit_editlevel_sadmin'];
			break;
	}
	
	$cell[] = $pfx . $data01 . $sfx;
	$cell[] = $pfx . $data02 . $sfx;

	print_cells_row($cell);
}

######################################################################################
print_table_footer();
print_cp_footer();

/*======================================================================*\
|| #################################################################### ||
|| # Advanced Editing Options for Mods & Admins for vBulletin 3.5.x - 3.8.x by Psionic Vision (Original by Xenon)
|| #################################################################### ||
\*======================================================================*/
?>