<?php
/*======================================================================*\
|| #################################################################### ||
|| # vS-Hide Hack Resurrection (Limited Edition) for vBulletin 3.5.x - 3.8.x by Anton Kanevsky
|| #################################################################### ||
|| # Copyright 2006-2009 Anton Kanevsky (ankan925@gmail.com) aka @kan. All Rights Reserved.
|| # This file may not be redistributed.
|| #################################################################### ||
\*======================================================================*/

class vS_HHR_Engine
{
	/**
	* The vBulletin registry object
	*
	* @var	vB_Registry
	*/
	var $registry = null;

	/**
	* Engine Tags
	*
	* @var	array
	*/
	var $tags = array(
		0 => 'HIDE-POSTS',
		4 => 'SHOWTOGROUPS'
	);
	
	/**
	* Engine Settings
	*
	* @var	array
	*/
	var $settings = array(
		'banned' => false,
		'dohtml' => false,
	);
	
	/**
	* Engine Variables
	*
	* @var	array
	*/
	var $vars = array();
	
	/**
	* Constructor
	*/
	function vS_HHR_Engine(&$registry)
	{
		// globalize variables
		global $show;

		// verify vbulletin presence
		if (is_object($registry))
		{
			$this->registry =& $registry;
		}
		else
		{
			trigger_error("vB_Database::Registry object is not an object", E_USER_ERROR);
		}
		
		// define whether the viewer cannot be view anything by definition
		if (substr($this->registry->options['templateversion'], 0, 3) == '3.5')
		{
			$is_banned = (($this->registry->usergroupcache[$this->registry->userinfo['usergroupid']]['genericoptions'] & $this->registry->bf_ugp_genericoptions['isbannedgroup']) ? true : false);
		}
		else
		{
			$is_banned = (!($this->registry->usergroupcache[$this->registry->userinfo['usergroupid']]['genericoptions'] & $this->registry->bf_ugp_genericoptions['isnotbannedgroup']) ? true : false);			
		}
		
		if (is_member_of($this->registry->userinfo, 3, 4) OR $is_banned OR THIS_SCRIPT == 'misc')
		{
			$this->settings['banned'] = true;
		}
		else
		{
			$this->settings['banned'] = false;
		}
		
		// define whether to use html version of replacements
		if (in_array(THIS_SCRIPT, array('ajax', 'editpost', 'misc', 'newthread', 'newreply', 'printthread', 'showpost', 'showthread')))
		{
			$this->settings['dohtml'] = true;
		}
		else
		{
			$this->settings['dohtml'] = false;
		}
		
		// apply makeup to $this->tags
		foreach ($this->tags as $key => $tag)
		{
			$this->tags["$tag"] =& $this->tags["$key"];
		}
		
		if (isset($this->tags[$this->registry->options['hidetag_shortcut']]))
		{
			$this->tags[$this->registry->options['hidetag_shortcut']] .= '|HIDE';
		}
	
		// define whether to show the buttons
		if (in_array(THIS_SCRIPT, array('editpost', 'newthread', 'newreply')) OR (THIS_SCRIPT == 'ajax' AND $_POST['do'] == 'quickedit') OR (THIS_SCRIPT == 'showthread' AND $this->registry->options['quickreply']))
		{
			global $foruminfo;
			
			$show['toolbar_hposts_button'] = 
			(
				$this->registry->options['enable_hposts_tag']
			);
			$show['toolbar_showtogroups_button'] = (
				$this->registry->options['enable_showtogroups_tag']
			);
			
			if ($show['toolbar_hposts_button'] OR $show['toolbar_showtogroups_button'])
			{
				$show['toolbar_hhr_separator'] = true;
				switch ($this->registry->options['hidetag_shortcut'])
				{
					case 0:
						$show['toolbar_shortcut_button'] = $show['toolbar_hposts_button'];
						break;
					case 4:
						$show['toolbar_shortcut_button'] = $show['toolbar_showtogroups_button'];
						break;
					default:
						$show['toolbar_shortcut_button'] = false;
				}
			}
			else
			{
				$show['toolbar_hhr_separator'] = false;
				$show['toolbar_shortcut_button'] = false;
			}
		}
	}

	###########################################################################################################################
	# vS-Hide Hack Resurrection - vB Code Parser
	###########################################################################################################################
	
	/**
	* Main function that is used to parse the tags.
	*
	* @var		string	Message (Raw)
	*
	* @return 	string	Message (Parsed)
	*/
	function parse_bbcode($message, $forumid, $threadid, $postid, $userid)
	{
		// globalize variables
		global $vbphrase, $stylevar, $show;
		
		// fetch variables
		$this->vars = array(
			'forumid' => intval($forumid),
			'threadid' => intval($threadid),
			'postid' => intval($postid),
			'userid' => intval($userid)
		);
		
		// parse message
		$message = preg_replace("/\[(" . $this->tags['HIDE-POSTS'] . ")\]/siU", '[\\1=' . $this->registry->options['hidetag_defaultposts'] . ']', $message);
		$message = preg_replace("/\[(" . $this->tags['HIDE-POSTS'] . ")=(&quot;|\"|'|)([0-9]+)\\2\](.*)\[\/\\1\]/esiU", "\$this->parse_bbcode_hposts('\\4', \\3)", $message);
		$message = preg_replace("/\[(" . $this->tags['HIDE-POSTS'] . ")=" . $this->registry->options['hidetag_defaultposts'] . "\]/siU", '[\\1]', $message);		
		
		$message = preg_replace("/\[(" . $this->tags['SHOWTOGROUPS'] . ")=(&quot;|\"|'|)([0-9,]+)\\2\](.*)\[\/\\1\]/esiU", "\$this->parse_bbcode_showtogroups('\\4', '\\3')", $message);
		
		// come to papa
		return $message;
	}
	
	/**
	* Helper function used to parse HIDE-POSTS
	*
	* @var		string	Message (Raw)
	* @var		int		The number of required posts.
	*
	* @return 	string	Message (Parsed)
	*/
	function parse_bbcode_hposts($message, $posts_required)
	{
		// globalize variables
		global $vbphrase, $stylevar, $show;
		
		// intialize field counter, for xhtml purposes
		static $hidefieldid = 0;
		$hidefieldid++;
		
		// correct the escapements
		$message = str_replace('\"', '"', $message);

		// decide whether the person can view
		$canview = false;
		if (!$this->settings['banned'])
		{
			if ($this->can_override())
			{
				$canview = true;
			}
			else
			{
				if ($this->registry->userinfo['userid'] AND $this->registry->userinfo['posts'] >= $posts_required)
				{
					$canview = true;
				}
			}
		}
		
		// construct caption
		if ($this->registry->userinfo['userid'])
		{
			$caption = construct_phrase($vbphrase['hidetag_caption_hposts_registered'], $posts_required, $this->registry->userinfo['posts']);
		}
		else if ($posts_required)
		{
			$caption = construct_phrase($vbphrase['hidetag_caption_hposts_guest_x'], $posts_required);
		}
		else
		{
			$caption = construct_phrase($vbphrase['hidetag_caption_hposts_guest']);
		}
		
		// construct replacement
		if ($this->settings['dohtml'])
		{
			eval('$message = "' . fetch_template('bbcode_hposts') . '";');
		}
		else
		{
			$message = ($canview ? $message : construct_phrase($vbphrase['hidetag_message_nohtml'], $caption));
		}
		
		// come to papa
		return $message;
	}
	
	/**
	* Helper function used to parse SHOWTOGROUPS
	*
	* @var		string	Message (Raw)
	* @var		string	Comma-Separated Usergroupids
	*
	* @return 	string	Message (Parsed)
	*/
	function parse_bbcode_showtogroups($message, $usergroupids) 
	{
		// globalize variables
		global $vbphrase, $stylevar, $show;
		
		// intialize field counter, for xhtml purposes
		static $hidefieldid = 0;
		$hidefieldid++;
		
		// correct the escapements
		$message = str_replace('\"', '"', $message);
		
		// fetch usergroups
		$usergroupids = array_intersect(array_keys($this->registry->usergroupcache), explode(",", $usergroupids));
		sort($usergroupids, SORT_NUMERIC);

		if (sizeof($usergroupids) > 0)
		{
			foreach ($usergroupids as $usergroupid)
			{
				$uglist .= (!empty($uglist) ? ', ' : '') . $this->registry->usergroupcache[$usergroupid]['title'] . " :: " . $usergroupid;
			}
		}
		else
		{
			$uglist = "N/A :: 0 - Invalid Usergroup(s) Specified";
		}
		
		// decide whether the person can view
		$canview = false;		
		if (!$this->settings['banned'])
		{
			if ($this->can_override())
			{
				$canview = true;
			}
			else
			{
				if (is_member_of($this->registry->userinfo, $usergroupids))
				{
					$canview = true;
				}
			}
		}
		
		// construct caption
		$caption = construct_phrase($vbphrase['hidetag_caption_showtogroups'], $uglist);
		
		// construct replacement
		if ($this->settings['dohtml'])
		{
			eval('$message = "' . fetch_template('bbcode_showtogroups') . '";');
		}
		else
		{
			$message = ($canview ? $message : construct_phrase($vbphrase['hidetag_message_nohtml'], $caption));
		}
		
		// come to papa
		return $message;
	}
	
	/**
	* Helper function used to strip bbcode.
	*
	* @var		string	Message (Raw)
	* @var		string	Purpose of Stripping ('editor', 'email', 'dopost')
	*
	* @return 	string	Message (Parsed)
	*/
	function strip_bbcode($message, $purpose = '') 
	{
		// globalize variables
		global $vbphrase, $stylevar, $show;

		// construct replacement
		switch ($purpose)
		{
			case 'editor':
				$replacement = $vbphrase['hidetag_stripped_quote'];
				break;
			case 'email':
				$replacement = $vbphrase['hidetag_stripped_email'];
				break;
			case 'dopost':
				$replacement = '';
				break;
			default:
				$replacement = 'vS-Hide Hack Resurrection: Undefined Replacement';
				break;
		}

		if (!($purpose == 'dopost' AND $show['toolbar_hposts_button']))
		{
			$message = preg_replace("/\[(" . $this->tags['HIDE-POSTS'] . ")\](.*)\[\/\\1\]/siU", $replacement, $message);
			$message = preg_replace("/\[(" . $this->tags['HIDE-POSTS'] . ")=(&quot;|\"|'|)([0-9]+)\\2\](.*)\[\/\\1\]/siU", $replacement, $message);		
		}

		if (!($purpose == 'dopost' AND $show['toolbar_showtogroups_button']))
		{
			$message = preg_replace("/\[(" . $this->tags['SHOWTOGROUPS'] . ")=(&quot;|\"|'|)([0-9,]+)\\2\](.*)\[\/\\1\]/siU", $replacement, $message);
		}
		
		// come to papa
		return $message;
	}
	
	/**
	* Returns true if the viewer can view hidden content regardless of conditional, false otherwise.
	*
	* @return 	boolean
	*/
	function can_override()
	{
		if ($this->registry->userinfo['permissions']['hhroptions'] & $this->registry->bf_ugp['hhroptions']['can_override_hide'])
		{
			return true;
		}
		if (in_array(THIS_SCRIPT, array('editpost', 'newthread')))
		{
			return true; // can override if [user is editing or making a post]
		}
		if (THIS_SCRIPT == 'newreply' AND !$this->vars['postid'])
		{
			return true; // can override if [user is previewing a new post]
		}
		if ($this->registry->userinfo['userid'] AND $this->registry->userinfo['userid'] == $this->vars['userid'])
		{
			return true; // can override if [user is the absolute post's owner (not a guest)]
		}
		if (can_moderate($this->vars['forumid'], 'caneditposts'))
		{
			return true; // can override if [user is a moderator of the current forum with post editing permissions]
		}
		
		return false;
	}
}

$hhr = new vS_HHR_Engine($vbulletin);

/*======================================================================*\
|| #################################################################### ||
|| # vS-Hide Hack Resurrection (Limited Edition) for vBulletin 3.5.x - 3.8.x by Anton Kanevsky
|| #################################################################### ||
\*======================================================================*/
?>