<?php
/* ------------------------------------------------------------ *\
|-> Inferno Warning System
|-> Translate by vBulletin.ae
\* ------------------------------------------------------------ */

/**
* Constructs visual display for warnings
*
* @param	array		User Information
* @param	boolean		Show add/remove warning linkage
*
* @return	string		HTML for the warning display
*/

function construct_warning_display(&$user, $showlinkage = false)
{
	global $vbulletin, $vbphrase;

	$Empty   = 5;
	$Maximum = $vbulletin->options['warn_max_level'];
	$Current = $user['inferno_warn_level'];
	$Bit     = ceil($Maximum / 5);
	$Full    = ceil($Current / $Bit);
	$Bits    = array();

	if ($Full > 0)
	{
		for ($f = 0; $f < $Full; $f++)
		{
			$Bits[] = bit_builder('full');
			$Empty--;
		}
	}

	if ($Empty > 0)
	{
		for ($e = 0; $e < $Empty; $e++)
		{
			$Bits[] = bit_builder();
		}
	}

	return $vbphrase['warn'] . ': (<a href="warn.php?' . $vbulletin->session->vars['sessionurl'] . 'do=view&amp;user=' . $user['userid'] . '">' . intval($Current / ($Maximum / 100)) . '</a>%) ' . finalize_bits($user, $Bits, $showlinkage);
}

/**
* Constructs warning image
*
* @param	string		image name
* @param	string		image alt
*
* @return	string		HTML for the image
*/

function bit_builder($type = 'empty', $alt = '')
{
	return '<img src="images/warning/'.$type.'.gif" alt="'.$alt.'" border="0" />';
}

/**
* Finalizes warning display
*
* @param	array		User Information
* @param	array		array of warning images
* @param	string		Show add/remove warning linkage
*
* @return	string		HTML for the warning display
*/

function finalize_bits(&$user, &$bits, $showlinkage)
{
	global $vbulletin;

	$Display   = '';
	if ($user['postid'])
	{
		$DataBuild = 'post;' . $user['userid'] . ';' . $user['postid'];
	}
	else
	{
		$DataBuild = 'user;' . $user['userid'];
	}

	if ($showlinkage)
	{
		$Display .= '<a href="warn.php?' . $vbulletin->session->vars['sessionurl'] . 'do=warn&amp;data=minus;' . $DataBuild . '">' .bit_builder('minus', '-'). '</a>';
	}

	for ($b = 0; $b < sizeof($bits); $b++)
	{
		$Display .= $bits[$b];
	}

	if ($showlinkage)
	{
		$Display .= '<a href="warn.php?' . $vbulletin->session->vars['sessionurl'] . 'do=warn&amp;data=plus;' . $DataBuild . '">' .bit_builder('plus', '+'). '</a>';
	}

	return $Display;
}

?>
