<?php

// Make an insert for settinggroups.
function settinggroup_make_insert($grouptitle, $displayorder, $text) {
	global $hack, $omgsglist, $omgsphraselist, $omgstext;
	(isset($omgsglist) ? $omgsglist .= ",\n" : $omgsglist = "");
	(isset($omgsphraselist) ? $omgsphraselist .= ",\n" : $omgsphraselist = "");
	$omgsglist .= "('$grouptitle', '$displayorder', '0')";
	$omgsphraselist .= "(NULL, '0',  'settinggroup_".$grouptitle."', '$text', '5000')";
	$omgstext .= "<font size=\"1\">$hack[displayname]:    - $text</font><br />\n";
}

// Make an insert for settings.
function setting_make_insert($title, $description, $varname, $grouptitle, $value, $defaultvalue, $optioncode, $displayorder) {
	global $hack, $omgslist, $omgsphraselist, $omgstext;
	(isset($omgslist) ? $omgslist .= ",\n" : $omgslist = "");
	(isset($omgsphraselist) ? $omgsphraselist .= ",\n" : $omgsphraselist = "");
	$omgsphraselist .= "(NULL, '0', 'setting_" . $varname . "_title', '" . addslashes($title) ."', '5000')";
	$omgsphraselist .= ",\n(NULL, '0',  'setting_" . $varname . "_desc', '" . addslashes($description) ."', '5000')";
	$omgslist .= "('$varname', '$grouptitle', '$value', '$defaultvalue', '" . addslashes($optioncode) ."', '$displayorder', '0', '0')";
	$omgstext .= "<font size=\"1\">$hack[displayname]:   - $title </font><br />";
}


// Update Settings Function
function update_setting($varname, $title = '', $description = '', $value = '', $defaultvalue = '', $optioncode = '', $displayorder = '') {
	global $DB_site, $hack, $omgstext;
	if ($title) {
		$DB_site->query("UPDATE " . TABLE_PREFIX . "phrase SET text = '".addslashes($title)."' WHERE varname = 'setting_" . $varname . "_title'");
	}
	if ($description) {
		$DB_site->query("UPDATE " . TABLE_PREFIX . "phrase SET text = '".addslashes($description)."' WHERE varname = 'setting_" . $varname . "_desc'");
	}
	$omgstext .= "<font size=\"1\">$hack[displayname]:   - $title </font><br />";
}

// Insert Settings Function
function insert_settings() {
	global $hack, $DB_site, $omgsglist, $omgslist, $omgsphraselist, $omgstext;
	if (isset($omgsglist)) {
		$DB_site->query("REPLACE INTO " . TABLE_PREFIX . "settinggroup (grouptitle, displayorder, volatile) VALUES\n $omgsglist");
	}
	if (isset($omgslist)) {
		$DB_site->query("REPLACE INTO " . TABLE_PREFIX . "setting (varname, grouptitle, value, defaultvalue, optioncode, displayorder, advanced, volatile) VALUES\n $omgslist");
	}
	if (isset($omgsphraselist)) {
		$DB_site->query("REPLACE INTO " . TABLE_PREFIX . "phrase (phraseid, languageid, varname, text, phrasetypeid) VALUES\n $omgsphraselist");
	}
	echo $omgstext;
	unset($GLOBALS['omgsglist'], $GLOBALS['omgslist'], $GLOBALS['omgsphraselist'], $GLOBALS['omgstext']);
}

// Make an insert for phrases.
function phrase_make_insert($varname, $text, $phrasetype) {
	global $hack, $omgplist, $omgptext;
	(isset($omgplist) ? $omgplist .= ",\n" : $omgplist = "");
	$omgplist .= "(NULL, '0', '" . $varname . "', '" . addslashes($text) ."', '$phrasetype')";
	$omgptext .= "<font size=\"1\">$hack[displayname]: Added/Updated Phrase - $varname</font><br />";
}

// Insert Phrases Function
function insert_phrases() {
	global $DB_site, $hack, $omgplist, $omgptext;
	$DB_site->query("REPLACE INTO " . TABLE_PREFIX . "phrase (phraseid, languageid, varname, text, phrasetypeid) VALUES\n $omgplist");
	echo $omgptext;
	unset($GLOBALS['omgplist'], $GLOBALS['omgptext']);
}

// Make an insert for admin help.
function adminhelp_make_insert($script, $action, $title, $text, $optionname, $displayorder) {
	global $hack, $omgahlist, $omgahphraselist, $omgahtext;
	// Make a varname.
	if (!empty($action)) {
		$action2 = "_".str_replace(",", "_", $action);
	} else {
		unset($action2);
	}
	if (!empty($optionname)) {
		$optionname2 = "_$optionname";
	} else {
		unset($optionname2);
	}
	$varname = $script.$action2.$optionname2;
	(isset($omgahlist) ? $omgahlist .= ",\n" : $omgahlist = "");
	(isset($omgahphraselist) ? $omgahphraselist .= ",\n" : $omgahphraselist = "");
	$omgahphraselist .= "(NULL, '0',  '" . $varname . "_title', '" . addslashes($title) ."', '6000')";
	$omgahphraselist .= ",\n(NULL, '0',  '" . $varname . "_text', '" . addslashes($text) ."', '6000')";
	$omgahlist .= "('$script', '$action', '$optionname', '$displayorder')";
	$omgahtext .= "<font size=\"1\">$hack[displayname]: Added Admin Help - $title </font><br />";
}

// Insert Admin Help Function
function insert_adminhelp() {
	global $hack, $DB_site, $omgahlist, $omgahphraselist, $omgahtext;
	if (isset($omgahlist)) {
		$DB_site->query("REPLACE INTO " . TABLE_PREFIX . "adminhelp (script, action, optionname, displayorder) VALUES\n $omgahlist");
	}
	if (isset($omgahphraselist)) {
		$DB_site->query("REPLACE INTO " . TABLE_PREFIX . "phrase (phraseid, languageid, varname, text, phrasetypeid) VALUES\n $omgahphraselist");
	}
	echo $omgahtext;
	unset($GLOBALS['omgahlist'], $GLOBALS['omgahphraselist'], $GLOBALS['omgahtext']);
}

// Make Template Function
function insert_template($name, $content) {
	global $DB_site, $hack;
	$template = compile_template($content);
	$DB_site->query("REPLACE INTO " . TABLE_PREFIX . "template (templateid, title, template, template_un, styleid, templatetype, dateline, username, version) VALUES (NULL, '$name', '" . addslashes($template) . "', '" . addslashes($content) ."', '-1', 'template', '" . time() . "', 'Geeky Designs', '3.0.0')");
	echo "<font size=\"1\">$hack[displayname]: Created/Updated Template - $name </font><br />";
}


// Make a kill list for settinggroups.
function settinggroup_kill_list($grouptitle, $title) {
	global $hack, $omgsgkilllist, $omgsphrasekilllist, $omgskilltext;
	(isset($omgsgkilllist) ? $omgsgkilllist .= "," : $omgsgkilllist = "");
	(isset($omgsphrasekilllist) ? $omgsphrasekilllist .= "," : $omgsphrasekilllist = "");
	$omgsgkilllist .= "'$grouptitle'";
	$omgsphrasekilllist .= "'settinggroup_".$grouptitle."'";
	$omgskilltext .= "<font size=\"1\">$hack[displayname]: Removed Setting Group - $title</font><br />";
}

// Make a kill list for settings.
function setting_kill_list($varname, $title) {
	global $hack, $omgskilllist, $omgsphrasekilllist, $omgskilltext;
	(isset($omgskilllist) ? $omgskilllist .= "," : $omgskilllist = "");
	(isset($omgsphrasekilllist) ? $omgsphrasekilllist .= "," : $omgsphrasekilllist = "");
	$omgsphrasekilllist .= "'setting_" . $varname . "_title'";
	$omgsphrasekilllist .= ",'setting_" . $varname . "_desc'";
	$omgskilllist .= "'$varname'";
	$omgskilltext .= "<font size=\"1\">$hack[displayname]:   - $title</font><br />";
}

// Kill Settings Function
function kill_settings() {
	global $hack, $DB_site, $omgsgkilllist, $omgskilllist, $omgsphrasekilllist, $omgskilltext;
	if (isset($omgsgkilllist)) {
		$DB_site->query("DELETE FROM " . TABLE_PREFIX . "settinggroup WHERE grouptitle IN ($omgsgkilllist)");
	}
	if (isset($omgskilllist)) {
		$DB_site->query("DELETE FROM " . TABLE_PREFIX . "setting WHERE varname IN ($omgskilllist)");
	}
	if (isset($omgsphrasekilllist)) {
		$DB_site->query("DELETE FROM " . TABLE_PREFIX . "phrase WHERE varname IN ($omgsphrasekilllist)");
	}
	echo $omgskilltext;
	unset($GLOBALS['omgsgkilllist'], $GLOBALS['omgskilllist'], $GLOBALS['omgsphrasekilllist'], $GLOBALS['omgskilltext']);
	build_options();
}

// Make a kill list for phrases.
function phrase_kill_list($varname) {
	global $hack, $omgpkilllist, $omgpkilltext;
	(isset($omgpkilllist) ? $omgpkilllist .= "," : $omgpkilllist = "");
	$omgpkilllist .= "'$varname'";
	$omgpkilltext .= "<font size=\"1\">$hack[displayname]: Removed Phrase - $varname </font><br />";
}

// Kill Phrases Function
function kill_phrases() {
	global $DB_site, $hack, $omgpkilllist, $omgpkilltext;
	$DB_site->query("DELETE FROM " . TABLE_PREFIX . "phrase WHERE varname IN ($omgpkilllist)");
	echo $omgpkilltext;
	unset($GLOBALS['omgpkilllist'], $GLOBALS['omgpkilltext']);
}

// Make a kill list for admin help.
function adminhelp_kill_list($script, $action, $optionname, $title) {
	global $hack, $omgahkilllist, $omgahphrasekilllist, $omgahkilltext;
	// Make a varname.
	if (!empty($action)) {
		$action2 = "_".str_replace(",", "_", $action);
	} else {
		unset($action2);
	}
	if (!empty($optionname)) {
		$optionname2 = "_$optionname";
	} else {
		unset($optionname2);
	}
	$varname = $script.$action2.$optionname2;
	(isset($omgahkilllist) ? $omgahkilllist .= " OR " : $omgahkilllist = "");
	(isset($omgahphrasekilllist) ? $omgahphrasekilllist .= "," : $omgahphrasekilllist = "");
	$omgahphrasekilllist .= "'" . $varname . "_title'";
	$omgahphrasekilllist .= ",'" . $varname . "_text'";
	$omgahkilllist .= "(script = '$script' && action='$action' && optionname='$optionname')";
	$omgahkilltext .= "<font size=\"1\">$hack[displayname]: Removed Admin Help - $title</font><br />";
}

// Kill Admin Help Function
function kill_adminhelp() {
	global $hack, $DB_site, $omgahkilllist, $omgahphrasekilllist, $omgahkilltext;
	if (isset($omgahkilllist)) {
		$DB_site->query("DELETE FROM " . TABLE_PREFIX . "adminhelp WHERE $omgahkilllist");
	}
	if (isset($omgahphrasekilllist)) {
		$DB_site->query("DELETE FROM " . TABLE_PREFIX . "phrase WHERE varname IN ($omgahphrasekilllist)");
	}
	echo $omgahkilltext;
	unset($GLOBALS['omgahkilllist'], $GLOBALS['omgaphrasekilllist'], $GLOBALS['omgahkilltext']);
}

// Make a kill list for templates.
function template_kill_list($title) {
	global $hack, $omgtkilllist, $omgtkilltext;
	(isset($omgtkilllist) ? $omgtkilllist .= "," : $omgtkilllist = "");
	$omgtkilllist .= "'$title'";
	$omgtkilltext .= "<font size=\"1\">$hack[displayname]: Removed template  - $title</font><br />";
}

// Kill Templates Function
function kill_templates() {
	global $DB_site, $hack, $omgtkilllist, $omgtkilltext;
	$DB_site->query("DELETE FROM " . TABLE_PREFIX . "template WHERE title IN ($omgtkilllist)");
	echo $omgtkilltext;
	unset($GLOBALS['omgtkilllist'], $GLOBALS['omgtkilltext']);
}



// Here's a complete steps array.
function steps_array_complete() {
	$array = array( 1 => "notes",
					2 => "dosettings",
					3 => "dophrases",
					4 => "doadminhelp",
					5 => "dotemplates",
					6 => "dodatabasequeries",
					7 => "doedits");
	return $array;
}
function steps_array_complete_desc() {
	$array = array( 1 => "",
					2 => "",
					3 => "",
					4 => "",
					5 => "",
					6 => "  ",
					7 => " / ");
	return $array;
}

// Here's a steps array for hacks made before build 3.
function steps_array_default() {
	$array = array( 2 => "dosettings",
					3 => "dophrases",
					5 => "dotemplates",
					6 => "dodatabasequeries",
					7 => "doedits");
	return $array;
}

function find_next_step($steparray, $current) {
	foreach ($steparray as $step => $action) {
		if ($step <= $current) {
			unset ($steparray[$step]);
		}
	}
	ksort($steparray);
	$steparray = array_values($steparray);
	$next = $steparray[0];
	return $next;
}

?>