<?php

/*
 * sendcard
 * Copyright Peter Bowyer <peter@sendcard.org> 2000, 2001, 2002
 * This script is released under the Artistic License
 * Please look in the docs/ directory for install instructions.
 *  
 * $Id: functions.php,v 1.14 2004/12/28 17:32:17 reywob Exp $
 */
class DB_Sendcard extends DB_Sql {
  var $Debug         = 0;     ## Set to 1 for debugging messages.
  var $Halt_On_Error = "yes"; ## "yes" (halt with message), "no" (ignore errors quietly), "report" (ignore errror, but spit a warning)

  function DB_Sendcard($query = "") {
    global $dbhost;
    global $dbpass;
    global $dbuser;
    global $dbdatabase;

    $this->Host = $dbhost;
    $this->Password = $dbpass;
    $this->User = $dbuser;
    $this->Database = $dbdatabase;

    $this->DB_Sql($query);
  }
}

Class Sendcard_Template extends Template {

  /**
   * Sendcard_Template::Sendcard_Template()
   * 
   * @param $root path to template directory
   * @param $unknowns what to do with unsubstituted variables
   * @return 
   */
  function Sendcard_Template($root = ".", $unknowns = "remove") {
    if ($this->debug & 4) {
      echo "<p><b>Template:</b> root = $root, unknowns = $unknowns</p>\n";
    }
    $this->set_root($root);
    $this->set_unknowns($unknowns);
  }
	/*
	 * private:
	 */
	function del_block($container, $handle) {
		$this->set_block($container, $handle);
		$this->set_var($handle, "");
	}

  /***************************************************************************/
  /* private: loadfile(string $varname)
   * varname:  load file defined by varname, if it is not loaded yet.
   */
  /**
   * Sendcard_Template::loadfile()
   * 
   * @param $varname name of file to load if not yet loaded.
   * @return 
   */
  function loadfile($varname) {
	global $php_in_tpl;
    if (!isset($this->file[$varname])) {
      // $varname does not reference a file so return
      return true;
    }

    if (isset($this->varvals[$varname])) {
      // will only be unset if varname was created with set_file and has never been loaded
      // $varname has already been loaded so return
      return true;
    }
    $filename = $this->file[$varname];

    /* use @file here to avoid leaking filesystem information if there is an error */
	if (floor(phpversion()) > 3 && $php_in_tpl == 1) {
		$str = _parseFile($filename);
	} else {
		$str = implode("", @file($filename));
	}
    if (empty($str)) {
      $this->halt("loadfile: While loading $varname, $filename does not exist or is empty.");
      return false;
    }

    $this->set_var($varname, $str);

    return true;
  }
	
} // End Class Sendcard_Template

/**
 * This function allows PHP in the templates to be executed.
 *
 * @author	Robin Vickery <robinv@ecosse.net>
 * @param		$match, the array of items matched using preg_replace_callback.
 * @return	The contents of the file.
 */
function _parseFile( $filename ) {
    ob_start();
      include($filename);
      $output = ob_get_contents();
    ob_end_clean();
    return $output;
}

/**
 * This function checks that the supplied email addresses are vaild.
 * Returns one status overall - 0 overrides 1.
 *
 * @author Peter Bowyer
 * @param	$email, array of email addresses.
 * @return returns 1 on success, 0 on failure.
 */
function is_valid_email($email) {
    settype($email, 'array');
    $status = 1;
    for ($i=0; $i < count($email); $i++){
        if (!eregi ("^([a-z0-9_]|\\-|\\.)+@(([a-z0-9_]|\\-)+\\.)+[a-z]{2,4}\$", $email[$i])) {
            $status = 0;
        }// End if
    }// End for
    return $status;
}// End function is_valid_email

/**
 * This function checks that the sender's email addresses are vaild.
 *
 * @author	Peter Bowyer
 * @param	$email, email address.
 * @return	returns 1 on success, 0 on failure.
 */
function validate_from_email ($email) {
    if (eregi ("^([a-z0-9_]|\\-|\\.)+@(([a-z0-9_]|\\-)+\\.)+[a-z]{2,4}\$", $email)) {
        return 1;
        }else{
        return 0;
        break;  // Do I need break in here??????  Beats me!
        }// End if
}// End function validate_from_email

/**
 * This function changes any URLs surrounded by <> into clickable URLs in
 * the message.
 *
 * @author	Peter Bowyer
 * @param	$text, the message from the postcard.
 * @return	returns $text, the message with hyperlinks in it.
 */
function makeurl($text)
{
    $text = eregi_replace("&lt;([http|news|ftp]+://[^ >\n\t]+)&gt;", "<a href=\"\\1\" target=\"_blank\">\\1</a>", $text);
    $text = eregi_replace("&lt;(mailto:)([^ >\n\t]+)&gt;", "<a href=\"\\1\\2\">\\2</a>", $text);
    $text = eregi_replace("<([http|news|ftp]+://[^ >\n\t]+)>", "<a href=\"\\1\" target=\"_blank\">\\1</a>", $text);
    $text = eregi_replace("<(mailto:)([^ >\n\t]+)>", "<a href=\"\\1\\2\">\\2</a>", $text);
    return $text;

}


/**
 * Returns the size of the image - needed to stop the contents of the card
 * shifting when the image loads.
 *
 * @author	Peter Bowyer
 * @param	$text, the message from the postcard.
 * @return	returns $text, the message with hyperlinks in it.
 */
function img_width($image) 
{
	global $img_path;
	if($image !="") {
		$size = @GetImageSize($img_path . $image);
		return $size[0];
	}
}

function img_height($image) 
{
	global $img_path;
	if ($image != "") {
		$size = @GetImageSize($img_path . $image);
		return $size[1];
	}
}

/**
 * Use GetImageSize to extract the number relating to the image type, and
 * either return the number (if return_name is false) or return the associated
 * extension.
 * 
 * @access public
 * @param string $image The name/path of the image file
 * @param bool $return_name true if the name/file extension should be returned
 * @return mixed string or integer 
 */
function image_type($image, $return_name = true)
{
	list(,,$image_type,) = GetImageSize($image);
    if (!$return_name) {
        return $image_type;
    }

    $types = array(
                   1 => 'GIF', 'JPEG', 'PNG', 'SWF', 'PSD', 'BMP', 'TIFF', 'TIFF',
                   'JPC', 'JP2', 'JPX', 'JB2', 'SWC', 'IFF');
	if (isset($types[$image_type])) {
	    return $types[$image_type];
	} else {
		#trigger_error('Error in function <b>image_type</b>: the type corresponding to image id=' . $image_type . ' isn\'t set', E_USER_NOTICE);
		return 0;
	}
}


/**
 * Used instead of htmlspecialchars(), as that caused problems when displaying
 * Hebrew text.
 *
 * @author	Peter Bowyer
 * @param	$str, a string of text.
 * @return	string $str, the escaped  string
 * @modified 2002/02/05
 */
function makesafe($str){
	global $tpl_path, $sc_language, $separate_language_templates;
    
    if ($separate_language_templates == 1 && file_exists($tpl_path . '/' . $sc_language . '/replace.txt')) {
        $str = replace_from_file($str, $tpl_path . '/' . $sc_language . '/replace.txt');
    } else {
        $str = replace_from_file($str, $tpl_path . 'replace.txt');
    }
	return $str;
}

/**
 * Used instead of htmlspecialchars(), as that caused problems when displaying
 * Hebrew text.
 *
 * @author	Peter Bowyer
 * @param string $str, a string of text.
 * @param string $file the file name and path to write to.
 * @return	string $str, the escaped  string
 */
function replace_from_file($str, $file){
	$fp = file($file);
    if ($fp === false) {
        trigger_error("Cannot read $file in replace_from_file() on line " . __LINE__);
    }
    // replace 4 spaces with a tab to make the file work after being edited 
    // by some text editors
    $fp = str_replace('    ', "\t", $fp);
	for($i=0, $j = count($fp); $i < $j; $i++) {
		$parts = split("\t", $fp[$i]);
		$parts[1] = trim($parts[1]);
		if($parts[0] != "") {
			$str = str_replace($parts[0], $parts[1], $str);
		}
	}
	return $str;
}


/**
 * Creates part of the id for the card.
 *
 * @author	Peter Bowyer
 * @return $str, the id of the card (less two digits)
 */
function advancetime($month="", $day="", $year="") {
	if ($month == "" || $day == "" || $year == "") {
		return time();
	} else {
		$now = getdate();
		$mktime = mktime($now["hours"],$now["minutes"],$now["seconds"],$month,$day,$year);
		return $mktime;
	} // End if
} // End function

     /*
     ** Function: DateSelector
     ** Version v2.0
     ** Last Updated: 2000-05-01
     ** Author: Leon Atkinson <leon@leonatkinson.com>
     ** Creates three form fields for get month/day/year
     ** Input: Prefix to name of field, default date
     ** Output: HTML to define three date fields
     ** This version highly modified by Peter Bowyer
     */
    function DateSelector($inName, $useDate=0){
		global $sc_lang;
        //create array so we can name months
        $monthName = $sc_lang['month_names'];

        //if date invalid or not supplied, use current time
        if($useDate == 0)
        {
            $useDate = time();
        }

        /*
        ** make day selector
        */
        $month  = "<select name=\"day\">\n";
        for($currentDay=1; $currentDay <= 31; $currentDay++)
        {
            $month  .= "<option value=\"$currentDay\"";
            if(intval(date( "d", $useDate))==$currentDay)
            {
                $month  .= " selected";
            }
            $month  .= ">$currentDay</option>\n";
        }
        $month  .= "</select>&nbsp;\n\n\n";

        /*
        ** make month selector
        */
        $month .= "<select name=\"month\">\n";
        for($currentMonth = 1; $currentMonth <= 12; $currentMonth++)
        {
            $month  .= "<option value=\"";
            $month  .= intval($currentMonth);
            $month  .= "\"";
            if(intval(date( "m", $useDate))==$currentMonth)
            {
                $month  .= " selected";
            }
            $month  .= ">" . $monthName[($currentMonth - 1)] .  "</option>\n";
        }
        $month  .= "</select>&nbsp;\n\n\n";

        /*
        ** make year selector
        */
        $month  .= "<select name=\"year\">\n";
        $startYear = date( "Y", $useDate);
        for($currentYear = $startYear /* - 5 */; $currentYear <= $startYear +1; $currentYear++)
        {
            $month  .= "<option value=\"$currentYear\"";
            if(date( "Y", $useDate)==$currentYear)
            {
                $month  .= " selected";
            }
            $month  .= ">$currentYear</option>\n";
        }
        $month  .= "</select>\n\n";
    return $month;
    }

/**
 * This code sees whether the image string has .swf at the end.  If so then
 * it removes the image code from form.tpl and message.tpl.  Otherwise, it
 * removes the code for the Flash movie.
 * @author	Peter Bowyer
 * @param string $image the image name.
 *
 */
function set_img_block($image) {
	Global $tpl;
	Global $applet_name;
	if( trim($applet_name) != "" || eregi("\.(class|jar)$", trim($image)) ) {
		$tpl->set_block("img_tags", "java_block_$applet_name");
		$code = $tpl->get_var("java_block_$applet_name");
	} elseif(eregi("\.(swf)$", trim($image))) {
		$tpl->set_block("img_tags", "swf_block");
		$code = $tpl->get_var("swf_block");
	} elseif( eregi("\.(jpg|jpeg|gif|png)$", trim($image)) ) {
		$tpl->set_block("img_tags", "img_block");
		$code = $tpl->get_var("img_block");
	} elseif( eregi("\.mov$", trim($image)) ) {
		$tpl->set_block("img_tags", "quicktime_block");
		$code = $tpl->get_var("quicktime_block");
	} else {
		// Don't know what the file is, so we'll try embedding it.
		$tpl->set_block("img_tags", "embed_block");
		$code = $tpl->get_var("embed_block");
	}
	$tpl->set_var("IMG", $code);
}


/**
 * This function returns the first 3 numbers of the PHP version.
 * For example, if you are using PHP 4.0.6 it will return 406.
 *
 * @author	Peter Bowyer
 * @return	int $ver, the version.
 */
function get_phpversion () {
	$ver = "";
	$temp = explode(".", phpversion());
	for($i = 0; $i < 3; $i++) {
		$ver .= $temp[$i];
	}
	return $ver;
}

/**
 * Prevent Cross-Site Scripting attacks from taking place.
 * @access public
 * @param string $str The string to be processed
 * @return string $str The modified string
 */
function prevent_xss($str)
{
    if (is_array($str)) {
        foreach($str as $key => $value){
        	$str[$key] = prevent_xss($value);
        }
    } else {
        $str = preg_replace('!<script([^>]*)>!si', '&lt;script$1&gt;', $str);
        $str = str_replace('</script>', '&lt;/script&gt;', $str);
        $str = preg_replace('!(\S+)script\s*:!si', '$1scriipt:', $str);
        $str = preg_replace('!\bon[a-zA-Z]*=!si', 'onHack=', $str);
    }
    return $str;
}


/**
 * Replaces the placeholders in the emails with actual values.
 *
 * @author	Peter Bowyer
 * @param		$str, string containing the placeholders
 * @param		$to, the recipients name
 * @param		$to_email, the recipients email address
 * @param		$id, the id of the card
 * @return	$str, the string with the placeholders substituted.
 */
function subst_placeholders($str, $to = '', $to_email = '', $id = "") {
    global $sc_lang, $email_substs;
	global $from, $from_email;
	global $sendcard_http_path, $date, $message;
    global $id;
	
	// Firstly determine which file to link to
	switch(SENDCARD_MODE){
		case 'PHPNUKE_MODULE': 
			$path = FORM_ACTION . '&';
			break;
		default:
            if (isset($sc_lang['frame_file']) && trim($sc_lang['frame_file']) != '') {
                $path = $sc_lang['frame_file'] . '?';
            } else {
			    $path = FORM_ACTION . '?';
            }
	} // switch
    
    $from = stripslashes($from);
    $from_email = stripslashes($from_email);
    
	$str = str_replace("[to]", $to, $str);
	$str = str_replace("[to_email]", $to_email, $str);
	$str = str_replace("[from]", $from, $str);
	$str = str_replace("[from_email]", $from_email, $str);
	$str = str_replace("[card_url]", $sendcard_http_path . $path . "view=1&id=$id", $str);
    $str = str_replace("[print_card_url]", $sendcard_http_path . $path . "view=1&id=$id&print=1", $str);
	$str = str_replace("[card_id]", $id, $str);
	$str = str_replace("[date]", $date, $str);
	$str = str_replace("[message]", $message, $str);
	$str = str_replace("[sender_card_url]", $sendcard_http_path . $path . "view=1&sender_view=1&id=$id", $str);
    foreach((array)$email_substs as $key => $val){
        $val = str_replace('[sendcard_http_path]', $sendcard_http_path, $val);
        $val = str_replace('[sendcard_path]', $path, $val);
    	$str = str_replace("[$key]", $val, $str);
    }
	return $str;
}

/**
 *
 * @access public
 * @return void 
 */
function sendcard_show_message($message)
{
	global $tpl, $des;
    $tpl->set_var("CONTENT", $message);
	$tpl->pparse("CONTENT", "card");
}

/**
 * Build the HTML required for the hidden inputs in the forms
 * 
 * @param array $items Array of name/value pairs
 * @return string $html HTML code
 */
function buildHiddenInputs($items, $padding = '', $basename = '')
{
    // Get rid of any items from the input array that aren't allowed
    #$items = array_intersect($items, $GLOBALS['allowed_inputs']);
    foreach($items as $key => $val){
        if ($basename != '') {
            $key = $basename . '[' . $key . ']';
        }
		if (is_array($val)) {
		    $html .= buildHiddenInputs($val, $padding, $key);
		} else {
            if ($val != '') {
                $html .= $padding . '<input type="hidden" name="' . $key . '" value="' . htmlspecialchars($val, ENT_QUOTES) . "\" />\n";
            }
		}
    }
    return $html;
}

/**
 * Creates the strings required to send the card, and passes them to the
 * send_email function.
 * 
 * @access public
 * @return void 
 */
function send_card_email($to, $to_email, $from, $from_email, $id)
{
    global $sc_lang;
		$youhavecard_subject_p = subst_placeholders($sc_lang['youhavecard_subject'], $to, $to_email);
		$youhavecard_p = subst_placeholders($sc_lang['youhavecard'], $to, $to_email);
        $email_headers = array('From' => "$from <$from_email>", 'Return-Path' => "$from <$from_email>");
        $email_data = array(
                            'to' => $to,
                            'to_email' => $to_email,
                            'from' => $from,
                            'from_email' => $from_email,
                            'subject' => $youhavecard_subject_p,
                            'message' => $youhavecard_p,
                            'headers' => $email_headers
                            );
        /*** plugin before_send_card_email ***/
		send_email($email_data);
}

/**
 *
 * @access public 
 * @return void 
 */
function send_thankyou_email($to, $to_email, $from, $from_email)
{
    global $sc_lang;
		$subject = subst_placeholders($sc_lang['cardreceived_subject'], $from, $from_email);
		$body = subst_placeholders($sc_lang['cardreceived'], $from, $from_email);
        $email_headers = array('From' => "$from <$from_email>", 'Return-Path' => "$from <$from_email>");
        /*** plugin before_send_thankyou_email ***/
        $email_data = array(
                            'to' => $to,
                            'to_email' => $to_email,
                            'from' => $from,
                            'from_email' => $from_email,
                            'subject' => $subject,
                            'message' => $body,
                            'headers' => $email_headers
                            );
		send_email($email_data);
}

/**
 * This function handles sending the email.
 * 
 * @access public
 * @param array The needed arguments
 * @return void 
 */
function send_email($array)
{
    extract($array);
	global $sc_mail;

    if (!isset($headers['X-Mailer'])) {
        $headers += array("X-Mailer" => "sendcard $sc_version - PHP/" . phpversion());
    }
    foreach($headers as $key => $val){
    	$header_str .= $key . ': ' . $val . "\r\n";
    }
    // Now remove the trailing \r\n from the headers
    $header_str = substr($header_str, 0, strlen($header_str) - 4);
	if ($sc_mail == 'mail' && $sc_html_emails == false) {
        #error_reporting(E_ALL);
        $message = str_replace("\r", "", $message);
        #$message = str_replace("\n", "\r\n", $message);
	    $status = mail("$to_email", $subject, $message, $header_str);
        if ($status == true) {
            $sstatus = 'sent';
        } elseif ($status == false) {
            $sstatus = 'not sent';
        } else {
            $sstatus = 'unknown';
        }
        #print "Using mail.  Returned status $sstatus";
	} else {
		global $smtp_server, $smtp_server_port, $smtp_username, $smtp_password, $smtp_auth, $sc_mail_binary;
		
		include_once("include/class.phpmailer.php");
		$mail = new phpmailer();
		
        // Remove the "From" item from $headers as handled separately by phpmailer
        unset($headers['From']);
		switch($sc_mail){
			case 'mail': 
				$mail->IsMail();
				break;
			case 'smtp': 
				$mail->IsSMTP();
				$mail->PluginDir = 'include/';
				$mail->Port = $smtp_server_port;
				$mail->Host = $smtp_server;
				$mail->SMTPAuth = $smtp_auth;
				$mail->Username = $smtp_username;
				$mail->Password = $smtp_password;
				break;
			case 'qmail':
				$mail->isQmail();
				break;
			case 'sendmail':
				$mail->IsSendmail();
				$mail->Sendmail = $sc_mail_binary;
				break;
			default:
				die("Error: You do not have a value for \$sc_mail in sendcard_setup.php\n");
		} // switch

		$mail->AddAddress($to_email, $to);
		$mail->From = $from_email;
		$mail->FromName = $from;
		$mail->Subject = $subject;
		$mail->Body = $message; 
		// Commented out until HTML email support added $mail->AltBody = $message;
		$mail->WordWrap = 76;
	/*	foreach($headers as $k => $v) {
			$mail->AddCustomHeader($k . ':' . $v);
		} */
		if(!$mail->Send()) {
			echo "Message was not sent<br>";
			echo "Mailer Error: " . $mail->ErrorInfo;
		}
	}
}

/**
 * Write an array to a file.  Of course it could just be serialised, but this
 * way you can edit the array by hand if you want to.  Ideal for making 
 * configuration files!
 * 
 * @param array $array The array to be written to the file
 * @param string $array_name Name to be give to the array
 * @param string $file File to write to
 * @return mixed Imploded contents of $output if $file isn't set or true
 */
function array_to_file($array, $array_name, $file = '', $mode = 'w'){
    $output = array();
	foreach($array as $key => $val){
        if(is_array($val)){
        	$output[$key] = array_to_file($array[$key], $array_name . "['" . $key . "']");
        } else {
            $output[$key] = '$' . $array_name . "['$key'] = ";
            if (is_string($val)) {
                $output[$key] .= "\"" . str_replace("\n", '\n', (!get_magic_quotes_gpc()) ? addslashes($val) : $val) . "\";";
            } elseif(is_bool($val)) {
                switch($val){
                	case 1: 
                		$val = 'true';
                		break;
                	default:
                		$val = 'false';
                } // switch
                $output[$key] .= $val . ';';
            } elseif(is_object($val)) {
                trigger_error("We do not yet support writing objects to file in function array_to_file");
            } else {
                $output[$key] .= $val . ';';
            }
        }
	}
    if('' != $file){
        write_to_file("<?php \n" . implode("\n", $output) . "\n?>", $file, $mode);
        return true;
    }
    return implode("\n", $output);
}

/**
 * Generic function to write a string to a file
 * @since 4/29/02 7:15:12 PM
 * @param string $contents The string to be written to the file
 * @param string $file The file name/path to be written to
 * @param string $mode The mode to open the file
 * @return void
 */
function write_to_file($contents, $file, $mode = 'w'){
	if (!$fp = fopen($file, $mode)) {
    	trigger_error("Cannot Open File $file to write to in __FILE__ on line __LINE__");
    } elseif (!fwrite ($fp, $contents)) {
	    echo ("Cannot write to file $file in __FILE__ on line __LINE__");
    } else {
	    fclose ($fp);
    }
}


/**
 * Just like stripslashes, only works on an (multidimensional) array
 * 
 * @author alex@netflex.nl
 * @param array $array Array to be stripped
 * @return array $array The given array with all slashes stripped
 **/
function stripslashes_array(&$array)
{
    while (list($key) = each($array)) {
        if (is_array($array[$key])) {
            $array[$key] = stripslashes_array($array[$key]);
        } else {
            $array[$key] = stripslashes($array[$key]);
        }
    }
    return $array;
}

/**
 * Read the contents of a directory and return an array of the contents
 *  - ignoring those files listed in the second paramater.
 * @access public
 * @return void 
 * @since 2002/12/28
 * @author Peter Bowyer <peter@sendcard.org>
 */
function read_directory($dir, $ignore = array('.', '..', '.htaccess', '.htpasswd'))
{
    if ($handle = opendir($dir)) {
        while (false !== ($file = readdir($handle))) { 
            if (!in_array($file, $ignore) && !is_dir($file)) { 
                $output[] = $file;
            } 
        }
        closedir($handle); 
    }
    return $output;
}

?>
