<?php

/*********************/

/*                   */

/*  Version : 5.1.0  */

/*  Author  : RM     */

/*  Comment : 071223 */

/*                   */

/*********************/



function html2rgb( $color )

{

    if ( $color[0] == "#" )

    {

        $color = substr( $color, 1 );

    }

    if ( strlen( $color ) == 6 )

    {

        list( $r, $g, $b ) = array(

            $color[0].$color[1],

            $color[2].$color[3],

            $color[4].$color[5]

        );

    }

    else if ( strlen( $color ) == 3 )

    {

        list( $r, $g, $b ) = array(

            $color[0].$color[0],

            $color[1].$color[1],

            $color[2].$color[2]

        );

    }

    else

    {

        return false;

    }

    $r = hexdec( $r );

    $g = hexdec( $g );

    $b = hexdec( $b );

    return array(

        $r,

        $g,

        $b

    );

}



function rgb2html( $r, $g = -1, $b = -1 )

{

    if ( is_array( $r ) && sizeof( $r ) == 3 )

    {

        list( $r, $g, $b ) = $r;

    }

    $r = intval( $r );

    $g = intval( $g );

    $b = intval( $b );

    $r = dechex( $r < 0 ? 0 : 255 < $r ? 255 : $r );

    $g = dechex( $g < 0 ? 0 : 255 < $g ? 255 : $g );

    $b = dechex( $b < 0 ? 0 : 255 < $b ? 255 : $b );

    $color = ( strlen( $r ) < 2 ? "0" : "" ).$r;

    $color .= ( strlen( $g ) < 2 ? "0" : "" ).$g;

    $color .= ( strlen( $b ) < 2 ? "0" : "" ).$b;

    return "#".$color;

}



function gradint( $src_color, $dst_color, $topic, $is_bg )

{

    $src_color = html2rgb( "{$src_color}" );

    $dst_color = html2rgb( "{$dst_color}" );

    $is_bg = $is_bg == 0 ? "a" : "c";

    $chars = preg_split( "//", $topic );

    $chars = join( $chars, " " );

    $chars = preg_replace( "/\\[([#=0-9A-Za-z \\/]*)\\]/Ues", "'['.str_replace(' ','',\"\\1\").']'", $chars );

    $chars = preg_replace( "/\\[".$is_bg."=(.*?)\\](.*?)\\[\\/".$is_bg."\\]/esi", "'['.\$is_bg.'=\$1]'.str_replace(' ','',\"\\2\").'[/".$is_bg."]'", $chars );

    $chars = preg_replace( "/&(.*);/Ues", "'&'.str_replace(' ','',\"\\1\").';'", $chars );

    $arr = explode( " ", $chars );

    $i = 0;

    for ( ; $i < 3; ++$i )

    {



 $step_color[$i] = ( $dst_color[$i] - $src_color[$i] ) / ( count( $arr ) - substr_count( $topic, "[" ) - 1 );

    }

    $stopic = count( $arr );

    $line = "";

    $j = 0;

    for ( ; $j < $stopic; ++$j )

    {

        if ( eregi( "[[^]]*(.*)*\"?[^]]*]", $arr[$j] ) )

        {

            $line .= $arr[$j];

        }

        else

        {

            $line .= "[".$is_bg."=".rgb2html( $src_color )."]".$arr[$j]."[/".$is_bg."]";

        }

    }

    $i = 0;

    for ( ; $i < 3; ++$i )

    {

        $src_color[$i] += $step_color[$i];

    }

    return $line;

}



function format_text_mpp( $text )

{

    $mreplace_array = array( "'" => "[s]", "<" => "&lt;", ">" => "&gt;", "'" => "&#039;", "\"" => "&quot;", "#" => "[b]", "@" => "[u]", " " => "&nbsp;" );

    $text = str_replace( array_keys( $mreplace_array ), $mreplace_array, $text );

    $smiles_array = array( "/:-@|\\|:@/" => "[IMG=015]", "/:-@|:@/" => "[IMG=014]", "/\\|-\\)/" => "[IMG=007]", "/\\(B\\)|\\(b\\)/" => "[IMG=057]", "/\\(L\\)|\\(l\\)/" => "[IMG=050]", "/\\(U\\)|\\(u\\)/" => "[IMG=049]", "/\\(K\\)|\\(k\\)/" => "[IMG=048]", "/\\(F\\)|\\(f\\)/" => "[IMG=047]", "/\\(ST\\)|\\(st\\)/" => "[IMG=060]", "/\\(SO\\)|\\(so\\)/" => "[IMG=061]", "/\\(W\\)|\\(w\\)/" => "[IMG=046]", "/:-O|:o/" => "[IMG=055]", "/\\(Y\\)|\\(y\\)/" => "[IMG=054]", "/\\(N\\)|\\(n\\)/" => "[IMG=053]", "/\\(X\\)|\\(x\\)/" => "[IMG=052]", "/\\(Z\\)|\\(z\\)/" => "[IMG=051]", "/:-\\)|:\\)/" => "[IMG=016]", "/\\(O\\)|\\(o\\)/" => "[IMG=025]", "/\\(6\\)/" => "[IMG=024]", "/:-\\$|:\\$/" => "[IMG=023]", "/\\(~\\)/" => "[IMG=022]", "/\\(R\\)/" => "[IMG=021]", "/\\(C\\)|\\(c\\)/" => "[IMG=030]", "/\\(\\%\\)/" => "[IMG=028]", "/\\(A\\)|\\(a\\)/" => "[IMG=027]", "/\\(\\&\\)/" => "[IMG=026]", "/\\(H\\)|\\(h\\)/" => "[IMG=035]", "/\\(S\\)/" => "[IMG=034]", "/\\(8\\)/" => "[IMG=033]", "/\\(\\*\\)/" => "[IMG=032]", "/\\(\\@\\)/" => "[IMG=031]", "/\\(D\\)|\\(d\\)/" => "[IMG=040]", "/\\(M\\)|\\(m\\)/" => "[IMG=039]", "/\\(E\\)|\\(e\\)/" => "[IMG=038]", "/\\(T\\)|\\(t\\)/" => "[IMG=037]", "/\\(I\\)|\\(i\\)/" => "[IMG=036]", "/\\(\\}\\)/" => "[IMG=045]", "/\\(\\{\\)/" => "[IMG=044]", "/\\(P\\)|\\(p\\)/" => "[IMG=043]", "/\\(G\\)|\\(g\\)/" => "[IMG=042]", "/\\(\\^\\)/" => "[IMG=041]", "/:-D|:d|:D/" => "[IMG=013]", "/:-P|:p|:P/" => "[IMG=012]", "/:'\\(/" => "[IMG=008]", "/\\(#\\)/" => "[IMG=020]", "/\\(H\\)|\\(h\\)/" => "[IMG=019]", "/:-S|:s|:S/" => "[IMG=018]", "/:-\\||:\\|/" => "[IMG=017]", "/\\+o\\(/" => "[IMG=001]", "/:-\\[|:\\[/" => "[IMG=056]", "/8-\\)/" => "[IMG=006]", "/\\<:o\\)/" => "[IMG=005]", "/\\*-\\)/" => "[IMG=004]", "/\\(bah\\)/" => "[IMG=003]", "/\\(ip\\)/" => "[IMG=002]", "/:-\\(|:\\(/" => "[IMG=011]", "/:-\\$|:\\$/" => "[IMG=010]", "/:-#/" => "[IMG=009]", "/:-\\$|:\\$/" => "[IMG=010]", "/:-#/" => "[IMG=009]", "/\\(mp\\)/" => "[IMG=058]", "/\\(ci\\)/" => "[IMG=059]" );

    $text = preg_replace( array_keys( $smiles_array ), $smiles_array, $text );

    $color_array = array( "67" => "#544D05", "66" => "#1C5300", "65" => "#06502F", "64" => "#000047", "63" => "#5F0162", "62" => "#4D0000", "61" => "#473400", "51" => "#D4C804", "50" => "#59D80D", "49" => "#03CC88", "48" => "#0000D3", "47" => "#DE00DE", "46" => "#EB0505", "45" => "#D98812", "57" => "#01038C", "58" => "#01885F", "55" => "#9B0008", "33" => "#F9FF57", "32" => "#8EFF67", "31" => "#68FFC3", "30" => "#6C6CFF", "29" => "#FF62FF", "28" => "#FF6D66", "27" => "#F9C152", "36" => "#FFA01E", "40" => "#1EFFA5", "41" => "#60F913", "24" => "#FAFDA2", "23" => "#C1FFA3", "22" => "#BAFBE5", "21" => "#B4B4FC", "20" => "#FFA8FF", "19" => "#FFAEB9", "18" => "#FFDEA4", "38" => "#FF20FF", "37" => "#F92611", "39" => "#202BFF", "16" => "#E7E6E4", "15" => "#D2D2D2", "14" => "#7F7F7F", "13" => "#FF00FF", "12" => "#2020FC", "11" => "#00FFFF", "10" => "#009393", "9" => "#00FC00", "8" => "#FFFF00", "7" => "#FC7F00", "6" => "#9C009C", "5" => "#7F0000", "4" => "#FF0000", "3" => "#009300", "2" => "#00007F", "1" => "#000000", "0" => "#FFFFFF" );

    if ( strstr( $text, "[/a=" ) || strstr( $text, "[/c=" ) )

    {

        $text = preg_replace( "/\\[(.*)=([0-9]{1,2})\\]/Ues", "'[$1='.\$color_array[$2].']'", $text );

        $chars_2 = preg_replace( "/\\[([#=0-9A-Za-z \\/]*)\\]/", "{w}[$1]{w}", $text );

        $arr_2 = explode( "{w}", $chars_2 );

        $arr_2 = array_reverse( $arr_2, true );

        $arr_2 = join( "", $arr_2 );

        $text_2 = preg_replace( "/\\[\\/c\\](.*?)\\[c=(.*?)\\]/", "[/w]\\1[w=\\2]", $arr_2 );

        $text_2 = preg_replace( "/\\[\\/a\\](.*?)\\[a=(.*?)\\]/", "[/q]\\1[q=\\2]", $text_2 );

        $chars_2 = preg_replace( "/\\[([#=0-9A-Za-z \\/]*)\\]/", "{w}[$1]{w}", $text_2 );

        $arr_2 = explode( "{w}", $chars_2 );

        $arr_2 = array_reverse( $arr_2, true );

        $text = join( "", $arr_2 );

    }

    $search_array = array( "/[\\$]{2}+([0-9]{1,2})\\,([0-9]{1,2})/" => "[a=$2][c=$1]", "/[\\$]{2}+([0-9]{1,2})\\,(#[A-Za-z0-9]{6})/" => "[c=$1][a=$2]", "/[\\$]{2}+\\,(#[A-Za-z0-9]{6})/" => "[a=$1]", "/[\\$]{2}+\\,([0-9]{1,2})/" => "[a=$1]", "/[\\$]{2}+(#[A-Za-z0-9]{6})/" => "[c=$1]", "/[\\$]{2}+\\(([0-9]{3})\\,([0-9]{3})\\,([0-9]{3})\\)/Ues" => "'[c='.rgb2html($1,$2,$3).']'", "/[\\$]{2}+([0-9]{1,2})/" => "[c=$1]", "/\\[(.*)=([0-9]{1,2})\\]/Ues" => "'[$1='.\$color_array[$2].']'", "/\\[c=(.*?)\\](.*?)\\[\\/c=(.*?)\\]/esi" => "gradint('\\1','\\3','\\2',1)", "/\\[a=(.*?)\\](.*?)\\[\\/a=(.*?)\\]/esi" => "gradint('\\1','\\3','\\2',0)", "/\\[(c|C|w)=(.*?)\\]/" => "<span style=\"color:\\2\">", "/\\[\\/(c|C|w)\\]/" => "</span>", "/\\[(a|A|q)=(.*?)\\]/" => "<span style=\"background-color:\\2\">", "/\\[\\/(a|A|q)\\]/" => "</span>", "/\\[(b|B)\\]/" => "<b>", "/\\[\\/(b|B)\\]/" => "</b>", "/\\[(i|I)\\]/" => "<i>", "/\\[\\/(i|I)\\]/" => "</i>", "/\\[(u|U)\\]/" => "<u>", "/\\[\\/(u|U)\\]/" => "</u>", "/\\[(s|S)\\]/" => "<s>", "/\\[\\/(s|S)\\]/" => "</s>", "/\\[IMG=(.*?)\\]/" => "<img src=\"msnEM/\\1.gif\" border=\"0\" align=\"absmiddle\">" );

    $text = @preg_replace( @array_keys( $search_array ), $search_array, $text );

    $text2 = preg_replace( array_keys( $search_array ), $search_array, $text );

    $dol_opened = 0;

    if ( strstr( $text, "\$" ) )

    {

        $rs = strpos( $text, "\$" );

        $prn = substr( $text, 0, $rs );

        $dol_opened = substr_count( $prn, "<span" );

        $dol_repest = str_repeat( "</span>", $dol_opened );

        $text = str_replace( "\$", $dol_repest, $text );

    }

    preg_match_all( "#<([a-z]+)( .*)?(?!/)>#iU", $text2, $result );

    $openedtags = $result[1];

    preg_match_all( "#</([a-z]+)>#iU", $text2, $result );

    $closedtags = $result[1];

    $len_opened = count( $openedtags );

    if ( count( $closedtags ) == $len_opened )

    {

        return $text;

    }

    $openedtags = array_reverse( $openedtags );

    $len_opened -= $dol_opened;

    $i = 0;

    for ( ; $i < $len_opened; ++$i )

    {

        if ( in_array( $openedtags[$i], $closedtags ) )

        {

            $text .= "</".$openedtags[$i].">";

        }

        else

        {

            unset( $closedtags[array_search( $openedtags[$i], $closedtags )] );

        }

    }

    return $text;

}



$_SERVER['HTTP_HOST'] = $_SERVER['HTTP_HOST']."";





?>