<?php
/**************************************************************************
 *                                                                        *
 *    4images - A Web Based Image Gallery Management System               *
 *    ----------------------------------------------------------------    *
 *                                                                        *
 *             File: paging.php                                           *
 *     File Version: 2.2                                                  *
 *        Copyright: (C) 2002 Jan Sorgalla                                *
 *            Email: jan@4homepages.de                                    *
 *              Web: http://www.4homepages.de                             *
 *    Scriptversion: 1.7                                                  *
 *                                                                        *
 *    Never released without support from: Nicky (http://www.nicky.net)   *
 *                                                                        *
 **************************************************************************
 *                                                                        *
 *    Dieses Script ist KEINE Freeware. Bitte lesen Sie die Lizenz-       *
 *    bedingungen (Lizenz.txt) fr weitere Informationen.                 *
 *    ---------------------------------------------------------------     *
 *    This script is NOT freeware! Please read the Copyright Notice       *
 *    (Licence.txt) for further information.                              *
 *                                                                        *
 *************************************************************************/
if (!defined('ROOT_PATH'))
{
  die("Security violation");
}
if (!class_exists("Paging"))
{
  class Paging
  {
    var $page,$page1,$offset,$perpage,$num_rows_all,$link_args;
    var $first,$last,$total_pages,$config,$desc,$next,$back,$extra,$query,$form,$formjs;

//    function Paging($page = 1, $perpage = 0, $num_rows_all = 0, $link_args = "", $text = "", $extra = "", $page_text = "", $style = "", $page1 = 0, $form = false, $formjs = false)
    function Paging($page = 1, $perpage = 0, $num_rows_all = 0, $link_args = "", $text = "", $extra = "", $page_text = "", $style = "", $page1 = 0, $form = false, $formjs =  false)
    {
      global $lang, $config;

  //-------- Config ------------
  //Change $this->alt to 1 if u want display number of pages not more then u set in the settings, no metter on witch page u are.
  //by default if u have 20 pages, for example, and in the settings set to show only 10, it will actualy show u 20 pages when u go to 10th page.
      $this->alt = 1;
      $this->form = $form; //(true, false or $form) - show the form where visitor can manualy enter the page they want to enter.
      $this->formjs = $formjs; //(true, false or $formjs) - include JS input validation, to ensure that the entered page is valid.
  //------- End Config ---------

      if (!isset($lang['gotopage'])) $lang['gotopage'] = "Go to page:";
      if (!isset($lang['pagebutton'])) $lang['pagebutton'] = "Go";
  /*
      if (!isset($lang['gotopage'])) $lang['gotopage'] = "";
      if (!isset($lang['pagebutton'])) $lang['pagebutton'] = "Go to page";
  */
      $this->style = ($style) ? $style : "paging";
      $this->extra = ($extra) ? "#".$extra : "";
      $this->page_text = ($page_text) ? $page_text : "page";
      $this->desc = ($text) ? $text : $lang['paging_stats'];

      $this->page = $page;
      $this->perpage = $perpage;
      $this->num_rows_all = $num_rows_all;

      if (!isset($this->page) || !intval($this->page))
      {
        $this->page = 1;
      }

      if (!$this->num_rows_all)
      {
        $this->total_pages = 0;
      }
      elseif ($this->num_rows_all <= $this->perpage)
      {
        $this->total_pages = 1;
      }
      elseif ($this->num_rows_all % $this->perpage == 0)
      {
        $this->total_pages = $this->num_rows_all / $this->perpage;
      }
      else
      {
        $this->total_pages = ceil($this->num_rows_all / $this->perpage);
      }

      if ($this->page > $this->total_pages)
      {
        $this->page = 1;
      }

      if (!$this->num_rows_all)
      {
        $this->first = 0;
      }
      else
      {
        $this->first = $this->perpage * $this->page - $this->perpage + 1;
      }

      if (!$this->num_rows_all)
      {
        $this->last = 0;
      }
      elseif ($this->page == $this->total_pages)
      {
        $this->last = $this->num_rows_all;
      }
      else
      {
        $this->last = $this->perpage * $this->page;
      }

      $this->offset = $this->perpage * $this->page - $this->perpage;

      $link_args = ereg_replace("&".$this->page_text."=[0-9]*", "", $link_args);
      $link_args = ereg_replace($this->page_text."=[0-9]*&", "", $link_args);
      $this->link_args = basename($link_args);
      $query = "";
      if (strpos($this->link_args, '?') !== false)
      {
        if ($this->form)
        {
          $query = substr(strrchr($this->link_args,"?"), 1);
        }
        $this->link_args .= "&amp;";
      }
      else
      {
        $this->link_args .= "?";
      }
      if ($query)
      {
        $query = explode("&", str_replace("&amp;", "&", $query));
        foreach ($query as $key)
        {
          if ($val = substr(strrchr($key,"="), 1))
          {
            $name = substr($key,0,(strlen($key)-strlen(strrchr($key,"="))));
          }
          else
          {
            $name = $key;
          }
          $this->query .= "<input type=\"hidden\" name=\"".$name."\" value=\"".$val."\">\n";
        }
      }

      $this->paging_next = $lang['paging_next'];
      $this->paging_back = $lang['paging_previous'];
      $this->paging_lastpage = $lang['paging_lastpage'];
      $this->paging_firstpage = $lang['paging_firstpage'];
      $this->range = $config['paging_range'];
    }

    function get_paging()
    {
      $html = "";
      if ($this->total_pages > 1)
      {
        $page_back = $this->page - 1;
        $page_next = $this->page + 1;
        if ($this->form)
        {
          $js = ($this->formjs) ? " onSubmit=\"if (!page.value || page.value < 1 || page.value > ".$this->total_pages.") return false;\"" : "";
          $html .= "<form action=\"".substr($this->link_args,0,(strlen($this->link_args)-strlen(strrchr($this->link_args,"?"))))."\" method=\"GET\"$js style=\"margin:0px;\"/>\n".$this->query;
        }
        if ($this->alt)
        {
          if ($page_back > 0)
          {
            $html .= "<a href=\"".$this->link_args.$this->page_text."=1".$this->extra."\" class=\"".$this->style."\"> ".$this->paging_firstpage." </a>&nbsp;&nbsp;";
            $html .= "<a href=\"".$this->link_args.$this->page_text."=".$page_back.$this->extra."\" class=\"".$this->style."\"> ".$this->paging_back." </a>&nbsp;&nbsp;";
          }
          $page_num2 = ceil($this->range / 2);
          $page_num3 = $this->range;
          $page_left = 1;
          if (($this->page - $page_num2) > 0)
          {
            $html .= "<a href=\"".$this->link_args.$this->page_text."=".(($this->page - $this->range < $page_num2) ? $page_num2 : (($this->page <= ($this->total_pages - $page_num2)) ? $this->page - $this->range : $this->total_pages - $this->range - $page_num2 + 1)).$this->extra."\" class=\"".$this->style."\"> ... </a>&nbsp;&nbsp;";
          }
          for ($page_num = 1; $page_num <= $this->total_pages; $page_num++){
            if ($page_num3)
            {
              if ($page_left)
              {
                if (($page_num >= $this->page - ($this->range - $page_num2)) || ($page_num > $this->total_pages - $this->range && $this->page > $this->total_pages - $this->range ))
                {
                  if ($this->page == $page_num)
                  {
                    $page_left--;
                    $page_num2--;
                    $page_num3--;
                    $html .= "<b class=\"".$this->style."on\">&nbsp;".$page_num."&nbsp;</b>&nbsp;&nbsp;";
                  }
                  else
                  {
                    $page_num2--;
                    $page_num3--;
                    $html .= "<a href=\"".$this->link_args.$this->page_text."=".$page_num.$this->extra."\" class=\"".$this->style."\"> ".$page_num." </a>&nbsp;&nbsp;";
                  }
                }
              }
              else
              {
              if ($page_num <= $this->page + ($this->range - $page_num2))
              {

                  if ($this->page == $page_num)
                  {
                    $html .= "<b class=\"".$this->style."on\">&nbsp;".$page_num."&nbsp;</b>&nbsp;&nbsp;";
                  }
                  else
                  {
                    $page_num2--;
                    $page_num3--;
                    $html .= "<a href=\"".$this->link_args.$this->page_text."=".$page_num.$this->extra."\" class=\"".$this->style."\"> ".$page_num." </a>&nbsp;&nbsp;";
                  }
                }
              }
            }
          }
          $page_num2 = ceil($this->range / 2);
          if (($this->page + $page_num2) <= $this->total_pages)
{
            $html .= "<a href=\"".$this->link_args.$this->page_text."=".(($this->page + $page_num2 <= $this->total_pages - $this->range) ? (($this->page < $page_num2) ? $this->range + $page_num2 : $this->page + $this->range) : $this->total_pages - $page_num2 + 1).$this->extra."\" class=\"".$this->style."\"> ... </a>&nbsp;&nbsp;";
          }
          if ($page_next <= $this->total_pages)
{
            $html .= "<a href=\"".$this->link_args.$this->page_text."=".$page_next.$this->extra."\" class=\"".$this->style."\"> ".$this->paging_next." </a>&nbsp;&nbsp;";
            $html .= "<a href=\"".$this->link_args.$this->page_text."=".$this->total_pages.$this->extra."\" class=\"".$this->style."\"> ".$this->paging_lastpage."&nbsp;</a>";
          }
        }
        else
        {
          if ($page_back > 0)
          {
            $html .= "<a href=\"".$this->link_args.$this->page_text."=1".$this->extra."\" class=\"".$this->style."\"> ".$this->paging_firstpage." </a>&nbsp;&nbsp;";
            $html .= "<a href=\"".$this->link_args.$this->page_text."=".$page_back.$this->extra."\" class=\"".$this->style."\"> ".$this->paging_back." </a>&nbsp;&nbsp;";
          }
          for ($page_num = 1; $page_num <= $this->total_pages; $page_num++)
          {
            if ($page_num >= ($this->page - $this->range) && $page_num <= ($this->page + $this->range))
            {
              if ($this->page == $page_num)
              {
                $html .= "<b class=\"".$this->style."on\">&nbsp;".$page_num."&nbsp;</b>&nbsp;&nbsp;";
              }
              else
              {
                $html .= "<a href=\"".$this->link_args.$this->page_text."=".$page_num.$this->extra."\" class=\"".$this->style."\"> ".$page_num." </a>&nbsp;&nbsp;";
              }
            }
          }
          if ($page_next <= $this->total_pages)
          {
            $html .= "<a href=\"".$this->link_args.$this->page_text."=".$page_next.$this->extra."\" class=\"".$this->style."\"> ".$this->paging_next." </a>&nbsp;&nbsp;";
            $html .= "<a href=\"".$this->link_args.$this->page_text."=".$this->total_pages.$this->extra."\" class=\"".$this->style."\"> ".$this->paging_lastpage." </a>";
          }
        }
        if ($this->form)
        {
          global $lang;
          $html .= "&nbsp;".$lang['gotopage']."&nbsp;<input type=\"text\" size=\"2\" name=\"page\" value=\"\" class=\"paginginput\" />\n<input type=\"submit\" value=\"".$lang['pagebutton']."\" class=\"pagingbutton\" />\n</form>";
        }
      }
      return $html;
    }

    function get_offset()
    {
      return $this->offset;
    }

    function get_paging_stats()
    {
      global $site_template;
      $search_array = array(
        "/".$site_template->start."total_cat_images".$site_template->end."/iU",
        "/".$site_template->start."total_pages".$site_template->end."/iU",
        "/".$site_template->start."first_page".$site_template->end."/iU",
        "/".$site_template->start."last_page".$site_template->end."/iU"
      );
      $replace_array = array(
        $this->num_rows_all,
        $this->total_pages,
        $this->first,
        $this->last
      );
      $this->desc = preg_replace($search_array, $replace_array, $this->desc);
      return $this->desc;
    }
  } //end of class
}
?>
