<?php
require_once('includes/config.php');
require_once('includes/functions/func.global.php');
if($config['usedigg'])
{
	require_once('includes/functions/func.digg.php');
}
require_once('includes/classes/class.template_engine.php');
require_once('includes/lang/lang_'.$config['lang'].'.php');

// Check if the script is installed
checkinstall($config);

// Connect to database
db_connect($config);

// Start session
session_start();

// Check if the user has a remember cookie set
checkremember($config);

// Get site categories
$cats = get_cats($config);

// Initiate story array
$stories = array();
$avatars = array();

// If no page is specified set to first page
if(!isset($_GET['page']))
{
	$_GET['page'] = 1;
}
else
{
	$_GET['page'] = makeInt($_GET['page']);
}

// Check if they are using digg.com mode
if($config['usedigg'])
{
	// Retreive digs from digg.com api
	$content = getdiggstories(0,$_GET['page']);
	// Set stories into stories array
	$stories = $content['stories'];
	
	// Set total stories
	$total[0] = $content['total'];
}
else
{
	// Retreive stories from database
	if($config['rating_mode'] == 0)
	{
		$query = "SELECT story_id,story_title,story_desc,story_cat,story_digs,story_url,story_comments,user_name,user_id,story_thumb,story_time FROM ".$config['db']['pre']."stories ORDER BY story_rating ASC LIMIT ".addslashes(($_GET['page']-1)*10).",10";
	}
	else
	{
		$query = "SELECT story_id,story_title,story_desc,story_cat,story_digs,story_url,story_comments,user_name,user_id,story_thumb,story_time FROM ".$config['db']['pre']."stories WHERE story_prom='1' ORDER BY story_rating ASC LIMIT ".addslashes(($_GET['page']-1)*10).",10";
	}
	$query_result = @mysql_query ($query) OR error(mysql_error(), __LINE__, __FILE__, 0, '', '');
	while ($info = @mysql_fetch_array($query_result))
	{
		$info['story_title'] = stripslashes($info['story_title']);
		$info['story_desc'] = stripslashes($info['story_desc']);
	
		$stories[$info['story_id']] = $info;
		$stories[$info['story_id']]['dugg'] = 0;
		$stories[$info['story_id']]['buried'] = 0;
		$stories[$info['story_id']]['cat_title'] = $cats[$info['story_cat']]['cat_title'];
		$stories[$info['story_id']]['cat_id'] = $info['story_cat'];
		$stories[$info['story_id']]['ago'] = time_taken((time()-$info['story_time']));
		$stories[$info['story_id']]['domain'] = getDomain($info['story_url']);
		
		$avatars[$info['user_id']] = $info['user_id'];
		
		if($config['mod_rewrite'] == 1)
		{
			$stories[$info['story_id']]['story_link'] = $config['site_url'].'stories/'.$info['story_id'].'/'.modrewriteurl($info['story_title']).'.html';
			$stories[$info['story_id']]['cat_link'] = $config['site_url'].'view/'.$info['story_cat'].'/'.modrewriteurl($cats[$info['story_cat']]['cat_title']).'/1.html';
			$stories[$info['story_id']]['user_link'] = $config['site_url'].'users/'.$info['user_id'].'/'.$info['user_name'].'/1.html';
		}
		else
		{
			$stories[$info['story_id']]['story_link'] = $config['site_url'].'story.php?id='.$info['story_id'];
			$stories[$info['story_id']]['cat_link'] = $config['site_url'].'cat.php?i='.$info['story_cat'];
			$stories[$info['story_id']]['user_link'] = $config['site_url'].'profile.php?id='.$info['user_id'];
		}
		
		if(!isset($_SESSION['dugg'][$info['story_id']]))
		{
			if(isset($story_where))
			{
				$story_where.= " OR story_id='".$info['story_id']."'";
			}
			else
			{
				$story_where = "story_id='".$info['story_id']."'";
			}
		}
		
		if(!isset($_SESSION['bury'][$info['story_id']]))
		{
			if(isset($story_where2))
			{
				$story_where2.= " OR story_id='".$info['story_id']."'";
			}
			else
			{
				$story_where2 = "story_id='".$info['story_id']."'";
			}
		}
	}
	
	$av_count = count($avatars);
	
	if($av_count > 0)
	{
		foreach ($avatars as $key => $info) 
		{
			if(isset($avatar_where))
			{
				$avatar_where.= " OR user_id='".$key."'";
			}
			else
			{
				$avatar_where = "user_id='".$key."'";
			}
		}
		$avatar_where.= "LIMIT ".$av_count;
		
		$query = "SELECT user_id,avatar FROM ".$config['db']['pre']."users WHERE ".$avatar_where;
		$query_result = @mysql_query ($query) OR error(mysql_error(), __LINE__, __FILE__, 0, '', '');
		while ($info = @mysql_fetch_array($query_result))
		{
			$avatars[$info['user_id']] = getUserAvatar($info['user_id'],$config,false,$info['avatar']);
		}
	}
	
	if($config['rating_mode'] == 0)
	{
		$total[0] = mysql_num_rows(mysql_query("SELECT 1 FROM ".$config['db']['pre']."stories"));
	}
	else
	{
		$total[0] = mysql_num_rows(mysql_query("SELECT 1 FROM ".$config['db']['pre']."stories WHERE story_prom='1'"));
	}

	if(isset($story_where))
	{
		if(isset($_SESSION['duser']['id']))
		{
			$query = "SELECT story_id FROM ".$config['db']['pre']."digs WHERE (user_id='".$_SESSION['duser']['id']."' AND (".$story_where."))";
			$query_result = @mysql_query ($query) OR error(mysql_error(), __LINE__, __FILE__, 0, '', '');
			while ($info = @mysql_fetch_array($query_result))
			{
				$stories[$info['story_id']]['dugg'] = 1;
			}
		}
	}
	
	if(isset($story_where2))
	{
		if(isset($_SESSION['duser']['id']))
		{
			$query = "SELECT story_id FROM ".$config['db']['pre']."buries WHERE (user_id='".$_SESSION['duser']['id']."' AND (".$story_where2."))";
			$query_result = @mysql_query ($query) OR error(mysql_error(), __LINE__, __FILE__, 0, '', '');
			while ($info = @mysql_fetch_array($query_result))
			{
				$stories[$info['story_id']]['buried'] = 1;
			}
		}
	}
	
	foreach ($stories as $key => $info) 
	{
		if(!$stories[$info['story_id']]['dugg'])
		{
			if(isset($_SESSION['dugg'][$info['story_id']]))
			{
				$stories[$info['story_id']]['dugg'] = 1;
			}
		}
		
		if(!$stories[$info['story_id']]['buried'])
		{
			if(isset($_SESSION['bury'][$info['story_id']]))
			{
				$stories[$info['story_id']]['buried'] = 1;
			}
		}
		
		$stories[$info['story_id']]['avatar'] = $avatars[$info['user_id']];
	}
}

// Output data to the index.html template
if($total[0])
{
	$page = new HtmlTemplate ("templates/" . $config['tpl_name'] . "/index.html");
}
else
{
	$page = new HtmlTemplate ("templates/" . $config['tpl_name'] . "/index_noresults.html");
}
$page->SetParameter ('MODE','popular');
$page->SetLoop ('CATS', $cats);
$page->SetLoop ('STORIES', $stories);
if($config['mod_rewrite'])
{
	$page->SetParameter ('UPCOMING_LINK',$config['site_url'].'upcoming/0/viewall/1.html');
	$page->SetParameter ('POPULAR_LINK',$config['site_url'].'viewall/1.html');
}
else
{
	$page->SetParameter ('UPCOMING_LINK',$config['site_url'].'upcoming.php?id=0');
	$page->SetParameter ('POPULAR_LINK',$config['site_url'].'index.php');
}
$page->SetParameter ('XML_URL', $config['site_url'].'xmlfeeds.php?cmd=popular');
$page->SetParameter ('OVERALL_HEADER', create_header($config,$lang,$cats,'View All'));
$page->SetParameter ('OVERALL_FOOTER', create_footer($config,$lang));
if(isset($_SESSION['duser']['id']))
{
	$page->SetParameter ('LOGGEDIN', 1);
}
else
{
	$page->SetParameter ('LOGGEDIN', 0);
}
if($config['cron_type'])
{
	if((time()-300) > $config['cron_time'])
	{
		$page->SetParameter ('CRON', 1);
		// Output unix timestamp to stop image caching
		$page->SetParameter ('TIMESTAMP',time());
	}
	else
	{
		$page->SetParameter ('CRON', 0);
	}
}
else
{
	$page->SetParameter ('CRON', 0);
}
if($config['mod_rewrite'])
{
	$page->SetLoop ('PAGES', pagenav2($total[0],$_GET['page'],10,'index.php',0,0,$config));
}
else
{
	$page->SetLoop ('PAGES', pagenav($total[0],$_GET['page'],10,$config['site_url'].'index.php',0));
}
$page->CreatePageEcho($lang,$config);
?>