<?php
function create_header($config,$lang,$cats=array(),$page_title='')
{
	$page = new HtmlTemplate ("templates/" . $config['tpl_name'] . "/overall_header.html");
	$page->SetLoop('CATS',$cats);
	$page->SetParameter('SITE_TITLE', $config['site_title']);
	$page->SetParameter('PAGE_TITLE', $page_title);
	$page->SetParameter('TPL_NAME', $config['tpl_name']);
	$page->SetParameter('SITE_URL', $config['site_url']);
	$page->SetParameter('ANOUNCE',$config['anounce_en']);
	$page->SetParameter('ANOUNCE_TEXT',$config['anounce_txt']);
	
	IF(isset($_SESSION['duser']['id']))
	{
		$page->SetParameter('LOGGED_IN', 1);
	}
	ELSE
	{
		$page->SetParameter('LOGGED_IN', 0);
	}
	
	return $page->CreatePageReturn($lang,$config);
}

function create_footer($config,$lang)
{
	$page = new HtmlTemplate ("templates/" . $config['tpl_name'] . "/overall_footer.html");
	$page->SetParameter('VERSION',$config['version']);
	return $page->CreatePageReturn($lang,$config);
}

function db_connect($config)
{
    $db_connection = @mysql_connect ($config['db']['host'], $config['db']['user'], $config['db']['pass']) OR error (mysql_error(),$config, __LINE__, __FILE__, 0, '');
    $db_select = @mysql_select_db ($config['db']['name']) or error (mysql_error(),$config, __LINE__, __FILE__, 0, '');
	
	return $db_connection;
}

function error($msg,$config, $line='', $file='', $formatted=0,$lang=array())
{
	IF($formatted == 0)
	{
		echo "Low Level Error: " . $msg;
	}
	ELSE
	{
		$page = new HtmlTemplate ("templates/" . $config['tpl_name'] . "/error.html");
		$page->SetParameter ('MESSAGE', $msg);
		$page->CreatePageEcho($lang);
	}
	exit;
}

function logincheck($redirect='')
{
	if(!isset($_SESSION['duser']['id']))
	{
		if($redirect)
		{
			header("Location: ".$config['site_url']."login.php?redirect=".urlencode($redirect));
		}
		else
		{
			header("Location: ".$config['site_url']."login.php");
		}
		exit;
	}
}

function checkinstall($config)
{
	if(!isset($config['installed']))
	{
		header("Location: install/");
		exit;
	}
}

function checkremember($config)
{
	if(!isset($_SESSION['duser']['id']))
	{
		if(isset($_COOKIE[$config['cookie_name']]))
		{
			$remarray = unserialize(str_replace('\\','',$_COOKIE[$config['cookie_name']]));
			
			// Lookup the users table for that user
			$user_info = mysql_fetch_row(mysql_query("SELECT user_id,remember,commentst FROM ".$config['db']['pre']."users WHERE username='".addslashes($remarray['username'])."' AND user_id='".addslashes($remarray['uid'])."' AND remember='".addslashes($remarray['rem'])."' LIMIT 1"));

			// The submitted details are valid
			if(isset($user_info[0]))
			{		
				$_SESSION['duser']['id'] = $user_info[0];
				$_SESSION['duser']['name'] = $remarray['username'];
				$_SESSION['duser']['comm'] = $user_info[2];
		
				header("Location: index.php");
				exit;
			}
		}
	}
}

function get_cats($config)
{
	if($config['usedigg'])
	{
		$cats = array();
		
		$cats['viewall']['cat_title'] = 'View All';
		$cats['viewall']['cat_url'] = 'index.php';
		$cats['technology']['cat_title'] = 'Technology';
		$cats['technology']['cat_url'] = $config['site_url'].'cat.php?i=technology';
		$cats['science']['cat_title'] = 'Science';
		$cats['science']['cat_url'] = $config['site_url'].'cat.php?i=science';
		$cats['world_business']['cat_title'] = 'World & Business';
		$cats['world_business']['cat_url'] = $config['site_url'].'cat.php?i=world_business';
		$cats['sports']['cat_title'] = 'Sports';
		$cats['sports']['cat_url'] = $config['site_url'].'cat.php?i=sports';
		$cats['videos']['cat_title'] = 'Videos';
		$cats['videos']['cat_url'] = $config['site_url'].'cat.php?i=videos';
		$cats['entertainment']['cat_title'] = 'Entertainment';
		$cats['entertainment']['cat_url'] = $config['site_url'].'cat.php?i=entertainment';
		$cats['gaming']['cat_title'] = 'Gaming';
		$cats['gaming']['cat_url'] = $config['site_url'].'cat.php?i=gaming';
	}
	else
	{
		// Initiate the Category array
		$cats = array();
		$cats2 = array();
		$parents = array();
		$sort = array();
		$count = 0;
		
		$cats[0]['cat_title'] = 'View All';
		$cats[0]['cat_id'] = 0;
		$cats[0]['parent_id'] = 0;
		if($config['mod_rewrite'] == 1)
		{
			$cats[0]['cat_url'] = $config['site_url'].'viewall/1.html';
		}
		else
		{
			$cats[0]['cat_url'] = $config['site_url'].'index.php';
		}
		
		$query = "SELECT cat_id,cat_title,parent_id,cat_subs FROM ".$config['db']['pre']."cats ORDER BY cat_title";
		$query_result = @mysql_query ($query) OR error(mysql_error(), __LINE__, __FILE__, 0, '', '');
		while ($info = @mysql_fetch_array($query_result))
		{
			$cats2[$info['parent_id']][$info['cat_id']] = $info;
			$cats2[$info['parent_id']][$info['cat_id']]['cat_title'] = stripslashes($info['cat_title']);
			if($config['mod_rewrite'] == 1)
			{
				$cats2[$info['parent_id']][$info['cat_id']]['cat_url'] = $config['site_url'].'view/'.$info['cat_id'].'/'.modrewriteurl($info['cat_title']).'/1.html';
			}
			else
			{
				$cats2[$info['parent_id']][$info['cat_id']]['cat_url'] = $config['site_url'].'cat.php?id='.$info['cat_id'];
			}
			
			if(isset($parents[$info['parent_id']]))
			{
				$parents[$info['parent_id']]++;
			}
			else
			{
				$parents[$info['parent_id']] = 0;
			}
			
			if($info['parent_id'] == 0)
			{
				$sort[$count] = $info['cat_id'];
				$count++;
			}
		}
		
		$count = 1;
		foreach ($sort as $key => $value)
		{
			$cats[$value] = $cats2[0][$value];
			unset($cats2[0][$value]);
			$count++;
			
			if(isset($cats2[$value]))
			{
				$cats[$value]['cats'] = count($cats2[$value]);
				foreach ($cats2[$value] as $key2 => $value2)
				{
					$cats[$key2] = $value2;
					unset($cats2[$value][$key2]);
					$count++;
				}
			}
		}
	}
	
	return $cats;
}

function pagenav($total,$page,$perpage,$url,$posts=0) 
{
	$page_arr = array();
	$arr_count = 0;

	if($posts) 
	{
		$symb='&';
	}
	else
	{
		$symb='?';
	}
	$total_pages = ceil($total/$perpage);
	$llimit = 1;
	$rlimit = $total_pages;
	$window = 5;
	$html = '';
	if ($page<1 || !$page) 
	{
		$page=1;
	}
	
	if(($page - floor($window/2)) <= 0)
	{
		$llimit = 1;
		if($window > $total_pages)
		{
			$rlimit = $total_pages;
		}
		else
		{
			$rlimit = $window;
		}
	}
	else
	{
		if(($page + floor($window/2)) > $total_pages) 
		{
			if ($total_pages - $window < 0)
			{
				$llimit = 1;
			}
			else
			{
				$llimit = $total_pages - $window + 1;
			}
			$rlimit = $total_pages;
		}
		else
		{
			$llimit = $page - floor($window/2);
			$rlimit = $page + floor($window/2);
		}
	}
	if ($page>1)
	{
		$page_arr[$arr_count]['title'] = 'Prev';
		$page_arr[$arr_count]['link'] = $url.$symb.'page='.($page-1);
		$page_arr[$arr_count]['current'] = 0;
		
		$arr_count++;
	}

	for ($x=$llimit;$x <= $rlimit;$x++) 
	{
		if ($x <> $page) 
		{
			$page_arr[$arr_count]['title'] = $x;
			$page_arr[$arr_count]['link'] = $url.$symb.'page='.($x);
			$page_arr[$arr_count]['current'] = 0;
		} 
		else 
		{
			$page_arr[$arr_count]['title'] = $x;
			$page_arr[$arr_count]['link'] = $url.$symb.'page='.($x);
			$page_arr[$arr_count]['current'] = 1;
		}
		
		$arr_count++;
	}
	
	if($page < $total_pages)
	{
		$page_arr[$arr_count]['title'] = 'Next';
		$page_arr[$arr_count]['link'] = $url.$symb.'page='.($page+1);
		$page_arr[$arr_count]['current'] = 0;
		
		$arr_count++;
	}
	
	return $page_arr;
}

function pagenav2($total,$page,$perpage,$url,$posts=0,$id,$config=array(),$name='') 
{
	$page_arr = array();
	$arr_count = 0;

	if($posts) 
	{
		$symb='&';
	}
	else
	{
		$symb='?';
	}
	$total_pages = ceil($total/$perpage);
	$llimit = 1;
	$rlimit = $total_pages;
	$window = 5;
	$html = '';
	if ($page<1 || !$page) 
	{
		$page=1;
	}
	
	if(($page - floor($window/2)) <= 0)
	{
		$llimit = 1;
		if($window > $total_pages)
		{
			$rlimit = $total_pages;
		}
		else
		{
			$rlimit = $window;
		}
	}
	else
	{
		if(($page + floor($window/2)) > $total_pages) 
		{
			if ($total_pages - $window < 0)
			{
				$llimit = 1;
			}
			else
			{
				$llimit = $total_pages - $window + 1;
			}
			$rlimit = $total_pages;
		}
		else
		{
			$llimit = $page - floor($window/2);
			$rlimit = $page + floor($window/2);
		}
	}
	if ($page>1)
	{	
		if($url == 'cat.php')
		{
			$page_arr[$arr_count]['title'] = 'Prev';
			$page_arr[$arr_count]['link'] = $config['site_url'].'view/'.$id.'/'.$name.'/'.($page-1).'.html';
			$page_arr[$arr_count]['current'] = 0;
		}
		elseif($url == 'profile.php')
		{
			$page_arr[$arr_count]['title'] = 'Prev';
			$page_arr[$arr_count]['link'] = $config['site_url'].'users/'.$id.'/'.$name.'/'.($page-1).'.html';
			$page_arr[$arr_count]['current'] = 0;
		}
		elseif($url == 'index.php')
		{
			$page_arr[$arr_count]['title'] = 'Prev';
			$page_arr[$arr_count]['link'] = $config['site_url'].'viewall/'.($page-1).'.html';
			$page_arr[$arr_count]['current'] = 0;
		}
		elseif($url == 'search.php')
		{
			$page_arr[$arr_count]['title'] = 'Prev';
			$page_arr[$arr_count]['link'] = $config['site_url'].$url.'?q='.$id.'&amp;page='.($page-1);
			$page_arr[$arr_count]['current'] = 0;
		}
		else
		{
			$page_arr[$arr_count]['title'] = 'Prev';
			$page_arr[$arr_count]['link'] = $config['site_url'].$url.'?id='.$id.'&amp;page='.($page-1);
			$page_arr[$arr_count]['current'] = 0;
		}
				
		$arr_count++;
	}

	for ($x=$llimit;$x <= $rlimit;$x++) 
	{
		if ($x <> $page) 
		{
			if($url == 'cat.php')
			{
				$page_arr[$arr_count]['title'] = $x;
				$page_arr[$arr_count]['link'] = $config['site_url'].'view/'.$id.'/'.$name.'/'.($x).'.html';
				$page_arr[$arr_count]['current'] = 0;
			}
			elseif($url == 'profile.php')
			{
				$page_arr[$arr_count]['title'] = $x;
				$page_arr[$arr_count]['link'] = $config['site_url'].'users/'.$id.'/'.$name.'/'.($x).'.html';
				$page_arr[$arr_count]['current'] = 0;
			}
			elseif($url == 'index.php')
			{
				$page_arr[$arr_count]['title'] = $x;
				$page_arr[$arr_count]['link'] = $config['site_url'].'viewall/'.($x).'.html';
				$page_arr[$arr_count]['current'] = 0;
			}
			elseif($url == 'upcoming.php')
			{
				$page_arr[$arr_count]['title'] = $x;
				$page_arr[$arr_count]['link'] = $config['site_url'].'upcoming/'.$id.'/'.$name.'/'.($x).'.html';
				$page_arr[$arr_count]['current'] = 0;
			}
			elseif($url == 'search.php')
			{
				$page_arr[$arr_count]['title'] = $x;
				$page_arr[$arr_count]['link'] = $config['site_url'].$url.'?q='.$id.'&amp;page='.($x);
				$page_arr[$arr_count]['current'] = 0;
			}
			else
			{
				$page_arr[$arr_count]['title'] = $x;
				$page_arr[$arr_count]['link'] = $config['site_url'].$url.'?id='.$id.'&amp;page='.($x);
				$page_arr[$arr_count]['current'] = 0;
			}
		} 
		else 
		{
			if($url == 'cat.php')
			{
				$page_arr[$arr_count]['title'] = $x;
				$page_arr[$arr_count]['link'] = $config['site_url'].'view/'.$id.'/'.$name.'/'.($x).'.html';
				$page_arr[$arr_count]['current'] = 1;
			}
			elseif($url == 'profile.php')
			{
				$page_arr[$arr_count]['title'] = $x;
				$page_arr[$arr_count]['link'] = $config['site_url'].'users/'.$id.'/'.$name.'/'.($x).'.html';
				$page_arr[$arr_count]['current'] = 1;
			}
			elseif($url == 'index.php')
			{
				$page_arr[$arr_count]['title'] = $x;
				$page_arr[$arr_count]['link'] = $config['site_url'].'viewall/'.($x).'.html';
				$page_arr[$arr_count]['current'] = 1;
			}
			elseif($url == 'upcoming.php')
			{
				$page_arr[$arr_count]['title'] = $x;
				$page_arr[$arr_count]['link'] = $config['site_url'].'upcoming/'.$id.'/'.$name.'/'.($x).'.html';
				$page_arr[$arr_count]['current'] = 1;
			}
			elseif($url == 'search.php')
			{
				$page_arr[$arr_count]['title'] = $x;
				$page_arr[$arr_count]['link'] = $config['site_url'].$url.'?q='.$id.'&amp;page='.($x);
				$page_arr[$arr_count]['current'] = 1;
			}
			else
			{
				$page_arr[$arr_count]['title'] = $x;
				$page_arr[$arr_count]['link'] = $config['site_url'].$url.'?id='.$id.'&amp;page='.($x);
				$page_arr[$arr_count]['current'] = 1;
			}
		}
		
		$arr_count++;
	}
	
	if($page < $total_pages)
	{
		if($url == 'cat.php')
		{
			$page_arr[$arr_count]['title'] = 'Next';
			$page_arr[$arr_count]['link'] = $config['site_url'].'view/'.$id.'/'.$name.'/'.($page+1).'.html';
			$page_arr[$arr_count]['current'] = 0;
		}
		elseif($url == 'profile.php')
		{
			$page_arr[$arr_count]['title'] = 'Next';
			$page_arr[$arr_count]['link'] = $config['site_url'].'users/'.$id.'/'.$name.'/'.($page+1).'.html';
			$page_arr[$arr_count]['current'] = 0;
		}
		elseif($url == 'index.php')
		{
			$page_arr[$arr_count]['title'] = 'Next';
			$page_arr[$arr_count]['link'] = $config['site_url'].'viewall/'.($page+1).'.html';
			$page_arr[$arr_count]['current'] = 0;
		}
		elseif($url == 'search.php')
		{
			$page_arr[$arr_count]['title'] = 'Next';
			$page_arr[$arr_count]['link'] = $config['site_url'].$url.'?q='.$id.'&amp;page='.($page+1);
			$page_arr[$arr_count]['current'] = 0;
		}
		else
		{
			$page_arr[$arr_count]['title'] = 'Next';
			$page_arr[$arr_count]['link'] = $config['site_url'].$url.'?id='.$id.'&amp;page='.($page+1);
			$page_arr[$arr_count]['current'] = 0;
		}
		
		$arr_count++;
	}
	
	return $page_arr;
}

function modrewriteurl($url)
{
	$url = str_replace(' ','_',$url);
	$url = ereg_replace("[^[:alnum:]_]", "", $url);

	return $url;
}

function getrandnum($length)
{
	$randstr=''; 
	srand((double)microtime()*1000000); 
	$chars = array ( 'a','b','C','D','e','f','G','h','i','J','k','L','m','N','P','Q','r','s','t','U','V','W','X','y','z','1','2','3','4','5','6','7','8','9'); 
	for ($rand = 0; $rand <= $length; $rand++) 
	{ 
		$random = rand(0, count($chars) -1); 
		$randstr .= $chars[$random]; 
	}
	
	return $randstr;
}

function time_taken($time)
{
	if($time > 86400)
	{
		$days = floor($time/86400);
		$hours = floor(($time-($days*86400))/3600);
		
		if($days > 1)
		{
			$took = $days . ' days';
		}
		else
		{
			$took = $days . ' day';
		}
	}
	elseif($time > 3600)
	{
		$hours = floor(($time/60)/60);
		$mins = floor(($time-($hours*3600))/60);
		
		if($hours > 1)
		{
			$took = $hours.' hours';
		}
		else
		{
			$took = $hours.' hour';
		}
	}
	elseif($time > 60)
	{
		$mins = floor($time/60);
	
		$took = $mins . ' minutes';
	}
	else
	{
		$took = $time . ' seconds';
	}
	
	return $took;
}

function makeInt ($x,$signed=false) 
{
	if(!is_numeric($x))
	{
   		$x = intval($x);
	}
	
	if(!$x)
	{
		$x=1;
	}
	
	if(!$signed)
	{
		if($x<1)
		{
			$x=1;
		}
	}
	
	return $x;
}

function getDomain($url)
{
	$parts = parse_url($url);
	
	if(isset($parts['host']))
	{
		$parts['host'] = str_replace('www.','',$parts['host']);
	
		return $parts['host'];
	}
	else
	{
		$url = str_replace('www.','',$url);
	
		return $url;
	}
}

function getuimgpath($id,$cfolder=false,$config=array())
{
	if($config['safe'])
	{
		$path = 'images/avatars/';
	}
	else
	{
		$lsb = dechex($id & 255);
		$msb = dechex(($id >> 8 ) & 255);
		
		if (strlen($lsb)==1) {$lsb = "0$lsb";}
		if (strlen($msb)==1) {$msb = "0$msb";}
		
		if($cfolder)
		{
			if(!file_exists('images/avatars/'.$msb.'/'))
			{
				mkdir('images/avatars/'.$msb);
			}
			if(!file_exists('images/avatars/'.$msb.'/'.$lsb.'/'))
			{
				mkdir('images/avatars/'.$msb.'/'.$lsb);
			}
			if(!file_exists('images/avatars/'.$msb.'/'.$lsb.'/'.$id.'/'))
			{
				mkdir('images/avatars/'.$msb.'/'.$lsb.'/'.$id);
			}
		}
	
		$path = 'images/avatars/'.$msb.'/'.$lsb.'/'.$id.'/';
	}

	return $path;
}

function getUserAvatar($id,$config,$lookup,$avatar_info,$size='s')
{
	if($lookup)
	{
		$avatar_info = mysql_fetch_row(mysql_query("SELECT avatar FROM ".$config['db']['pre']."users WHERE user_id='".addslashes($id)."' LIMIT 1"));
	}

	if($avatar_info[0])
	{
		if($config['safe'])
		{
			$path = 'images/avatars/'.$size.$id.'.jpg';
		}
		else
		{
			$lsb = dechex($id & 255);
			$msb = dechex(($id >> 8 ) & 255);
			
			if (strlen($lsb)==1) {$lsb = "0$lsb";}
			if (strlen($msb)==1) {$msb = "0$msb";}
			
			$path = 'images/avatars/'.$msb.'/'.$lsb.'/'.$id.'/'.$size.$id.'.jpg';
		}
	}
	else
	{
		if($size == 's')
		{
			$path = 'templates/'.$config['tpl_name'].'/images/noavatar16x16.gif';
		}
		elseif($size == 'm')
		{
			$path = 'templates/'.$config['tpl_name'].'/images/noavatar48x48.gif';
		}
		else
		{
			$path = 'templates/'.$config['tpl_name'].'/images/noavatar64x64.gif';
		}
	}
	
	return $path;
}
?>