﻿-- 
-- Structure de la table `man_categories`
-- 

CREATE TABLE `man_categories` (
  `category_id` int(11) unsigned NOT NULL auto_increment,
  `name` varchar(100) collate utf8_unicode_ci NOT NULL,
  `description` text collate utf8_unicode_ci,
  `entry_count` int(11) NOT NULL default '0',
  PRIMARY KEY  (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 
-- Contenu de la table `man_categories`
-- 

INSERT INTO `man_categories` (`category_id`, `name`, `description`, `entry_count`) VALUES 
(1, 'القسم الأول', 'هنا وصف القسم الأول.', 4),
(2, 'القسم الثاني', 'هنا وصف القسم الثاني.', 4),
(3, 'القسم الثالث', 'هنا وصف القسم الثالث.', 0),
(4, 'القسم الرابع', 'هنا وصف القسم الرابع.', 0);

-- --------------------------------------------------------

-- 
-- Structure de la table `man_entries`
-- 

CREATE TABLE `man_entries` (
  `entry_id` bigint(11) unsigned NOT NULL auto_increment,
  `FK_category_id` int(11) unsigned NOT NULL,
  `FK_user_id` bigint(11) unsigned NOT NULL,
  `active` tinyint(1) unsigned NOT NULL,
  `title` varchar(255) collate utf8_unicode_ci NOT NULL,
  `description` text collate utf8_unicode_ci,
  `date_added` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `url` mediumtext collate utf8_unicode_ci NOT NULL,
  PRIMARY KEY  (`entry_id`),
  KEY `FK_category_id` (`FK_category_id`),
  KEY `FK_user_id` (`FK_user_id`),
  KEY `active` (`active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 
-- Contenu de la table `man_entries`
-- 

INSERT INTO `man_entries` (`entry_id`, `FK_category_id`, `FK_user_id`, `active`, `title`, `description`, `date_added`, `url`) VALUES 
(1, 1, 1, 1, 'عنوان المقال الأول', 'المقال الأول. وصف المقال الأول. وصف المقال الأول. المقال الأول. وصف المقال الأول. وصف المقال الأول. المقال الأول. وصف المقال الأول. وصف المقال الأول.', '2008-06-06 05:53:42', 'نص المقال الأول. نص المقال الأول. نص المقال الأول. نص المقال الأول. نص المقال الأول. نص المقال الأول. نص المقال الأول. نص المقال الأول.\r\n\r\nنص المقال الأول. نص المقال الأول. نص المقال الأول. نص المقال الأول. نص المقال الأول. نص المقال الأول. نص المقال الأول. نص المقال الأول.\r\n\r\nنص المقال الأول. نص المقال الأول. نص المقال الأول. نص المقال الأول. نص المقال الأول. نص المقال الأول. نص المقال الأول. نص المقال الأول.\r\n\r\nنص المقال الأول. نص المقال الأول. نص المقال الأول. نص المقال الأول. نص المقال الأول. نص المقال الأول. نص المقال الأول. نص المقال الأول.\r\n\r\nنص المقال الأول. نص المقال الأول. نص المقال الأول. نص المقال الأول. نص المقال الأول. نص المقال الأول. نص المقال الأول. نص المقال الأول.'),
(2, 1, 1, 1, 'عنوان المقال الثاني', 'وصف المقال الثاني. وصف المقال الثاني. وصف المقال الثاني. وصف المقال الثاني. وصف المقال الثاني. وصف المقال الثاني. وصف المقال الثاني. وصف المقال الثاني. وصف المقال الثاني.', '2008-06-06 05:53:42', 'نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني.\r\n\r\nنص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني.\r\n\r\nنص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني.\r\n\r\nنص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني.\r\n\r\nنص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني. نص المقال الثاني.'),
(3, 1, 1, 0, 'عنوان المقال الثالث', 'وصف المقال الثالث. وصف المقال الثالث. وصف المقال الثالث. وصف المقال الثالث. وصف المقال الثالث. وصف المقال الثالث. وصف المقال الثالث. وصف المقال الثالث. وصف المقال الثالث.', '2008-06-16 06:11:50', 'نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث.\r\n\r\nنص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث.\r\n\r\nنص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث.\r\n\r\nنص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث.\r\n\r\nنص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث. نص المقال الثالث.'),
(4, 2, 1, 0, 'عنوان المقال الرابع', 'وصف المقال الرابع. وصف المقال الرابع. وصف المقال الرابع. وصف المقال الرابع. وصف المقالوصف المقال الرابع. وصف المقال الرابع. وصف المقال الرابع. وصف المقال الرابع. وصف المقال الرابع.', '2008-06-16 06:13:53', 'نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع.\r\n\r\nنص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع.\r\n\r\nنص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع.\r\n\r\nنص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع.\r\n\r\nنص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع. نص المقال الرابع.'),
(5, 2, 1, 0, 'عنوان المقال الخامس', 'وصف المقال الخامس. وصف المقال الخامس. وصف المقال الخامس. وصف المقال الخامس. وصف المقال الخامس. وصف المقال الخامس. وصف المقال الخامس. وصف المقال الخامس. وصف المقال الخامس.', '2008-06-16 06:14:49', 'نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس.\r\n\r\nنص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس.\r\n\r\nنص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس.\r\n\r\nنص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس.\r\n\r\nنص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس. نص المقال الخامس.'),
(6, 2, 1, 0, 'عنوان المقال السادس', 'وصف المقال السادس. وصف المقال السادس. وصف المقال السادس. وصف المقال السادس. وصف المقال السادس. وصف المقال السادس. وصف المقال السادس. وصف المقال السادس. وصف المقال السادس.', '2008-06-16 06:17:47', 'نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس.\r\n\r\nنص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس.\r\n\r\nنص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس.\r\n\r\nنص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس.\r\n\r\nنص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس. نص المقال السادس.'),
(7, 2, 1, 0, 'عنوان المقال السابع', 'وصف المقال السابع. وصف المقال السابع. وصف المقال السابع. وصف المقال السابع. وصف المقال السابع. وصف المقال السابع. وصف المقال السابع. وصف المقال السابع. وصف المقال السابع.', '2008-06-16 06:18:37', 'نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع.\r\n\r\nنص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع.\r\n\r\nنص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع.\r\n\r\nنص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع.\r\n\r\nنص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع. نص المقال السابع.'),
(8, 1, 1, 0, 'عنوان المقال الثامن', 'وصف المقال الثامن. وصف المقال الثامن. وصف المقال الثامن. وصف المقال الثامن. وصف المقال الثامن. وصف المقال الثامن. وصف المقال الثامن. وصف المقال الثامن. وصف المقال الثامن.', '2009-04-05 03:11:59', 'نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن.\r\n\r\nنص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن.\r\n\r\nنص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن.\r\n\r\nنص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن.\r\n\r\nنص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن. نص المقال الثامن.');

-- --------------------------------------------------------

-- 
-- Table structure for table `man_pages`
-- 

CREATE TABLE `man_pages` (
  `page_id` int(11) unsigned NOT NULL auto_increment,
  `active` tinyint(1) unsigned NOT NULL,
  `url` varchar(50) collate utf8_unicode_ci NOT NULL,
  `meta_description` varchar(255) collate utf8_unicode_ci default NULL,
  `meta_keywords` text collate utf8_unicode_ci,
  `title` varchar(255) collate utf8_unicode_ci NOT NULL,
  `content` text collate utf8_unicode_ci,
  PRIMARY KEY  (`page_id`),
  UNIQUE KEY `uri` (`url`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

-- 
-- Dumping data for table `man_pages`
-- 

INSERT INTO `man_pages` (`page_id`, `active`, `url`, `meta_description`, `meta_keywords`, `title`, `content`) VALUES
(1, 1, 'about', NULL, NULL, 'عن الموقع', '<p>\r\nمن خلال هذه الصفحة يمكن نشر نبذة عن الموقع.\r\n</p>'),
(2, 1, 'tos', NULL, NULL, 'شروط الاستخدام', '<p>شروط الاستخدام توضع هنا</p>'),
(3, 0, 'privacy', NULL, NULL, 'خصوصية المعلومات', '<p>خصوصية المعلومات تأتي هنا</p>');

-- --------------------------------------------------------

-- 
-- Structure de la table `man_sessions`
-- 

CREATE TABLE `man_sessions` (
  `session_id` varchar(40) NOT NULL default '0',
  `ip_address` varchar(16) NOT NULL default '0',
  `user_agent` varchar(50) NOT NULL,
  `last_activity` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`session_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Contenu de la table `man_sessions`
-- 

INSERT INTO `man_sessions` (`session_id`, `ip_address`, `user_agent`, `last_activity`) VALUES 
('3b4f8cd4be71453cd695bd375e268527', '127.0.0.1', 'Mozilla/5.0 (Windows; U; Windows NT 5.1; fr; rv:1.', 1213589867);

-- --------------------------------------------------------

-- 
-- Structure de la table `man_user_groups`
-- 

CREATE TABLE `man_user_groups` (
  `group_id` tinyint(3) unsigned NOT NULL auto_increment,
  `title` varchar(20) collate utf8_unicode_ci NOT NULL,
  `description` varchar(100) collate utf8_unicode_ci NOT NULL,
  PRIMARY KEY  (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 
-- Contenu de la table `man_user_groups`
-- 

INSERT INTO `man_user_groups` (`group_id`, `title`, `description`) VALUES 
(1, 'الإداريون', ''),
(2, 'Users', '');

-- --------------------------------------------------------

-- 
-- Structure de la table `man_users`
-- 

CREATE TABLE `man_users` (
  `user_id` bigint(11) unsigned NOT NULL auto_increment,
  `FK_group_id` tinyint(3) unsigned NOT NULL default '0',
  `location` varchar(75) collate utf8_unicode_ci NOT NULL,
  `join_date` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `name` varchar(50) collate utf8_unicode_ci NOT NULL,
  `surname` varchar(50) collate utf8_unicode_ci NOT NULL,
  `username` varchar(15) collate utf8_unicode_ci NOT NULL,
  `password` varchar(40) collate utf8_unicode_ci NOT NULL,
  `email` varchar(40) collate utf8_unicode_ci NOT NULL,
  `hash` varchar(40) collate utf8_unicode_ci NOT NULL,
  `activation_code` varchar(40) collate utf8_unicode_ci NOT NULL default '0',
  `change_password` tinyint(1) unsigned NOT NULL default '0',
  `active` tinyint(1) unsigned NOT NULL,
  `last_failure` int(10) unsigned NOT NULL default '0',
  `failed_logins` tinyint(2) unsigned NOT NULL default '0',
  PRIMARY KEY  (`user_id`),
  KEY `FK_group_id` (`FK_group_id`),
  KEY `active` (`active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 
-- Contenu de la table `man_users`
-- 

INSERT INTO `man_users` (`user_id`, `FK_group_id`, `location`, `join_date`, `name`, `surname`, `username`, `password`, `email`, `hash`, `activation_code`, `change_password`, `active`, `last_failure`, `failed_logins`) VALUES
(1, 1, '0', '2008-05-24 01:22:22', 'الاسم الأول', 'الاسم الثاني', 'admin', 'aabca367a7ec47390378f238d4b8d184d4ccdad3', 'admin@mantis.dev', '04b6a774402ffe4ada3cb9abc97ec527525c6a79', '0', 1, 1, 1238980029, 0);

-- 
-- Contraintes pour les tables exportées
-- 

-- 
-- Contraintes pour la table `man_entries`
-- 
ALTER TABLE `man_entries`
  ADD CONSTRAINT `man_entries_ibfk_1` FOREIGN KEY (`FK_category_id`) REFERENCES `man_categories` (`category_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `man_entries_ibfk_2` FOREIGN KEY (`FK_user_id`) REFERENCES `man_users` (`user_id`);

-- 
-- Contraintes pour la table `man_users`
-- 
ALTER TABLE `man_users`
  ADD CONSTRAINT `man_users_ibfk_1` FOREIGN KEY (`FK_group_id`) REFERENCES `man_user_groups` (`group_id`);

ALTER TABLE `man_entries` CHANGE `url` `url` MEDIUMTEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL  