<?php

/*-----------------------------------------*\
|   (FSY22) DB Customization Manager v1.2   |
+-------------------------------------------+
|   Admin Component File                    |
+-------------------------------------------+
|   (c) 2007 Michael McCune                 |
|   Email: michael.mccune@gmail.com         |
|   http://www.invisionmodding.com/         |
\*-----------------------------------------*/

if ( !defined( 'IN_ACP' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded 'admin.php'.";
	exit();
}

class ad_db_manager
{
	var $ipsclass;
	var $class_cache;
	var $class_xml;
	
	var $bad_lines        = array();
	var $tool_data        = array();
	
	var $dbcm_ver         = "1.2";
	var $has_gallery      = 0;
	var $has_blogs        = 0;
	var $has_downloads    = 0;
	
	var $ipb_inst_dir     = "install";
	var $blog_inst_dir    = "blog_setup";
	var $gallery_inst_dir = "gallery_setup";
	var $idm_inst_dir     = "idm_setup";
	
	/*-------------------------------------------------------------------------*/
	// Our 'auto_run' function
	/*-------------------------------------------------------------------------*/
	
	function auto_run()
	{
		//-----------------------------------------
		// Run the init
		//-----------------------------------------
		
		$this->init();
		
		//-----------------------------------------
		// What are we doing?
		//-----------------------------------------
		
		switch ( $this->ipsclass->input['code'] )
		{
			case 'overview':
				$this->overview();
				break;
			case 'tool':
				$this->do_tool();
				break;
			case 'do_update':
				$this->do_update();
				break;
			case 'do_notes':
				$this->update_notes();
				break;
			case 'do_deletes':
				$this->run_deletes();
				break;
			default:
				$this->overview();
				break;
		}
	}
	
	/*-------------------------------------------------------------------------*/
	// INIT: Load classes, populate arrays
	/*-------------------------------------------------------------------------*/
	
	function init()
	{
		//-----------------------------------------
		// Ensure our install directory exists
		//-----------------------------------------
		
		if ( !file_exists( ROOT_PATH.$this->ipb_inst_dir.'/sql/mysql_tables.php' ) )
		{
			$this->ipsclass->admin->error( "Your IPB installation directory, or some of its files, are missing.  This directory and its files are required for this component to operate.  It is trying to find this directory here:<br /><br /><b>".ROOT_PATH.$this->ipb_inst_dir."</b><br /><br />Please ensure that this directory exists and has all of its files, or edit the <b>/sources/components_acp/db_manager.php</b> file to point to your renamed IPB install directory." );
		}
		
		//-----------------------------------------
		// Init the nav
		//-----------------------------------------
		
		$this->ipsclass->admin->nav[] = array( $this->ipsclass->form_code."&amp;code=overview", '(FSY22) DB Customization Manager' );
		
		//-----------------------------------------
		// Load more caches
		//-----------------------------------------
		
		$this->ipsclass->init_load_cache( array( 'components', 'settings' ) );
		
		//-----------------------------------------
		// Load the Cache class
		//-----------------------------------------
		
		$this->class_cache = $this->ipsclass->load_class( ROOT_PATH.'sources/action_admin/administration.php', 'ad_administration' );
		
		//-----------------------------------------
		// Load the XML class
		//-----------------------------------------
		
		$this->class_xml = $this->ipsclass->load_class( KERNEL_PATH.'class_xml.php', 'class_xml' );
		
		//-----------------------------------------
		// Check and see if the IPS modules are installed
		//-----------------------------------------
		
		foreach ( $this->ipsclass->cache['components'] as $id => $component )
		{
			if ( $component['com_enabled'] )
			{
				if ( $component['com_url_title'] == "{ipb.lang['gallery']}" )
				{
					if ( !file_exists( ROOT_PATH.$this->gallery_inst_dir.'/installfiles/install/mysql_tables.php' ) )
					{
						$this->ipsclass->admin->error( "Your IP.Gallery installation directory, or some of its files, are missing.  This directory and its files are required for this component to operate.  It is trying to find this directory here:<br /><br /><b>".ROOT_PATH.$this->gallery_inst_dir."</b><br /><br />Please ensure that this directory exists and has all of its files, or edit the <b>/sources/components_acp/db_manager.php</b> file to point to your renamed IP.Gallery install directory." );
					}
					
					$this->has_gallery = 1;
				}
				
				if ( $component['com_url_title'] == "{ipb.lang['blog']}" )
				{
					if ( !file_exists( ROOT_PATH.$this->blog_inst_dir.'/installfiles/install/mysql_tables.php' ) )
					{
						$this->ipsclass->admin->error( "Your IP.Blog installation directory, or some of its files, are missing.  This directory and its files are required for this component to operate.  It is trying to find this directory here:<br /><br /><b>".ROOT_PATH.$this->blog_inst_dir."</b><br /><br />Please ensure that this directory exists and has all of its files, or edit the <b>/sources/components_acp/db_manager.php</b> file to point to your renamed IP.Blog install directory." );
					}
					
					$this->has_blogs = 1;
				}
				
				if ( $component['com_url_title'] == "{ipb.lang['idm_header']}" )
				{
					if ( !file_exists( ROOT_PATH.$this->idm_inst_dir.'/installfiles/install/mysql_tables.php' ) )
					{
						$this->ipsclass->admin->error( "Your IP.Downloads installation directory, or some of its files, are missing.  This directory and its files are required for this component to operate.  It is trying to find this directory here:<br /><br /><b>".ROOT_PATH.$this->idm_inst_dir."</b><br /><br />Please ensure that this directory exists and has all of its files, or edit the <b>/sources/components_acp/db_manager.php</b> file to point to your renamed IP.Downloads install directory." );
					}
					
					$this->has_downloads = 1;
				}
			}
		}
		
		//-----------------------------------------
		// We're not interested in this stuff
		//-----------------------------------------
		
		$this->bad_lines = array( 'PRIMARY', 'KEY', ');', ')' );
		
		//-----------------------------------------
		// Load up our tool data
		//-----------------------------------------
		
		$this->tool_data = array( 'acp_help'        => array( 'table'      => 'acp_help',
															  'where'      => 'is_setting=0',
															  'order'      => 'page_key ASC',
															  'key'        => 'page_key',
															  'xml_key'    => 'key',
															  'file'       => 'help_sections',
															  'l_1'        => 'helpsectionsexport',
															  'l_2'        => 'helpsectionsgroup',
															  'l_3'        => 'helpsections',
															  'output'     => 'page_key',
															  'head_title' => 'ACP Help Section',
															  'tbl_title'  => 'Extra ACP Help Sections',
															  'none'       => 'No Extra ACP Help Sections',
															  'code'       => 'acp_help',
															  'index'      => 'id',
															),
								  'acp_settings'    => array( 'table'      => 'acp_help',
															  'where'      => 'is_setting=1',
															  'order'      => 'page_key ASC',
															  'key'        => 'page_key',
															  'xml_key'    => 'key',
															  'file'       => 'help_settings',
															  'l_1'        => 'helpsettingsexport',
															  'l_2'        => 'helpsettingsgroup',
															  'l_3'        => 'helpsettings',
															  'output'     => 'page_key',
															  'head_title' => 'ACP Help Settings',
															  'tbl_title'  => 'Extra ACP Help Settings',
															  'none'       => 'No Extra ACP Help Settings',
															  'code'       => 'acp_settings',
															  'index'      => 'id',
															),
								  'acp_perms'       => array( 'table'      => 'admin_permission_keys',
															  'order'      => 'perm_key ASC',
															  'key'        => 'perm_key',
															  'file'       => 'acpperms',
															  'l_1'        => 'permsexport',
															  'l_2'        => 'permsgroup',
															  'l_3'        => 'perm',
															  'comp'       => array( 'acpperm_main', 'acpperm_child', 'acpperm_bit' ),
															  'output'     => 'perm_key',
															  'head_title' => 'ACP Permission Key',
															  'tbl_title'  => 'Extra ACP Permission Keys',
															  'none'       => 'No Extra ACP Permission Keys',
															  'code'       => 'acp_perms',
															  'index'      => 'perm_key',
															),
								  'components'      => array( 'table'      => 'components',
															  'order'      => 'com_title ASC',
															  'key'        => 'com_section',
															  'file'       => 'components',
															  'mod_file'   => 'components',
															  'l_1'        => 'export',
															  'l_2'        => 'group',
															  'l_3'        => 'row',
															  'm_1'        => 'componentexport',
															  'm_2'        => 'componentgroup',
															  'm_3'        => 'component',
															  'output'     => 'com_title',
															  'head_title' => 'Component Name',
															  'tbl_title'  => 'Extra Components',
															  'none'       => 'No Extra Components',
															  'code'       => 'components',
															  'index'      => 'com_id',
															),
								  'bbcode'          => array( 'table'      => 'custom_bbcode',
															  'order'      => 'bbcode_title ASC',
															  'key'        => 'bbcode_tag',
															  'file'       => 'bbcode',
															  'mod_file'   => 'bbcode',
															  'l_1'        => 'bbcodeexport',
															  'l_2'        => 'bbcodegroup',
															  'l_3'        => 'bbcode',
															  'm_1'        => 'bbcodeexport',
															  'm_2'        => 'bbcodegroup',
															  'm_3'        => 'bbcode',
															  'output'     => 'bbcode_title',
															  'head_title' => 'BBCode Name',
															  'tbl_title'  => 'Extra Custom BBCode',
															  'none'       => 'No Extra Custom BBCodes',
															  'code'       => 'bbcode',
															  'idx'        => 7,
															  'index'      => 'bbcode_id',
															),
								  'fields'          => array( 'schema'     => 1,
															  'multi'      => 1,
															  'second'     => 1,
															  'head_title' => 'Field Name',
															  'sec_title'  => 'Table Name',
															  'tbl_title'  => 'Extra Database Fields',
															  'none'       => 'No Extra Database Fields',
															  'code'       => 'fields',
															),
								  'tables'          => array( 'schema'     => 1,
															  'output'     => 0,
															  'head_title' => 'Table Name',
															  'tbl_title'  => 'Extra Tables',
															  'none'       => 'No Extra Tables',
															  'code'       => 'tables',
															),
								  'help'            => array( 'table'      => 'faq',
															  'order'      => 'title ASC',
															  'key'        => 'title',
															  'file'       => 'faq',
															  'mod_file'   => 'faq',
															  'l_1'        => 'export',
															  'l_2'        => 'group',
															  'l_3'        => 'row',
															  'm_1'        => 'export',
															  'm_2'        => 'group',
															  'm_3'        => 'row',
															  'output'     => 'title',
															  'head_title' => 'Help File Title',
															  'tbl_title'  => 'Extra Help Files',
															  'none'       => 'No Extra Help Files',
															  'code'       => 'help',
															  'index'      => 'id',
															),
								  'macros'          => array( 'table'      => 'skin_macro',
															  'where'      => 'macro_set=1',
															  'order'      => 'macro_value ASC',
															  'key'        => 'macro_value',
															  'file'       => 'macro',
															  'mod_file'   => 'macro',
															  'l_1'        => 'macroexport',
															  'l_2'        => 'macrogroup',
															  'l_3'        => 'macro',
															  'm_1'        => 'macroexport',
															  'm_2'        => 'macrogroup',
															  'm_3'        => 'macro',
															  'output'     => 'macro_value',
															  'head_title' => 'Macro Value',
															  'tbl_title'  => 'Extra Skin Macros',
															  'none'       => 'No Extra Skin Macros',
															  'code'       => 'macros',
															  'index'      => 'macro_id',
															),
								  'settings_groups' => array( 'table'      => 'conf_settings_titles',
															  'order'      => 'conf_title_title ASC',
															  'key'        => 'conf_title_keyword',
															  'file'       => 'settings',
															  'mod_file'   => 'settings',
															  'settings'   => 'conf_is_title',
															  'l_1'        => 'settingexport',
															  'l_2'        => 'settinggroup',
															  'l_3'        => 'setting',
															  'm_1'        => 'settingexport',
															  'm_2'        => 'settinggroup',
															  'm_3'        => 'setting',
															  'output'     => 'conf_title_title',
															  'head_title' => 'Settings Group',
															  'tbl_title'  => 'Extra Settings Groups',
															  'none'       => 'No Extra Settings Groups',
															  'code'       => 'settings_groups',
															  'index'      => 'conf_title_id',
															),
								  'settings'        => array( 'table'      => 'conf_settings',
															  'order'      => 'conf_key ASC',
															  'key'        => 'conf_key',
															  'file'       => 'settings',
															  'mod_file'   => 'settings',
															  'settings'   => 'conf_key',
															  'l_1'        => 'settingexport',
															  'l_2'        => 'settinggroup',
															  'l_3'        => 'setting',
															  'm_1'        => 'settingexport',
															  'm_2'        => 'settinggroup',
															  'm_3'        => 'setting',
															  'output'     => 'conf_key',
															  'head_title' => 'Settings Key',
															  'tbl_title'  => 'Extra Settings Keys',
															  'none'       => 'No Extra Settings Keys',
															  'code'       => 'settings',
															  'index'      => 'conf_id',
															),
								  'templates'       => array( 'table'      => 'skin_templates',
															  'where'      => 'set_id=1',
															  'order'      => 'group_name ASC, func_name ASC',
															  'key'        => 'func_name',
															  'key2'       => 'group_name',
															  'multi'      => 1,
															  'tmpl'       => 1,
															  'file'       => 'ipb_templates',
															  'mod_file'   => 'templates',
															  'l_1'        => 'templateexport',
															  'l_2'        => 'templategroup',
															  'l_3'        => 'template',
															  'm_1'        => 'templateexport',
															  'm_2'        => 'templategroup',
															  'm_3'        => 'template',
															  'output'     => 'func_name',
															  'second'     => 'group_name',
															  'head_title' => 'Skin Template',
															  'sec_title'  => 'Skin Group',
															  'tbl_title'  => 'Extra Skin Templates',
															  'none'       => 'No Extra Skin Templates',
															  'code'       => 'templates',
															  'index'      => 'suid',
															),
								  'tasks'           => array( 'table'      => 'task_manager',
															  'order'      => 'task_title ASC',
															  'key'        => 'task_key',
															  'file'       => 'tasks',
															  'mod_file'   => 'tasks',
															  'l_1'        => 'export',
															  'l_2'        => 'group',
															  'l_3'        => 'row',
															  'm_1'        => 'export',
															  'm_2'        => 'group',
															  'm_3'        => 'row',
															  'output'     => 'task_title',
															  'head_title' => 'Task Title',
															  'tbl_title'  => 'Extra Tasks',
															  'none'       => 'No Extra Tasks',
															  'code'       => 'tasks',
															  'idx'        => 24,
															  'index'      => 'task_id',
															),
								);
	}
	
	/*-------------------------------------------------------------------------*/
	// The overview page
	/*-------------------------------------------------------------------------*/
	
	function overview()
	{
		//-----------------------------------------
		// Init ACP Help
		//-----------------------------------------
		
		$this->acp_help_init();
		
		//-----------------------------------------
		// Basic admin page stuff
		//-----------------------------------------
		
		$this->ipsclass->admin->page_title  = "(FSY22) DB Customization Manager: Overview";
		$this->ipsclass->admin->page_detail = "This page lists the available cleanup tools in this component.  Click <b>Run Tool</b> to run the tool.  <b>Total Entries</b> and <b>Noted Entries</b> are counts from when the tool was last run, run the tool again to update these counts.";
		$this->ipsclass->admin->nav[]       = array( '', 'Overview' );
		
		//-----------------------------------------
		// Build the tools table
		//-----------------------------------------
		
		$this->ipsclass->adskin->td_header[] = array( "Tool"          , "30%" );
		$this->ipsclass->adskin->td_header[] = array( "Last Run"      , "25%" );
		$this->ipsclass->adskin->td_header[] = array( "Total Entries" , "15%" );
		$this->ipsclass->adskin->td_header[] = array( "Noted Entries" , "15%" );
		$this->ipsclass->adskin->td_header[] = array( "Run"           , "15%" );
		
		$this->ipsclass->html .= $this->ipsclass->adskin->start_table( "Database cleanup tools" );
		
		$this->ipsclass->DB->build_query( array( 'select' => '*', 'from' => 'dbm_tools' ) );
		$this->ipsclass->DB->exec_query();
		
		if ( $this->ipsclass->DB->get_num_rows() )
		{
			while ( $tool = $this->ipsclass->DB->fetch_row() )
			{
				if ( !isset( $this->ipsclass->vars['acp_tutorial_mode'] ) && in_array( $tool['code'], array( 'acp_help', 'acp_settings' ) ) )
				{
					continue;
				}
				
				$this->ipsclass->html .= $this->ipsclass->adskin->add_td_row( array( "<b>{$tool['description']}</b>",
																					 $this->ipsclass->get_date( $tool['lastrun'], LONG ),
																					 "<div align='center'>{$tool['total_entries']}</div>",
																					 "<div align='center'>{$tool['noted_entries']}</div>",
																					 "<div align='center'><a href='{$this->ipsclass->base_url}&amp;{$this->ipsclass->form_code}&amp;code=tool&amp;tool={$tool['code']}' onclick='xmlobj = new ajax_request();xmlobj.show_loading()'>Run Tool</a></div>",
																			)	   );
			}
		}
		else
		{
			$this->ipsclass->html .= $this->ipsclass->adskin->add_td_basic( "<div align='center'><b>No available Tools to run</b></div>", 'center', 'tablerow1' );
		}
		
		$this->ipsclass->html .= $this->ipsclass->adskin->end_table();
		
		//-----------------------------------------
		// Copyright
		//-----------------------------------------
		
		$this->ipsclass->html .= $this->ipsclass->adskin->add_standalone_row( "(FSY22) DB Customization Manager v{$this->dbcm_ver}, by <a href='http://www.invisionmodding.com/' target='_blank'>Michael</a>, &copy; ".date("Y"), 'center', 'tablefooter' );
		
		//-----------------------------------------
		// Output
		//-----------------------------------------
		
		$this->ipsclass->admin->output();
	}
	
	/*-------------------------------------------------------------------------*/
	// Generic function to run a tool
	/*-------------------------------------------------------------------------*/
	
	function do_tool()
	{
		//-----------------------------------------
		// Our data for this tool
		//-----------------------------------------
		
		$data = $this->tool_data[ $this->ipsclass->input['tool'] ];
		
		//-----------------------------------------
		// Do all of the work
		//-----------------------------------------
		
		$this->build_output( $data, $this->compare_loop( $data, $this->load_site_data( $data ), $this->load_default_data( $data ) ) );
		
		//-----------------------------------------
		// Do the output
		//-----------------------------------------
		
		$this->ipsclass->admin->output();
	}
	
	/*-------------------------------------------------------------------------*/
	// Last confirmation page before things get updated
	/*-------------------------------------------------------------------------*/
	
	function do_update()
	{
		//-----------------------------------------
		// Basic admin page stuff
		//-----------------------------------------
		
		$this->ipsclass->admin->page_title  = "(FSY22) DB Customization Manager: Update";
		$this->ipsclass->admin->page_detail = "These are the items you selected to update, either to manage the notes, or to delete.  When adding a new note, please be advised that this will overwrite any existing note, so be certain you want to update the notes for <b>all</b> of the selected items below.  And should you be deleting items from this page, remember that there is no undo, so before confirming be sure that you want to delete <b>all</b> of the items listed below.";
		$this->ipsclass->admin->nav[]       = array( '', 'Update' );
		
		//-----------------------------------------
		// Which tool?
		//-----------------------------------------
		
		$tool = $this->ipsclass->input['tool'];
		$data = $this->tool_data[ $tool ];
		
		//-----------------------------------------
		// Make sure we got something to do
		//-----------------------------------------
		
		if ( !count( $this->ipsclass->input['ids'] ) )
		{
			$this->ipsclass->admin->error( "You didn't select any items to work on, silly goose!" );
		}
		
		//-----------------------------------------
		// Which items are we working with?
		//-----------------------------------------
		
		$items = array();
		
		if ( $data['schema'] )
		{
			foreach ( $this->ipsclass->input['ids'] as $id )
			{
				if ( $data['code'] == 'tables' )
				{
					$items[] = array( 0 => $id );
				}
				else
				{
					$items[] = $id;
				}
			}
		}
		else
		{
			$this->ipsclass->DB->build_query( array( 'select' => '*',
													 'from'   => $data['table'],
													 'where'  => $data['index']." IN ('".implode( "','", $this->ipsclass->input['ids'] )."')",
													 'order'  => $data['order'],
											)	   );
			$this->ipsclass->DB->exec_query();
			
			if ( $this->ipsclass->DB->get_num_rows() )
			{
				while ( $row = $this->ipsclass->DB->fetch_row() )
				{
					if ( $data['tmpl'] )
					{
						$items[ $row[ $data['index'] ] ] = $row[ $data['key'] ].'^'.$row[ $data['key2'] ];
					}
					else
					{
						$items[ $row[ $data['key'] ] ] = $row;
					}
				}
			}
		}
		
		//-----------------------------------------
		// Find our notes
		//-----------------------------------------
		
		$notes = array();
		
		$this->ipsclass->DB->build_query( array( 'select' => '*', 'from' => 'dbm_notes', 'where' => "code='{$data['code']}'" ) );
		$this->ipsclass->DB->exec_query();
		
		if ( $this->ipsclass->DB->get_num_rows() )
		{
			while ( $note = $this->ipsclass->DB->fetch_row() )
			{
				$notes[ $note['note_key'] ] = $note;
			}
		}
		
		//-----------------------------------------
		// Build the table
		//-----------------------------------------
		
		if ( $data['second'] )
		{
			$this->ipsclass->adskin->td_header[] = array( $data['head_title'] , "20%" );
			$this->ipsclass->adskin->td_header[] = array( $data['sec_title']  , "20%" );
			$this->ipsclass->adskin->td_header[] = array( "Existing Note"     , "60%" );
		}
		else
		{
			$this->ipsclass->adskin->td_header[] = array( $data['head_title'] , "30%" );
			$this->ipsclass->adskin->td_header[] = array( "Existing Note"     , "70%" );
		}
		
		$code = ( $this->ipsclass->input['to_run'] == 'note' ) ? 'do_notes' : 'do_deletes';
		
		$this->ipsclass->html .= $this->ipsclass->adskin->start_form( array( 0 => array( 'act'    , 'db_manager'  ),
																			 1 => array( 'code'   , $code         ),
																			 2 => array( 'tool'   , $data['code'] ),
																			 3 => array( 'section', $this->ipsclass->section_code ),
																	)	   );
		
		$this->ipsclass->html .= "\n<input type='hidden' name='ids' value=\"'".implode( "','", $this->ipsclass->input['ids'] )."'\" />\n";
		
		$this->ipsclass->html .= $this->ipsclass->adskin->start_table( $data['tbl_title'] );
		
		foreach ( $items as $item => $item_data )
		{
			if ( $data['second'] )
			{
				$note   = in_array( $item_data, array_keys( $notes ) ) ? $notes[ $item_data ]['note'] : '<i>None</i>';
				$fields = explode( "^", $item_data );
				
				$to_show = array( "<b>{$fields[0]}</b>", $fields[1], $note );
			}
			else
			{
				$clean = str_replace( ' ', '_', $item_data[ $data['output'] ] );
				$note  = in_array( $clean, array_keys( $notes ) ) ? $notes[ $clean ]['note'] : "<i>None</i>";
				
				$to_show = array( "<b>{$item_data[$data['output']]}</b>", $note );
			}
			
			$this->ipsclass->html .= $this->ipsclass->adskin->add_td_row( $to_show );
		}
		
		if ( $this->ipsclass->input['to_run'] == 'note' )
		{
			$this->ipsclass->html .= $this->ipsclass->adskin->add_td_basic( "Set the note for each of the above items to the following:
																			 <input type='text' name='new_note' value='' size='60' class='textinput'>
																			 <input type='submit' value='Go!' class='realbutton'>", "center", "tablefooter" );
		}
		else
		{
			$this->ipsclass->html .= $this->ipsclass->adskin->add_td_basic( "Are you sure you want to delete all of the selected items?
																			 <input type='submit' value='Yes' class='realbutton'>", "center", "tablefooter" );
		}
		
		$this->ipsclass->html .= $this->ipsclass->adskin->end_table();
		
		$this->ipsclass->html .= $this->ipsclass->adskin->end_form();
		
		//-----------------------------------------
		// Copyright
		//-----------------------------------------
		
		$this->ipsclass->html .= $this->ipsclass->adskin->add_standalone_row( "(FSY22) DB Customization Manager v{$this->dbcm_ver}, by <a href='http://www.invisionmodding.com/' target='_blank'>Michael</a>, &copy; ".date("Y"), 'center', 'tablefooter' );
		
		//-----------------------------------------
		// Output
		//-----------------------------------------
		
		$this->ipsclass->admin->output();
	}
	
	/*-------------------------------------------------------------------------*/
	// Update the notes for selected items
	/*-------------------------------------------------------------------------*/
	
	function update_notes()
	{
		//-----------------------------------------
		// Which tool?
		//-----------------------------------------
		
		$tool = $this->ipsclass->input['tool'];
		$data = $this->tool_data[ $tool ];
		
		//-----------------------------------------
		// Process the other inputs
		//-----------------------------------------
		
		$note = trim( $this->ipsclass->input['new_note'] );
		$ids  = str_replace( "&#39;", "'", $this->ipsclass->input['ids'] );
		
		//-----------------------------------------
		// Which items are we working with?
		//-----------------------------------------
		
		$items = array();
		
		if ( $data['schema'] )
		{
			foreach ( explode( ',', $ids ) as $id )
			{
				$items[] = str_replace( "'", "", $id );
			}
		}
		else
		{
			$this->ipsclass->DB->build_query( array( 'select' => '*',
													 'from'   => $data['table'],
													 'where'  => $data['index']." IN (".$ids.")",
													 'order'  => $data['order'],
											)	   );
			$this->ipsclass->DB->exec_query();
			
			if ( $this->ipsclass->DB->get_num_rows() )
			{
				while ( $row = $this->ipsclass->DB->fetch_row() )
				{
					if ( $data['tmpl'] )
					{
						$items[] = $row[ $data['key'] ].'^'.$row[ $data['key2'] ];
					}
					else
					{
						$items[] = $row[ $data['key'] ];
					}
				}
			}
		}
		
		//-----------------------------------------
		// Which items have existing notes?
		//-----------------------------------------
		
		$has_note   = array();
		$needs_note = array();
		
		$this->ipsclass->DB->build_query( array( 'select' => '*',
												 'from'   => 'dbm_notes',
												 'where'  => "code='{$data['code']}' AND note_key IN ('".implode( "','", $items )."')",
										)	   );
		$this->ipsclass->DB->exec_query();
		
		if ( $this->ipsclass->DB->get_num_rows() )
		{
			while ( $row = $this->ipsclass->DB->fetch_row() )
			{
				$has_note[] = $row['note_key'];
			}
		}
		
		foreach ( $items as $item )
		{
			if ( !in_array( $item, $has_note ) )
			{
				$needs_note[] = $item;
			}
		}
		
		//-----------------------------------------
		// Adding/updating, or removing notes?
		//-----------------------------------------
		
		if ( $note )
		{
			//-----------------------------------------
			// Got notes to update?
			//-----------------------------------------
			
			if ( count( $has_note ) )
			{
				$this->ipsclass->DB->do_update( 'dbm_notes', array( 'note' => $note ), "code='{$tool}' AND note_key IN ('".implode( "','", $has_note )."')" );
			}
			
			//-----------------------------------------
			// Got notes to add?
			//-----------------------------------------
			
			if ( count( $needs_note ) )
			{
				foreach( $needs_note as $need )
				{
					$this->ipsclass->DB->do_insert( 'dbm_notes', array( 'note' => $note, 'code' => $tool, 'note_key' => $need ) );
				}
			}
		}
		else
		{
			//-----------------------------------------
			// Delete these notes
			//-----------------------------------------
			
			$this->ipsclass->DB->do_delete( 'dbm_notes', "code='{$tool}' AND note_key IN ('".implode( "','", $items )."')" );
		}
		
		//-----------------------------------------
		// How many notes in this tool?
		//-----------------------------------------
		
		$this->ipsclass->DB->build_query( array( 'select' => '*',
												 'from'   => 'dbm_notes',
												 'where'  => "code='{$data['code']}'",
										)	   );
		$this->ipsclass->DB->exec_query();
		
		$count = $this->ipsclass->DB->get_num_rows();
		
		$this->ipsclass->DB->build_and_exec_query( array( 'update' => 'dbm_tools', 'set' => 'noted_entries='.$count, 'where' => "code='{$tool}'" ) );
		
		//-----------------------------------------
		// Log the action and redirect
		//-----------------------------------------
		
		$this->ipsclass->admin->save_log( "Updated notes in the DB Customization Manager mod" );
		
		$this->ipsclass->main_msg = "Successfully updated the notes for the selected item(s)!";
		$this->ipsclass->admin->redirect_noscreen( $this->ipsclass->base_url."&{$this->ipsclass->form_code}&code=overview" );
	}
	
	/*-------------------------------------------------------------------------*/
	// Delete selected items
	/*-------------------------------------------------------------------------*/
	
	function run_deletes()
	{
		//-----------------------------------------
		// Which tool?
		//-----------------------------------------
		
		$tool = $this->ipsclass->input['tool'];
		$data = $this->tool_data[ $tool ];
		
		//-----------------------------------------
		// Process the other inputs
		//-----------------------------------------
		
		$ids = str_replace( "&#39;", "'", $this->ipsclass->input['ids'] );
		
		//-----------------------------------------
		// Caches to be recached
		//-----------------------------------------
		
		$caches = array( 'components'      => 'components',
						 'bbcode'          => 'bbcode',
						 'settings'        => 'settings',
						 'settings_groups' => 'settings',
					   );
		
		//-----------------------------------------
		// Which items are we working with?
		//-----------------------------------------
		
		$items = array();
		
		if ( $data['schema'] )
		{
			foreach ( explode( ',', $ids ) as $id )
			{
				$items[] = str_replace( "'", "", $id );
			}
		}
		else
		{
			$this->ipsclass->DB->build_query( array( 'select' => '*',
													 'from'   => $data['table'],
													 'where'  => $data['index']." IN (".$ids.")",
													 'order'  => $data['order'],
											)	   );
			$this->ipsclass->DB->exec_query();
			
			if ( $this->ipsclass->DB->get_num_rows() )
			{
				while ( $row = $this->ipsclass->DB->fetch_row() )
				{
					$items[] = $row[ $data['key'] ];
				}
			}
		}
		
		//-----------------------------------------
		// Delete associated notes
		//-----------------------------------------
		
		$this->ipsclass->DB->do_delete( 'dbm_notes', "code='{$tool}' AND note_key IN ('".implode( "','", $items )."')" );
		
		//-----------------------------------------
		// Delete the item
		//-----------------------------------------
		
		switch ( $tool )
		{
			case 'acp_help':
			case 'acp_settings':
			case 'acp_perms':
			case 'help':
			case 'tasks':
				$this->ipsclass->DB->do_delete( $data['table'], $data['index']." IN (".$ids.")" );
				break;
			case 'components':
			case 'bbcode':
			case 'settings':
			case 'settings_groups':
				$this->ipsclass->DB->do_delete( $data['table'], $data['index']." IN (".$ids.")" );
				$this->class_cache->cache_end( $caches[ $tool ], 1 );
				break;
			case 'macros':
			case 'templates':
				$this->ipsclass->DB->do_delete( $data['table'], $data['index']." IN (".$ids.")" );
				$this->update_skin_caches();
				break;
			case 'fields':
				foreach ( explode( ',', $ids ) as $key )
				{
					$info = explode( '^', $key );
					$this->ipsclass->DB->sql_drop_field( str_replace( "'", "", substr( $info[1], strlen( $this->ipsclass->vars['sql_tbl_prefix'] ) ) ), str_replace( "'", "", $info[0] ) );
				}
				$this->update_all_caches();
				break;
			case 'tables':
				foreach ( explode( ',', $ids ) as $key )
				{
					$this->ipsclass->DB->sql_drop_table( substr( str_replace( "'", "", $key ), strlen( $this->ipsclass->vars['sql_tbl_prefix'] ) ) );
				}
				break;
		}
		
		//-----------------------------------------
		// How many notes in this tool?
		//-----------------------------------------
		
		$this->ipsclass->DB->build_query( array( 'select' => '*',
												 'from'   => 'dbm_notes',
												 'where'  => "code='{$data['code']}'",
										)	   );
		$this->ipsclass->DB->exec_query();
		
		$count = $this->ipsclass->DB->get_num_rows();
		
		$this->ipsclass->DB->build_and_exec_query( array( 'update' => 'dbm_tools', 'set' => 'total_entries=total_entries-'.count( $items ).', noted_entries='.$count, 'where' => "code='{$data['code']}'" ) );
		
		//-----------------------------------------
		// Log the action and redirect
		//-----------------------------------------
		
		$this->ipsclass->admin->save_log( "Deleted items in the DB Customization Manager mod" );
		
		$this->ipsclass->main_msg = "Successfully deleted the selected item(s)!";
		$this->ipsclass->admin->redirect_noscreen( $this->ipsclass->base_url."&{$this->ipsclass->form_code}&code=overview" );
	}
	
	/*-------------------------------------------------------------------------*/
	// ACP Help (New in 2.3)
	/*-------------------------------------------------------------------------*/
	
	function acp_help_init()
	{
		//-----------------------------------------
		// Are we on 2.3?
		//-----------------------------------------
		
		if ( isset( $this->ipsclass->vars['acp_tutorial_mode'] ) )
		{
			//-----------------------------------------
			// Define our help sections
			//-----------------------------------------
			
			$umi_acp_help = array( 'components_db_manager_'          => array( 'is_setting'     => 0,
																			   'help_title'     => '(FSY22) DB Customization Manager: Overview',
																			   'help_body'      => 'This page lists the available cleanup tools in this component.  Click <b>Run Tool</b> to run the tool.  <b>Total Entries</b> and <b>Noted Entries</b> are counts from when the tool was last run, run the tool again to update these counts.',
																			   'help_mouseover' => '',
																			),
								   'components_db_manager_overview'  => array( 'is_setting'     => 0,
																			   'help_title'     => '(FSY22) DB Customization Manager: Overview',
																			   'help_body'      => 'This page lists the available cleanup tools in this component.  Click <b>Run Tool</b> to run the tool.  <b>Total Entries</b> and <b>Noted Entries</b> are counts from when the tool was last run, run the tool again to update these counts.',
																			   'help_mouseover' => '',
																			),
								   'components_db_manager_tool'      => array( 'is_setting'     => 0,
																			   'help_title'     => '(FSY22) DB Customization Manager: Results',
																			   'help_body'      => 'This page lists the extra items the component found.  From here you can manage the notes for individual items that indicate why the item was added, or you can delete the item.  <b>Please remember</b> that there is no undo for the delete command, so be very sure you want to delete the item before doing so.',
																			   'help_mouseover' => '',
																			),
								   'components_db_manager_do_update' => array( 'is_setting'     => 0,
																			   'help_title'     => '(FSY22) DB Customization Manager: Update',
																			   'help_body'      => 'These are the items you selected to update, either to manage the notes, or to delete.  When adding a new note, please be advised that this will overwrite any existing note, so be certain you want to update the notes for <b>all</b> of the selected items below.  And should you be deleting items from this page, remember that there is no undo, so before confirming be sure that you want to delete <b>all</b> of the items listed below.',
																			   'help_mouseover' => '',
																			),
								 );
			
			//-----------------------------------------
			// Ensure the help keys have been created
			//-----------------------------------------
			
			foreach ( $umi_acp_help as $key => $value )
			{
				$me = $this->ipsclass->DB->build_and_exec_query( array( 'select' => '*', 'from' => 'acp_help', 'where' => "page_key='{$key}'" ) );
				
				if ( !$me )
				{
					$insert = array( 'is_setting'     => $value['is_setting'],
									 'page_key'       => $key,
									 'help_title'     => $value['help_title'],
									 'help_body'      => $value['help_body'],
									 'help_mouseover' => $value['help_mouseover'],
									);
					
					$this->ipsclass->DB->do_insert( 'acp_help', $insert );
				}
			}
		}
		
		return TRUE;
	}
	
	/*-------------------------------------------------------------------------*/
	// Load tool data from what is currently on the site
	/*-------------------------------------------------------------------------*/
	
	function load_site_data( $data=array() )
	{
		if ( $data['schema'] )
		{
			//-----------------------------------------
			// Get the current db schema
			//-----------------------------------------
			
			foreach ( $this->ipsclass->DB->get_table_names() as $name )
			{
				if ( !$data['multi'] )
				{
					$fields[0] = $name;
				}
				
				if ( preg_match( "/^".$this->ipsclass->vars['sql_tbl_prefix']."/", $name ) )
				{
					$this->ipsclass->DB->query( "SHOW fields FROM " . $name );
					
					while ( $check = $this->ipsclass->DB->fetch_row() )
					{
						$fields[] = $check['Field'];
					}
					
					$ipb_data[ $name ] = $fields;
				}
				
				unset( $fields );
			}
			
			ksort( $ipb_data );
		}
		else
		{
			//-----------------------------------------
			// Get info from a specific table
			//-----------------------------------------
			
			$this->ipsclass->DB->build_query( array( 'select' => '*',
													 'from'   => $data['table'],
													 'where'  => $data['where'],
													 'order'  => $data['order'],
											)	   );
			$this->ipsclass->DB->exec_query();
			
			if ( $this->ipsclass->DB->get_num_rows() )
			{
				while ( $row = $this->ipsclass->DB->fetch_row() )
				{
					if ( $data['tmpl'] )
					{
						$ipb_data[ $row[ $data['key2'] ] ][ $row[ $data['index'] ] ] = $row[ $data['key'] ];
					}
					else
					{
						$ipb_data[ str_replace( ' ', '_', $row[ $data['key'] ] ) ] = $row;
					}
				}
			}
		}
		
		//-----------------------------------------
		// Return the data
		//-----------------------------------------
		
		return $ipb_data;
	}
	
	/*-------------------------------------------------------------------------*/
	// Load the default IPB data
	/*-------------------------------------------------------------------------*/
	
	function load_default_data( $data=array() )
	{
		if ( $data['schema'] )
		{
			//-----------------------------------------
			// Load the IPB install file
			//-----------------------------------------
			
			require_once( ROOT_PATH.$this->ipb_inst_dir.'/sql/mysql_tables.php' );
			
			//-----------------------------------------
			// Loop through each command
			//-----------------------------------------
			
			foreach ( $TABLE as $v )
			{
				$split    = explode( "\n", $v );
				$tbl_line = explode( " ", $split[0] );
				
				foreach ( $split as $line => $data )
				{
					if ( $line == 0 )
					{
						continue;
					}
					
					$line_data = explode( " ", trim( str_replace( "\t", " ", $data ) ) );
					
					if ( !in_array( $line_data[0], $this->bad_lines ) )
					{
						$fields[] = $line_data[0];
					}
					
					unset( $line_data );
				}
				
				$def_data[ $tbl_line[2] ] = $fields;
				
				unset( $fields );
			}
			
			unset( $TABLE );
		}
		else
		{
			$this->class_xml->xml_parse_document( file_get_contents( ROOT_PATH.'resources/'.$data['file'].'.xml' ) );
			$temp_array = $this->class_xml->xml_array[ $data['l_1'] ][ $data['l_2'] ];
			
			if ( !is_array( $temp_array[ $data['l_3'] ][0] ) )
			{
				$tmp = $temp_array[ $data['l_3'] ];
				unset( $temp_array[ $data['l_3'] ] );
				$temp_array[ $data['l_3'] ][0] = $tmp;
			}
			
			foreach ( $temp_array[ $data['l_3'] ] as $row )
			{
				$fields = array();
				
				foreach ( $row as $key => $value )
				{
					if ( $key != 'VALUE' )
					{
						$fields[ $key ] = $value['VALUE'];
					}
				}
				
				if ( $data['tmpl'] )
				{
					$def_data[ $row[ $data['key2'] ]['VALUE'] ][] = $row[ $data['key'] ]['VALUE'];
				}
				else if ( count( $data['comp'] ) )
				{
					$look = array();
					
					foreach ( $data['comp'] as $comp )
					{
						$look[] = $fields[ $comp ];
					}
					
					$def_data[ implode( ':', $look ) ] = $fields;
				}
				else if ( $data['settings'] )
				{
					if ( in_array( $data['settings'], array_keys( $row ) ) )
					{
						$def_data[ str_replace( ' ', '_', $row[ $data['key'] ]['VALUE'] ) ] = $fields;
					}
				}
				else
				{
					$data['key'] = $data['xml_key'] ? $data['xml_key'] : $data['key'];
					$def_data[ str_replace( ' ', '_', $row[ $data['key'] ]['VALUE'] ) ] = $fields;
				}
			}
		}
		
		//-----------------------------------------
		// Check if we have any IPS modules
		//-----------------------------------------
		
		if ( $this->has_gallery == 1 )
		{
			$def_data = $this->process_module( $def_data, $data, 'gallery' );
		}
		
		if ( $this->has_blogs == 1 )
		{
			$def_data = $this->process_module( $def_data, $data, 'blog' );
		}
		
		if ( $this->has_downloads == 1 )
		{
			$def_data = $this->process_module( $def_data, $data, 'idm' );
		}
		
		return $def_data;
	}
	
	/*-------------------------------------------------------------------------*/
	// Compare the big ass arrays
	/*-------------------------------------------------------------------------*/
	
	function compare_loop( $data=array(), $ipb_data=array(), $def_data=array() )
	{
		//-----------------------------------------
		// Init some variables
		//-----------------------------------------
		
		$extra_data = array();
		
		//-----------------------------------------
		// Loop!
		//-----------------------------------------
		
		foreach ( $ipb_data as $title => $content )
		{
			if ( $data['multi'] )
			{
				if ( $data['tmpl'] )
				{
					if ( !in_array( $title, array_keys( $def_data ) ) )
					{
						foreach ( $content as $idx => $field )
						{
							$extra_data[ $idx ] = array( 'primary'   => $field,
												   'secondary' => $title
												 );
						}
					}
					else
					{
						foreach ( $content as $idx => $field )
						{
							if ( !in_array( $field, $def_data[ $title ] ) )
							{
								$extra_data[ $idx ] = array( 'primary'   => $field,
													   'secondary' => $title
													 );
							}
						}
					}
				}
				else
				{
					if ( in_array( $title, array_keys( $def_data ) ) )
					{
						foreach ( $content as $field )
						{
							if ( !in_array( $field, $def_data[ $title ] ) )
							{
								$extra_data[] = array( 'primary'   => $field,
													   'secondary' => $title
													 );
							}
						}
					}
				}
			}
			else
			{
				if ( !in_array( $title, array_keys( $def_data ) ) )
				{
					$index = $data['schema'] ? $content[ $data['output'] ] : $content[ $data['index'] ];
					$extra_data[ $index ] = array( 'primary'   => $content[ $data['output'] ],
												   'secondary' => $content[ $data['second'] ],
												 );
				}
			}
		}
		
		foreach ( $extra_data as $k => $v )
		{
			if ( !$v['secondary'] )
			{
				unset( $extra_data[ $k ]['secondary'] );
			}
		}
		
		return $extra_data;
	}
	
	/*-------------------------------------------------------------------------*/
	// Display the tool compare results
	/*-------------------------------------------------------------------------*/
	
	function build_output( $data=array(), $extra_data=array() )
	{
		//-----------------------------------------
		// Basic admin page stuff
		//-----------------------------------------
		
		$this->ipsclass->admin->page_title  = "(FSY22) DB Customization Manager: Results";
		$this->ipsclass->admin->page_detail = "This page lists the extra items the component found.  From here you can manage the notes for individual items that indicate why the item was added, or you can delete the item.  <b>Please remember</b> that there is no undo for the delete command, so be very sure you want to delete the item before doing so.";
		$this->ipsclass->admin->nav[]       = array( '', 'Results' );
		
		//-----------------------------------------
		// Find our notes
		//-----------------------------------------
		
		$notes  = array();
		$_notes = array();
		
		$this->ipsclass->DB->build_query( array( 'select' => '*',
												 'from'   => 'dbm_notes',
												 'where'  => "code='{$data['code']}'",
										)	   );
		$this->ipsclass->DB->exec_query();
		
		if ( $this->ipsclass->DB->get_num_rows() )
		{
			while ( $note = $this->ipsclass->DB->fetch_row() )
			{
				$notes[ $note['note_key'] ] = $note;
			}
		}
		
		//-----------------------------------------
		// Build the table
		//-----------------------------------------
		
		$this->ipsclass->html .= $this->dbm_javascript();
		
		if ( $data['second'] )
		{
			$this->ipsclass->adskin->td_header[] = array( $data['head_title'] , "15%" );
			$this->ipsclass->adskin->td_header[] = array( $data['sec_title']  , "15%" );
			$this->ipsclass->adskin->td_header[] = array( "Notes"             , "60%" );
		}
		else
		{
			$this->ipsclass->adskin->td_header[] = array( $data['head_title'] , "25%" );
			$this->ipsclass->adskin->td_header[] = array( "Notes"             , "65%" );
		}
		
		$this->ipsclass->adskin->td_header[] = array( "<input name='allbox' type='checkbox' value='Check All' onClick='CheckAll();'>" , "10%" );
		
		$this->ipsclass->html .= <<<EOF
<form action='{$this->ipsclass->base_url}&section={$this->ipsclass->section_code}&act=db_manager&code=do_update' method='post' name='theForm' id='theForm'>
<input type='hidden' name='tool' value='{$data['code']}' />
<input type='hidden' name='_admin_auth_key' value='{$this->ipsclass->_admin_auth_key}' />
EOF;
		
		$this->ipsclass->html .= $this->ipsclass->adskin->start_table( $data['tbl_title'] );
		
		$total = 0;
		$noted = 0;
		
		if ( count( $extra_data ) )
		{
			foreach ( $extra_data as $id => $ed )
			{
				if ( $data['second'] )
				{
					$clean    = $ed['primary'].'^'.$ed['secondary'];
					$note     = in_array( $clean, array_keys( $notes ) ) ? $notes[ $clean ]['note'] : '<i>None</i>';
					$_notes[] = $clean;
					
					$total++;
					
					if ( in_array( $clean, array_keys( $notes ) ) )
					{
						$noted++;
					}
					
					$value = $data['tmpl'] ? $id : $clean;
					
					$to_show = array( "<b>{$ed['primary']}</b>",
									  $ed['secondary'],
									  $note,
									  "<div align='center'><input name='ids[]' value='{$value}' type='checkbox' onClick=\"CheckCheckAll();\"></div>",
									 );
				}
				else
				{
					$clean    = str_replace( ' ', '_', $ed['primary'] );
					$note     = in_array( $clean, array_keys( $notes ) ) ? $notes[ $clean ]['note'] : '<i>None</i>';
					$_notes[] = $clean;
					
					$total++;
					
					if ( in_array( $clean, array_keys( $notes ) ) )
					{
						$noted++;
					}
					
					$to_show = array( "<b>{$ed['primary']}</b>",
									  $note,
									  "<div align='center'><input name='ids[]' value='{$id}' type='checkbox' onClick=\"CheckCheckAll();\"></div>",
									 );
				}
				
				$this->ipsclass->html .= $this->ipsclass->adskin->add_td_row( $to_show );
			}
		}
		else
		{
			$this->ipsclass->html .= $this->ipsclass->adskin->add_td_basic( "<div align='center'><b>{$data['none']}</b></div>", 'center', 'tablerow1' );
		}
		
		$this->ipsclass->html .= $this->ipsclass->adskin->add_td_basic( "Back to: <a href='{$this->ipsclass->base_url}&amp;{$this->ipsclass->form_code}&amp;code=overview'>View Cleanup Tools</a>", "center", "tablerow1" );
		
		$this->ipsclass->html .= $this->ipsclass->adskin->add_td_basic( "With selected: <select id='button' name='to_run'>
													<option value='note'>Manage Notes</option>
													<option value='delete'>Delete</option>
												  </select>
												 <input type='submit' value='Go!' class='realbutton'>", "right", "tablefooter" );
		
		$this->ipsclass->html .= $this->ipsclass->adskin->end_table();
		
		$this->ipsclass->html .= $this->ipsclass->adskin->end_form();
		
		//-----------------------------------------
		// Copyright
		//-----------------------------------------
		
		$this->ipsclass->html .= $this->ipsclass->adskin->add_standalone_row( "(FSY22) DB Customization Manager v{$this->dbcm_ver}, by <a href='http://www.invisionmodding.com/' target='_blank'>Michael</a>, &copy; ".date("Y"), 'center', 'tablefooter' );
		
		//-----------------------------------------
		// Update the tool
		//-----------------------------------------
		
		$this->ipsclass->DB->do_update( 'dbm_tools', array( 'lastrun' => time(), 'total_entries' => $total, 'noted_entries' => $noted ), "code='{$data['code']}'" );
		
		//-----------------------------------------
		// Prune any dead notes
		//-----------------------------------------
		
		$dead = array();
		
		foreach ( $notes as $note_key => $note_data )
		{
			if ( !in_array( $note_key, $_notes ) )
			{
				$dead[] = $note_key;
			}
		}
		
		$this->ipsclass->DB->do_delete( 'dbm_notes', "note_key IN('".implode( "','", $dead )."')" );
		
	}
	
	/*-------------------------------------------------------------------------*/
	// Grab info for the official IPS modules
	/*-------------------------------------------------------------------------*/
	
	function process_module( $def_data=array(), $data=array(), $module='' )
	{
		$mod_path = $module.'_inst_dir';
		
		if ( $data['schema'] )
		{
			//-----------------------------------------
			// Load the module install file
			//-----------------------------------------
			
			require_once( ROOT_PATH.$this->$mod_path.'/installfiles/install/mysql_tables.php' );
			
			//-----------------------------------------
			// Loop through each command
			//-----------------------------------------
			
			foreach ( $SQL as $v )
			{
				$pos = strpos( $v, 'ALTER TABLE' );
				
				if ( $pos !== false )
				{
					$line_data = explode( " ", trim( str_replace( "\t", " ", $v ) ) );
					$def_data[ $line_data[2] ][] = $line_data[4];
				}
				else
				{
					$split    = explode( "\n", $v );
					$tbl_line = explode( " ", $split[0] );
					$tbl_line[2] = trim( str_replace( '(', '', $tbl_line[2] ) );
					
					foreach ( $split as $line => $data )
					{
						if ( $line == 0 )
						{
							continue;
						}
						
						$line_data = explode( " ", trim( str_replace( "\t", " ", $data ) ) );
						
						if ( !in_array( $line_data[0], $this->bad_lines ) )
						{
							$fields[] = $line_data[0];
						}
						
						unset( $line_data );
					}
					
					$def_data[ $tbl_line[2] ] = $fields;
					
					unset( $fields );
				}
			}
			
			//-----------------------------------------
			// Kill the $SQL variable
			//-----------------------------------------
			
			unset( $SQL );
		}
		else
		{
			//-----------------------------------------
			// Get the data from the resources XML
			//-----------------------------------------
			
			if ( file_exists( ROOT_PATH.'resources/'.$module.'/'.$module.'_'.$data['mod_file'].'.xml' ) )
			{
				$this->class_xml->xml_parse_document( file_get_contents( ROOT_PATH.'resources/'.$module.'/'.$module.'_'.$data['mod_file'].'.xml' ) );
				$temp_array = $this->class_xml->xml_array[ $data['m_1'] ][ $data['m_2'] ];
				
				if ( !is_array( $temp_array[ $data['m_3'] ][0] ) )
				{
					$tmp = $temp_array[ $data['m_3'] ];
					unset( $temp_array[ $data['m_3'] ] );
					$temp_array[ $data['m_3'] ][0] = $tmp;
				}
				
				foreach ( $temp_array[ $data['m_3'] ] as $row )
				{
					$fields = array();
					
					foreach ( $row as $key => $value )
					{
						if ( $key != 'VALUE' )
						{
							$fields[ $key ] = $value['VALUE'];
						}
					}
					
					if ( $data['tmpl'] )
					{
						$def_data[ $row[ $data['key2'] ]['VALUE'] ][] = $row[ $data['key'] ]['VALUE'];
					}
					else
					{
						$def_data[ str_replace( ' ', '_', $row[ $data['key'] ]['VALUE'] ) ] = $fields;
					}
				}
			}
			else if ( file_exists( ROOT_PATH.$this->$mod_path.'/installfiles/install/mysql_inserts.php' ) )
			{
				require_once( ROOT_PATH.$this->$mod_path.'/installfiles/install/mysql_inserts.php' );
				
				//-----------------------------------------
				// Loop through each command
				//-----------------------------------------
				
				if ( count( $SQL ) )
				{
					foreach ( $SQL as $v )
					{
						$pos = strpos( $v, 'INSERT INTO '.SQL_PREFIX.$data['table'] );
						
						if ( $pos !== false )
						{
							$line_data = explode( ",", trim( str_replace( "\t", " ", $v ) ) );
							$def_data[ trim( str_replace( '\'', '', $line_data[ $data['idx'] ] ) ) ] = 1;
						}
					}
				}
				
				//-----------------------------------------
				// Kill the $SQL variable
				//-----------------------------------------
				
				unset( $SQL );
			}
		}
		
		return $def_data;
	}
	
	/*-------------------------------------------------------------------------*/
	// Update all IPB caches (except calendar events, for some reason...)
	/*-------------------------------------------------------------------------*/
	
	function update_all_caches()
	{
		//-----------------------------------------
		// All the caches
		//-----------------------------------------
		
		$caches = array( 'forum_cache', 'group_cache', 'systemvars', 'skin_id_cache', 'moderators', 'stats', 'ranks', 'profilefields', 'birthdays', 'calendars', 'multimod', 'bbcode', 'settings', 'emoticons', 'badwords', 'languages', 'banfilters', 'attachtypes', 'announcements', 'components' );
		
		//-----------------------------------------
		// Loop and update
		//-----------------------------------------
		
		foreach ( $caches as $cache )
		{
			$this->class_cache->cache_end( $cache, 1 );
		}
		
		//-----------------------------------------
		// No messages, please
		//-----------------------------------------
		
		unset( $this->ipsclass->main_msg );
	}
	
	/*-------------------------------------------------------------------------*/
	// Update all skin caches
	/*-------------------------------------------------------------------------*/
	
	function update_skin_caches()
	{
		//-----------------------------------------
		// Load the Lib class
		//-----------------------------------------
		
		$lib = $this->ipsclass->load_class( ROOT_PATH.'sources/lib/admin_cache_functions.php', 'admin_cache_functions' );
		
		//-----------------------------------------
		// Rebuild
		//-----------------------------------------
		
		$lib->_rebuild_all_caches( array_keys( $this->ipsclass->cache['skin_id_cache'] ) );
	}
	
	/*-------------------------------------------------------------------------*/
	// Our javascript code, just cuz I want to keep it isolated from the rest of the HTML
	/*-------------------------------------------------------------------------*/
	
	function dbm_javascript()
	{
		$html = <<<EOF
<script type="text/javascript">
function CheckAll( cb )
{
    var fmobj = document.theForm;
    
    for ( var i=0; i<fmobj.elements.length; i++ )
    {
        var e = fmobj.elements[i];
        
        if ( ( e.name != 'allbox' ) && ( e.type=='checkbox' ) && ( !e.disabled ) )
        {
            e.checked = fmobj.allbox.checked;
        }
    }
}

function CheckCheckAll( cb )
{	
    var fmobj = document.theForm;
    var TotalBoxes = 0;
    var TotalOn = 0;
    
    for ( var i=0; i<fmobj.elements.length; i++)
    {
        var e = fmobj.elements[i];
        
        if ( ( e.name != 'allbox' ) && ( e.type=='checkbox' ) )
        {
            TotalBoxes++;
            
            if ( e.checked )
            {
                TotalOn++;
            }
        }
    }
    
    if ( TotalBoxes==TotalOn )
    {
		fmobj.allbox.checked=true;
	}
    else
    {
		fmobj.allbox.checked=false;
	}
}
</script>
EOF;
		
		return $html;
	}
}

?>