<?php

/*
	english.php - English language file
	Created: January 16, 2001
	Author: Alex Suzuki, Cynox webdesign

	This is a language file. You can alter it to fit your language. For example if were to make a russian
	one, name it "russian.php" and put into the "lang" subdirectory along with the other language files.
	Then start editing the variables. Note that there are pieces of text that are actually format strings
	(those including a %s) somewhere in the text. Those %s have to be there, they are placeholders for
	information that is dynamically inserted at run-time. Mostly their content is self-explaining.
	
	If you have created a language file for a language that is not yet supported (in the official release),
	please email it to me (yes I will mention your name somewhere :). It will then be included in the next
	release.
*/


/*
	Variables for index.php
*/

$t_overview_upper_right = "%s registered users | Most active user: %s (%s posts) | <b>%s users online</b>";
$t_welcome = "Welcome";

$t_login = "Login";
$t_guest_access = "Guest access granted. You have to <a href=\"register.php\">register</a> if you want to post messages.";
$t_username = "Username";
$t_password = "Password";
$t_logged_in = "Logged in";
$t_reguser_welcome_phrase = "Welcome, <b>%s</b>."; // %s = username
$t_reguser_rights = "You have <b>%s</b> rights."; // %s = rights (admin, moderator, normal)

$t_search = "Search in Forums";
$t_find = "Find:";
$t_infield = "in Field:";
$t_search_subject = "Subject";
$t_search_text = "Text";
$t_indiscussion = "in Forum:";

$t_forums = "Forums";
$t_forumname = "Name";
$t_new = "New";
$t_total = "Total";
$t_lastpost = "Last post";
$t_fdesc = "Description";

/* Added for Release 0.19 */
$t_cookie_remember_box = " Remember (needs cookies)";



/*
	Variables for profile.php
*/

$t_update_confirmation = "Profile updated, you'll have to relogon!";
$t_general_info = "General information for %s"; // %s = username
$t_real_name = "Real name";
$t_emailaddr = "Email";
$t_newpwd = "New Password";
$t_repeatpwd = "Repeat Password";

$t_preferences = "Preferences: ";
$t_threadsperpage = "Threads per page: ";
$t_signature = "Signature: ";


/*
	Variables for show.php
*/

$t_foruminfo = "(%s Threads, %s Messages total)";
$t_usersonline = "%s user(s) online";

$t_post_new_topic = "Post new topic";
$t_collapse_threads = "Collapse Threads";
$t_expand_threads = "Expand Threads";

$t_previous_page = "Previous Page";
$t_next_page = "Next Page";

$t_subject_field = "Subject";
$t_author_field = "Author";
$t_date_field = "Date";

$t_one_reply = "(1 reply)";
$t_many_replies = "(%s replies)";
$t_delete_thread = "Delete Thread";

$t_user_info = "User Info";
$t_text = "Text";
$t_user_posts = "(%s posts total, last post: %s)";
$t_replies_to_this_msg = "Replies to this post";
$t_postinfo = ", posted by <b>%s</b>, [%s], %s. Viewed <b>%s</b> times.";
$t_reply_to_msg = "Reply to this post";


/*
	Variables for register.php
*/

$t_terms_of_usage = "Terms of usage";
$t_userinformation = "User information";
$t_reg_info = "As soon as you've registered, your password will be emailed to you.";

$t_regmail_head = "You have registered for a Cyphor forum (%s). This is your confirmation.";
$t_regmail_user = "Your username is: ";
$t_regmail_pass = "Your password is: ";
$t_regmail_info = "The forum's URL is: ";
$t_regmail_subject = "[Cyphor] Registration successful!";
$t_reg_conf = "Registration successful! You will receive your confirmation to: %s"; // %s = email


/*
	Variables for search.php
*/

$t_search = "Search";
$t_results = "%s results for forum \"%s\" found.";
$t_found_nothing = "No results for forum \"%s\" found.";
$t_search_again = "Search again";

/*
	Variables for send.php
*/

$t_message_posted = "Message posted.";
$t_view_your_message = "View your message";
$t_mail_header = "%s has replied to your message in forum '%s'"; // %s = nickname, forum name
$t_mail_link = "This link will take you directly to his/her message";
$t_mail_subject = "[Cyphor] Reply to: %s"; // %s = subject of message

/*
	Variables for newmsg.php
*/

$t_new_msg_in_forum = "New message in forum \"%s\""; // %s = forum name
$t_new_reply_in_forum = "Reply to \"%s\" in forum \"%s\""; // %s = subject of parent msg | forum name
$t_post_rules = "Line breaks are processed, you don't need to force them through &lt;BR&gt;. HTML tags will be filtered! Links will automatically be generated.";
$t_msg_from_field = "From: ";
$t_msg_subject_field = "Subject: ";
$t_msg_text_field = "Text: ";
$t_email_notification = "Notify me when someone replies to this message.";
$t_attach_sig = "Attach my personal signature to this message.";

/*
	Variables for lost_pwd.php
*/

$t_enter_email_address = "Enter email";
$t_lostpwd_info = "You can have a new password emailed to you by providing your username and email address. Cyphor will then email the new password we have associated with the email address you provide. This information will be sent to the email address you type below.";
$t_pwd_sent = "New password sent.";

/*
	Globals	
*/

$t_btnupdate = "Update Profile";
$t_btnsignup = "Sign up!";
$t_btnsearch = "Search";
$t_btnresetform = "Reset Form";
$t_btnpostmsg = "Post message";
$t_btnquote = "Quote original message";
$t_back_link = "Back";
$t_invalid_query = "Invalid query!";
$t_btnsubmit = "Submit";

/*
	Footer
*/

$t_forums_overview = "Forums Overview";
$t_back_to_forum = "Back to the forum";
$t_register = "Register";
$t_edit_profile = "Edit Profile";
$t_logout = "Logout";
$t_administration = "Administration";
$t_btngo = "Go";
$t_jump_to = "Jump to...";
$t_lost_password = "Lost your password?";

/*
	Error messages
*/

$terr_not_logged_in = "Not logged in!";
$terr_no_admin_rights = "User does not have admin rights!";
$terr_no_forum = "No forum specified!";
$terr_login_failed = "Login failed!";
$terr_required_fields = "You have not specified all required fields!";
$terr_pwd_match = "Passwords do not match!";

$terr_nick_alpha = "Nickname must be alpha-numeric!";
$terr_nick_len = "Nickname must be atleast 3 characters!";
$terr_nick_reg = "Nickname has already been registered!";
$terr_dbl_email = "Somebody with the same email address has already registered!";





?>