<?
    ## SETTINGS.INC
    ## Cyphor configuration file

    # Database settings
    ###################

	class DB_Cyphor extends DB_Sql {
        var $classname = "DB_Cyphor";	
	
        # Host
        #
        # The address of the computer where MySQL is running, probably localhost,
        # if on same host like Webserver
        #
        var $Host     = "localhost";

        # Database
        # 
        # Name of the MySQL database where Cyphor will save it's data.
        # The database must exist!
        #
        var $Database = "cyphor";

        # User
        # 
        # Name of the MySQL user with the following MySQL permissions
        # (SELECT, INSERT, DELETE, UPDATE, CREATE, DROP)
        #
        var $User     = "mysql_username_here";

        # Password
        # 
        # The password for the MySQL user.
       	#
        var $Password = "mysql_password_here";

        function haltmsg($msg) {
            global $admin_email;
            printf("</td></table><b>MySQL Error:</b> %s<br>\n", $msg);
            printf("<b>Database error</b>: %s (%s)<br>\n", $this->Errno, $this->Error);
            printf("Please contact us [<a href=\"mailto:%s\">%s</a>] and specify the exact error message.<br>\n", $admin_email, $admin_email);
        }
    }

    # General settings
    ##################

    # forum_title
    #
    # This specifies a name for your forum (e.g. "My Discussions"), it will appear in various
    # places, including email notifications.
    #
    $forum_title = "My Discussions";

    # forum_url
    #
    # The URL of your forum. Something like http://www.mydomain.com/cyphor, don't put a
    # slash at the end of it!!! You need to set this value if you want the email notifications
    # to work properly (so the users will get the right links!)
    #
    $forum_url = "http://www.mydomain.com/cyphor";

    # admin_email
    #
    # the emailaddress of the board administrator. Users will get this address
    # displayed when they receive error messages
    #
    $admin_email = "admin@domain.ext";

    # timezone_hours
    # 
    # If your server is located in another timezone just specify the time
    # offset in hours. If you're in the same timezone just set it to 0 (default)
    #
    $timezone_hours = 0;

    # timezone_inc
    #
    # Used internally, do not modify
    #
    $timezone_inc = $timezone_hours * 3600;
    
    # auto_expire
    #
    # If this is set to 1, messages will automatically be deleted when they
    # are older than $msg_expired_days (defined below). Default = 0. If it's zero, messages
    # have to be deleted via the administration console
    #
    $auto_expire = 0;
    
    # msg_expired_days
    # 
    # Sets how many days a thread "lives", after that ammount of days
    # the thread including all it's submessages  will be "old" and deleted.
    # Default = 20. This option will only be useful when you set auto_expire to 1
    #
	$threads_expire_days = 20;

    # block_multiple_email
    #
    # Set this to 1 if you don't want users to sign up more than once
    # with the same email address.
    #
    $block_multiple_email = 1;
    
    # how_long_is_new
    #
    # Sets how long (in days) a message should be considered "new"
    #
	$how_long_is_new = 2;
	
	# display_hostname
	#
	# Set this to 1 if you want the hostname (in a form of ---.microsoft.com) to
	# be displayed in posts, set it to 0 if you don't want it. (Default = 1)
	#
	$display_hostname = 1;
	
	# language
	#
	# Sets the forum language. Possible values are:
	#	"english" will select english language and include lang/english.php
	#	"german" will select german langauge an include lang/german.php
	# ...
	$language = "english";
	
	# max_subject_length
	#
	# The maximum length of a subject header. If the subject is actually
	# longer, it will be truncated and "..." will be appended to the end
	# of the string. The subject itself will _not_ be altered. It will
	# just be displayed in a shorter, more convenient form. This also
	# prevents really long subject lines from screwing up the layout
	#
	# default = 60 chars
	$max_subject_length = 60;

	# max_subject_length_decrement
	#
	# The amount of characters that should be substracted from the maximum
	# subject length depending on the nesting level.
	# Example: The top item has a maximum subject length of $max_subject_length	
	# All replies to this item have maximum length of
	# $max_subject_length - (1 * $max_subject_length_decrement)
	# All second-replies have $max_subject_length - (2 * $max_subject_length_decrement)
	# and so on...
	#
	# default = 5 chars;
	$max_subject_length_decrement = 5;
	
	# cookie_remember_time
	#
	# Sets the amount of seconds for which cookies should stay on user's
	# computer.
	#
	# default = 10 days
	$cookie_remember_time = 10 * 24 * 60 * 60;

	# tbl_prefix (Table prefix)
	#
	# This prefix will be appended to every table name Cyphor uses.
	# This is especially useful for people that have only one database
	# or already have tables called "users", "forums" etc.
	# The default setting is "cyphor_", so all table names will begin
	# with cyphor_, e.g. cyphor_forums, cyphor_users etc.
	#
	$tbl_prefix = "cyphor_";
	
    # End of configuration file. Have fun.
?>
