<?php 
###########################################################
##                                                       ##
##            WEB//NEWS Newsmanagement Script            ##
##                (c) Copyright 2002-2003                ##
##                  by Christian Scheb                   ##
##                                                       ##
###########################################################



//*********************************************************
//********************  DEFINE CLASS  *********************
//*********************************************************

if ( !is_object($WN) ) {

class webnews_parser {
var $dir;
var $set      = array();
var $file     = array();
var $cache    = array();
var $htmlcode = array();
var $result   = 0;
var $fetched  = array();



//*********************************************************
//******************  MYSQL FUNCTIONS  ********************
//*********************************************************

	//Datenbankanfrage
	function query($query) {
	$this->result=@mysql_query($query,CONN);
		if ( !$this->result ) $this->error("MySQL-Error: ".mysql_error()."<br>Anfrage: ".$query);
		return $this->result;
	}
	
	//Datenbankanfrage (nur die erste Reihe)
	function first($query,$type=MYSQL_BOTH) {
	$this->result=@mysql_query($query,CONN);
		if ( !$this->result ) {
		$this->error("MySQL-Error: ".mysql_error()."<br>Anfrage: ".$query);
		return array();
		}
	$this->fetched=@mysql_fetch_array($this->result,$type);
	$this->free();
	return $this->fetched;
	}
	
	//Array holen
	function fetch($result=-1,$type=MYSQL_BOTH) {
		if ( $result!=-1 ) $this->result=$result;
	$this->fetched=@mysql_fetch_array($this->result,$type);
	return $this->fetched;
	}
	
	//Anfrage "befreien"
	function free($result=-1) {
		if ( $result!=-1 ) $this->result=$result;
	@mysql_free_result($this->result);
	}
	
	//Gibt 1 zurck wenn das Ergebnis mindestens eine Reihe enthlt
	function checkres($result=-1) {
		if ( $result!=-1 ) $this->result=$result;
	if ( @mysql_num_rows($this->result) ) return 1;
	else return 0;
	}
	
	//Verbindung schlieen
	function close() {
	mysql_close(CONN);
	}
	
	//MySQL-Error schreiben
	function error($text) {
	echo'<p><b>Schwerer Ausnahmefehler!</b><br>'.$text.'</p>';
	}



//*********************************************************
//*****************  REPLACE FUNCTIONS  *******************
//*********************************************************

	//Stripslashes
	function strpsl(&$array) {
	reset($array);
		foreach($array AS $key => $val) {
			if(is_string($val)) $array[$key]=trim(stripslashes($val));
			elseif(is_array($val)) $array[$key]=$this->strpsl($val);
		}
	return $array;
	}

	//Replace
	function replace($text,$blocker=-1) {
	$text=htmlentities($text);
		if ( $blocker==-1 ) $text=nl2br($text);
	return $text;
	}
	
	//Mark
	function mark($text) {
	$mark=explode(" ",$_REQUEST['mark']);
		foreach ( $mark AS $m ) {
		$m=str_replace('/','\/',addslashes($m));
		$text=preg_replace("/((<[^>]*)|$m)/ie", '"\2"=="\1"? "\1":"<font color=\"red\"><b>\1</b></font>"', $text);
		}
	return $text;
	}
	
	//Liste generieren
	function makelist($text,$type) {

	$lines=explode("<br />",trim(str_replace('<br>','<br />',str_replace('\"','"',$text)))); //Trim String and Explode it
		foreach( $lines AS $value ) {
		$data=trim($value);
			if ( substr($data,0,3)=="[*]" ) $list.='<li>'.substr($data,3).'</li>';
		}
		
		if ( $type=="1" ) $list='<ol>'.$list.'</ol>';
		elseif ( $type=="a" || $type=="A" || $type=="i" || $type=="I" ) $list='<ol type="'.$type.'">'.$list.'</ol>';
		else $list='<ul>'.$list.'</ul>';
		
	return $list;
	}
	
	//Codes
	function codes($text) {
		if ( $this->set['usecode'] ) {
		
		//Text
		$text = preg_replace("/\[b\](.*?)\[\/b\]/si", "<b>\\1</b>", $text);
		$text = preg_replace("/\[i\](.*?)\[\/i\]/si", "<i>\\1</i>", $text);
		$text = preg_replace("/\[u\](.*?)\[\/u\]/si", "<u>\\1</u>", $text);
		$text = preg_replace("/\[s\](.*?)\[\/s\]/si", "<s>\\1</s>", $text);
		
		//Absatz
		$text = preg_replace("/\[left\](.*?)\[\/left\]/si", "<div align=\"left\">\\1</div>", $text);
		$text = preg_replace("/\[center\](.*?)\[\/center\]/si", "<div align=\"center\">\\1</div>", $text);
		$text = preg_replace("/\[right\](.*?)\[\/right\]/si", "<div align=\"right\">\\1</div>", $text);
		
		//Links
		$text = preg_replace("/\[url\](.*?)\[\/url\]/si", "<a href=\"\\1\" target=\"_blank\">\\1</a>", $text);
		$text = preg_replace("/\[url=(.*?)\](.*?)\[\/url\]/si", "<a href=\"\\1\" target=\"_blank\">\\2</a>", $text);
		$text = preg_replace("/\[urlin\](.*?)\[\/urlin\]/si", "<a href=\"\\1\">\\1</a>", $text);
		$text = preg_replace("/\[urlin=(.*?)\](.*?)\[\/urlin\]/si", "<a href=\"\\1\">\\2</a>", $text);
		$text = preg_replace("/\[mail\](.*?)\[\/mail\]/si", "<a href=\"mailto:\\1\">\\1</a>", $text);
		$text = preg_replace("/\[mail=(.*?)\](.*?)\[\/mail\]/si", "<a href=\"mailto:\\1\">\\2</a>", $text);
		
		//Font Format
		$text = preg_replace("/\[font=(.*?)\](.*?)\[\/font\]/si", "<font face=\"\\1\">\\2</font>", $text);
		$text = preg_replace("/\[size=(.*?)\](.*?)\[\/size\]/si", "<font size=\"\\1\">\\2</font>", $text);
		$text = preg_replace("/\[color=(.*?)\](.*?)\[\/color\]/si", "<font color=\"\\1\">\\2</font>", $text);
		
		//Liste
		$text = preg_replace("/\[list\](.*?)\[\/list\]/sie", "\$this->makelist('\\1','');", $text);
		$text = preg_replace("/\[list=(.*?)\](.*?)\[\/list\]/sie", "\$this->makelist('\\2','\\1');", $text);
		
			//Image Codes
			if ( $this->set['useimg'] ) {
			$text = preg_replace("/\[img\](.*?)\[\/img\]/si", "<img src=\"\\1\" alt=\"\" border=\"0\">", $text);
			$text = preg_replace("/\[img\=center](.*?)\[\/img\]/si", "<div align=\"center\"><img src=\"\\1\" alt=\"\" border=\"0\"></div>", $text);
			$text = preg_replace("/\[img\=(.*?)](.*?)\[\/img\]/si", "<img src=\"\\2\" alt=\"\" border=\"0\" align=\"\\1\" vspace=\"".$this->set['vspace']."\" hspace=\"".$this->set['hspace']."\">", $text);
			$text = preg_replace("/\[popup=(.*?)\](.*?)\[\/popup\]/si", "<a href=\"\\1\" target=\"_blank\"><img src=\"\\2\" alt=\"\" border=\"0\"></a>", $text);
			}
		}
		
		//Smilies
		if ( $this->set['usesmilies'] ) {
			foreach ( $this->set['smilies'] AS $datei => $code ) $text=str_replace($code,'<img src="'.$this->set['location'].'/parse/smilies/'.$datei.'.gif" border="0">',$text);
		}
	return $text;
	}
	
	//Codes
	function comcodes($text) {
		if ( $this->set['allowcode'] ) {
		$text = preg_replace("/\[b\](.*?)\[\/b\]/si", "<b>\\1</b>", $text);
		$text = preg_replace("/\[i\](.*?)\[\/i\]/si", "<i>\\1</i>", $text);
		$text = preg_replace("/\[u\](.*?)\[\/u\]/si", "<u>\\1</u>", $text);
		$text = preg_replace("/\[s\](.*?)\[\/s\]/si", "<s>\\1</s>", $text);
		
		$text = preg_replace("/\[url\](.*?)\[\/url\]/si", "<a href=\"\\1\" target=\"_blank\">\\1</a>", $text);
		$text = preg_replace("/\[url=(.*?)\](.*?)\[\/url\]/si", "<a href=\"\\1\" target=\"_blank\">\\2</a>", $text);
		$text = preg_replace("/\[mail\](.*?)\[\/mail\]/si", "<a href=\"mailto:\\1\">\\1</a>", $text);
		$text = preg_replace("/\[mail=(.*?)\](.*?)\[\/mail\]/si", "<a href=\"mailto:\\1\">\\2</a>", $text);
		
			if ( $this->set['allowimg'] ) $text = preg_replace("/\[img\](.*?)\[\/img\]/si", "<img src=\"\\1\" alt=\"\" border=\"0\">", $text);
		}
		
		if ( $set['allowsmilies'] ) {
			foreach ( $this->set['smilies'] AS $datei => $code ) $text=str_replace($code,'<img src="'.$this->set['location'].'/parse/smilies/'.$datei.'.gif" border="0">',$text);
		}
	return $text;
	}
	
	//Text Codes only
	function textcodes($text) {
		if ( $this->set['usecode'] ) {
		$text = preg_replace("/\[b\](.*?)\[\/b\]/si", "<b>\\1</b>", $text);
		$text = preg_replace("/\[i\](.*?)\[\/i\]/si", "<i>\\1</i>", $text);
		$text = preg_replace("/\[u\](.*?)\[\/u\]/si", "<u>\\1</u>", $text);
		$text = preg_replace("/\[s\](.*?)\[\/s\]/si", "<s>\\1</s>", $text);
		
		/*v 1.3 -> entfernt wegen links
		$text = preg_replace("/\[url\](.*?)\[\/url\]/si", "<a href=\"\\1\" target=\"_blank\">\\1</a>", $text);
		$text = preg_replace("/\[url=(.*?)\](.*?)\[\/url\]/si", "<a href=\"\\1\" target=\"_blank\">\\2</a>", $text);
		$text = preg_replace("/\[urlin\](.*?)\[\/urlin\]/si", "<a href=\"\\1\">\\1</a>", $text);
		$text = preg_replace("/\[urlin=(.*?)\](.*?)\[\/urlin\]/si", "<a href=\"\\1\">\\2</a>", $text);
		$text = preg_replace("/\[mail\](.*?)\[\/mail\]/si", "<a href=\"mailto:\\1\">\\1</a>", $text);
		$text = preg_replace("/\[mail=(.*?)\](.*?)\[\/mail\]/si", "<a href=\"mailto:\\1\">\\2</a>", $text);*/
		}
	return $text;
	}
	
	//Badwords
	function badwords($text) {
		if ( is_array($this->set['badwords']) && count($this->set['badwords'])!=0 ) foreach ( $this->set['badwords'] AS $find ) $text=eregi_replace($find,'#%$!',$text);
	return $text;
	}
	
	//Aliases
	function aliases($text) {
		if ( is_array($this->set['alias']) && count($this->set['alias']) ) $text=strtr($text,$this->set['alias']);
	return $text;
	}

	//HTML-Code Cache
	function htmlcodecache($code) {
	$this->htmlcode[]=str_replace('\"','"',$code);
	return "%HTMLCODE#".(count($this->htmlcode)-1)."%";
	}
	
	//Deutsche Wochentage
	function gerday($day) {
		switch($day) {
		case 0: return "Sonntag";
		case 1: return "Montag";
		case 2: return "Dienstag";
		case 3: return "Mittwoch";
		case 4: return "Donnerstag";
		case 5: return "Freitag";
		case 6: return "Samstag";
		}
	}
	
	//Deutsche Monate
	function germon($mon) {
		switch($mon) {
		case 1: return "Januar";
		case 2: return "Februar";
		case 3: return "M&auml;rz";
		case 4: return "April";
		case 5: return "Mai";
		case 6: return "Juni";
		case 7: return "Juli";
		case 8: return "August";
		case 9: return "September";
		case 10: return "Oktober";
		case 11: return "November";
		case 12: return "Dezember";
		}
	}



//*********************************************************
//*****************  TEMPLATE FUNCTIONS  ******************
//*********************************************************
	
	//Templates laden
	function load($string) {
	$files=explode(",",$string);
		foreach ( $files AS $file ) {
		$filecache=@file($this->dir."/parse/templates/".$file.".html");
			if ( is_array($filecache) ) {
			$this->file[$file]=implode("",$filecache);
			unset($filecache);
			}
			else echo "Template ".$file.".html wurde nicht gefunden!<br>";
		}
	}
	
	//Output
	function out() {
		if ( is_array($this->cache) ) foreach ( $this->cache AS $data ) echo $data;
	unset($this->cache);
	}
	
	//Message
	function message($id,$input=array()) {
	$messages=@file($this->dir."/parse/templates/messages.html");
		if ( isset($messages[$id]) ) echo strtr($messages[$id],$input);
		else echo "WRONG ID";
	}



//*********************************************************
//*****************  GENERAL FUNCTIONS  *******************
//*********************************************************

	//Startup
	function startup($dirname) {
	$this->dir=$dirname;
	require($this->dir."/modules/config.inc.php");
	$this->set=$set;
		if ( $this->set['parseconn'] ) {
		global ${$this->set['parseconn']};
		define("CONN",${$this->set['parseconn']});
			if ( !CONN ) die("Verbindung zur Datenbank nicht gefunden!");
			if ( !@mysql_select_db($set['database'], CONN) ) die("Konnte die Datenbank ".$set['database']." nicht ausw&auml;hlen!");
		define("PRE",$set['table']);
		}
		else {
		define("CONN",@mysql_connect($set['server'], $set['user'], $set['password']));
			if ( !CONN ) die("Konnte keine Verbindung zur Datenbank herstellen!");
			if ( !@mysql_select_db($set['database'], CONN) ) die("Konnte die Datenbank ".$set['database']." nicht ausw&auml;hlen!");
		define("PRE",$set['table']);
		}
	
		if (get_magic_quotes_gpc()) {
			if(is_array($_REQUEST)) $_REQUEST=$this->strpsl($_REQUEST);
			if(is_array($_POST)) $_POST=$this->strpsl($_POST);
		}
	}
	
	//End
	function endscript() {
		if ( $this->set['closeconn'] ) $this->close();
		//One (!) Script has finished now
	}
	
	//if string
	function iif($arg,$string,$elsestring="") {
		if ( $arg ) return $string;
		else return $elsestring;
	}
	
	//Print starten
	function wnprint($type) {
	
		//NEWS
		if ( $type=="news" ) {
			if ( $_REQUEST['addcom']==1 && $this->set['usecoms'] ) require($this->dir."/parse/module_addcom.php");
			elseif ( $_REQUEST['stof'] ) require($this->dir."/parse/module_sendtofriend.php");
			else require($this->dir."/parse/module_news.php");
		}
		
		//ARCHIV
		elseif ( $type=="archiv" ) {
			if ( $_REQUEST['addcom']==1 && $this->set['usecoms'] ) require($this->dir."/parse/module_addcom.php");
			elseif ( $_REQUEST['stof'] ) require($this->dir."/parse/module_sendtofriend.php");
			elseif ( $_REQUEST['id'] ) require($this->dir."/parse/module_news.php");
			elseif ( $_REQUEST['month'] ) require($this->dir."/parse/module_news.php");
			else require($this->dir."/parse/module_archiv.php");
		}
		
		//SUCHE
		elseif ( $type=="search" ) {
			if ( $_REQUEST['id'] ) require($this->dir."/parse/module_news.php");
			elseif ( $_REQUEST['stof'] ) require($this->dir."/parse/module_sendtofriend.php");
			else require($this->dir."/parse/module_search.php");
		}
		
		//SENDNEWS
		elseif ( $type=="sendnews" ) {
			if ( $_REQUEST['sendnews']==1 ) require($this->dir."/parse/module_addnews.php");
			else require($this->dir."/parse/module_sendnews.php");
		}
		
		//LASTNEWS
		elseif ( $type=="lastnews" ) require($this->dir."/parse/module_lastnews.php");
		
		//OLDNEWS
		elseif ( $type=="oldnews" ) require($this->dir."/parse/module_oldnews.php");
		
		//PRINTNEWS
		elseif ( $type=="printnews" ) require($this->dir."/parse/module_print.php");
				
		//ELSE
		else echo"Funktion &quot;".$type."&quot; existiert nicht!";
  }
}

//Get Parser-Class
$WN=new webnews_parser;
$WN->startup($WN_BASEDIR);

} //End Object Check


?>