<?php 
###########################################################
##                                                       ##
##            WEB//NEWS Newsmanagement Script            ##
##                (c) Copyright 2002-2004                ##
##                  by Christian Scheb                   ##
##                                                       ##
###########################################################



/*****************************      DATENBANK BENUTZERDATEN      *****************************/

$set['server']     = "localhost";   //IP oder Adresses des MySQL-Servers
$set['user']       = "";            //Benutzername zum Login fr die Datenbank
$set['password']   = "";            //Passwort fr die Datenbank
$set['database']   = "";            //Name der Datenbank
$set['table']      = "wn";          //Vorangestellte Tabellenbezeichnung (Beispiel: Wre hier "wn" gesetzt, hiee die Tabelle "user" mit voller Bezeichnung "wn_user")



/**************************      DATENBANK PROFIEINSTELLUNGEN      ***************************/

$set['parseconn']  = "";            //Weist das Script an bei der News-Ausgabe eine bereits bestehende Verbindung zu verwenden. Ist Ihre Verbindung als $conn definiert, geben Sie hier "conn" an (der Variablen-Name ohne $)
                                    //Wenn Sie diesen Wert nicht setzen wird eine Verbindung mit den obenstehenden Benutzerdaten hergestellt
$set['closeconn']  = 0;             //Verbindung nach dem Ausfhren eines WN-Scripts schlieen ( 0 = nein; 1 = ja )



/**************************************      PFADE      **************************************/

$set['http']           = "http://meine-domain.de";   //HTTP-Adresse Ihrer Website (nur die Domain, ohne / am Ende!)
$set['location']       = "/webnews";                 //Pfad zum Webnews-Ordener, relativ zum Mutterverzeichnis der Domain, Pfad muss mit "/" beginnen
$set['picfolder']      = "/bilder";                  //Pfad zum Uploadordner fr Bilder, relativ zum Mutterverzeichnis der Domain, Pfad muss mit "/" beginnend

$set['newspage']       = "/news.php";                //Link zur "News"-Seite, relativ zum Mutterverzeichnis der Domain mit "/" beginnend. KEINE (!) PHP-Parameter verwenden!
$set['newsparams']     = "";                         //PHP Parameter zustzlich fr die "News"-Seite, kein "?" am Anfang!

$set['archpage']       = "/archiv.php";              //Link zur "Archiv"-Seite, relativ zum Mutterverzeichnis der Domain mit "/" beginnend. KEINE (!) PHP-Parameter verwenden!
$set['archparams']     = "";                         //PHP Parameter zustzlich fr die "Archiv"-Seite, kein "?" am Anfang!

$set['searchpage']     = "/search.php";              //Link zur "Suchen"-Seiten, relativ zum Mutterverzeichnis der Domain mit "/" beginnend. KEINE (!) PHP-Parameter verwenden!
$set['searchparams']   = "";                         //PHP Parameter zustzlich fr die "Suchen"-Seite, kein "?" am Anfang!

$set['sendnpage']      = "/sendnews.php";            //Link zur "News einsenden"-Seite, relativ zum Mutterverzeichnis der Domain mit "/" beginnend. KEINE (!) PHP-Parameter verwenden!
$set['sendnparams']    = "";                         //PHP Parameter zustzlich fr die "News einsenden"-Seiten, kein "?" am Anfang!



/*********************************       ADMINISTRATION      *********************************/

$set['title']      = "Meine Website";     //Titel, z.B. Name der Website (wird im Adminbereich in der Titelleiste angezeigt)
$set['pagelink']   = "/news.php";         //Link zur Website (vom Adminbereich aus)
$set['epp']        = 20;                  //Eintrge pro Seite zeigen
$set['smallpic']   = "__small";           //Kennzeichnung fr Thumbnail-Bilder (wird an den Bildnamen angehngt)



/**********************************       CODE-EDITOR      ***********************************/

$set['e_fonts']=array("Arial", "Arial Black", "Arial Narrow", "Book Antiqua", "Century Gothic", "Comic Sans MS", "Courier New", "Fixedsys", "Franklin Gothic Medium", "Garamond", "Georgia", "Impact", "Lucida Console", "Lucida Sans Unicode", "Microsoft Sans Serif", "Palatino Linotype", "System", "Tahoma", "Times New Roman", "Trebuchet MS", "Verdana");
$set['e_sizes']=array(1, 2, 3, 4, 5, 6, 7);
$set['e_colors']=array( "schwarz" => "black", "wei&szlig;" => "white", "himmelblau" => "skyblue", "royalblau" => "royalblue", "blau" => "blue", "dunkelblau" => "darkblue", "orange" => "orange", "orangerot" => "orangered", "blutrot" => "crimson", "rot" => "red", "ziegelrot" => "firebrick", "dunkelrot" => "darkred", "gr&uuml;n" => "green", "limone" => "limegreen", "seegr&uuml;n" => "seagreen", "pink" => "deeppink", "tomatenrot" => "tomato", "korallenrot" => "coral", "lila" => "purple", "indigo" => "indigo", "gelbbraun" => "burlywood", "sandbraun" => "sandybrown", "braun" => "sienna", "schokolade" => "chocolate", "t&uuml;rkis" => "teal", "silber" => "silver" );
//Anmerkung: statt "schwarz" => "black" wre auch "schwarz" => "#000000" mglich usw...



/********************************      NEWSKONFIGURATION      ********************************/

$set['importmode'] = 0;  //Import-Modus: Wenn sie von einem anderen Newsscript auf WEB//NEWS umstellen wollen Sie sicher ihre alten News importieren
                         //Wenn Sie den Import-Modus aktivieren knnen Sie jeder News sofort ein Verffentlichungs-Datum zuweisen
$set['usecode']    = 1;  //WN-Code zur Formatierung verwenden? ( 0 = nein; 1 = ja )
$set['usehtml']    = 1;  //WN-Code [HTML] verwenden sofern WN-Code aktiviert? ( 0 = nein; 1 = ja )
$set['useimg']     = 1;  //WN-Codes [IMG] und [POPUP] verwenden sofern WN-Code aktiviert? ( 0 = nein; 1 = ja )
$set['usesmilies'] = 1;  //grafische Smilies in den News verwenden? ( 0 = nein; 1 = ja )
$set['usetcode']   = 1;  //WN-Codes [B] [I] [U] [S] im Thema verwenden? ( 0 = nein; 1 = ja )
$set['usekats']    = 1;  //Newskategorien verwenden? ( 0 = nein; 1 = ja )
$set['usecoms']    = 1;  //Komentarfunktion aktivieren? ( 0 = nein; 1 = ja )



/***********************************      NEWSAUSGABE      ***********************************/

$set['maxnews']       = 10; //Maximale Anzahl der News, die angezeigt werden sollen
$set['bigdate']       = 0;  //Groes Datum unter dem alle News des Tages gelistet sind ( = 1 ) oder in jedem Eintrag einzeln ( = 0 )?
$set['leadingzero']   = 1;  //fhrende Null bei Datumsangaben: z.B. 03.06.2003 ( 0 = nein; 1 = ja )
$set['listcats']      = 1;  //Kategorien am Ende der News auflisten, um nur die Meldungen aus einer gewhlten Kategorie anzuzeigen
$set['mehrtext']      = "mehr";  //Beschriftung des "mehr"-Links
$set['searchfnews']   = 0;  //Suchfeld auf der News-Seite anzeigen? ( 0 = nein; 1 = ja )
$set['searchfarch']   = 1;  //Suchfeld im Archiv anzeigen? ( 0 = nein; 1 = ja )
$set['relatednews']   = 1;  //Liste mit hnlichen Meldungen anzeigen ( 0 = nein; 1 = ja )
$set['relnewscount']  = 3;  //Zahl der Eintrge in der "hnliche Meldungen"-Liste
$set['archallnews']   = 0;  //Sollen im Newsarchiv die aktuellen Meldungen von der Newsseite ebenfalls angezeigt werden? ( 0 = nein; 1 = ja )

$set['lastnewscount'] = 10; //Zahl der Eintrge in der "letze X News"-Liste
$set['lastnewsltype'] = 1;  //Sollen die Links der "letzen X News" nur zum Artikel in der bersicht springen ( $set['lastnewsltyle'] = 1 ) oder den Artikel direkt auswhlen ( $set['lastnewsltyle'] = 2 )?
$set['lastnewsmlen']  = 20; //Maximale Anzahl der Zeichen, die der Titel haben darf, danach wird mit "..." abgekrzt (Untertitel nicht betroffen! 0 = unendlich) 

$set['oldnewscount']  = 10; //Zahl der Eintrge in der "alten X News"-Liste
$set['oldnewsltype']  = 1;  //Sollen die Links der "alten X News" nur zum Artikel in der bersicht springen ( $set['lastnewsltyle'] = 1 ) oder den Artikel direkt auswhlen ( $set['lastnewsltyle'] = 2 )?
$set['oldnewsmlen']   = 20; //Maximale Anzahl der Zeichen, die der Titel haben darf, danach wird mit "..." abgekrzt (Untertitel nicht betroffen! 0 = unendlich)

$set['browsenews']    = 1;  //Seitenzahlen am Ende der News-Seite auflisten um in lteren News zu blttern ( 0 = nein; 1 = ja )
$set['selpage']       = "[%ZAHL%]";  //Style der Seitennummer der aktuell gewhlten Page. Setzten Sie den Platzhalter %ZAHL% in den gewnschten Code ein
$set['cutpages']      = 5;  //Anzahl der Seitenzahlen verringern auf X Seitenzahlen rechts und links von der aktuellen Seitenzahl ( 0 = Funktion deaktivieren )

$set['imgvspace']     = 5;  //Wert des vspace-Attributs bei rechtbndigen/linksbndigen Bildern
$set['imghspace']     = 5;  //Wert des hspace-Attributs bei rechtbndigen/linksbndigen Bildern



/********************************      KOMMENTARAUSGABE      *********************************/

$set['allowarchcoms'] = 0;       //Darf man zu Artikeln die bereits im Archiv sind Kommentare schreiben? ( 0 = nein; 1 = ja )
$set['comformpos']    = 1;       //Position des Kommentar-Formulars: 1 = ber den Kommentaren, 2 = unter der Kommentaren
$set['allowcode']     = 1;       //Standard WN-Codes in den Kommentaren erlauben? ( 0 = nein; 1 = ja )
$set['allowimg']      = 0;       //WN-Code [img] in den Kommentaren erlauben? ( 0 = nein; 1 = ja )
$set['allowsmilies']  = 1;       //Smilies in den Kommentaren erlauben? ( 0 = nein; 1 = ja )

$set['maxcomchars']   = 1000;    //Zeichenbeschrnkung fr einen Kommentar
$set['noshouting']    = 1;       //Anti-Schrei-Funktion, nicht mehr als drei Ausrufe- oder Fragezeichen hintereinander erlaubt ( 0 = nein; 1 = ja )
$set['spamprot']      = 2;       //Dauer der Spammersperre in Minuten (so lange muss ein User warten, ehe er einen weiteren Kommentar absenden kann)
$set['badwords']      = array(); //Wrter, die in den Kommentaren zensiert werden sollen, einfach in die Klammern schreiben, in Anfhrungszeichen und mit Komma getrennt.
                                 //Beispiel: $set['badwords'] = array("Arschloch","Idiot","...");



/*****************************      KOMMENTAR-EINGABEFELDER      *****************************/

//Hier werden die 5 verfgbaren Eingabefelder der Kommentare ber 4 Optionen konfiguriert:
//useit:    Soll dieses Feld berhaupt verwendet werden? ( 0 = nein; 1 = ja )
//required: Ist die Angabe zwingend? ( 0 = nein; 1 = ja )
//output:   Das "Template", wie die Eingabe des Feldes in der Ausgabe verarbeitet werden soll. %INHALT% wird jeweils durch den Inhalt des Feldes ersetzt.
//          Im Template "commententry" lassen sich die mit dem hier konfigurierten Templates verarbeiteten Feld-Daten dann ber %FELDx% einsetzen. (x fr die Nummer des Feldes)
//else:     Sofern keine Eingabe fr dieses Feld erfolgt ist, wird dieses "Template" ausgegeben

//Feld 1
$set['cf1']['useit']      = 1;
$set['cf1']['required']   = 1;
$set['cf1']['output']     = '<a href="mailto:%INHALT%">MAIL</a>';
$set['cf1']['else']       = '';

//Feld 2
$set['cf2']['useit']      = 1;
$set['cf2']['required']   = 0;
$set['cf2']['output']     = '<a href="%INHALT%" target="_blank">HOMEPAGE</a>';
$set['cf2']['else']       = '';

//Feld 3
$set['cf3']['useit']      = 1;
$set['cf3']['required']   = 0;
$set['cf3']['output']     = '<a href="http://wwp.icq.com/scripts/search.dll?to=%INHALT%">ICQ</a>';
$set['cf3']['else']       = '';

//Feld 4
$set['cf4']['useit']      = 1;
$set['cf4']['required']   = 0;
$set['cf4']['output']     = 'Herkunft: %INHALT%';
$set['cf4']['else']       = 'Herkunft: unbekannt';

//Feld 5
$set['cf5']['useit']      = 0;
$set['cf5']['required']   = 0;
$set['cf5']['icon']       = '';
$set['cf5']['else']       = '';



/**************************************      ALIAS      **************************************/

//Hiermit knnen Sie bestimmte Zeichenketten ersetzen lassen. Damit lassen sich z.B. bestimmte Keywords direkt verlinken (siehe Beispiel unten)
//Aliases werden bei der Ausgabe auf den Newstext angewandt

//Syntax: "Suchtext" => "Ersatztext"
$set['alias'] = array (
	"Stylemotion" => "[url=http://www.stylemotion.de]Stylemotion[/url]",
	"Stylemotion.de" => "[url=http://www.stylemotion.de]Stylemotion.de[/url]",
);



/*************************************      SMILIES      *************************************/

//Syntax: "Datei (ohne .gif)" => "Code"
$set['smilies'] = array (
	"smile" => ":)",
	"zwinker" => ";)",
	"frown" => ":(",
	"heul" => ";(",
	"biggrin" => ":D",
	"tongue" => ":P",
	"dozey" => ":dozey:",
	"cool" => ":cool:",
	"crazy" => ":crazy:",
	"sconf" => ":sconf:",
	"laugh" => ":lol:",
	"confused" => ":confused:",
	"angryfire" => ":flamer:",
	"eek" => ":eek:",
	"eek3" => ":eek2:",
	"biggthumpup" => ":gut:",
	"naughty" => ":naughty:",
	"scream" => ":schrei:",
	"shinner" => ":aua:",
	"ugh" => ":ugh:",
	"nuke" => ":nuke:",
	"ausruf" => ":!!!:",
	"frage" => ":???:"
);

?>