<?php

/*
+--------------------------------------------------------------------------
|   Invision Board v1.1
|   ========================================
|   by Matthew Mecham
|   (c) 2001,2002 Invision Power Services
|   http://www.ibforums.com
|   ========================================
|   Web: http://www.ibforums.com
|   Email: phpboards@ibforums.com
|   Licence Info: phpib-licence@ibforums.com
+---------------------------------------------------------------------------
|
|   > Admin HTML stuff library
|   > Script written by Matt Mecham
|   > Date started: 1st march 2002
|
+--------------------------------------------------------------------------
*/


class api_template {

	var $base_url;
	var $img_url;
	var $has_title;
	var $td_widths = array();
	var $td_header = array();
	var $td_colspan = 0;
	
	function api_template()
	{
		global $this_script, $ibforums;
		
		$this->base_url = $ibforums->vars['this_script'];
		
		$this->img_url  = 'html/sys-img';
	}
	
	//+--------------------------------------------------------------------
	//+--------------------------------------------------------------------
	// FORM ELEMENTS
	//+--------------------------------------------------------------------
	//+--------------------------------------------------------------------
	
	function start_form($hiddens="", $name='theAdminForm', $js="") {
		global $IN, $INFO, $ibforums;
		
		$this->base_url = $ibforums->vars['this_script'];
	
		$form = "<form action='{$this->base_url}' method='post' name='$name' $js>";
		
		if (is_array($hiddens))
		{
			foreach ($hiddens as $k => $v) {
				$form .= "\n<input type='hidden' name='{$v[0]}' value='{$v[1]}'>";
			}
		}
		
		return $form;
		
	}
	
	//+--------------------------------------------------------------------
	
	function form_hidden($hiddens="") {
	
		if (is_array($hiddens))
		{
			foreach ($hiddens as $k => $v) {
				$form .= "\n<input type='hidden' name='{$v[0]}' value='{$v[1]}'>";
			}
		}
		
		return $form;
	}
	
	
	//+--------------------------------------------------------------------
	
	function end_form($text = "", $js = "")
	{
		// If we have text, we print another row of TD elements with a submit button
		
		$html    = "";
		$colspan = "";
		
		if ($text != "")
		{
			if ($this->td_colspan > 0)
			{
				$colspan = " colspan='".$this->td_colspan."' ";
			}
			
			$html .= "<tr><td align='center' id='tdrow2'".$colspan."><input type='submit' value='$text'".$js." id='button' accesskey='s'></td></tr>\n";
		}
		
		$html .= "</form>";
		
		return $html;
		
	}
	
	//+--------------------------------------------------------------------
	
	function form_upload($name="FILE_UPLOAD", $js="") {
	
		if ($js != "")
		{
			$js = ' '.$js.' ';
		}
	
		return "<input class='textinput' type='file' $js size='30' name='$name'>";
		
	}
	
	//+--------------------------------------------------------------------
	
	function form_input($name, $value="", $type='text', $js="") {
	
		if ($js != "")
		{
			$js = ' '.$js.' ';
		}
	
		return "<input type='$type' name='$name' value='$value' style='width:95%'".$js." id='textinput'>";
		
	}
	
	function form_simple_input($name, $value="", $size='5') {
	
		return "<input type='text' name='$name' value='$value' size='$size' id='textinput'>";
		
	}
	
	//+--------------------------------------------------------------------
	
	function form_textarea($name, $value="", $cols='60', $rows='5', $wrap='soft') {
	
		return "<textarea name='$name' cols='$cols' rows='$rows' wrap='$wrap' id='multitext'>$value</textarea>";
		
	}
	
	//+--------------------------------------------------------------------
	
	function form_dropdown($name, $list=array(), $default_val="", $js="") {
	
		if ($js != "")
		{
			$js = ' '.$js.' ';
		}
	
		$html = "<select name='$name'".$js." id='dropdown'>\n";
		
		foreach ($list as $k => $v)
		{
		
			$selected = "";
			
			if ( ($default_val != "") and ($v[0] == $default_val) )
			{
				$selected = ' selected';
			}
			
			$html .= "<option value='".$v[0]."'".$selected.">".$v[1]."</option>\n";
		}
		
		$html .= "</select>\n\n";
		
		return $html;
	
	
	}
	
	//+--------------------------------------------------------------------
	
	function form_yes_no( $name, $default_val="" ) {
	
		$yes = "Yes &nbsp; <input type='radio' name='$name' value='1' id='green'>";
		$no  = "<input type='radio' name='$name' value='0' id='red'> &nbsp; No";
		
		
		if ($default_val == 1)
		{
			$yes = "Yes &nbsp; <input type='radio' name='$name' value='1' checked id='green'>";
		}
		else
		{
			$no  = "<input type='radio' name='$name' value='0' checked id='red'> &nbsp; No";
		}
		
		
		return $yes.'&nbsp;&nbsp;&nbsp;'.$no;
		
	}
	
	
	
	
	//+--------------------------------------------------------------------
	//+--------------------------------------------------------------------
	// SCREEN ELEMENTS
	//+--------------------------------------------------------------------
	//+--------------------------------------------------------------------
	
	function add_subtitle($title="",$id="subtitle", $colspan="") {
		
		if ($colspan != "")
		{
			$colspan = " colspan='$colspan' ";
		}
		
		return "\n<tr><td id='$id'".$colspan.">$title</td><tr>\n";
		
	}
	
	//+--------------------------------------------------------------------
	
	function start_table( $title="", $desc="") {
	
		if ($desc != "")
		{
			$desc = "<br><span id='smalltitle'>&nbsp;&nbsp;&nbsp;&nbsp;$desc</span>";
		}
	
	
		if ($title != "")
		{
			$this->has_title = 1;
			$html .= "<tr>
						<td id='subtitle'>&#149;&nbsp;$title $desc</td>
					  <tr>
					  <td>
					  	<table cellpadding='8' cellspacing='0' width='100%' align='center' border='0' id='tablewrap'>
					 ";
		}
	
	
	
		$html .= "<tr>
				  <td>
				<table width='100%' cellspacing='1' cellpadding='0' align='center' border='0' id='table1'>
				 <tr>
				  <td>
				   <table width='100%' cellspacing='2' cellpadding='3' align='center' border='0'>";
		
		
		if (isset($this->td_header[0]))
		{
			$html .= "<tr>\n";
			
			foreach ($this->td_header as $td)
			{
				if ($td[1] != "")
				{
					$width = " width='{$td[1]}' ";
				}
				else
				{
					$width = "";
				}
				
				$html .= "<td id='tdtop'".$width."align='center'>{$td[0]}</td>\n";
				
				$this->td_colspan++;
			}
			
			$html.= "</tr>\n";
		}
		
		return $html;
		
	}
	
	//+--------------------------------------------------------------------
	
	
	function add_td_row( $array, $css="" ) {
	
		if (is_array($array))
		{
			$html = "<tr>\n";
			
			$count = count($array);
			
			$this->td_colspan = $count;
			
			for ($i = 0; $i < $count ; $i++ )
			{
			
				$td_col = $i % 2 ? 'tdrow2' : 'tdrow1';
				
				if ($css != "")
				{
					$td_col = $css;
				}
			
				if (is_array($array[$i]))
				{
					$text    = $array[$i][0];
					$colspan = $array[$i][1];
					
					$html .= "<td id='$td_col' colspan='$colspan' id='$css'>".$text."</td>\n";
				}
				else
				{
					$html .= "<td id='$td_col'>".$array[$i]."</td>\n";
				}
			}
			
			$html .= "</tr>\n";
			
			return $html;
		}
		
	}
	
	//+--------------------------------------------------------------------
	
	function add_td_basic($text="",$align="left",$id="tdrow1") {
	
		$html    = "";
		$colspan = "";
		
		if ($text != "")
		{
			if ($this->td_colspan > 0)
			{
				$colspan = " colspan='".$this->td_colspan."' ";
			}
			
			
			$html .= "<tr><td align='$align' id='$id'".$colspan.">$text</td></tr>\n";
		}
		
		return $html;
	
	}
	
	//+--------------------------------------------------------------------
	
	function add_td_spacer() {
	
		if ($this->td_colspan > 0)
		{
			$colspan = " colspan='".$this->td_colspan."' ";
		}
	
		return "<tr><td".$colspan."><img src='html/sys-img/blank.gif' height='7' width='1'></td></tr>";
	
	}
	
	
	
	//+--------------------------------------------------------------------
	
	function end_table() {
	
		$this->td_header = array();  // Reset TD headers
	
		if ($this->has_title == 1)
		{
			$this->has_title = 0;
			
			return "</table></td></tr></table></td></tr></table></td></tr>";
		}
		else
		{
			return "</table></td></tr></table></td></tr>";
		}
		
	}
	
	
	//+--------------------------------------------------------------------
	
	
			
	
	
	//+--------------------------------------------------------------------
	//+--------------------------------------------------------------------
	
	function get_css()
	{
		return "<style type='text/css'>
		          	TABLE, TR, TD     { font-family:Verdana, Arial;font-size: 11px; color:#000000; line-height:120% }
					BODY      { font: 10px Verdana; color:#333333 }
					a:link, a:visited, a:active  { color:#000055 }
					a:hover                      { color:#333377;text-decoration:underline }
					
					
					#normal      { font: 10px Verdana; color:#333333 }
					
					#title  { font-size:10px; font-weight:bold; line-height:150%; color:#FFFFFF; height: 30px; background-image: url({$this->img_url}/tile_back.gif); }
					#title  a:link, #title  a:visited, #title  a:active { text-decoration: underline; color : #FFFFFF; font-size:11px }
					
					#detail { font-family: Arial; font-size:11px; color: #333333 }
					
 					#large { font-family: verdana, arial; font-size:18px; color:#4C77B6; font-weight:bold; letter-spacing:-1px }
 					
					#subtitle { font-family: Arial,Verdana; font-size:16px; color:#FF9900; font-weight:bold }
					#smalltitle { font-family: Arial,Verdana; font-size:11px; color:#FF9900; font-weight:bold }
					
					#table1 {  background-color:#FFFFFF; width:100%; align:center; border:1px solid black }
					
					#tdrow1 { background-color:#EEF2F7 }
					
					#subforum { background-color:#DFE6EF }
					
					#tdrow2 { background-color:#F5F9FD }
					
					#catrow { font-weight:bold; height:24px; line-height:150%; color:#4C77B6; background-image: url({$this->img_url}/tile_sub.gif); }
					#catrow2 { font-size:10px; font-weight:bold; line-height:150%; color:#4C77B6; background-color:#D3DFEF; }
					
					#tablewrap { background-color:#F5F9FD }
					
					#copy { color:#555555; font-size:9px }
					
					#tdtop  { font-weight:bold; height:24px; line-height:150%; color:#FFFFFF; background-image: url({$this->img_url}/tile_back.gif); }
					
					#memgroup { border:1px solid #777777 }
					
					#mgred   { border:1px solid #777777; background-color: #f5cdcd }
					#mggreen { border:1px solid #777777; background-color: #caf2d9 }
					#mgblue  { border:1px solid #777777; background-color: #DFE6EF }
					
					#green    { background-color: #caf2d9 }
					#red      { background-color: #f5cdcd }
					
					#button   { background-color: #4C77B6; color: #FFFFFF; font-family:Verdana, Arial; font-size:11px }
					
					#editbutton   { background-color: #DDDDDD; color: #000000; font-family:Verdana, Arial; font-size:9px }
					
					#textinput { background-color: #FFFFFF; color:#000000; font-family:Verdana, Arial; font-size:10px }
					
					#dropdown { background-color: #F5F9FD; color:#000000; font-family:Verdana, Arial; font-size:10px }
					
					#multitext { background-color: #F5F9FD; color:#000000; font-family:Verdana, Arial; font-size:10px }
					
				  </style>";
	}
	
	
	
	function print_top($title="",$desc="")
	{
		global $API;
		
		$css = $this->get_css();
	
		return "<html>
		          <head><title>Invision Power Board Convertor</title>
		          <meta HTTP-EQUIV=\"Pragma\"  CONTENT=\"no-cache\">
				  <meta HTTP-EQUIV=\"Cache-Control\" CONTENT=\"no-cache\">
				  <meta HTTP-EQUIV=\"Expires\" CONTENT=\"Mon, 06 May 1996 04:57:00 GMT\">
		          $css
				  </head>
				 <body marginheight='0' marginwidth='0' leftmargin='0' topmargin='0' bgcolor='#EFEFEF'>
				 <br>
				 <table cellspacing='0' cellpadding='0' align='center' width='95%' bgcolor='#FFFFFF' style='border-right:4px solid #BBBBBB;border-bottom:4px solid #BBBBBB'>
				 <tr>
				  <td>
				   <table cellspacing='0' cellpadding='0' align='center' width='100%' bgcolor='#FFFFFF' style='border:1px solid #4C77B6'>
				   <tr>
					<td align='center' id='title'>Invision Power Board Convertor</td>
				   </tr>
				   <tr>
					<td align='top' width='100%'>
					  <table cellspacing='0' cellpadding='4' align='center' width='98%'>
					   <tr>
						 <td id='large'><a href='{$API->script}'>Home</a> :: $title</td>
						</tr>
					  <tr>
					  <td>$desc<br>&nbsp;</td>
					  </tr>";
				  	   
	}
	
	//+--------------------------------------------------------------------
	
	function print_foot() {
		global $API;
		
		return "     </td>
					</tr>
					</table>
				  </td>
				 </tr>
				 <tr><td align='center' id='copy'>Invision Power Board &copy 2002 <a href='http://www.invisionpower.com' target='_blank'>IPS, Inc.</a><br>{$API->board_copyright}<br>&nbsp;</td></tr>
				 </table>
				 </td>
				</tr>
			</table>
		</body>
	</html>";
	}
	
	
	
}






?>