<?php
///////////////////////////////////////////////////
//  Advanced Poll 1.6 (PHP)                      //
//  Copyright (c)2001 Chi Kien Uong              //
//  URL: http://www.proxy2.de                    //
///////////////////////////////////////////////////

$script_path = dirname(__file__);
require $script_path."/include/config.inc.php";
$include_path = "$script_path/polldata";

if (!isset($PHP_SELF)) {
  $PHP_SELF = $HTTP_SERVER_VARS["PHP_SELF"];
  if (isset($HTTP_GET_VARS)) {
    while (list($name, $value)=each($HTTP_GET_VARS)) {
      $$name=$value;
    }
  }
  if (isset($HTTP_POST_VARS)) {
    while (list($name, $value)=each($HTTP_POST_VARS)) {
      $$name=$value;
    }
  }
}

function show_form($poll_id) {
  global $table_width, $bgcolor_fr, $title, $bgcolor_tab;
  global $font_face, $question, $PHP_SELF;

?>
<table border="0" cellspacing="0" cellpadding="1" align="center" bgcolor="<?php echo $bgcolor_fr; ?>">
  <tr align="center">
    <td>
     <style type="text/css">
      <!--
       .button {  font-family: <?php echo $font_face; ?>; font-size: 8pt}
       .textarea {  font-family: "MS Sans Serif"; font-size: 9pt; width: 195px}
       .input {  width: 195px}
      -->
    </style><font color="#FFFFFF" face="<?php echo $font_face; ?>" size="2"><b>Send Your Comment</b></font></td>
  </tr>
  <tr>
    <td>
      <table border="0" cellspacing="0" cellpadding="5" align="center" bgcolor="<?php echo $bgcolor_tab; ?>" width="200">
        <tr>
          <td width="149">
            <form method="post" action="<?php echo $PHP_SELF; ?>">
              <table border="0" cellspacing="0" cellpadding="2" bgcolor="<?php echo $bgcolor_tab; ?>" align="center">
                <tr>
                  <td class="td1" height="40"><b><font face="<?php echo $font_face; ?>" size="1"><?php echo $question; ?></font></b></td>
                </tr>
                <tr>
                  <td class="td1"><font face="<?php echo $font_face; ?>" size="1">Name:</font><br>
                    <input type="text" name="name" maxlength="25" class="input" size="23">
                  </td>
                </tr>
                <tr>
                  <td class="td1"><font face="<?php echo $font_face; ?>" size="1">e-mail:</font><br>
                    <input type="text" name="email" size="23" maxlength="50" class="input">
                  </td>
                </tr>
                <tr>
                  <td class="td1"><font face="<?php echo $font_face; ?>" size="1">Comment(*):</font><br>
                    <font face="MS Sans Serif" size="1">
                    <textarea name="message" cols="19" wrap="VIRTUAL" rows="6" class="textarea"></textarea>
                    </font>
                  </td>
                </tr>
                <tr valign="top">
                  <td>
                    <input type="submit" value="Submit" class="button">
                    <input type="reset" value="Reset" class="button">
                    <input type="hidden" name="action" value="add">
                    <input type="hidden" name="id" value="<?php echo $poll_id; ?>">
                  </td>
                </tr>
              </table>
            </form>
          </td>
        </tr>
      </table>
    </td>
  </tr>
</table>
<?php }

function get_status($poll_id) {
  global $include_path;
  $line = file("$include_path/$poll_id");
  list($question,$timestamp,$exp_time,$expire,$logging,$status,$comments) = split("\\|",$line[0]);
  return (sizeof($line)>0) ? array(
    "question" => "$question",
    "timestamp" => "$timestamp",
    "exp_time" => "$exp_time",
    "expire" => "$expire",
    "logging" => "$logging",
    "status" => "$status",
    "comments" => "$comments"
  ) : false;
}

function format_string($strg) {
  if (get_magic_quotes_gpc()) {
    $strg = stripslashes($strg);
  }
  $strg = trim($strg);
  $strg = htmlspecialchars($strg);
  $strg = str_replace("","",$strg);
  $strg = str_replace("\r\n","<br>",$strg);
  $strg = str_replace("\n","<br>",$strg);
  return $strg;
}

function add_comment($poll_id) {
  global $message, $name, $email, $include_path;
  global $REMOTE_ADDR, $HTTP_USER_AGENT;
  $name = format_string($name);
  if (!$name) {
    $name = "anonymous";
  }
  $email = trim($email);
  if (!eregi("^[_a-z0-9-]+(\\.[_a-z0-9-]+)*@([0-9a-z][0-9a-z-]*[0-9a-z]\\.)+[a-z]{2,4}$", $email) ) {
    $email = '';
  }
  $this_time = time();
  $ip = $REMOTE_ADDR;
  if (!$ip) {
    $ip = getenv("REMOTE_ADDR");
  }
  $host = @gethostbyaddr($ip);
  $agent = $HTTP_USER_AGENT;
  if (!$agent) {
    $agent = @getenv("HTTP_USER_AGENT");
  }
  $comment_table = fopen("$include_path/$poll_id.dat","a");
  $entry = "$this_time".""."$host".""."$agent".""."$name".""."$email".""."$message\n";
  fwrite($comment_table,"$entry");
  fclose($comment_table);
  return ($comment_table) ? true : false;
}

function check_poll_id($poll_id) {
  global $include_path;
  if (!file_exists("$include_path/$poll_id")) {
    return false;
  } else {
    $stat_array = get_status($poll_id);
    $question = htmlspecialchars($stat_array["question"]);
    if ($stat_array["status"]==2) {
      return false;
    } elseif ($stat_array["comments"]==0) {
      return false;
    } else {
      return $question;
    }
  }
}

function print_message($strg,$autoclose) {
  global $font_face;
  if ($autoclose==1) {
    echo "<script language=\"JavaScript\">
      setTimeout(\"closeWin()\",2000);
      function closeWin() {
	self.close();
      }
      </script>";
  }
  echo "<center><font face=\"$font_face\" size=\"1\"><b>$strg</b></font></center>";
}

if (!isset($action)) {
  $action = '';
}

switch ($action) {
  case "send":
    if (!isset($id)) {
      echo "<b>Poll ID is not set!</b>";
      break;
    } else {
      $question = check_poll_id($id);
      if (!$question) {
        echo "<b>Poll ID ".$id." does not exist or is disabled!</b>";
        break;
      } else {
        show_form($id); 
        break;
      }
    }
    break;

  case "add":
    $message = format_string($message);
    if (!isset($id)) {
      echo "<b>Poll ID is not set!</b>";
      break;
    } elseif (empty($message)) {
      print_message("You forgot to fill in the message field!<br><a href=\"javascript:history.go(-1)\">Go back</a>",0);
      break;
    } else {
      $question = check_poll_id($id);
      if (!$question) {
        echo "<b>Poll ID ".$id." does not exist or is disabled!</b>";
        break;
      } else {
        if (add_comment($id)) {
          print_message("Your message has been sent!",1);
        } else {
          print_message("Error occured!<br><a href=\"javascript:history.go(-1)\">Go back</a>",0);
        }
      }
    }
    break;

  default:
    echo "<b>No valid command!</b>";
    break;
}

?>