<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.0.1 - Licence Number 15745589
|| # ---------------------------------------------------------------- # ||
|| # Copyright 20002004 Jelsoft Enterprises Ltd. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

error_reporting(E_ALL & ~E_NOTICE);

define('VERSION', '3.0.1');
define('THIS_SCRIPT', 'tools.php');

if (file_exists('./../includes/init.php'))
{ // need to go up a single directory, we must be in includes / admincp / modcp / install
	chdir('./../');
}
else
{
	die('Please place this file within the admin / install folder');
}

require_once('./includes/init.php');
require_once('./includes/functions.php');
require_once('./includes/adminfunctions.php');

#####################################
# phrases for import systems
#####################################
$vbphrase['importing_language'] = 'Importing Language';
$vbphrase['importing_style'] = 'Importing Style';
$vbphrase['importing_admin_help'] = 'Importing Admin Help';
$vbphrase['importing_settings'] = 'Importing Setting';
$vbphrase['please_wait'] = 'Please Wait';
$vbphrase['language'] = 'Language';
$vbphrase['master_language'] = 'Master Language';
$vbphrase['admin_help'] = 'Admin Help';
$vbphrase['style'] = 'Style';
$vbphrase['styles'] = 'Styles';
$vbphrase['settings'] = 'Settings';
$vbphrase['master_style'] = 'MASTER STYLE';
$vbphrase['templates'] = 'Templates';
$vbphrase['css'] = 'CSS';
$vbphrase['stylevars'] = 'Stylevars';
$vbphrase['replacement_variables'] = 'Replacement Variables';
$vbphrase['controls'] = 'Controls';
$vbphrase['rebuild_style_information'] = 'Rebuild Style Information';
$vbphrase['updating_style_information_for_each_style'] = 'Updating style information for each style';
$vbphrase['updating_styles_with_no_parents'] = 'Updating style sets with no parent information';
$vbphrase['updated_x_styles'] = 'Updated %1$s Styles';
$vbphrase['no_styles_needed_updating'] = 'No Styles Needed Updating';
$vbphrase['processing_complete_proceed'] = 'Processing Complete - Proceed';

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<title>vBulletin 3.0 Tools</title>
	<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
	<link rel="stylesheet" href="../cpstyles/vBulletin_3_Default/controlpanel.css" />
	<script type="text/javascript">var SESSIONHASH = "";</script>
	<script type="text/javascript" src="../clientscript/generic.js"></script>

</head>
<body style="margin:0px">
<!-- END CONTROL PANEL HEADER -->
<?php

if (empty($_REQUEST['do']))
{
	print_form_header();
	print_table_header('Import XML Files');
	print_label_row(construct_link_code('Style', THIS_SCRIPT . '?do=xml&amp;type=style'), 'This will take the latest style from ./install/vbulletin-style.xml');
	print_label_row(construct_link_code('Settings', THIS_SCRIPT . '?do=xml&amp;type=settings'), 'This will take the latest settings from ./install/vbulletin-settings.xml');
	print_label_row(construct_link_code('Language', THIS_SCRIPT . '?do=xml&amp;type=language'), 'This will take the latest language from ./install/vbulletin-language.xml');
	print_table_header('MySQL');
	print_label_row(construct_link_code('Run Query', THIS_SCRIPT . '?do=mysql&amp;type=query'), 'This allows you to run alter and update queries on the database');
	print_label_row(construct_link_code('Repair Tables', THIS_SCRIPT . '?do=mysql&amp;type=repair'), 'You can select tables that need repaired here');
	print_table_header('MySQL');
	print_label_row(construct_link_code('Reset Admin Access', THIS_SCRIPT . '?do=user&amp;type=access'), 'Reset admin access for a user');
	print_table_footer();
}
else if ($_REQUEST['do'] == 'xml')
{
	switch ($_REQUEST['type'])
	{
		case 'style':
			require_once('./includes/adminfunctions_template.php');

			if (!($xml = file_read('./install/vbulletin-style.xml')))
			{
				echo '<p>Uh oh, ./install/vbulletin-style.xml doesn\'t appear to exist! Upload it and refresh the page.</p>';
				break;
			}

			echo '<p>Importing vbulletin-style.xml</p>';

			xml_import_style($xml);

			// define those phrases that are used for the import
			$vbphrase['importing_x'] = 'Importing %1$s';
			$vbphrase['style'] = 'Style';
			$vbphrase['please_wait'] = 'Please Wait';

			build_all_styles(0, 1);
		break;
		case 'settings':
			require_once('./includes/adminfunctions_options.php');

			if (!($xml = file_read('./install/vbulletin-settings.xml')))
			{
				echo '<p>Uh oh, ./install/vbulletin-settings.xml doesn\'t appear to exist! Upload it and refresh the page.</p>';
				print_cp_footer();
			}

			echo '<p>Importing vbulletin-settings.xml';
			xml_import_settings($xml);
			echo '<br /><span class="smallfont"><b>Okay</b></span></p>';
		break;
		case 'language':
			require_once('./includes/adminfunctions_language.php');

			if (!($xml = file_read('./install/vbulletin-language.xml')))
			{
				echo '<p>Uh oh, ./install/vbulletin-language.xml doesn\'t appear to exist! Upload it and refresh the page.</p>';
				print_cp_footer();
			}

			echo '<p>Importing vbulletin-language.xml';
			xml_import_language($xml);
			build_language();
			echo '<br /><span class="smallfont"><b>Okay</b></span></p>';
		break;
	}
	define('SCRIPT_REDIRECT', true);
}
else if ($_REQUEST['do'] == 'mysql')
{
	switch ($_REQUEST['type'])
	{
		case 'query':
		if (empty($_POST['query']) OR !preg_match('#^(Alter|Update)#si', $_POST['query']))
		{
			print_form_header('tools', 'mysql');
			construct_hidden_code('type', 'query');
			print_table_header('Please paste alter / update query below');
			print_textarea_row('Query to run', 'query','', 6, 60, 0, 0);
			print_submit_row('Run', '');
		}
		else
		{
			$DB_site->query($_POST['query']);
			define('SCRIPT_REDIRECT', true);
		}
		break;
		case 'repair':
		if (empty($_POST['tables']))
		{
			print_form_header('tools', 'mysql');
			construct_hidden_code('type', 'repair');
			print_table_header('Please select tables to repair');
			$result = $DB_site->query("SHOW tables");
			while ($currow = $DB_site->fetch_array($result, DBARRAY_NUM))
			{
				print_checkbox_row($currow[0], "tables[$currow[0]]", 0);
			}
			print_submit_row('Repair', '');
		}
		else
		{
			$result = $DB_site->query("SHOW tables");
			foreach($_POST['tables'] AS $key => $val)
			{
				if ($val == 1)
				{
					echo "Repairing $key<br />\n";
					flush();
					$DB_site->query("REPAIR TABLE $key");
					echo "Repair Complete<br />\n";
				}
			}
			echo "Overall Repair complete<br />";
			define('SCRIPT_REDIRECT', true);
		}
		break;
	}
}
else if ($_REQUEST['do'] == 'user')
{
	switch ($_REQUEST['type'])
	{
		case 'access':
		if (empty($_POST['user']))
		{
			print_form_header('tools', 'user');
			construct_hidden_code('type', 'access');
			print_table_header('Enter username to restore access to');
			print_input_row('User Name', 'user', '');
			print_submit_row('Submit', '');
		}
		else
		{
			$userid = $DB_site->query_first("SELECT userid, usergroupid FROM " . TABLE_PREFIX . "user WHERE username = '" . addslashes(htmlspecialchars_uni($_POST['user'])) . "'");
			if (empty($userid['userid']))
			{
				echo '<p align="center">Invalid username</p>';
			}
			else
			{
				// lets check that usergroupid 6 is still admin
				$ugroup = $DB_site->query_first("SELECT * FROM " . TABLE_PREFIX . "usergroup WHERE usergroupid = 6 AND (adminpermissions & " . CANCONTROLPANEL . ")");
				if (empty($ugroup['usergroupid']))
				{ // lets give them admin permissions again
					$DB_site->query("UPDATE " . TABLE_PREFIX . "usergroup SET adminpermissions = 3 WHERE usergroupid = 6");
					build_forum_permissions();
				}
				$DB_site->query("REPLACE INTO " . TABLE_PREFIX . "administrator
					(userid, adminpermissions)
				VALUES
					($userid[userid], " . (array_sum($_BITFIELD['usergroup']['adminpermissions'])-3) . ")
				");
				$DB_site->query("UPDATE " . TABLE_PREFIX . "user SET usergroupid = 6 WHERE userid = $userid[userid]");
				define('SCRIPT_REDIRECT', true);
			}
		}
		break;
	}
}

if (defined('SCRIPT_REDIRECT'))
{
	echo '<p align="center" class="smallfont"><a href="tools.php" onclick="javascript:clearTimeout(timerID);">' . $vbphrase['processing_complete_proceed'] . '</a></p>';
	echo "\n<script type=\"text/javascript\">\n";
	echo "myvar = \"\"; timeout = " . (20) . ";
	function exec_refresh()
	{
		window.status=\"" . $vbphrase['redirecting'] . "\"+myvar; myvar = myvar + \" .\";
		timerID = setTimeout(\"exec_refresh();\", 100);
		if (timeout > 0)
		{ timeout -= 1; }
		else { clearTimeout(timerID); window.status=\"\"; window.location=\"tools.php\"; }
	}
	exec_refresh();";
	echo "\n</script>\n";
}
?>
<!-- START CONTROL PANEL FOOTER -->
<p align="center"><a href="http://www.vbulletin.com/" target="_blank" class="copyright">vBulletin <?php echo VERSION; ?>, Copyright 2000-2004, Jelsoft Enterprises Ltd</a></p>
</div>
</body>
</html>