/* ***** BEGIN LICENSE BLOCK *****
 freeForum @soft.ZoneO.net
 Copyright (C) 2005-2007 ZoneO-soft, Butchu (email butchu with domain zoneo.net)
 with significant contributions from C. Iancu (iancu_ctin with domain yahoo.com)

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 More Info About The Licence At http://www.gnu.org/copyleft/gpl.html
 * ***** END LICENSE BLOCK ***** */

// This file was adapted from the DotClear source code
// http://www.dotclear.net

function ffToolBar(textarea,format,img_path) {
	this.addButton		= function() {}
	this.addSpace		= function() {}
	this.draw			= function() {}
	this.btStrong		= function() {}
	this.btEm			= function() {}
	this.btCode		= function() {}
	this.btBquote		= function() {}
	
	if (!document.createElement) {
		return;
	}
	
	if ((typeof(document["selection"]) == "undefined")
	&& (typeof(textarea["setSelectionRange"]) == "undefined")) {
		return;
	}
	
	var toolbar = document.createElement("div");
	toolbar.id = "ffToolbar";
	
	function addButton(src, title, fn) {
		var i = document.createElement('img');
		i.src = src;
		i.title = title;
		i.onclick = function() { try { fn() } catch (e) { } return false };
		i.tabIndex = 400;
		toolbar.appendChild(i);
		addSpace(2);
	}
	
	function addSpace(w)
	{
		s = document.createElement('span');
		s.style.padding='0 '+w+'px 0 0';
		s.appendChild(document.createTextNode(' '));
		toolbar.appendChild(s);
	}
	
	function encloseSelection(prefix, suffix, fn) {
		textarea.focus();
		var start, end, sel, scrollPos, subst;
		
		if (typeof(document["selection"]) != "undefined") {
			sel = document.selection.createRange().text;
		} else if (typeof(textarea["setSelectionRange"]) != "undefined") {
			start = textarea.selectionStart;
			end = textarea.selectionEnd;
			scrollPos = textarea.scrollTop;
			sel = textarea.value.substring(start, end);
		}
		
		if (sel.match(/ $/)) { // exclude ending space char, if any
			sel = sel.substring(0, sel.length - 1);
			suffix = suffix + " ";
		}
		
		if (typeof(fn) == 'function') {
			var res = (sel) ? fn(sel) : fn('');
		} else {
			var res = (sel) ? sel : '';
		}
		
		subst = prefix + res + suffix;
		
		if (typeof(document["selection"]) != "undefined") {
			var range = document.selection.createRange().text = subst;
			textarea.caretPos -= suffix.length;
		} else if (typeof(textarea["setSelectionRange"]) != "undefined") {
			textarea.value = textarea.value.substring(0, start) + subst +
			textarea.value.substring(end);
			if (sel) {
				textarea.setSelectionRange(start + subst.length, start + subst.length);
			} else {
				textarea.setSelectionRange(start + prefix.length, start + prefix.length);
			}
			textarea.scrollTop = scrollPos;
		}
	}
	
	function draw(msg) {
		p = document.createElement('em');
		p.style.display='block';
		p.style.margin='-0.5em 0 0.5em 0';
		p.appendChild(document.createTextNode(msg));
		textarea.parentNode.insertBefore(p, textarea);
		textarea.parentNode.insertBefore(toolbar, textarea);
	}
	
	
	// ---
	function singleTag(wtag,htag,wetag) {
		var stag = '['+htag+']';
		var etag = '[/'+htag+']';
		encloseSelection(stag,etag);
	}
	
	function btStrong(label) {
		addButton(img_path+'bt_strong.png',label,
		function() { singleTag('__','b'); });
	}
	
	function btEm(label) {
		addButton(img_path+'bt_em.png',label,
		function() { singleTag("''",'i'); });
	}
	
	function btCode(label) {
		addButton(img_path+'bt_code.png',label,
		function() { singleTag('@@','code'); });
	}
	
	function btBquote(label) {
		addButton(img_path+'bt_bquote.png',label,
		function() {
			encloseSelection("\n",'',
			function(str) {
				return "[quote]"+str+"[/quote]\n";
			});
		});
	}
	
	// methods
	this.addButton		= addButton;
	this.addSpace		= addSpace;
	this.draw			= draw;
	this.btStrong		= btStrong;
	this.btEm			= btEm;
	this.btCode		= btCode;
	this.btBquote		= btBquote;
}