<?PHP

##########################
##  AutoRank PHP 2.0.0  ##
###############################################################
##  rate.php - Handle surfer rating interface                ##
###############################################################

include_once('arphp.php');


if( $_SERVER['REQUEST_METHOD'] == 'GET' )
{
    displayMain();
}
else
{
    processRating();
}


$DB->Disconnect();



function displayMain()
{
    global $DB;

    $member = $DB->Row("SELECT * FROM a_Accounts WHERE Username='{$_REQUEST['id']}'");

    if( !$member )
    {
        derr(1023);
    }

    createSession();

    mergeUpper($member, $tpl);
    $tpl['MAX_RATING'] = $GLOBALS['MAX_RATING'];
    $tpl['OUT_URL']    = "{$GLOBALS['OUT_URL']}?id={$_REQUEST['id']}&url={$member['Site_URL']}";
    $tpl['TITLE']      = $GLOBALS['T_RATE_SITE'];

    for( $i = $GLOBALS['MAX_RATING']; $i >= 1; $i-- )
    {
        $tpl['RATE_SELECT'] .= "<option value=\"$i\">$i</option>\n";
    }

    fileParse('_rate_main.htmlt', $tpl, true);
}



function processRating()
{
    global $DB;


    // Comment provided
    if( !emptyString($_REQUEST['Comment']) )
    {
        // Check for properly formatted e-mail address
        if( !preg_match('|^[\w\d][\w\d\,\.\-]*\@([\w\d\-]+\.)+([a-zA-Z]+)$|', $_REQUEST['Email']) )
        {
            $errorList[] = "{$GLOBALS['error']['1007']}: {$GLOBALS['L_EMAIL']}";
        }        
        
        if( emptyString($_REQUEST['Name']) )
        {
            $errorList[] = "{$GLOBALS['error']['1005']}: {$GLOBALS['L_NAME']}";
        }

        $result = $DB->Query("SELECT * FROM a_Bans WHERE Type='Word'");

        while( $ban = $DB->NextRow($result) )
        {
            if( preg_match("|({$ban['Value']})|i", $_REQUEST['Comment'], $matches) )
            {
                $errorList[] = "{$GLOBALS['error']['1016']}<br>{$GLOBALS['L_WORD']}: {$matches[1]}";
            }
        }

        $DB->Free($result);

        if( $errorList )
        {
            getErrorCode($errorList, $tpl);
            $tpl['TITLE'] = $GLOBALS['T_ERROR_SUBMIT'];
            fileParse('_error_submit.htmlt', $tpl, true);
            exitScript();
        }

        convertHTML($_REQUEST);
    }


    // Valid browser
    if( !$_SERVER['HTTP_ACCEPT'] || !$_SERVER['HTTP_USER_AGENT'] )
    {
        handleCheat('Browser');
    }


    if( $GLOBALS['USE_R_NO_PROXY'] && ($_SERVER['HTTP_VIA'] || $_SERVER['HTTP_X_FORWARDED_FOR']) )
    {
        handleCheat('Proxy');
    }


    if( $GLOBALS['USE_R_COOKIES'] )
    {
        if( $_COOKIE["Rate_Done_{$_REQUEST['id']}"] )
        {
            handleCheat('Cookie');
        }
        else
        {
            setcookie("Rate_Done_{$_REQUEST['id']}", 'DONE', time()+$GLOBALS['RATE_SESSION'], '/');
        }
    }

    
    if( !stristr($_SERVER['HTTP_REFERER'], $GLOBALS['BASE_URL']) )
    {
        handleCheat('Referrer');
    }


    if( $GLOBALS['USE_R_REQ_COOKIE'] )
    {
        if( !$_COOKIE['Rate_Session'] )
        {
            handleCheat('No_Cookies');
        }

        $session = md5($GLOBALS['RANDOM'] . $_SERVER['REMOTE_ADDR'] . $_COOKIE['Rate_Time'] . $_REQUEST['id']);

        if( $session != $_COOKIE['Rate_Session'] )
        {
            handleCheat('Session');
        }
    }


    if( $GLOBALS['USE_R_BANNED_IPS'] )
    {
        checkBannedIP();
    }


    if( $GLOBALS['USE_R_TRACK_IPS'] )
    {
        checkExistingIP();
    }


    // Rating is within valid range
    if( $_REQUEST['Rating'] >= 1 && $_REQUEST['Rating'] <= $GLOBALS['MAX_RATING'] )
    {
        
        // Comment provided
        if( !emptyString($_REQUEST['Comment']) )
        {

            arrayStripSlashes($_REQUEST);
            arrayAddSlashes($_REQUEST);

            $DB->Insert("INSERT INTO a_Comments VALUES (" .
                        " NULL, " .
                        " '{$_REQUEST['id']}', " .
                        " UNIX_TIMESTAMP(), " .
                        " '{$_SERVER['REMOTE_ADDR']}', " .
                        " '{$_REQUEST['Email']}', " .
                        " '{$_REQUEST['Name']}', " .
                        " '{$_REQUEST['Rating']}', " .
                        " '{$_REQUEST['Comment']}' )");
        }

        $DB->Update("UPDATE a_Ratings SET Num_Ratings=Num_Ratings+1, Rating_Total=Rating_Total+{$_REQUEST['Rating']} WHERE Username='{$_REQUEST['id']}'");
    }

    displayConfirm();
}

function displayConfirm()
{
    arrayStripSlashes($_REQUEST);

    mergeUpper($_REQUEST, $tpl);

    fileParse('_rate_done.htmlt', $tpl, true);
    exitScript();
}



function createSession()
{
    $time    = time();
    $highres = getMicrotime();
    $session = md5($GLOBALS['RANDOM'] . $_SERVER['REMOTE_ADDR'] . $highres . $_REQUEST['id']);

    setcookie('Rate_Username', $_REQUEST['id'], $time + $GLOBALS['RATE_SESSION'], '/');
    setcookie('Rate_Session', $session, $time + $GLOBALS['RATE_SESSION'], '/');
    setcookie('Rate_Time', $highres, $time + $GLOBALS['RATE_SESSION'], '/');
}



function checkBannedIP()
{
    global $DB;

    $result = $DB->Query("SELECT * FROM a_BannedIPs WHERE IP_Address='{$_SERVER['REMOTE_ADDR']}'");

    if( $DB->Rows($result) != 0 )
    {
        $DB->Free($result);
        handleCheat('Banned_IP');
    }

    $DB->Free($result);
}



function checkExistingIP()
{
    global $DB;

    $result = $DB->Query("SELECT * FROM a_RateIPs WHERE Username='{$_REQUEST['id']}' AND IP_Address='{$_SERVER['REMOTE_ADDR']}'");

    if( $DB->Rows($result) != 0 )
    {
        $DB->Free($result);
        handleCheat('IP_Address');
    }
    else
    {
        $DB->Insert("INSERT INTO a_RateIPs VALUES ( '{$_REQUEST['id']}', '{$_SERVER['REMOTE_ADDR']}' )");
    }
}



function handleCheat($type)
{
    global $DB;

    if( $GLOBALS['USE_R_CHEAT_TALLY'] )
    {
        $DB->Update("UPDATE a_RateCheats SET $type=$type+1 WHERE Username='{$_REQUEST['id']}'");
    }
    

    if( $GLOBALS['USE_R_CHEAT_LOG'] )
    {
        $date = date("H:i m-d-Y");

        fileAppend("{$GLOBALS['DDIR']}/rcheat.log", "[ $date ]  [ $type ]  [ {$_REQUEST['id']} ] [ {$_SERVER['REMOTE_ADDR']} ({$_SERVER['HTTP_X_FORWARDED_FOR']}) ]\n");
    }

    displayConfirm();
}
?>