<?PHP

define(INIT, "INIT");

include('arphp.php');

$DB = NULL;

$check  = "admin:admin";
$result = $PHP_SELF;
cryptpass($check,$result);

if( $_SERVER['REQUEST_METHOD'] == 'GET' )
{
    if( !isInitialized() )
    {
        displayMain();
    }
    else
    {
        displayRemove();
    }
}
else
{
    if( !isInitialized() )
    {
        runTests();
        setupTables();
        setupFiles();
        displayComplete();
    }
    else
    {
        displayRemove();
    }
}



function displayMain( $pass = true, $TPL = NULL )
{
    include("{$GLOBALS['IDIR']}/_init_main.php");
}



function isInitialized()
{
    if(
      !file_exists("{$GLOBALS['ADIR']}/.htaccess") ||
      !file_exists("{$GLOBALS['ADIR']}/.htpasswd") ||
      !$GLOBALS['USERNAME']                        ||
      !$GLOBALS['PASSWORD']                        
      )
      {
            return false;
      }
      else
      {
            return true;
      } 
}



function runTests()
{
    $TPL = array();

    mysqlTests(&$TPL);

    $TPL['DDIR_WRITE'] = is_writeable($GLOBALS['DDIR']);
    $TPL['ADIR_WRITE'] = is_writeable($GLOBALS['ADIR']);
    $TPL['IDIR_WRITE'] = is_writeable($GLOBALS['IDIR']);
    $TPL['CDIR_WRITE'] = is_writeable($GLOBALS['CDIR']);

    if( in_array(false, $TPL) )
    {
        displayMain(false, $TPL);
        exit;
    }
}



function mysqlTests(&$TPL)
{
    $TPL['DB_CONNECT'] = true;
    $TPL['DB_SELECT']  = true;

    error_reporting(E_ALL);
    restore_error_handler();

    $dbh = @mysql_connect($_REQUEST['Hostname'], $_REQUEST['Username'], $_REQUEST['Password']);

    if( !$dbh )
    {
        $TPL['DB_CONNECT']  = false;
        $TPL['DB_SELECT']   = false;
        $TPL['CONNECT_ERR'] = mysql_error();

        if( !$TPL['CONNECT_ERR'] )
        {
            $TPL['CONNECT_ERR'] = 'Could not connect to database with supplied values';
        }
    }
    else
    {
        if( !mysql_select_db($_REQUEST['Database']) )
        {
            $TPL['DB_SELECT']  = false;
            $TPL['SELECT_ERR'] = mysql_error();
        }

        mysql_close($dbh);
    }

    error_reporting(E_ERROR|E_PARSE);
    set_error_handler('errorHandler');
}



function setupTables()
{
    global $DB;

    include_once("{$GLOBALS['DDIR']}/tables.php");

    $DB = new DB($_REQUEST['Hostname'], $_REQUEST['Username'], $_REQUEST['Password']);

    $DB->Connect();
    $DB->SelectDB($_REQUEST['Database']);

    $existing = $DB->GetTables();

    foreach( $table as $name => $query )
    {
        if( !$existing[$name] )
        {
            $DB->Create($query);
        }
    }

    $DB->Disconnect();
}



function setupFiles()
{
    $cwd = getcwd();

    $vardata .= "<?PHP\n";
    $vardata .= "\$USERNAME = '{$_REQUEST['Username']}';\n";
    $vardata .= "\$PASSWORD = '{$_REQUEST['Password']}';\n";
    $vardata .= "\$HOSTNAME = '{$_REQUEST['Hostname']}';\n";
    $vardata .= "\$DATABASE = '{$_REQUEST['Database']}';\n";
    $vardata .= "?".">";

    fileWrite("{$GLOBALS['DDIR']}/vars.php", $vardata);

    $block  .= "AuthName \"Restricted Area\"\n";
    $block  .= "AuthType Basic\n";
    $block  .= "AuthUserFile /dev/null\n";
    $block  .= "AuthGroupFile /dev/null\n\n";
    $block  .= "require valid-user";

    fileWrite("{$GLOBALS['DDIR']}/.htaccess", $block);
    fileWrite("{$GLOBALS['CDIR']}/.htaccess", $block);
    fileWrite("{$GLOBALS['IDIR']}/.htaccess", $block);

    $htdata .= "AuthName \"AutoRank PHP Administration\"\n";
    $htdata .= "AuthType Basic\n";
    $htdata .= "AuthUserFile $cwd/admin/.htpasswd\n";
    $htdata .= "AuthGroupFile /dev/null\n\n";
    $htdata .= "require valid-user\n\n";

    fileWrite("{$GLOBALS['ADIR']}/.htpasswd", "admin:" . crypt("admin"));
    fileWrite("{$GLOBALS['ADIR']}/.htaccess", $htdata);
}



function displayComplete()
{
    include("{$GLOBALS['IDIR']}/_init_done.php");
}



function displayRemove()
{
    include("{$GLOBALS['IDIR']}/_init_remove.php");
}

?>