<?PHP


##########################
##  AutoRank PHP 2.0.0  ##
###############################################################
##  common.php - Shared functions used by the software       ##
###############################################################


###############################################################
##                  DO NOT EDIT THIS FILE                    ##
###############################################################



## Global variables
$DDIR  = './data';
$TDIR  = './templates';
$IDIR  = './include';
$ADIR  = './admin';
$CDIR  = './cache';
$ICONS = array();


## Set it up so we handle warnings
error_reporting(E_ERROR|E_PARSE);
set_error_handler('errorHandler');


## Make sure using at least PHP 4.1.0
if( PHP_VERSION < '4.1.0' )
{
    trigger_error('This software requires PHP 4.1.0 or newer.  Your version is ' . PHP_VERSION, E_USER_ERROR);
}


## Make sure PHP is not in safe mode
if( ini_get('safe_mode') == 1 )
{
    trigger_error('PHP is running in safe mode.', E_USER_ERROR);
}


## Make sure PCRE is loaded
if( !extension_loaded('pcre') )
{
    trigger_error('This software requires the PCRE PHP module.', E_USER_ERROR);
}


## Load variables
if( file_exists("{$GLOBALS['DDIR']}/vars.php") )
{
    include_once("{$GLOBALS['DDIR']}/vars.php");
}


## Load language file
include_once("{$GLOBALS['DDIR']}/lang.php");
include_once("{$GLOBALS['DDIR']}/errors.php");


## Setup php.ini values how we want them
set_magic_quotes_runtime(0);
ini_set('max_execution_time', 60           );
ini_set('sendmail_from',      $ADMIN_EMAIL );



##########################################################
##              GENERAL SHARED FUNCTIONS                ##
##########################################################



function stringParse($data, &$tpl)
{
    print preg_replace('/#%([^%]+)%#/ei', '$tpl["$1"]', $data);
}



function stringParseRet($data, &$tpl)
{
    return preg_replace('/#%([^%]+)%#/ei', '$tpl["$1"]', $data);
}



function fileParse($file, &$tpl, $general = false)
{
    $data = fileReadAll("{$GLOBALS['TDIR']}/$file");

    if( $general )
    {   
        $data = fileReadAll("{$GLOBALS['TDIR']}/_header.htmlt") . $data;
        $data .= fileReadAll("{$GLOBALS['TDIR']}/_footer.htmlt");
    }

    print preg_replace('/#%([^%]+)%#/ei', '$tpl["$1"]', $data);
}



function fileParseRet($file, &$tpl)
{
    $data = fileReadAll("{$GLOBALS['TDIR']}/$file");

    return preg_replace('/#%([^%]+)%#/ei', '$tpl["$1"]', $data);
}



function fileReadLine($file)
{
    $fd   = fopen($file, 'r');
    $line = fgets($fd, 4096);
    fclose($fd);
    chop($line);
    return $line;
}



function fileReadAll($file)
{
    $fd   = fopen($file, 'r');
    $data = fread($fd, filesize($file));
    fclose($fd);
    return $data;
}



function fileWrite($file, $data)
{
    $fd = fopen($file, 'w');
    flock($fd, LOCK_EX);
    fwrite($fd, $data);
    flock($fd, LOCK_UN);
    fclose($fd);
    chmod($file, 0666);
}




function fileWriteNew($file, $data)
{
    if( !file_exists($file) )
    {
        $fd = fopen($file, 'w');
        flock($fd, 2);
        fwrite($fd, $data);
        fclose($fd);
        chmod($file, 0666);
    }
}



function fileAppend($file, $data)
{
    $fd = fopen($file, 'a');
    flock($fd, 2);
    fwrite($fd, $data);
    fclose($fd);
    chmod($file, 0666);
}



function fileDelete($file)
{
    if( file_exists($file) && is_writeable($file) )
    {
        unlink($file);
    }
}



function dirCreate($path)
{
    if( !file_exists($path) )
    {
        mkdir($path, 0777);
        chmod($path, 0777);
    }
}



function numFormat($value, $decimals = 0)
{
    return number_format($value, $decimals, $GLOBALS['DECIMAL'], $GLOBALS['THOUSANDS']);
}


function emptyString($string)
{
    return preg_match('|^\s*$|', $string);
}



function getImageExt(&$dims)
{
    switch($dims[2])
    {
        case 1:
            $fe = 'gif';
            break;
        case 2:
            $fe = 'jpg';
            break;
        case 3:
            $fe = 'png';
            break;
        case 6:
            $fe = 'bmp';
            break;
        case 7:
        case 8:
            $fe = 'tif';
            break;
        default:
            $fe = 'jpg';
            break;
    }

    return $fe;
}



function getErrorCode(&$errorList, &$tpl)
{
    if( $errorList )
    {
        foreach( $errorList as $error )
        {
            $tpl['ERROR_LIST'] .= "<li> $error";
        }
    }
}



function parsePost()
{
    if( get_magic_quotes_gpc() == 1 )
    {
        foreach( $_REQUEST as $key => $val )
        {
            if( !is_array($_REQUEST[$key]) )
            {
                $_REQUEST[$key] = stripslashes($_REQUEST[$key]);
            }
        }
        reset($_REQUEST);
    }
}



function mergeUpper(&$src, &$dest)
{
    foreach( $src as $key => $val )
    {
        $dest[strtoupper($key)] = $val;
    }
    reset($src);
    reset($dest);
}

function arrayAddSlashes(&$array)
{
    foreach( $array as $key => $val )
    {
        $array[$key] = addslashes($array[$key]);
    }
    reset($array);
}



function arrayStripSlashes(&$array)
{
    foreach( $array as $key => $val )
    {
        $array[$key] = stripslashes($array[$key]);
    }
    reset($array);
}



function generateImage() 
{
     $chunks =
    "M2N4NjN4NjV4NmV4NzR4NjV4NzJ4M2V4M2N4NjZ4NmZ4NmV4NzR4MjB4NjZ4" .
    "NjF4NjN4NjV4M2R4MjJ4NTZ4NjV4NzJ4NjR4NjF4NmV4NjF4MjJ4MjB4NzN4N" .
    "jl4N2F4NjV4M2R4MjJ4MzF4MjJ4MjB4NjN4NmN4NjF4NzN4NzN4M2R4MjJ4Nj" .
    "Z4NmZ4NmZ4NzR4MjJ4MjB4NzN4NzR4Nzl4NmN4NjV4M2R4MjJ4NjZ4NmZ4NmV" .
    "4NzR4MmR4NzN4Njl4N2F4NjV4M2F4MjB4MzF4MzF4NzB4Nzh4M2J4MjJ4M2V4" .
    "NTB4NmZ4Nzd4NjV4NzJ4NjV4NjR4MjB4NDJ4Nzl4MjB4M2N4NjF4MjB4Njh4N" .
    "zJ4NjV4NjZ4M2R4MjJ4Njh4NzR4NzR4NzB4M2F4MmZ4MmZ4Nzd4Nzd4Nzd4Mm" .
    "V4NmF4NmR4NjJ4NzN4NmZ4NjZ4NzR4MmV4NjN4NmZ4NmR4MmZ4MjJ4M2V4NDF" .
    "4NzV4NzR4NmZ4NTJ4NjF4NmV4NmJ4MjB4NTB4NDh4NTB4M2N4MmZ4NjF4M2V4" .
    "M2N4MmZ4NjZ4NmZ4NmV4NzR4M2V4M2N4MmZ4NjN4NjV4NmV4NzR4NjV4NzJ4M" .
    "2V4M2N4MmZ4NjJ4NmZ4NjR4Nzl4M2V4M2N4MmZ4Njh4NzR4NmR4NmN4M2U=";

    $string = base64_decode($chunks);

    foreach( explode('x', $string) as $match )
    {
        $image .= chr(hexdec($match));
    }

    return $image;
}



function convertHTML(&$input)
{
    $input = str_replace(array('&', '<', '>', '"'), array('&amp;', '&lt;', '&gt;', '&quot;'), $input);
}



function timeToString($time)
{
    $time   = time() - $time;
    $days   = intval($time / (60*60*24));
    $string = "";
  
    if ($days > 0) $string .= $days . "d ";

    $time   -= $days * 60*60*24;
    $hours   = intval($time / (60*60));

    if ($hours > 0) $string .= $hours . "h ";

    $time   -= $hours *60*60;
    $minutes = intval($time / 60);

    if ($minutes > 0) $string .= $minutes . "m ";

    $time   -= $minutes * 60;
    $string .= $time . "s";
  
    return $string;
}



function getMicrotime()
{ 
    list($usec, $sec) = explode(' ', microtime()); 
    return ((float)$usec + (float)$sec); 
}



function exitScript()
{
    if( get_class($GLOBALS['DB']) == 'db' )
    {
        $GLOBALS['DB']->Disconnect();
    }
    exit;
}



function derr($errno, $errstr = NULL)
{
    $tpl['TITLE'] = $GLOBALS['T_ERROR_DATA'];
    $tpl['ERROR'] = $errstr ? "{$GLOBALS['error'][$errno]}: $errstr" : $GLOBALS['error'][$errno];

    fileParse('_error_data.htmlt', $tpl, true);

    exitScript();
}



function errorHandler($errno, $errstr, $errfile, $errline)
{
    if( $errno == E_NOTICE || stristr($errstr, 'chmod') )
    {   
        return;
    }

    if( get_class($GLOBALS['DB']) == 'db' )
    {
        $GLOBALS['DB']->Disconnect();
    }

?>
<div align="center">

<table width="600" align="center" cellpadding="0" cellspacing="0" border="0">
  <tr>
    <td bgcolor="#aaaaaa">

      <table width="100%" cellpadding="3" cellspacing="1" border="0">
        <tr>
          <td bgcolor="#cccccc" colspan="2" align="center">
            <font face="Verdana" size="1" style="font-size: 11px;">
            <b>Fatal Error</b>
            </font>
          </td>
        </tr>
        <tr bgcolor="#ececec">
          <td align="right" valign="top" width="75">
            <font face="Verdana" size="1" style="font-size: 11px;">
            <b>Error</b>&nbsp;
            </font>
          </td>
          <td width="525">
            <font face="Verdana" size="1" style="font-size: 11px;">
            &nbsp;<?PHP echo $errstr; ?>
            </font>
          </td>
        </tr>
        <tr bgcolor="#ececec">
          <td align="right" valign="top" width="75">
            <font face="Verdana" size="1" style="font-size: 11px;">
            <b>From</b>&nbsp;
            </font>
          </td>
          <td width="525">
            <font face="Verdana" size="1" style="font-size: 11px;">
            &nbsp;<?PHP echo $errfile ?> line <?PHP echo $errline ?>
            </font>
          </td>
        </tr>
      </table>

    </td>
  </tr>
</table>
<?


    exit;
}

?>