<?PHP

##########################
##  AutoRank PHP 2.0.0  ##
###############################################################
##  setup.php - Handle variables and options interface       ##
###############################################################

chdir('..');

include_once('arphp.php');


if( !$_SERVER['REMOTE_USER'] )
{
    derr(1000);
}



if( $_SERVER['REQUEST_METHOD'] == 'POST' )
{
    saveSettings();
}
else
{
    displayMain();
}


$GLOBALS['DB']->Disconnect();



function displayMain()
{
    getDefaults();

    include_once("{$GLOBALS['IDIR']}/_setup_main.php");
}



function saveSettings()
{
    global $catPages, $allPages;
    global $catFonts, $allFonts;
    global $catBreaks, $allBreaks;
    global $allList, $catList;
    global $catConv;

    $time = time();

    checkInput();

    dirCreate("{$GLOBALS['DDIR']}/icons");
    dirCreate("{$GLOBALS['DDIR']}/mails");
    dirCreate("{$GLOBALS['DDIR']}/breaks");
    dirCreate("{$GLOBALS['DDIR']}/times");
    
    fileWriteNew("{$GLOBALS['DDIR']}/times/start",      $time );
    fileWriteNew("{$GLOBALS['DDIR']}/times/backup",     $time );
    fileWriteNew("{$GLOBALS['DDIR']}/times/rerank",     $time );
    fileWriteNew("{$GLOBALS['DDIR']}/times/reset",      $time );
    fileWriteNew("{$GLOBALS['DDIR']}/times/rclear",     $time );
    fileWriteNew("{$GLOBALS['DDIR']}/times/hclear",     $time );
    fileWriteNew("{$GLOBALS['DDIR']}/times/treset",     $time );
    fileWriteNew("{$GLOBALS['DDIR']}/times/members",    0     );
    fileWriteNew("{$GLOBALS['DDIR']}/times/rerank.frm", 'N/A' );
    fileWriteNew("{$GLOBALS['DDIR']}/times/reset.frm",  'N/A' );
    fileWriteNew("{$GLOBALS['DDIR']}/hcheat.log",       ''    );
    fileWriteNew("{$GLOBALS['DDIR']}/rcheat.log",       ''    );
    fileWriteNew("{$GLOBALS['DDIR']}/counts.php",       ''    );


    // Generate random value
    $_REQUEST['RANDOM'] = md5(uniqid(''));


    // Update the vars.php file
    $fd = fopen("{$GLOBALS['DDIR']}/vars.php", 'w');
    fwrite($fd, "<?PHP\n\n## DO NOT EDIT THIS FILE\n\n");

    foreach( $_REQUEST as $key => $val )
    {
        fwrite($fd, "\$$key = '$_REQUEST[$key]';\n");
    }

    fwrite($fd, "\$PAGES    = array( $allPages );\n");
    fwrite($fd, "\$C_PAGES  = array( $catPages );\n");
    fwrite($fd, "\$FONTS    = array( $allFonts );\n");
    fwrite($fd, "\$C_FONTS  = array( $catFonts );\n");
    fwrite($fd, "\$CONVERT  = array( $catConv  );\n");
    fwrite($fd, "\$BREAKS   = array( $allBreaks );\n");
    fwrite($fd, "\$C_BREAKS = array( $catBreaks );\n");
    fwrite($fd, "\$PAGE_LIST = '$allList';\n");
    fwrite($fd, "\$C_PAGE_LIST = '$catList';\n");

    fwrite($fd, "\n?" . ">");
    fclose($fd);

    // Update the index.php, out.php, and in.php files
    updateFiles();
    
    include_once("{$GLOBALS['IDIR']}/_setup_done.php");
}



function checkInput()
{
    global $catPages, $allPages;
    global $catFonts, $allFonts;
    global $catBreaks, $allBreaks;
    global $allList, $catList;
    global $catConv;

    $required = array(
                        'IMAGE_DIR'      => 'Image Directory',
                        'MYSQL'          => 'Path to mysql',
                        'MYSQLDUMP'      => 'Path to mysqldump',
                        'BASE_URL'       => 'Base Install URL',
                        'FORWARD_URL'    => 'Forward URL',
                        'IMAGE_URL'      => 'Image URL',
                        'IN_URL'         => 'In URL',
                        'OUT_URL'        => 'Out URL',
                        'ADMIN_EMAIL'    => 'E-mail Address',
                        'BANNER_HEIGHT'  => 'Banner Height',
                        'BANNER_WIDTH'   => 'Banner Width',
                        'BANNER_BYTES'   => 'Banner Bytes',
                        'BANNER_TAG'     => 'Banner Image Tag',
                        'MIN_HITS'       => 'Minimum Hits',
                        'MAX_RATING'     => 'Highest Rating',
                        'RANKING_IMAGES' => 'Ranking Images',
                        'TITLE_LEN'      => 'Title Max Length',
                        'DESC_LEN'       => 'Description Max Length',
                        'TIME_ZONE'      => 'Time Zone',
                        'DATE_FORMAT'    => 'Date Format',
                        'TIME_FORMAT'    => 'Time Format',
                        'SORT_METHOD'    => 'Sort Method',
                        'DECIMALS'       => 'Decimal Places',
                        'RERANK'         => 'Rerank Time',
                        'RESET'          => 'Reset Time',
                        'RESULTS_PPAGE'  => 'Search Results Per Page',
                        'COMMENTS_PPAGE' => 'Comments Per Page',
                        'QUICK_SITES'    => 'Quick List Sites',
                        'MAXIMUM_NEW'    => 'Maximum Age For New Sites',
                        'THOUSANDS'      => 'Thousands Separator',
                        'DECIMAL'        => 'Decimal Separator',
                        'CATEGORIES'     => 'Categories',
                        'RANKING_PAGES'  => 'Ranking Pages',
                        'NUM_BANNERS'    => 'Banners To Show'
                     );


    foreach( $required as $key => $val )
    {
        if( preg_match('|^\s*$|', $_REQUEST[$key]) )
        {
            $errorList[] = "{$GLOBALS['error']['1005']}: $val";
        }
    }

    

    // Check for valid ranking page list
    getPages();
    
    // Check for valid font sizes
    $allFonts = getFonts($_REQUEST['FONT_SIZES']);
    $catFonts = getFonts($_REQUEST['C_FONT_SIZES']);


    // Get list break hash
    $allBreaks = getBreaks($_REQUEST['BREAK_LIST']);
    $catBreaks = getBreaks($_REQUEST['C_BREAK_LIST']);


    // Check for valid categories and setup the category conversion hash
    $cats[] = "'Overall' => 'Overall'";
    foreach( explode(',', $_REQUEST['CATEGORIES']) as $cat )
    {
        if( preg_match('{^\s|\s$}', $cat) )
        {
            $errorList[] = $GLOBALS['error']['1030'];
        }

        $string = getCatString($cat);

        $cats[] = "'$string' => '$cat'";

        if( $string != $cat )
        {
            $cats[] = "'$cat' => '$cat'";
        }
    }
    $catConv = join(",\n                  ", $cats);



    // Setup the minimum value to check against
    // Used when pulling accounts for the ranking pages
    if( $_REQUEST['SORT_METHOD'] == 'averageRating' || $_REQUEST['SORT_METHOD'] == 'totalRatings' )
    {
        $_REQUEST['MINIMIZER'] = 'Num_Ratings';
    }
    else
    {
        $_REQUEST['MINIMIZER'] = 'Sort_Value';
    }


    if( $errorList )
    {
        getErrorCode($errorList, $tpl);
        $tpl['TITLE'] = $GLOBALS['T_ERROR_SUBMIT'];
        fileParse('_error_submit.htmlt', $tpl, true);
        exitScript();
    }


    foreach( $_REQUEST as $key => $val )
    {
        $_REQUEST[$key] = stripslashes($_REQUEST[$key]);
        $_REQUEST[$key] = str_replace("'", "\'", $_REQUEST[$key]);
    }
    reset($_REQUEST);


    $_REQUEST['HOSTNAME']   = $GLOBALS['HOSTNAME'];
    $_REQUEST['USERNAME']   = $GLOBALS['USERNAME'];
    $_REQUEST['PASSWORD']   = $GLOBALS['PASSWORD'];
    $_REQUEST['DATABASE']   = $GLOBALS['DATABASE'];
    $_REQUEST['INDEX_URL']  = $_REQUEST['BASE_URL'];
    $_REQUEST['INDEX_FILE'] = 'index.php';
    
    unset($_REQUEST['Username'], $_REQUEST['Session'], $_REQUEST['Category'], $_REQUEST['Time']);
}



function getDefaults()
{
    $cwd   = getcwd();
    $paths = array('/bin', '/usr/bin', '/usr/local/bin', '/usr/local/mysql/bin');
    $uri   = str_replace('/admin/setup.php', '', $_SERVER['REQUEST_URI']);
    $vals  = array();

    $vals['IMAGE_DIR']      = "$cwd/images";
    $vals['BASE_URL']       = ($uri && $_SERVER['HTTP_HOST']) ? "http://{$_SERVER['HTTP_HOST']}$uri" : '';
    $vals['FORWARD_URL']    = $vals['BASE_URL'] ? "{$vals['BASE_URL']}/index.php" : '';
    $vals['IMAGE_URL']      = $vals['BASE_URL'] ? "{$vals['BASE_URL']}/images" : '';
    $vals['IN_URL']         = $vals['BASE_URL'] ? "{$vals['BASE_URL']}/in.php" : '';
    $vals['OUT_URL']        = $vals['BASE_URL'] ? "{$vals['BASE_URL']}/out.php" : '';
    $vals['BANNER_HEIGHT']  = 60;
    $vals['BANNER_WIDTH']   = 468;
    $vals['BANNER_BYTES']   = 20000;
    $vals['BANNER_TAG']     = '<img src="#%BANNER_URL%#" #%HEIGHT_WIDTH%# border="0"><br>';
    $vals['MIN_HITS']       = 1;
    $vals['MAX_RATING']     = 10;
    $vals['RANKING_IMAGES'] = 5;
    $vals['TITLE_LEN']      = 60;
    $vals['DESC_LEN']       = 255;
    $vals['TIME_ZONE']      = 0;
    $vals['DATE_FORMAT']    = 'n-j-y';
    $vals['TIME_FORMAT']    = 'g:ia';
    $vals['DECIMALS']       = 2;
    $vals['RERANK']         = 3600;
    $vals['RESET']          = 86400;
    $vals['FIELD_1_NAME']   = 'Field One';
    $vals['FIELD_2_NAME']   = 'Field Two';
    $vals['FIELD_3_NAME']   = 'Field Three';
    $vals['THOUSANDS']      = ',';
    $vals['DECIMAL']        = '.';
    $vals['RESULTS_PPAGE']  = 25;
    $vals['COMMENTS_PPAGE'] = 25;
    $vals['QUICK_SITES']    = 50;
    $vals['MAXIMUM_NEW']    = 604800;
    $vals['HIT_SESSION']    = 120;

    foreach( $paths as $path )
    {
        if( file_exists("$path/mysql") )
        {
            $vals['MYSQL']     = "$path/mysql";
            $vals['MYSQLDUMP'] = "$path/mysqldump";
            break;
        }
    }

    foreach( $vals as $key => $val )
    {
        if( emptyString($GLOBALS[$key]) )
        {
            $GLOBALS[$key] = $val;
        }
    }
}



function getBreaks($list)
{
    if( !emptyString($list) )
    {
        foreach( explode(',', $list) as $break )
        {
            $breaks[] = "'$break' => '1'";
        }

        return join(', ', $breaks);
    }
}



function getPages()
{
    global $catPages, $allPages;
    global $allList, $catList;

    dirCreate("{$GLOBALS['DDIR']}/html");

    $defHTML = fileReadAll("{$GLOBALS['DDIR']}/def.php");

    $count = 0;
    foreach( explode(',', $_REQUEST['RANKING_PAGES']) as $range )
    {
        if( !preg_match('|^\d+-\d+$|', $range) )
        {
            $errorList[] = "{$GLOBALS['error']['1027']}";
            return;
        }

        $count++;
        $pages[]    = "'$count' => '$range'";
        $pageList[] = "Overall.$count.php";

        fileWriteNew("{$GLOBALS['DDIR']}/html/Overall.$count.php", $defHTML);
    }
    $allPages = join(', ', $pages);
    $allList  = join(',', $pageList);


    if( !emptyString($_REQUEST['C_RANKING_PAGES']) )
    {
        unset($pageList);

        $count = 0;
        foreach( explode(',', $_REQUEST['C_RANKING_PAGES']) as $range )
        {
            if( !preg_match('|^\d+-\d+$|', $range) )
            {
                $errorList[] = "{$GLOBALS['error']['1027']}";
                return;
            }

            $count++;
            $pages[] = "'$count' => '$range'";

            foreach( explode(',', $_REQUEST['CATEGORIES']) as $cat )
            {
                $curPage = getCatString($cat) . ".$count.php";
                fileWriteNew("{$GLOBALS['DDIR']}/html/$curPage", $defHTML);
                $pageList[$cat][] = $curPage;
            }
        }
        $catPages = join(', ', $pages);
        $catList  = join(',', flatten($pageList));
    }
}



function getFonts($list)
{
    if( !emptyString($list) )
    {
        foreach( explode(',', $list) as $size )
        {
            if( !preg_match('|^(\d+)-(\d+)=>(\d+)$|', $size, $matches) )
            {
                $errorList[] = "{$GLOBALS['error']['1028']}";
                return;
            }

            $fonts[] = "'$matches[1]' => '$matches[3]'";
        }
    }
    
    if( is_array($fonts) )
    {
        return join(', ', $fonts);
    }
}



function flatten($array)
{
    $newArray = array();

    foreach( array_keys($array) as $key )
    {
        $newArray[] = join(',', $array[$key]);
    }

    return $newArray;
}



function updateFiles()
{
    $files = array(
                     'index.php' => array(
                                            'RESET',
                                            'RERANK',
                                            'USE_CRON'
                                         ),

                     'in.php'    => array(
                                            'FORWARD_URL',
                                            'RANDOM',
                                            'BASE_URL',
                                            'HOSTNAME',
                                            'USERNAME',
                                            'PASSWORD',
                                            'DATABASE',
                                            'BASE_URL',
                                            'INDEX_URL',
                                            'INDEX_FILE',
                                            'HIT_SESSION',
                                            'USE_PERSIST',
                                            'USE_FORWARD_CAT',
                                            'USE_H_NO_PROXY',
                                            'USE_H_BANNED_IPS',
                                            'USE_H_TRACK_IPS',                                            
                                            'USE_H_CHEAT_TALLY',
                                            'USE_H_CHEAT_LOG'
                                         ),

                     'out.php'   => array(
                                            'FORWARD_URL',
                                            'RANDOM',                                            
                                            'HOSTNAME',
                                            'USERNAME',
                                            'PASSWORD',
                                            'DATABASE',
                                            'BASE_URL',
                                            'HIT_SESSION',
                                            'USE_PERSIST',
                                            'USE_FORWARD_CAT',                                            
                                            'USE_H_CHEAT_TALLY',
                                            'USE_H_CHEAT_LOG'
                                         )
                  );
   
    foreach( $files as $file => $values )
    {
        $data = fileReadAll($file);

        foreach( $values as $key )
        {
            if( preg_match('|^USE_|', $key) )
            {
                $_REQUEST[$key] = intval($_REQUEST[$key]);
            }

            $find    = "|\\$$key(\\s+)=(\\s+)'[^']*';|";
            $replace = "\\$$key\$1=\$2'{$_REQUEST[$key]}';";
            $data    = preg_replace($find, $replace, $data);
        }

        fileWrite($file, $data);
    }
}


?>