<?php

function can_overrideHide()
{
	global $vbulletin;
	global $hidetag;

	if (defined('HIDETAG_CANOVERRIDE'))
	{
		if (HIDETAG_CANOVERRIDE)
		{
			return true;
		}
	}
	else
	{
		$usergroups_override = ((trim($vbulletin->options['hidetag_ug_override'])) ? explode(',', trim($vbulletin->options['hidetag_ug_override'])) : array());
		
		if (sizeof($usergroups_override))
		{
			foreach ($usergroups_override as $usergroupid)
			{
				if (is_member_of($vbulletin->userinfo, $usergroupid))
				{
					// define a constant to skip future looping during this session
					define('HIDETAG_CANOVERRIDE', true);
					return true; // can override if [user can override based on system settings]
				}
			}
		}
		
		// define a constant to skip future looping during this session
		define('HIDETAG_CANOVERRIDE', false);
	}
	if (can_moderate($hidetag['forumid']))
	{
		return true; // can override if [user is a moderator of the current forum]
	}
	if (in_array(THIS_SCRIPT, array('editpost', 'newthread')))
	{
		return true; // can override if [user is editing a post]
	}
	if (in_array(THIS_SCRIPT, array('newreply')) AND !$hidetag['postid']) 
	{
		return true; // can override if [user is making a post]
	}
	if ($vbulletin->userinfo['userid'] AND $vbulletin->userinfo['userid'] == $hidetag['posterid'])
	{
		return true; // can override if [user is the absolute post's owner (not a guest)]
	}
	
	return false;
}

################################################################################################################################################
################################################################################################################################################
################################################################################################################################################

function parseHide($text) 
{
	############################################################################################################################################
	global $vbulletin;
	global $hidetag;
	
	############################################################################################################################################
	$threaddata 			=	(is_array($GLOBALS['thread']) 	? 	$GLOBALS['thread'] 				: 	$GLOBALS['threadinfo']);
	
	$hidetag['forumid'] 	=	($GLOBALS['post']['forumid'] 	? 	$GLOBALS['post']['forumid'] 	: 	$threaddata['forumid']);
	$hidetag['threadid']	=	($GLOBALS['post']['threadid'] 	? 	$GLOBALS['post']['threadid'] 	: 	$threaddata['threadid']);
	$hidetag['postid'] 		= 	($GLOBALS['post']['postid'] 	? 	$GLOBALS['post']['postid'] 		: 	$threaddata['firstpostid']);
	$hidetag['posterid']	= 	($GLOBALS['post']['userid'] 	?	$GLOBALS['post']['userid'] 		: 	$threaddata['postuserid']);

	if (THIS_SCRIPT == 'newreply')
	{
		$hidetag['postid'] = $GLOBALS['post']['postid']; // if we are replying to a thread, we won't have a postid in our preview. However, we don't want it to be taken from the firstpostid, because then poster won't see his own text
	}

	############################################################################################################################################
	if (!defined('HIDE_BAN') AND (is_member_of($vbulletin->userinfo, 3, 4) OR ($vbulletin->usergroupcache[$vbulletin->userinfo['usergroupid']]['genericoptions'] & $vbulletin->bf_ugp_genericoptions['isbannedgroup'])))
	{
		define('HIDE_BAN', true); // define ban if [user is an unmoderated coppa || user is a new registrant with an unconfirmed e-mail || user is a member of a banned usergroup]
	}
	
	############################################################################################################################################
	if (!defined('HIDE_HTML') AND in_array(THIS_SCRIPT, array('showthread', 'showpost', 'newthread', 'newreply', 'editpost', 'printthread')))
	{
		define('HIDE_HTML', true);
	}
	
	############################################################################################################################################
	if ($vbulletin->options['enable_hide_tag'])
	{
		$text = preg_replace("/\[HIDE\]/siU", "[HIDE=".$vbulletin->options['hidetag_defaultposts']."]", $text);
	}

	if ($vbulletin->options['enable_hide_tag'])
	{
		$text = preg_replace_callback("/\[HIDE=(&quot;|\"|'|)([0-9]*)\\1\](.*)\[\/HIDE\]/siU", 
			create_function(
				'$matches',
				'return parseHide2($matches[2], $matches[3]);'
			),
			$text);
	}			

	if ($vbulletin->options['enable_showtogroups_tag'])
	{
		$text = preg_replace_callback("/\[SHOWTOGROUPS=(&quot;|\"|'|)([0-9,]+)\\1\](.*)\[\/SHOWTOGROUPS\]/siU",
			create_function(
				'$matches',
				'return parseShowToGroups($matches[2], $matches[3]);'
			),
			$text);
	}

	if ($vbulletin->options['enable_htnx_tag'])
	{
		$text = preg_replace_callback("/\[HIDE-THANKS\](.*)\[\/HIDE-THANKS\]/siU",
			create_function(
				'$matches',
				'return parseHideThanks($matches[1]);'
			),
			$text);
	}
	
	if ($vbulletin->options['enable_hrply_tag'])
	{
		$text = preg_replace_callback("/\[HIDE-REPLY\](.*)\[\/HIDE-REPLY\]/siU",
			create_function(
				'$matches',
				'return parseHideReply($matches[1]);'
			),
			$text);
	}
	
	############################################################################################################################################
	return $text;
}

################################################################################################################################################
################################################################################################################################################
################################################################################################################################################

function parseHide2($postsrequired, $text) 
{
	############################################################################################################################################
	global $vbulletin, $vbphrase, $stylevar;
	global $hidetag;
	
	############################################################################################################################################
	$hidetag['canview'] = false;

	if (can_overrideHide())
	{
		$hidetag['canview'] = true; 												// allowed if [user has override privileges]
	}
	else if (defined('HIDE_BAN'))
	{
		$hidetag['canview'] = false; 												// disallowed if [user is banned from viewing hidden content]
	}
	else if ($vbulletin->userinfo['posts'] >= $postsrequired)
	{
		$hidetag['canview'] = true; 												// allowed if [user = conditional match]
	}

	############################################################################################################################################
	if (!$vbulletin->userinfo['userid'])
	{
		$caption = construct_phrase($vbphrase['hidetag_posts_guest_caption'], ($postsrequired > 0 ? construct_phrase($vbphrase['hidetag_and_x_posts'], $postsrequired) : ''));
	}
	else
	{
		$caption = construct_phrase($vbphrase['hidetag_posts_registered_caption'], $postsrequired, $vbulletin->userinfo['posts']);
	}
	
	if (defined('HIDE_HTML'))
	{
		eval('$text = "' . fetch_template('bbcode_hide') . '";');
	}
	else
	{
		$text = (($hidetag['canview']) ? ($text) : ($vbphrase['hidetag_nohtml_pfx'] . $caption . $vbphrase['hidetag_nohtml_sfx']));
	}
	
	############################################################################################################################################
	return $text;
}

################################################################################################################################################
################################################################################################################################################
################################################################################################################################################

function parseShowToGroups($usergroupids, $text) 
{
	############################################################################################################################################
	global $vbulletin, $vbphrase, $stylevar;
	global $hidetag;
	
	############################################################################################################################################
	$usergroupids = array_intersect(array_keys($vbulletin->usergroupcache), explode(",", $usergroupids));
	sort($usergroupids, SORT_NUMERIC);

	if (sizeof($usergroupids) > 0)
	{
		foreach ($usergroupids as $usergroupid)
		{
			$usergroups_list .= (!empty($usergroups_list) ? ', ' : '') . $vbulletin->usergroupcache["$usergroupid"]['title'] . " :: " . $usergroupid;
		}
	}
	else
	{
		$usergroups_list = "N/A :: 0 - Invalid Usergroup(s) Specified [ErrorCode SH02]";
	}

	############################################################################################################################################
	$hidetag['canview'] = false;

	if (can_overrideHide())
	{
		$hidetag['canview'] = true; 												// allowed if [user has override privileges]
	}
	else if (defined('HIDE_BAN'))
	{
		$hidetag['canview'] = false; 												// disallowed if [user is banned from viewing hidden content]
	}
	else
	{
		foreach ($usergroupids as $usergroupid) 
		{
			if (is_member_of($vbulletin->userinfo, $usergroupid))
			{
				$hidetag['canview'] = true; 										// allowed if [user = conditional match]
			}
		}
	}
	
	############################################################################################################################################
	$caption = construct_phrase($vbphrase['hidetag_showtogroups_caption'], $usergroups_list);
	
	if (defined('HIDE_HTML'))
	{
		eval('$text = "' . fetch_template('bbcode_showtogroups') . '";');
	}
	else
	{
		$text = (($hidetag['canview']) ? ($text) : ($vbphrase['hidetag_nohtml_pfx'] . $caption . $vbphrase['hidetag_nohtml_sfx']));
	}
	
	############################################################################################################################################
	return $text;
}

################################################################################################################################################
################################################################################################################################################
################################################################################################################################################

function parseHideThanks($text) 
{
	############################################################################################################################################
	global $vbulletin, $vbphrase, $stylevar;
	global $hidetag;

	############################################################################################################################################
	$hidetag['canview'] = false;

	if (can_overrideHide())
	{
		$hidetag['canview'] = true; 												// allowed if [user has override privileges]
	}
	else if (defined('HIDE_BAN'))
	{
		$hidetag['canview'] = false; 												// disallowed if [user is banned from viewing hidden content]
	}
	else if (in_array($hidetag['postid'], $hidetag['said_thanks']))
	{
		$hidetag['canview'] = true; 												// allowed if [user = conditional match]
	}

	############################################################################################################################################
	if (defined('HIDE_HTML'))
	{
		eval('$text = "' . fetch_template('bbcode_hide_thanks') . '";');
	}
	else
	{
		$text = (($hidetag['canview']) ? ($text) : ($vbphrase['hidetag_nohtml_pfx'] . $vbphrase['hidetag_accessdenied_mustsaythanks_nohtml'] . $vbphrase['hidetag_nohtml_sfx']));
	}
	
	############################################################################################################################################
	return $text;
}

################################################################################################################################################
################################################################################################################################################
################################################################################################################################################

function parseHideReply($text) 
{
	############################################################################################################################################
	global $vbulletin, $vbphrase, $stylevar;
	global $hidetag;

	############################################################################################################################################
	$hidetag['canview'] = false;

	if (can_overrideHide())
	{
		$hidetag['canview'] = true;													// allowed if [user has override privileges]
	}	
	else if (defined('HIDE_BAN'))
	{
		$hidetag['canview'] = false; 												// disallowed if [user is banned from viewing hidden content]
	}
	else
	{
		static $has_reply = array();
			
		if (!isset($has_reply["$hidetag[threadid]"]))
		{
			$check_reply = $vbulletin->db->query_read("
				SELECT postid FROM " . TABLE_PREFIX . "post
				WHERE userid = '" . $vbulletin->userinfo['userid'] . "'
				AND threadid = '" . $hidetag['threadid'] . "'
				AND visible = 1
				LIMIT 1
			");
			
			if ($vbulletin->db->num_rows($check_reply))
			{
				$hidetag['canview'] = true; 									// allowed if [user = conditional match]
				$has_reply["$hidetag[threadid]"] = true;
			}
		}
		else
		{
			$hidetag['canview'] = true;
		}
	}

	############################################################################################################################################
	if (defined('HIDE_HTML'))
	{
		eval('$text = "' . fetch_template('bbcode_hide_reply') . '";');
	}
	else
	{
		$text = (($hidetag['canview']) ? ($text) : ($vbphrase['hidetag_nohtml_pfx'] . $vbphrase['hidetag_accessdenied_mustreply_nohtml'] . $vbphrase['hidetag_nohtml_sfx']));
	}
	
	############################################################################################################################################
	return $text;
}

################################################################################################################################################
################################################################################################################################################
################################################################################################################################################

function stripHide($text, $where='') 
{
	############################################################################################################################################
	global $vbulletin, $vbphrase;

	############################################################################################################################################
	switch ($where)
	{
		case 'editor':
			$replacement = $vbphrase['hidetag_stripped_quote'];
			break;
		case 'email':
			$replacement = $vbphrase['hidetag_stripped_email'];
			break;
		default:
			$replacement = "[HIDE] Hack Resurrection by Psionic Vision: Undefined Replacement [ErrorCode SH01]";
			break;
	}

	############################################################################################################################################
	if ($vbulletin->options['enable_hide_tag'])
	{
		$text = preg_replace("/\[HIDE\](.*)\[\/HIDE\]/siU", $replacement, $text);
		$text = preg_replace("/\[HIDE=(&quot;|\"|'|)([0-9]*)\\1\](.*)\[\/HIDE\]/siU", $replacement, $text);
	}
		
	if ($vbulletin->options['enable_showtogroups_tag'])
	{
		$text = preg_replace("/\[SHOWTOGROUPS=(&quot;|\"|'|)([0-9,]+)\\1\](.*)\[\/SHOWTOGROUPS\]/siU", $replacement, $text);
	}
	
	if ($vbulletin->options['enable_htnx_tag'])
	{
		$text = preg_replace("/\[HIDE-THANKS\](.*)\[\/HIDE-THANKS\]/siU", $replacement, $text);
	}
	
	if ($vbulletin->options['enable_hrply_tag'])
	{
		$text = preg_replace("/\[HIDE-REPLY\](.*)\[\/HIDE-REPLY\]/siU", $replacement, $text);
	}
	
	############################################################################################################################################
	return $text;
}

################################################################################################################################################
################################################################################################################################################
################################################################################################################################################

$hidetag = array(
	'thankscache' => array(),
	'thankscache_u' => array(),
	'said_thanks' => array()
);
	
############################################################################################################################################	
$getthanks = $vbulletin->db->query_read("
	SELECT thanks.*, post.userid as postuserid, user.username
	FROM " . TABLE_PREFIX . "thanks as thanks
	LEFT JOIN " . TABLE_PREFIX ."post as post ON (post.postid = thanks.postid)
	LEFT JOIN " . TABLE_PREFIX ."user as user ON (user.userid = thanks.userid)
	ORDER BY thanks.dateline DESC
");

############################################################################################################################################
if ($vbulletin->db->num_rows($getthanks) > 0)
{
	while ($thanks = $vbulletin->db->fetch_array($getthanks))
	{
		if ($vbulletin->userinfo['userid'] == $thanks['userid'])
		{
			$hidetag['said_thanks'][] = $thanks['postid'];
		}
	
		$hidetag['thankscache'][] = $thanks;
			
		if (!isset($hidetag['thankscache_u']["$thanks[postuserid]"]))
		{
			$hidetag['thankscache_u']["$thanks[postuserid]"] = 1;
		}
		else
		{
			$hidetag['thankscache_u']["$thanks[postuserid]"]++;
		}
	}
}

?>