<?php
/*
+--------------------------------------------------------------------------
|   D-Shoutbox -- The High-Tech Shoutbox
|   =======================================================
|   By Dean
|    2003-2004 Dean
|   http://www.dscripting.com
|   ========================================================
|   Web: http://www.dscripting.com
|   Email: dean@dscripting.com
+--------------------------------------------------------------------------
*/

class SBFUNC {

	var $colors   = "";
	var $badwords = "";
	var $member   = array();
	var $html;
	
	function SBFUNC()
	{
		global $ibforums, $DB, $std, $shoutbox;

		$DB->query("SELECT * FROM ibf_shoutbox_badwords");
		if ($DB->get_num_rows())
		{
			while ($r = $DB->fetch_row())
			{
				$this->badwords[] = array( 'bword'  => stripslashes($r['bword']),
									       'switch' => stripslashes($r['switch']),
									       'exact'  => $r['exact'],
									     );
			}
		}
		else
		{
			$this->no_badwords = 1;
		}

		$this->member();
	}

	//------------------------------------------------
	// Member, What Member? :)
	//------------------------------------------------

	function member()
	{
		global $ibforums, $DB, $shoutbox;

		$DB->query("SELECT m.*, g.*
				FROM ibf_members m
				LEFT JOIN ibf_groups g ON (m.mgroup=g.g_id)
				WHERE id='{$ibforums->member['id']}'");
		$this->member = $DB->fetch_row();

		return $this->member;
	}
	
	//------------------------------------------------
	// Ooooo, pretty colors!  :)
	//------------------------------------------------
	
	function get_sbcolors()
	{
		global $ibforums, $DB, $shoutbox;

		$DB->query("SELECT * FROM ibf_shoutbox_colors");
		while ($color = $DB->fetch_row())
		{
			$sbcolors .= "<option value='{$color['color']}' style='color: {$color['color']}'";
			$sbcolors .= $color['color'] == $this->member['sb_defaultcolor'] ? "selected>{$color['color']}</option>\n" : ">{$color['color']}</option>\n";
		}
		
		return $sbcolors;
	}
	
	//------------------------------------------------
	// Badwords .... ut oh....  :(
	//------------------------------------------------

	function bad_words($text = "")
	{
		global $DB, $ibforums;
		
		if ($text == "")
		{
			return "";
		}
		
		if ( $this->no_badwords == 1 )
		{
			return $text;
		}
		
		if ( !is_array($this->badwords) )
		{
			$DB->query("SELECT * from ibf_shoutbox_badwords");
			$this->badwords = array();
			if ( $DB->get_num_rows() )
			{
				while ( $r = $DB->fetch_row() )
				{
					$this->badwords[] = array( 'bword'  => stripslashes($r['bword']),
											   'switch' => stripslashes($r['switch']),
											   'exact'  => $r['exact'],
											 );
				}
			}
		}
		
		usort($this->badwords, array('SBFUNC', 'word_sort'));
		
		if ( count($this->badwords) > 0 )
		{
			foreach($this->badwords as $idx => $r)
			{
				if ($r['replace'] == "")
				{
					$replace = '*~*~*';
				}
				else
				{
					$replace = $r['switch'];
				}

				$r['bword'] = preg_quote($r['bword'], "/");

				if ($r['exact'] == 1)
				{
					$text = preg_replace( "/(^|\b)".$r['bword']."(\b|!|\?|\.|,|$)/i", "$replace", $text );
				}
				else
				{
					$text = preg_replace( "/".$r['bword']."/i", "$replace", $text );
				}
			}
		}
		
		return $text;
	}

	//------------------------------------------------
	// Sort out the naughty words...  :)
	//------------------------------------------------
	
	function word_sort($a, $b)
	{
		if ( strlen($a['bword']) == strlen($b['bword']) )
		{
			return 0;
		}
		
		return ( strlen($a['bword']) > strlen($b['bword']) ) ? -1 : 1;
	}
	
	
	//------------------------------------------------
	// Wrapping up the shout!  :)
	//------------------------------------------------
	
	function wordwrap($text="", $chs=0, $rep="<br>")
	{
		if ( $text == "" )
		{
			return $text;
		}
		
		if ( $chs < 1 )
		{
			return $text;
		}
		
		$text = preg_replace("#([^\s<>'\"/\.\\-\?&\n\r\%]{".$chs."})#i", " \\1".$rep ,$text);
		
		return $text;
	}
	
	//------------------------------------------------
	// Say, Can I have your avatar size please?
	//------------------------------------------------

	function get_avatar($member_avatar="", $member_view_avatars=0, $avatar_dims="x")
	{
		global $ibforums, $DB, $sess, $shoutbox;

		if (!$member_avatar or $member_view_avatars == 0 or $this->member['sb_showavatars'] == 0)
		{
			return "";
		}

		if (preg_match ( "/^noavatar/", $member_avatar ))
		{
			return "<img src='{$ibforums->vars['img_url']}/{$shoutbox['noavatar_name']}' border='0' alt='{$ibforums->lang['no_avatar']}'>";
		}

		if ( (preg_match ( "/\.swf/", $member_avatar)) and ($ibforums->vars['allow_flash'] != 1) )
		{
			return "";
		}

		$davatar_dims    = explode( "x", $shoutbox['avatar_dims'] );
		$default_a_dims  = explode( "x", $ibforums->vars['avatar_def'] );

		//---------------------------------------
		// Is URL/Upload avatars enabled?
		//---------------------------------------

		$this_dims = explode( "x", $avatar_dims );
		if (!$this_dims[0]) $this_dims[0] = $davatar_dims[0];
		if (!$this_dims[1]) $this_dims[1] = $davatar_dims[1];

		if ( preg_match( "/^http:\/\//", $member_avatar ) )
		{		
			if (preg_match ( "/\.swf/", $member_avatar))
			{
				return "<object classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\" width='{$this_dims[0]}' height='{$this_dims[1]}'>
						<param name='movie' value='{$member_avatar}'><param name='play' value='true'>
						<param name='loop' value='true'><param name='quality' value='high'>
						<embed src='{$member_avatar}' width='{$this_dims[0]}' height='{$this_dims[1]}' play='true' loop='true' quality='high'></embed>
						</object>";
			}
			else
			{
				return "<img src='{$member_avatar}' border='0' width='{$this_dims[0]}' height='{$this_dims[1]}' alt='' />";
			}
			
			//---------------------------------------
			// Not a URL Avatar, Then an
			// uploaded one it must be!
			//---------------------------------------

		}
		else if ( ($ibforums->vars['avup_size_max'] > 1) and ( preg_match( "/^upload:av-(?:\d+)\.(?:\S+)/", $member_avatar ) ) )
		{
			$member_avatar = preg_replace( "/^upload:/", "", $member_avatar );
			
			if ( preg_match ( "/\.swf/", $member_avatar) )
			{
				return "<object classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\" width='{$this_dims[0]}' height='{$this_dims[1]}'>
						<param name='movie' value='{$ibforums->vars['upload_url']}/$member_avatar'><param name='play' value='true'>
						<param name='loop' value='true'><param name='quality' value='high'>
						<embed src='{$ibforums->vars['upload_url']}/$member_avatar\' width='{$this_dims[0]}' height='{$this_dims[1]}' play='true' loop='true' quality='high'></embed>
						</object>";
			}
			else
			{
				return "<img src='{$ibforums->vars['upload_url']}/$member_avatar' border='0' width='{$this_dims[0]}' height='{$this_dims[1]}' alt='' />";
			}
					
			//---------------------------------------
			// Not a URL or an uploaded one!
			// Just a good ole normal one then
			//---------------------------------------
		}		
		else if ($member_avatar != "")
		{
			//---------------------------------------
			// Avatar, you still here?
		   	//---------------------------------------
		   	
			return "<img src='{$ibforums->vars['AVATARS_URL']}/{$member_avatar}' width='{$this_dims[0]}' height='{$this_dims[1]}' border='0' alt='' />";
		}
		else
		{
			//---------------------------------------
			// Well, we'll name you "Blank" then
			//---------------------------------------
			
    		return "<img src='{$ibforums->vars['img_url']}/{$shoutbox['noavatar_name']}' border='0' alt='{$ibforums->lang['no_avatar']}'>";
		}
	}
    
	//------------------------------------------------
	//  Refresh me up please!  :)
	//------------------------------------------------
    
	function refresh($destination)
	{
		global $ibforums;
	
		$destination = str_replace( "&amp;", "&", $destination );
		
		if ($ibforums->vars['header_redirect'] == 'refresh')
		{
			@header("Refresh: 0;url=".$destination);
		}
		else if ($ibforums->vars['header_redirect'] == 'html')
		{
			@flush();
			echo("<html><head><meta http-equiv='refresh' content='0; url=$destination'></head><body></body></html>");
			exit();
		}
		else
		{
			@header("Location: ".$destination);
		}
		exit();
	}

	//------------------------------------------------
	// Hello shouters, Can I get your name please?
	//------------------------------------------------
	
	function active_shouters()
	{
		global $ibforums, $DB, $sess;

		$t_time = time() - 900;
		$guests = 0;
		$members = 0;
		$cached = array();
		$DB->query("SELECT g.prefix,g.suffix,s.member_name, s.member_id FROM ibf_sessions s, ibf_groups g WHERE location LIKE '%Shoutbox%' AND g.g_id=s.member_group AND s.login_type <> 1 AND s.running_time>'$t_time'");
		while ( $result = $DB->fetch_row() )
		{
			if ($result['member_id'] == 0)
			{
				$guests++;
			}
			else
			{
				if (empty($cached[$result['member_id']]))
				{
					$cached[$result['member_id']] = 1;
					$active .= "<a href='{$ibforums->base_url}&act=Profile&MID={$result['member_id']}'>{$result['prefix']}{$result['member_name']}{$result['suffix']}</a><br>";
					$members++;
				}
			}
		}

		if ($members == 0)
		{
			$active = "{$ibforums->lang['none']}";
		}
		
		return "{$ibforums->lang['current_online']}:<br>{$active}<br>";
	}

	//------------------------------------------------
	// Can I get a link?
	//------------------------------------------------
	
	function get_glink()
	{
		global $ibforums, $DB, $std, $sess, $shoutbox;

		if ($this->member['sb_shoutboxtype'] == 2)
		{
		    $glink = "&nbsp; &nbsp;&nbsp;<img src='{$ibforums->vars['img_url']}/atb_shoutbox.gif' border='0' />&nbsp;<a href='javascript:' onclick=\"window.open('index.php?act=Shoutbox','Shoutbox','width=377,height=438,resizable=no,location=no,menubar=no,status=no,left=0,top=0,screenX=0,screenY=0,scrollbars=no'); return false\">{$shoutbox['sbname']}</a>";
		}
		else
		{
		    $glink = "&nbsp; &nbsp;&nbsp;<img src='{$ibforums->vars['img_url']}/atb_shoutbox.gif' border='0' />&nbsp;<a href='{$ibforums->base_url}&act=Shoutbox'>{$shoutbox['sbname']}</a>";
		}

		return $glink;
	}
	
	//------------------------------------------------
	// Round up some global shouts!  :)
	//------------------------------------------------
	
	function global_shouts()
	{
		global $ibforums, $DB, $sess, $shoutbox;

		$DB->query("SELECT * FROM ibf_shoutbox_stats");
		$stats = $DB->fetch_row();

		if ($shoutbox['gsnum'] > $stats['totalshouts'])
		{
			$shoutbox['gsnum'] = $stats['totalshouts'];
		}
		else if ($shoutbox['gsnum'] > 15)
		{
			$shoutbox['gsnum'] = 15;
		}

		$ibfshout[] = array();
		$DB->query("SELECT m.*, m.id AS mid, s.* FROM ibf_shoutbox s, ibf_members m WHERE s.name=m.name ORDER BY s.id DESC LIMIT {$shoutbox['gsnum']}");
		while($r = $DB->fetch_row())
		{
			$r['message'] = stripslashes($r[message]);
			$r['message'] = "<span style='color: ".$r['color']."'>".$r['message']."</span>";
			$r['message'] = $this->bad_words($r['message']);
			$r['message'] = $this->global_clean($r['message']);

			$num++;
			if (($ibforums->member['id'] == "0" || $ibforums->member['id'] == "" || $this->member['name'] == "Guest" || $this->member['name'] == "") && ($shoutbox['guestviewsb'] != "1"))
			{
				$ibfshout[$num] = stripslashes($shoutbox['error_msg_1']);
			}
			else
			{
				$ibfshout[$num] = "<a href='{$ibforums->base_url}act=Profile&CODE=03&MID={$r['mid']}'><b>{$r['name']}</b></a> -- {$r['message']}<br>";
			}
		}
		
		if (($shoutbox['online'] == '1') && ($this->member['g_view_dshoutbox'] == 1 || $this->member['use_dshoutbox'] == 1))
		{
			if (($this->member['g_view_dshoutbox'] != 1 || $this->member['use_dshoutbox'] != 1) && ($ibforums->member['id'] > 0))
			{
				$globalshouts = $shoutbox['error_msg_3'];
			}
			else if (($ibforums->member['id'] == "" || $ibforums->member['id'] == "0") && ($shoutbox['guestviewsb'] == 0)) 
			{
				$globalshouts = $shoutbox['error_msg_1'];
			}
			else
			{
				if ($shoutbox['gseffect'] == '0')
				{
					$DB->query("SELECT m.*, m.id AS mid, s.* FROM ibf_shoutbox s, ibf_members m WHERE s.name=m.name ORDER BY s.id DESC LIMIT {$shoutbox['gsnum']}");
					while($r = $DB->fetch_row())
					{
						$r['message'] = stripslashes($r[message]);
						$r['message'] = "<span style='color: ".$r['color']."'>".$r['message']."</span>";
						$r['message'] = $this->bad_words($r['message']);
						$r['message'] = $this->global_clean($r['message']);

						if (($ibforums->member['id'] == "0" || $ibforums->member['id'] == "" || $this->member['name'] == "Guest" || $this->member['name'] == "") && ($shoutbox['guestviewsb'] != "1"))
						{
							$gshouts = stripslashes($shoutbox['error_msg_1']);
						}
						else
						{
							$gshouts .= "<a href='{$ibforums->base_url}act=Profile&CODE=03&MID={$r['mid']}'><b>{$r['name']}</b></a> -- {$r['message']}<br>\n";
						}
					}

					$globalshouts = $gshouts;
				}
				else if ($shoutbox['gseffect'] == '1')
				{
					$DB->query("SELECT m.*, m.id AS mid, s.* FROM ibf_shoutbox s, ibf_members m WHERE s.name=m.name ORDER BY s.id DESC LIMIT {$shoutbox['gsnum']}");
					while($r = $DB->fetch_row())
					{
						$r['message'] = stripslashes($r[message]);
						$r['message'] = "<span style='color: ".$r['color']."'>".$r['message']."</span>";
						$r['message'] = $this->bad_words($r['message']);
						$r['message'] = $this->global_clean($r['message']);

						if (($ibforums->member['id'] == "0" || $ibforums->member['id'] == "" || $this->member['name'] == "Guest" || $this->member['name'] == "") && ($shoutbox['guestviewsb'] != "1"))
						{
							$gshouts = stripslashes($shoutbox['error_msg_1']);
						}
						else
						{
							$gshouts .= "<a href='{$ibforums->base_url}act=Profile&CODE=03&MID={$r['mid']}'><b>{$r['name']}</b></a> -- {$r['message']} &nbsp; &middot; &nbsp; ";
						}
					}

					$globalshouts = "<marquee>{$gshouts}</marquee>";					
				}
				else if ($shoutbox['gseffect'] == '2')
				{
					$DB->query("SELECT m.*, m.id AS mid, s.* FROM ibf_shoutbox s, ibf_members m WHERE s.name=m.name ORDER BY s.id DESC LIMIT {$shoutbox['gsnum']}");
					while($r = $DB->fetch_row())
					{
						$r['message'] = stripslashes($r[message]);
						$r['message'] = "<span style='color: ".$r['color']."'>".$r['message']."</span>";
						$r['message'] = $this->bad_words($r['message']);
						$r['message'] = $this->global_clean($r['message']);

						if (($ibforums->member['id'] == "0" || $ibforums->member['id'] == "" || $this->member['name'] == "Guest" || $this->member['name'] == "") && ($shoutbox['guestviewsb'] != "1"))
						{
							$gshouts = stripslashes($shoutbox['error_msg_1']);
						}
						else
						{
							$gshouts .= "<a href='{$ibforums->base_url}act=Profile&CODE=03&MID={$r['mid']}'><b>{$r['name']}</b></a> -- {$r['message']} &nbsp; &middot; &nbsp; ";
						}
					}

					$globalshouts = "<marquee direction='right'>{$gshouts}</marquee>";					
				}
				else if ($shoutbox['gseffect'] == '3')
				{
					$globalshouts = "
					<script language='JavaScript'>
					var delay = 2000
					var fcontent = new Array()
					fcontent[1] = \"{$ibfshout[1]}\"
					fcontent[2] = \"{$ibfshout[2]}\"
					fcontent[3] = \"{$ibfshout[3]}\"
					fcontent[4] = \"{$ibfshout[4]}\"
					fcontent[5] = \"{$ibfshout[5]}\"
					fcontent[6] = \"{$ibfshout[6]}\"
					fcontent[7] = \"{$ibfshout[7]}\"
					fcontent[8] = \"{$ibfshout[8]}\"
					fcontent[9] = \"{$ibfshout[9]}\"
					fcontent[10] = \"{$ibfshout[10]}\"
					fcontent[11] = \"{$ibfshout[11]}\"
					fcontent[12] = \"{$ibfshout[12]}\"
					fcontent[13] = \"{$ibfshout[13]}\"
					fcontent[14] = \"{$ibfshout[14]}\"
					fcontent[15] = \"{$ibfshout[15]}\"

					var fadescheme = 0
					var fadelinks = 1

					var hex = (fadescheme==0) ? 255 : 0
					var startcolor = (fadescheme==0) ? 'rgb(255,255,255)' : 'rgb(0,0,0)'
					var endcolor = (fadescheme==0) ? 'rgb(0,0,0)' : 'rgb(255,255,255)'

					var ie4 = document.all&&!document.getElementById
					var ns4 = document.layers
					var DOM2 = document.getElementById
					var faderdelay = 0
					var index = 1

					if (DOM2)
					faderdelay = 2000

					function changecontent()
					{
						if (index>{$shoutbox['gsnum']})
						index=1
						if (DOM2)
						{
							document.getElementById('fscroller').style.color = startcolor
							document.getElementById('fscroller').innerHTML = fcontent[index]
							linksobj = document.getElementById('fscroller').getElementsByTagName('A')
							if (fadelinks)
							{
								linkcolorchange(linksobj)
								colorfade()
							}
						}
						else if (ie4)
						{
							document.all.fscroller.innerHTML = fcontent[index]
						}
						else if (ns4)
						{
							document.fscrollerns.document.fscrollerns_sub.document.write(fcontent[index])
							document.fscrollerns.document.fscrollerns_sub.document.close()
						}
	
						index++
						setTimeout('changecontent()',delay+faderdelay)
					}

					frame = 20;
					function linkcolorchange(obj)
					{
						if (obj.length>0)
						{
							for (i=0;i<obj.length;i++)
							obj[i].style.color = 'rgb('+hex+','+hex+','+hex+')'
						}
					}

					function colorfade()
					{
						if(frame>0)
						{
							hex = (fadescheme==0) ? hex-12 : hex+12
							document.getElementById('fscroller').style.color = 'rgb('+hex+','+hex+','+hex+')';
							if (fadelinks)
							{
								linkcolorchange(linksobj)
								frame--;
								setTimeout('colorfade()',20);
							}
						}
						else
						{
							document.getElementById('fscroller').style.color = endcolor;
							frame = 20;
							hex = (fadescheme==0) ? 255 : 0
						}
					}

					if (ie4 || DOM2)
					{
						document.write('<div id=\"fscroller\" style=\"width:70%;padding:2px\"></div>')
					}
					window.onload=changecontent
					</script>

					<ilayer id='fscrollerns' valign='top' width=&{fwidth}; height=&{fheight};>
					<layer id='fscrollerns_sub' valign='top' width=&{fwidth}; height=&{fheight}; left=0 top=0></layer>
					</ilayer>";
				}
				else if ($shoutbox['gseffect'] == '4')
				{
					$globalshouts = "
					<script language='Javascript'>
					var scrollerdelay = '2000'
					var scrollerwidth = '560px'
					var scrollerheight = '58px'
					var scrollerbgcolor = ''
					var scrollerbackground = ''
					var messages = new Array()
					messages[0] = \"\"
					messages[1] = \"{$ibfshout[1]}\"
					messages[2] = \"{$ibfshout[2]}\"
					messages[3] = \"{$ibfshout[3]}\"
					messages[4] = \"{$ibfshout[4]}\"
					messages[5] = \"{$ibfshout[5]}\"
					messages[6] = \"{$ibfshout[6]}\"
					messages[7] = \"{$ibfshout[7]}\"
					messages[8] = \"{$ibfshout[8]}\"
					messages[9] = \"{$ibfshout[9]}\"
					messages[10] = \"{$ibfshout[10]}\"
					messages[11] = \"{$ibfshout[11]}\"
					messages[12] = \"{$ibfshout[12]}\"
					messages[13] = \"{$ibfshout[13]}\"
					messages[14] = \"{$ibfshout[14]}\"
					messages[15] = \"{$ibfshout[15]}\"

					var ie = document.all
					var dom = document.getElementById

					if (messages.length>2)
					{
						i=2
					}
					else
					{
						i=1
					}
	
					function move1(whichlayer)
					{
						if (i > {$shoutbox['gsnum']})
						i = 1
						tlayer = eval(whichlayer)
						if (tlayer.top>0 && tlayer.top<=5)
						{
							tlayer.top=0
							setTimeout('move1(tlayer)',scrollerdelay)
							setTimeout('move2(document.main.document.second)',scrollerdelay)
							return
						}
						if (tlayer.top >= tlayer.document.height*-1)
						{
							tlayer.top-=5
							setTimeout('move1(tlayer)',50)
						}
						else
						{
							tlayer.top = parseInt(scrollerheight)
							tlayer.document.write(messages[i])
							tlayer.document.close()
							if (i == messages.length-1)
							{
								i=1
							}
							else
							{
								i++
							}
						}
					}
	
					function move2(whichlayer)
					{
						if (i > {$shoutbox['gsnum']})
						i = 1
						tlayer2 = eval(whichlayer)
						if (tlayer2.top>0 && tlayer2.top<=5)
						{
							tlayer2.top = 0
							setTimeout('move2(tlayer2)',scrollerdelay)
							setTimeout('move1(document.main.document.first)',scrollerdelay)
							return
						}
						if (tlayer2.top >= tlayer2.document.height*-1)
						{
							tlayer2.top-=5
							setTimeout('move2(tlayer2)',50)
						}
						else
						{
							tlayer2.top = parseInt(scrollerheight)
							tlayer2.document.write(messages[i])
							tlayer2.document.close()
							if (i == messages.length-1)
							{
								i=1
							}
							else
							{
								i++
							}
						}
					}

					function move3(whichdiv)
					{
						if (i > {$shoutbox['gsnum']})
						i = 1
						tdiv = eval(whichdiv)
						if (parseInt(tdiv.style.top)>0 && parseInt(tdiv.style.top)<=5)
						{
							tdiv.style.top = 0+'px'
							setTimeout('move3(tdiv)',scrollerdelay)
							setTimeout('move4(second2_obj)',scrollerdelay)
							return
						}
						if (parseInt(tdiv.style.top) >= tdiv.offsetHeight*-1)
						{
							tdiv.style.top = parseInt(tdiv.style.top)-5+'px'
							setTimeout('move3(tdiv)',50)
						}
						else
						{
							tdiv.style.top = parseInt(scrollerheight)
							tdiv.innerHTML = messages[i]
							if (i == messages.length-1)
							{
								i=1
							}
							else
							{
								i++
							}
						}
					}
	
					function move4(whichdiv)
					{
						if (i > {$shoutbox['gsnum']})
						i = 1
						tdiv2 = eval(whichdiv)
						if (parseInt(tdiv2.style.top)>0 && parseInt(tdiv2.style.top)<=5)
						{
							tdiv2.style.top = 0+'px'
							setTimeout('move4(tdiv2)',scrollerdelay)
							setTimeout('move3(first2_obj)',scrollerdelay)
							return
						}
						if (parseInt(tdiv2.style.top) >= tdiv2.offsetHeight*-1)
						{
							tdiv2.style.top = parseInt(tdiv2.style.top)-5+'px'
							setTimeout('move4(second2_obj)',50)
						}
						else
						{
							tdiv2.style.top = parseInt(scrollerheight)
							tdiv2.innerHTML = messages[i]
							if (i == messages.length-1)
							{
								i=1
							}
							else
							{
								i++
							}
						}
					}
		
					function startscroll()
					{
						if (ie || dom)
						{
							first2_obj = ie ? first2 : document.getElementById('first2')
							second2_obj = ie ? second2 : document.getElementById('second2')
							move3(first2_obj)
							second2_obj.style.top = scrollerheight
							second2_obj.style.visibility = 'visible'
						}
						else if (document.layers)
						{
							document.main.visibility = 'show'
							move1(document.main.document.first)
							document.main.document.second.top = parseInt(scrollerheight)+5
							document.main.document.second.visibility = 'show'
						}
					}
					window.onload=startscroll
					</script>
		
					<ilayer id='main' width=&{scrollerwidth}; height=&{scrollerheight}; visibility=hide>
					<layer id='first' left=0 top=1 width=&{scrollerwidth};>
					<script language='Javascript'>
					if (document.layers)
					document.write(messages[1])
					</script>
					</layer>
					<layer id='second' left=0 top=0 width=&{scrollerwidth}; visibility=hide>
					<script language='Javascript'>
					if (document.layers)
					document.write(messages[dyndetermine=(messages.length==1)? 1 : 1])
					</script>
					</layer>
					</ilayer>
		
					<script language='Javascript'>
					if (ie || dom)
					{
						document.writeln('<div id=\"main2\" style=\"position:relative;width:'+scrollerwidth+';height:'+scrollerheight+';overflow:hidden;background-color:'+scrollerbgcolor+';\">')
						document.writeln('<div style=\"position:absolute;width:'+scrollerwidth+';height:'+scrollerheight+';clip:rect(0 '+scrollerwidth+' '+scrollerheight+' 0);left:0px;top:0px\">')
						document.writeln('<div id=\"first2\" style=\"position:absolute;width:'+scrollerwidth+';left:0px;top:1px;\">')
						document.write(messages[0])
						document.writeln('</div>')
						document.writeln('<div id=\"second2\" style=\"position:absolute;width:'+scrollerwidth+';left:0px;top:0px;visibility:hidden\">')
						document.write(messages[dyndetermine=(messages.length==1)? 1 : 1])
						document.writeln('</div>')
						document.writeln('</div>')
						document.writeln('</div>')
					}
					</script>";
				}
			}
		}
		else
		{
			$globalshouts = $shoutbox['error_msg_2'];
		}
		
		return $globalshouts;
	}
	
	//------------------------------------------------
	// Clean up Mr. Global Shout please.  :)
	//------------------------------------------------
	
	function global_clean($txt)
	{
		global $DB, $shoutbox;

		if ($shoutbox['global_rlb'] == 1)
		{
			$txt = str_replace("<br>", "&nbsp;", $txt);
			$txt = str_replace("<br />", "&nbsp;", $txt);
		}
		
		return $txt;
	}
	
	//------------------------------------------------
	// Um, What is my page number, sir?
	//------------------------------------------------
	
	function get_pages($start)
	{
		global $ibforums, $DB, $skin_universal, $shoutbox;

		if ($ibforums->input['view'] == 'regular')
		{
			$this->viewreg = "&view=regular";
			if ($ibforums->input['sbsearch']<>"")
			{
				if ($ibforums->input['searchtype'] == 'author')
				{
					if ($ibforums->input['searchhow'] == 'begins')
					{
						$this->viewreg .= "&searchtype=author&searchhow=begins&searchinput={$ibforums->input['searchinput']}";
					}
					else
					{
						$this->viewreg .= "&searchtype=author&searchhow=contains&searchinput={$ibforums->input['searchinput']}";
					}
				}
				else if ($ibforums->input['searchtype'] == 'shout')
				{
					if ($ibforums->input['searchhow'] == 'begins')
					{
						$this->viewreg .= "&searchtype=shout&searchhow=begins&searchinput={$ibforums->input['searchinput']}";
					}
					else
					{
						$this->viewreg .= "&searchtype=shout&searchhow=contains&searchinput={$ibforums->input['searchinput']}";
					}
				}
			}
		}

		$this->sbs = "";
		if ($ibforums->input['searchtype'] == 'author')
		{
			if ($ibforums->input['searchhow'] == 'begins')
			{
				$this->sbs .= "&searchtype=author&searchhow=begins&searchinput={$ibforums->input['searchinput']}";
			}
			else
			{
				$this->sbs .= "&searchtype=author&searchhow=contains&searchinput={$ibforums->input['searchinput']}";
			}
		}
		else if ($ibforums->input['searchtype'] == 'shout')
		{
			if ($ibforums->input['searchhow'] == 'begins')
			{
				$this->sbs .= "&searchtype=shout&searchhow=begins&searchinput={$ibforums->input['searchinput']}";
			}
			else
			{
				$this->sbs .= "&searchtype=shout&searchhow=contains&searchinput={$ibforums->input['searchinput']}";
			}
		}

		$start = $ibforums->input['start'];
		$author = $ibforums->input['author'];
		$shout = $ibforums->input['shout'];
		
		if ($ibforums->input['searchtype'] == 'author')
		{
			if ($ibforums->input['searchhow'] == 'begins')
			{
				$qextra = "AND name LIKE '{$ibforums->input['searchinput']}%'";
			}
			else
			{
				$qextra = "AND name LIKE '%{$ibforums->input['searchinput']}%'";
			}
		}
		else if ($ibforums->input['searchtype'] == 'shout')
		{
			if ($ibforums->input['searchhow'] == 'begins')
			{
				$qextra = "AND message LIKE '{$ibforums->input['searchinput']}%'";
			}
			else
			{
				$qextra = "AND message LIKE '%{$ibforums->input['searchinput']}%'";
			}
		}

		if ($author<>"")
		{
			$qextra .= " AND name='{$author}'";
		}
		if ($shout<>"")
		{
			$qextra .= " AND id='{$shout}'";
		}

		if (!$start)
		{
			$start = 0;
		}

		$n = $DB->query("SELECT * FROM ibf_shoutbox WHERE id>0 {$qextra}");
		$tsnum = $DB->get_num_rows($n);
		$totalshouts = $tsnum+1;
		$burl = $ibforums->base_url."&act=Shoutbox{$this->viewreg}{$this->sbs}";
		
		$work = array();
		$section = ($data['leave_out'] == "") ? 2 : $data['leave_out'];
		$work['pages'] = 1;
		
		if ( ($totalshouts % $shoutbox['postspp']) == 0 )
		{
			$work['pages'] = $totalshouts / $shoutbox['postspp'];
		}
		else
		{
			$number = ($totalshouts / $shoutbox['postspp']);
			$work['pages'] = ceil($number);
		}
		
		
		$work['total_page'] = $work['pages'];
		$work['current_page'] = $start > 0 ? ($start / $shoutbox['postspp']) + 1 : 1;
		
	
		if ($work['pages'] > 1)
		{
			$work['first_page'] = $skin_universal->make_page_jump($totalshouts,$shoutbox['postspp'], $burl)." (".$work['pages'].")";
			
			for( $i = 0; $i <= $work['pages'] - 1; ++$i )
			{
				$RealNo = $i * $shoutbox['postspp'];
				$PageNo = $i+1;
				
				if ($RealNo == $start)
				{
					$work['page_span'] .= "&nbsp;<b>[{$PageNo}]</b>";
				}
				else
				{
					if ($PageNo < ($work['current_page'] - $section))
					{
						$work['st_dots'] = "&nbsp;<a href='{$burl}&start=0'>&laquo; {$ibforums->lang['ps_first']}</a>&nbsp;...";
						continue;
					}

					if ($PageNo > ($work['current_page'] + $section))
					{
						$work['end_dots'] = "...&nbsp;<a href='{$burl}&start=".($work['pages']-1) * $shoutbox['postspp']."'>{$ibforums->lang['ps_last']} &raquo;</a>";
						break;
					}
					
					
					$work['page_span'] .= "&nbsp;<a href='{$burl}&start={$RealNo}'>{$PageNo}</a>";
				}
			}
			
			$work['return'] = $work['first_page'].$work['st_dots'].$work['page_span'].'&nbsp;'.$work['end_dots'];
		}
		else
		{
			$work['return'] = "";
		}
	
		return $work['return'];
	}

	//------------------------------------------------
	// Flood Warning!  Where are the sandbags at?
	//------------------------------------------------
	
	function flood_check($member)
	{
		global $iforums, $DB, $std, $shoutbox;

		$DB->query("SELECT * FROM ibf_members WHERE name='{$member}'");
		$mem = $DB->fetch_row();

		if ( $shoutbox['flood_seconds'] > 0 )
		{
			if ( time() - $mem['last_shout_time'] < $shoutbox['flood_seconds'] )
			{
				$check = $std->Error( array( 'LEVEL' => 1, 'MSG' => 'flood_control' , 'EXTRA' => $shoutbox['flood_seconds'] ) );
			}
			else
			{
				$num1 = 0;
				$DB->query("SELECT name FROM ibf_shoutbox ORDER BY id DESC LIMIT {$shoutbox['flood']}");
				while ($namearray = $DB->fetch_row())
				{
					$name1 = $namearray['name'];
					if ($name1 == $mem['name'])
					{
						$num1++;
					}
						
					if ($num1 >= $shoutbox['flood'])
					{
						$check = $std->error(array('LEVEL' => 1, MSG => 'no_flood_shoutbox'));
					}
				}	
			}
		}
		else
		{
			$check = "";
		}

		return $check;
	}

	//------------------------------------------------
	// Update me!  Wait, do I need updated?
	//------------------------------------------------
	
	function run_update()
	{
		global $ibforums, $DB, $shoutbox;

		if ($shoutbox['autodelete'] == 1)
		{
			$shoutbox['addays'] = ($shoutbox['addays'] > 0) ? $shoutbox['addays'] : 10;
			$time_del = $shoutbox['addays'] * 24 * 60 * 60;
			$DB->query("DELETE FROM ibf_shoutbox WHERE time_time<'". (time() - $time_del) . "'");
		}

		$time = date("jS F Y");		
		if ($this->member['dshout_today'])
		{
			$mst = explode( "|", $this->member['dshout_today'] );
			$msh = $mst[0];
			$mti = $mst[1];
		
			if ($mti != $time)
			{
				$DB->query("UPDATE {$ibforums->vars['sql_tbl_prefix']}members SET dshout_today='0|{$time}' WHERE id='{$ibforums->member['id']}'");
			}
		}
		
		if ($this->member['g_dshout_today'])
		{
			$gst = explode( "|", $this->member['g_dshout_today'] );
			$gsh = $gst[0];
			$gti = $gst[1];
		
			if ($gti != $time)
			{
				$DB->query("UPDATE {$ibforums->vars['sql_tbl_prefix']}groups SET g_dshout_today='0|{$time}' WHERE g_id='{$this->member['mgroup']}'");
			}
		}
	}

	//------------------------------------------------
	// Am I A Shoutbox Moderator?
	//------------------------------------------------
	
	function shbox_mod()
	{
		global $ibforums, $DB;
		
		if ($this->member['g_dshoutbox_mod'] == 1 || $this->member['dshoutbox_mod'] == 1)
		{
			$modopts = $this->sb_display('dsbmodopts');
			$sboxmod = "<div style='display:{$modopts['fc']}' id='fc_dsbmodopts'>
						<div class='pformstrip'><div style='float:right;width:auto'><img src='{$ibforums->vars['html_url']}/sys-img/plus.gif' border='0' style='cursor: hand' onclick=\"togglecategory('dsbmodopts', 0)\"></div>
						<div>{$ibforums->lang['dsb_mod_opts']}</div></div></div><p>
						<div style='display:{$modopts['fo']}' id='fo_dsbmodopts'>
						<div class='pformstrip'><div style='float:right;width:auto'><img src='{$ibforums->vars['html_url']}/sys-img/minus.gif' border='0' style='cursor: hand' onclick=\"togglecategory('dsbmodopts', 1)\"></div>
						<div>{$ibforums->lang['dsb_mod_opts']}</div></div>
						<input type='submit' name='submit' value='{$ibforums->lang['mod_delsel']}' class='forminput'>
						<input type='button' value='{$ibforums->lang['mod_selall']}' onclick='SelectAll()' class='forminput'></form></div><p>";
		}
		else
		{
			$sboxmod = "</form>";
		}
		
		return $sboxmod;
	}

	function sb_display($id)
	{
		global $DB, $ibforums, $std;

		$dsb_ids = ",".$std->my_getcookie('dsbsets').",";

		$show['fo'] = 'show';
		$show['fc'] = 'none';

		if ( strstr( $dsb_ids, $id ) )
		{
			$show['fo'] = 'none';
			$show['fc'] = 'show';
		}

		return $show;
	}

	function get_sbrules()
	{
		global $DB;

		$DB->query("SELECT * FROM ibf_cache_store WHERE cs_key='sbrules'");
		$sbrules = $DB->fetch_row();

		return $sbrules['cs_value'];
	}
}
?>