<?php
/*
+--------------------------------------------------------------------------
|   D-Shoutbox -- The High-Tech Shoutbox
|   =======================================================
|   By Dean
|    2003-2004 Dean
|   http://www.dscripting.com
|   ========================================================
|   Web: http://www.dscripting.com
|   Email: dean@dscripting.com
+--------------------------------------------------------------------------
*/

$Shoutbox = new Shoutbox;

class Shoutbox {

  var $html;
  var $output   = "";
  var $base_url = "";
  var $badwords = "";
  var $version  = "5.7.4";
  var $nav;

	//------------------------------------------------
	// Main Shoutbox Function
	//------------------------------------------------

	function sberror($msg)
	{
		global $ibforums, $DB, $std, $print, $skin_universal, $sbfunc, $shoutbox;

		$DB->query("SELECT s.*, t.template, c.css_text
					FROM ibf_skins s
					LEFT JOIN ibf_templates t ON (t.tmid=s.tmpl_id)
					LEFT JOIN ibf_css c ON (s.css_id=c.cssid)
					WHERE s.default_set=1");

		$ibforums->skin = $DB->fetch_row();
		$ibforums->session_id = $std->my_getcookie('session_id');

		$ibforums->base_url   = $ibforums->vars['board_url'].'/index.'.$ibforums->vars['php_ext'].'?s='.$ibforums->session_id;
		$ibforums->skin_rid   = $ibforums->skin['set_id'];
		$ibforums->skin_id    = 's'.$ibforums->skin['set_id'];

		if ($ibforums->vars['default_language'] == "")
		{
			$ibforums->vars['default_language'] = 'en';
		}

		$ibforums->lang_id = $sbfunc->member['language'] ? $sbfunc->member['language'] : $ibforums->vars['default_language'];

		if ( ($ibforums->lang_id != $ibforums->vars['default_language']) and (! is_dir( $ibforums->vars['base_dir']."lang/".$ibforums->lang_id ) ) )
		{
			$ibforums->lang_id = $ibforums->vars['default_language'];
		}

		$ibforums->lang = $std->load_words($ibforums->lang, "lang_shoutbox", $ibforums->lang_id);

		$ibforums->vars['img_url']   = 'style_images/' . $ibforums->skin['img_dir'];

		list($em_1, $em_2) = explode( '@', $ibforums->vars['email_in'] );

	    $msg = stripslashes($msg);

		$html = $skin_universal->Error( $msg, $em_1, $em_2);
    	    	
		if ($ibforums->member['id'] == "" and $error['MSG'] != 'server_too_busy' and $error['MSG'] != 'account_susp')
		{
			$html = str_replace( "<!--IBF.LOG_IN_TABLE-->", $skin_universal->error_log_in($_SERVER['QUERY_STRING']), $html);
		}
    	
		if ( $ibforums->input['act'] == 'Post' OR $ibforums->input['act'] == 'Msg' OR $ibforums->input['act'] == 'calendar' )
		{
			if ( $_POST['Post'] )
			{
				$post_thing = $skin_universal->error_post_textarea($std->txt_htmlspecialchars($std->txt_stripslashes($_POST['Post'])) );

				$html = str_replace( "<!--IBF.POST_TEXTAREA-->", $post_thing, $html );
			}
		}

		$print->add_output($html);
		$print->do_output( array(
									OVERRIDE   => 1,
									TITLE      => "{$ibforums->vars['board_name']}: {$shoutbox['sbname']}",
						 )		);
	}
  
	function Shoutbox()
	{
		global $ibforums, $DB, $std, $print, $skin_universal, $sbfunc, $shoutbox;

		$ibforums->lang = $std->load_words($ibforums->lang, 'lang_shoutbox', $ibforums->lang_id);
		if ($shoutbox['skin_selection'] == 'new')
		{
			$this->html = $std->load_template('skin_shoutbox');
		}
		else if ($shoutbox['skin_selection'] == 'old')
		{
			$this->html = $std->load_template('skin_shoutbox2');
		}

		$sbfunc->run_update();

		if ($ibforums->input['view'] == 'regular')
		{
			$this->viewreg = "&view=regular";
		}
		if ($ibforums->input['searchtype'] == 'author')
		{
			if ($ibforums->input['searchhow'] == 'begins')
			{
				$this->sbs .= "&searchtype=author&searchhow=begins&searchinput={$ibforums->input['searchinput']}";
			}
			else
			{
				$this->sbs .= "&searchtype=author&searchhow=contains&searchinput={$ibforums->input['searchinput']}";
			}
		}
		else if ($ibforums->input['searchtype'] == 'shout')
		{
			if ($ibforums->input['searchhow'] == 'begins')
			{
				$this->sbs .= "&searchtype=shout&searchhow=begins&searchinput={$ibforums->input['searchinput']}";
			}
			else
			{
				$this->sbs .= "&searchtype=shout&searchhow=contains&searchinput={$ibforums->input['searchinput']}";
			}
		}
		if (!$ibforums->member['id'] )
		{
			$ibforums->input['last_visit'] = time();
		}
		if ($shoutbox['sbname'] == "" || !$shoutbox['sbname'])
		{
			$shoutbox['sbname'] = $ibforums->lang['dshoutbox'];
		}

		$sbrules = $sbfunc->get_sbrules();
		require "./sources/lib/post_parser.php";

		if ($ibforums->input['sbmod'])
		{
			switch($ibforums->input['sbmod'])
			{
				case '01':
					$this->banmem();
					break;
				case '02':
					$this->unbanmem();
					break;
				case '03':
					$this->delshout();
					break;
				case '04':
					$this->editshout();
					break;
				case '05':
					$this->doeditshout();
					break;
				case '06':
					$this->closewindow();
					break;
				case '07':
					$this->delmulti();
					break;
				case '08':
					$this->userdelshout();
					break;
				default:
					$this->sberror($shoutbox['error_msg_4']);
					break;
			}
		}

		$this->base_url = "{$ibforums->vars['board_url']}";

		if ($sbfunc->member['sb_shoutboxtype'] == 2)
		{
			$this->nav = array( "<a href='javascript:' onclick=\"window.open('{$ibforums->vars['board_url']}/index.php?act=Shoutbox','DShoutbox','width=377,height=440,resizable=no,location=no,menubar=no,status=no,left=0,top=0,screenX=0,screenY=0,scrollbars=no'); return false\">{$shoutbox['sbname']}</a>" );
		}
		else
		{
			$this->nav = array( "<a href='{$ibforums->base_url}act=Shoutbox'>{$shoutbox['sbname']}</a>" );
		}

		//--------------------------------
		//  Permission To View?
		//--------------------------------
	
		if ($shoutbox['online'] != 1)
		{
			$this->sberror($shoutbox['error_msg_2']);
		}

		if (($ibforums->member['id'] == "" || $ibforums->member['id'] == "0") && ($shoutbox['guestviewsb'] == 0)) 
		{
			$this->sberror($shoutbox['error_msg_1']);
		}

		if (($sbfunc->member['g_view_dshoutbox'] != 1 || $sbfunc->member['use_dshoutbox'] != 1) && ($ibforums->member['id'] > 0))
		{
			$this->sberror($shoutbox['error_msg_3']);
		}

		$bannerurl = $shoutbox['bannerurl'];

		if ($sbfunc->member['g_view_dshoutbox'] != 1 && $ibforums->input['Post']<>"")
		{
			$this->sberror($shoutbox['error_msg_3']);
		}

		$start = $ibforums->input['start'];
		if ($start == "" or $start <= 0)
		{
			$start = 0;
		}

		if($ibforums->input['Post']<>"")
		{
			$this->Post_Shout();
			if ($ibforums->input['viewing'] == 'iframe' || $ibforums->input['viewing'] == 'popup')
			{
				$sbfunc->refresh("{$ibforums->vars['board_url']}/sb_iframe.php?step=three&clear=1");
			}
			else if ($ibforums->input['viewing'] == "regular" || $ibforums->input['viewing'] == "" || !$ibforums->input['viewing'])
			{
				$sbfunc->refresh("{$_SERVER['HTTP_REFERER']}");
			}
		}

		if ($ibforums->input['sbmod'] == 04)
		{
			$this->editshout();
		}
		else if ($ibforums->input['sbmod'] == 05)
		{
			$this->doeditshout();
		}
		if ($ibforums->input['view'] == 'rules')
		{
			$this->output .= $this->html->PageTop();

			$this->output .= $this->html->rules_begin();

			$this->output .= $sbfunc->get_sbrules();

			$this->output .= $this->html->PageFoot($this->version);

			$this->output .= "<center><br><a href='{$ibforums->base_url}&act=Shoutbox'>{$ibforums->lang['back_to']} {$shoutbox['sbname']}</a></center>";
		}
		else if ($ibforums->input['view'] == 'regular')
		{
			$this->output .= $this->html->PageTop();

			if ($shoutbox['banner'] == 1)
			{
				$this->output .= $this->html->show_banner($bannerurl);
			}

			$this->output .= $this->html->begin_shoutbox();

			if ($shoutbox['sbdisplay'] == 'L')
			{
				$this->output .= $this->Render_Shouts();

				$this->output .= "<p>".$sbfunc->get_pages($start);

				$this->output .= $this->html->Content_Separate();

				$this->output .= $this->html->Submit_Box_h();

				$this->get_replaces();

				if ($shoutbox['smiliestable'] == 1 && $sbfunc->member['sb_showsmiliest'] == 1)
				{	
					$this->smilie_table();
				}

			}
			else if ($shoutbox['sbdisplay'] == 'R')
			{
				$this->output .= $this->html->Submit_Box_h();

				$this->get_replaces();

				if ($shoutbox['smiliestable'] == 1 && $sbfunc->member['sb_showsmiliest'] == 1)
				{	
					$this->smilie_table();
				}

				$this->output .= $this->html->Content_Separate();

				$this->output .= $this->Render_Shouts();

				$this->output .= "<p>".$sbfunc->get_pages($start);
			}

			$this->output .= $this->html->PageFoot($this->version);
		}
		else if ($sbfunc->member['sb_shoutboxtype'] == 2)
		{
			$print->pop_up_window($shoutbox['sbname'], $this->html->shoutbox_popup());
		}
		else if ($sbfunc->member['sb_shoutboxtype'] == 1)
		{
			$this->output .= $this->html->PageTop();

			if ($shoutbox['banner']==1)
			{
				$this->output .= $this->html->show_banner($bannerurl);
			}

			$this->output .= $this->html->begin_shoutbox();

			$this->output .= $this->html->shoutbox_iframe($shoutbox['iframeh']);

			$this->output .= $this->html->PageFoot($this->version);
		}
		else if ($sbfunc->member['sb_shoutboxtype'] == 0)
		{
			$this->output .= $this->html->PageTop();

			if ($shoutbox['banner'] == 1)
			{
				$this->output .= $this->html->show_banner($bannerurl);
			}

			$this->output .= $this->html->begin_shoutbox();

			if ($shoutbox['sbdisplay'] == 'L')
			{
				$this->output .= $this->Render_Shouts();

				$this->output .= "<p>".$sbfunc->get_pages($start);

				$this->output .= $this->html->Content_Separate();

				$this->output .= $this->html->Submit_Box_h();

				$this->get_replaces();

				if ($shoutbox['smiliestable'] == 1 && $sbfunc->member['sb_showsmiliest'] == 1)
				{	
					$this->smilie_table();
				}

			}
			else if ($shoutbox['sbdisplay'] == 'R')
			{
				$this->output .= $this->html->Submit_Box_h();

				$this->get_replaces();

				if ($shoutbox['smiliestable'] == 1 && $sbfunc->member['sb_showsmiliest'] == 1)
				{	
					$this->smilie_table();
				}

				$this->output .= $this->html->Content_Separate();

				$this->output .= $this->Render_Shouts();

				$this->output .= "<p>".$sbfunc->get_pages($start);
			}

			$this->output .= $this->html->PageFoot($this->version);
		}

		$print->add_output("$this->output");

		$print->do_output( array( 'TITLE' => $ibforums->vars['board_name']." ".$shoutbox['sbname'] , 'JS' => 0, 'NAV' => $this->nav ) );
	}

	//------------------------------------------------
	// Shows the smilies table if turned on
	//------------------------------------------------

	function smilie_table()
	{
		global $ibforums, $DB, $shoutbox;

		$show_table = 0;
		$count      = 0;
		$smilies    = "<tr align='center'>\n";

		// Get the smilies from the DB

		$DB->query("SELECT * FROM ibf_emoticons WHERE clickable='1'");
		while ($elmo = $DB->fetch_row())
		{
			$show_table++;
			$count++;

			// Make single quotes as URL's with html entites in them
			// are parsed by the browser, so ' causes JS error :o

			if (strstr($elmo['typed'], "&#39;"))
			{
				$in_delim  = '"';
				$out_delim = "'";
			}
			else
			{
				$in_delim  = "'";
				$out_delim = '"';
			}

			$smilies .= "<td><a href={$out_delim}javascript:add_emoticon($in_delim".$elmo['typed']."$in_delim){$out_delim}><img src=\"".$ibforums->vars['EMOTICONS_URL']."/".$elmo['image']."\" alt='{$ibforums->lang['smilie']}' border='0' /></a>&nbsp;</td>\n";

			if ($count == 5)
			{
				$smilies .= "</tr>\n\n<tr align='center'>";
				$count = 0;
			}
		}

		if ($count != $ibforums->vars['emo_per_row'])
		{
			for ($i = $count ; $i < $ibforums->vars['emo_per_row'] ; ++$i)
			{
				$smilies .= "<td>&nbsp;</td>\n";
			}
			$smilies .= "</tr>";
		}

		$table = preg_replace( "/<!--THE SMILIES-->/", $smilies,$this->html->smilie_table() );
		$this->output = preg_replace( "/<!--SMILIE TABLE-->/", $table, $this->output );
	}
	
	//------------------------------------------------
	// Get some replaces for the Shoutbox
	//------------------------------------------------

	function get_replaces()
	{
		global $ibforums, $DB, $std, $print, $skin_universal, $sbfunc, $shoutbox;

		$allowed = $shoutbox['allowsmilies'] == 1  ? "Smilies Are <i>Allowed</i><br>\n" : "Smilies Are <i>Not Allowed</i><br>\n";
		$allowed .= $shoutbox['allowbbcodes'] == 1 ? "BBCodes Are <i>Allowed</i><br>\n" : "BBCodes Are <i>Not Allowed</i><br>\n";

		$this->output = preg_replace( "/<!--ALLOWED OPTIONS-->/", $allowed, $this->output );

		$this->output = preg_replace( "/<!--SEARCH DSHOUTBOX-->/", $this->html->dsb_search(), $this->output );

		if ($shoutbox['usesbcard'] == 1)
		{
			$this->output = preg_replace( "/<!--D-SHOUTBOX CARD-->/", $this->html->sbcard(), $this->output );
		}
		
		if ($shoutbox['showou']==1)
		{
			$this->output = preg_replace( "/<!--ONLINE MEMBERS-->/", $sbfunc->active_shouters(), $this->output );
		}
		
		if ($shoutbox['showtods'] == 1 && $sbfunc->member['sb_showtdshouters'] == 1)
		{
			$this->output = preg_replace( "/<!--TODAY SHOUTERS-->/", $this->Shouters_Today(), $this->output );
		}

		if ($shoutbox['showtops'] == 1 && $sbfunc->member['sb_showtpshouters'] == 1)
		{
			$this->output = preg_replace( "/<!--OVERALL SHOUTERS-->/", $this->Render_Top_Shouters(), $this->output );
		}
	}

	//------------------------------------------------
	// Adds a new shout into the shoutbox
	//------------------------------------------------

	function Post_Shout()
	{
		global $INFO, $ibforums, $DB, $std, $print, $skin_universal, $sbfunc, $shoutbox;

		$name    = $sbfunc->member['name'];
		$uid     = $ibforums->member['id'];
		$message = $ibforums->input['Post'];
		$color   = $ibforums->input['Color'];

		$sbfunc->flood_check($name);

		if ($sbfunc->member['g_post_dshoutbox'] != 1)
		{
			$this->sberror($shoutbox['error_msg_5']);
		}

		$ma = explode("|", $sbfunc->member['dshouts_today']);
		$ms = $ma[0];
		$ga = explode("|", $sbfunc->member['g_dshouts_today']);
		$gs = $ga[0];

		if ($sbfunc->member['dshout_limit'] != 0 || $sbfunc->member['g_dshout_limit'] != 0)
		{
			if ($ms > $sbfunc->member['dshout_limit'] || $gs > $sbfunc->member['g_dshout_limit'])
			{
				$this->sberror($shoutbox['error_msg_9']);
			}
		}

		if($shoutbox['guestposting'] == 0 AND $sbfunc->member['name']=="Guest" OR $ibforums->member['id'] == 0)
		{
			$this->sberror($shoutbox['error_msg_6']);
		}

		if ($shoutbox['usesbcard']==1 && ($shoutbox['chargeperpost'] > $sbfunc->member['sb_sbcard_value']))
		{
			$std->Error( array( 'LEVEL' => 1, 'MSG' => 'not_enough_card_value') );
		}

		if(trim($message)=="")
		{
			$std->Error( array( 'LEVEL' => 1, 'MSG' => 'no_message') );
		}

		if ($color == "")
		{
			$color = $sbfunc->member['sb_defaultcolor'];
		}

		$parser = new post_parser(1);
		$message = $parser->unconvert($message);
		$message = preg_replace('/\[img]/i', '', $message);
		$message = preg_replace('/\[\/img]/i', '', $message);
		$message = preg_replace('/<img/i', '', $message);
		$message = trim($parser->convert( array( 	TEXT    => $message,
													SMILIES => $shoutbox['allowsmilies'],
													CODE    => $shoutbox['allowbbcodes'],
													HTML    => 0
										)	)	);
		$message = addslashes($message);

		$time = date("jS F Y");
		$DB->query("INSERT INTO ibf_shoutbox (name, uid, message, time, time_time, color) VALUES ('$name','$uid','$message','$time','".time()."','$color')");

		if ($shoutbox['usesbcard'] == 1 && $shoutbox['chargeperpost'] != "")
		{
			$DB->query("UPDATE ibf_members SET sb_sbcard_value = sb_sbcard_value - ".$shoutbox['chargeperpost']." WHERE id='".$ibforums->member['id']."'");
		}
		if ($shoutbox['useshopp'] == 1)
		{
			if ($shoutbox['shoppoints'] == "")
			{
				$shoutbox['shoppoints'] = '0';
			}
			$DB->query("UPDATE ibf_members SET points = points + ".$shoutbox['shoppoints']." WHERE id='".$ibforums->member['id']."'");
		}
		if ($shoutbox['usestorep'] == 1)
		{
			if ($shoutbox['storepoints'] == "")
			{
				$shoutbox['storepoints'] = '0';
			}
			$DB->query("UPDATE ibf_members SET points = points + ".$shoutbox['storepoints']." WHERE id='".$ibforums->member['id']."'");
		}

		$a = explode( "|", $sbfunc->member['dshouts_today'] );
		$b = $a[0]+1;
		$c = explode( "|", $sbfunc->member['g_dshouts_today'] );
		$d = $c[0]+1;
		$dstoday = $b."|".$time;
		$dstodayg = $d."|".$time;

		$DB->query("UPDATE ibf_members SET dshouts=dshouts+1, dshouts_alltime=dshouts_alltime+1, last_shout_time='".time()."', dshouts_today='{$dstoday}' WHERE id='".$ibforums->member['id']."'");
		$DB->query("UPDATE ibf_groups SET g_dshouts_today='{$dstoday}' WHERE g_id='".$sbfunc->member['mgroup']."'");
		$DB->query("UPDATE ibf_shoutbox_stats SET totalshouts=totalshouts+1, shouts_alltime=shouts_alltime+1");
	}
  
	//------------------------------------------------
	// Display the shouts in the shoutbox
	//------------------------------------------------

	function Render_Shouts()
	{
		global $ibforums, $DB, $std, $shoutbox, $sbfunc;

		$DB->query("UPDATE ibf_shoutbox SET name='{$sbfunc->member['name']}' WHERE uid='{$ibforums->member['id']}'");
		
		$shouts = "";
		$ppp = $shoutbox['postspp'];

		$start = $ibforums->input['start'];
		$author = $ibforums->input['author'];
		$shout = $ibforums->input['shout'];
		
		if ($ibforums->input['searchtype'] == 'author')
		{
			if ($ibforums->input['searchhow'] == 'begins')
			{
				$qextra = "AND s.name LIKE '{$ibforums->input['searchinput']}%'";
			}
			else
			{
				$qextra = "AND s.name LIKE '%{$ibforums->input['searchinput']}%'";
			}
		}
		if ($ibforums->input['searchtype'] == 'shout')
		{
			if ($ibforums->input['searchhow'] == 'begins')
			{
				$qextra = "AND s.message LIKE '{$ibforums->input['searchinput']}%'";
			}
			else
			{
				$qextra = "AND s.message LIKE '%{$ibforums->input['searchinput']}%'";
			}
		}

		if ($author<>"")
		{
			$qextra = " AND s.name='{$author}'";
		}
		if ($shout<>"")
		{
			$qextra .= " AND s.id='".$shout."'";
		}

		if ($start == "" or $start <= 0)
		{
			$start = 0;
		}

		$DB->query("SELECT g.prefix, g.suffix, m.*, m.id AS mid, s.* FROM ibf_shoutbox s, ibf_members m, ibf_groups g WHERE s.name=m.name AND m.mgroup=g.g_id {$qextra} ORDER BY s.id DESC LIMIT $start, $ppp");
		while($r = $DB->fetch_row())
		{
			$r['prefix']	=	stripslashes($r['prefix']);
			$r['suffix']	=	stripslashes($r['suffix']);
			$r['message'] 	= 	stripslashes($r[message]);
			$r['message'] 	= 	"<span style='color: {$r['color']}'>{$r['message']}</span>";
			$r['message']	=	$sbfunc->bad_words($r['message']);

			if ($shoutbox['wordwrap'] > 0)
			{
				$r['message'] = $sbfunc->wordwrap($r['message'], $shoutbox['wordwrap']);
			}

			if ($sbfunc->member['sb_showshouttime'] == 1)
			{
				if ($r['time_time']<>'0')
				{
					$r['time'] = $std->get_date($r[time_time], 'LONG');
				}
			}

			if ($shoutbox['showava'] == 1 && $sbfunc->member['sb_showavatars'] == 1)
			{
				$r['ava'] = $sbfunc->get_avatar( $r['avatar'], 1, $r['avatar_size'] );
			}
			
			if ($sbfunc->member['g_dshoutbox_mod'] == 1 || $sbfunc->member['dshoutbox_mod'] == 1)
			{
				$sbm = "<a href='javascript:' onclick=\"mod_edit_shout('{$r['id']}')\">{$ibforums->lang['edit_shout']}</a> | <a href='{$ibforums->base_url}&act=Shoutbox&sbmod=03&sid={$r['id']}'>{$ibforums->lang['del_shout']}</a> | ";
				if ($r['use_dshoutbox'] == '1')
				{
					$sbm .= "<a href='{$ibforums->base_url}&act=Shoutbox&sbmod=01&mid={$id}'>{$ibforums->lang['ban_member']}</a>";
				}
				else if ($r['use_dshoutbox'] == '0')
				{
					$sbm .= "<a href='{$ibforums->base_url}&act=Shoutbox&sbmod=02&mid={$id}'>{$ibforums->lang['unban_member']}</a>";
				}
			}
			else if ($r['uid'] == $ibforums->member['id'])
			{
				$sbm = "<a href='{$ibforums->base_url}&act=Shoutbox&sbmod=08&sid={$r['id']}'>{$ibforums->lang['del_shout']}</a>";
			}
			else
			{
				$sbm = "";
			}
			
			if ($sbfunc->member['g_dshoutbox_mod'] == 1 || $sbfunc->member['dshoutbox_mod'] == 1)
			{
				$chb = "<input type='checkbox' name='shoutid_{$r['id']}' value='shoutid_{$r['id']}'> ";
			}
			else
			{
				$chb = "";
			}

			$shouts .= $this->html->Render_Shout($r, $sbm, $chb);
		}

		return $shouts;
	}

	//------------------------------------------------
	// Displays the top shouters overall
	//------------------------------------------------

	function Render_Top_Shouters()
	{
		global $INFO, $ibforums, $DB, $std, $print, $skin_universal, $sbfunc, $shoutbox;

		$top_shouters = "";
		$DB->query("SELECT g.prefix, g.suffix, s.*, m.* FROM ibf_shoutbox s, ibf_members m, ibf_groups g WHERE s.name=m.name AND m.mgroup=g.g_id GROUP BY s.name ORDER BY m.dshouts_alltime DESC, m.id ASC LIMIT {$shoutbox['topsnum']}");
		while ($r = $DB->fetch_row())
		{
			$r['prefix'] = stripslashes($r['prefix']);
			$r['suffix'] = stripslashes($r['suffix']);

			$top_shouters .= $this->html->Render_Name_Top($r);
		}

		$DB->query("SELECT * FROM ibf_shoutbox_stats");
		$stuff = $DB->fetch_row();

		return $this->html->Top_Shouters( array(
													'top_shouters'	=>	$top_shouters,
													'count'			=>	$stuff['shouts_alltime']
										)	   );
	}

	//------------------------------------------------
	// Displays the top shouters for today
	//------------------------------------------------

	function Shouters_Today()
	{
		global $INFO, $ibforums, $DB, $std, $print, $skin_universal, $sbfunc, $shoutbox;

		$shouters = "";
		$time = date("jS F Y");
		$DB->query("SELECT g.prefix, g.suffix, s.name, COUNT(s.name) as count, m.id FROM ibf_shoutbox s, ibf_members m, ibf_groups g WHERE s.name=m.name AND m.mgroup=g.g_id AND time='$time' GROUP BY s.name ORDER by count DESC, m.id ASC LIMIT {$shoutbox['todsnum']}");
		while ($r = $DB->fetch_row())
		{
			$r['prefix'] = stripslashes($r['prefix']);
			$r['suffix'] = stripslashes($r['suffix']);

			$shouters .= $this->html->Render_Name($r);
		}

		$DB->query("SELECT COUNT(*) as count2 FROM ibf_shoutbox WHERE time='$time'");
		$stuff = $DB->fetch_row();
		$count1 = $stuff['count2'];

		return $this->html->Shouters_Today(	array(
													'shouters'	=>	$shouters,
													'count'		=>	$count1
										  )		 );
	}
 
	//+---------------------------------------------------------------------------------
	// D-Shoutbox Moderator Options
	//+---------------------------------------------------------------------------------

	function banmem()
	{
		global $ibforums, $DB, $std, $sbfunc, $shoutbox;

		if ($sbfunc->member['dshoutbox_mod'] == 1)
		{
			$mid = $ibforums->input['mid'];
			$DB->query("SELECT use_dshoutbox FROM ibf_members WHERE id='{$mid}'");
			$r = $DB->fetch_row();
			if ($r['use_dshoutbox'] == 0)
			{
				$std->Error( array( 'LEVEL' => 1, 'MSG' => 'mod_already_banned') );
			}

			$DB->query("UPDATE ibf_members SET use_dshoutbox='0' WHERE id='{$mid}'");
			$sbfunc->refresh("{$ibforums->base_url}&act=Shoutbox{$this->viewreg}{$this->sbs}");
			exit();
		}
		else if ($sbfunc->member['g_dshoutbox_mod'] == 1)
		{
			$mid = $ibforums->input['mid'];
			$DB->query("SELECT use_dshoutbox FROM ibf_members WHERE id='{$mid}'");
			$r = $DB->fetch_row();
			if ($r['use_dshoutbox'] == 0)
			{
				$std->Error( array( 'LEVEL' => 1, 'MSG' => 'mod_already_banned') );
			}

			$DB->query("UPDATE ibf_members SET use_dshoutbox='0' WHERE id='{$mid}'");
			$sbfunc->refresh("{$ibforums->base_url}&act=Shoutbox{$this->viewreg}{$this->sbs}");
			exit();
		}
		else
		{
			$this->sberror($shoutbox['error_msg_4']);
		}
	}

	function unbanmem()
	{
		global $ibforums, $DB, $std, $sbfunc, $shoutbox;

		if ($sbfunc->member['dshoutbox_mod'] == 0)
		{
			$mid = $ibforums->input['mid'];
			$DB->query("SELECT use_dshoutbox FROM ibf_members WHERE id='{$mid}'");
			$r = $DB->fetch_row();
			if ($r['use_dshoutbox'] == 1)
			{
				$std->Error( array( 'LEVEL' => 1, 'MSG' => 'mod_already_unbanned') );
			}

			$DB->query("UPDATE ibf_members SET use_dshoutbox='1' WHERE id='{$mid}'");
			$sbfunc->refresh("{$ibforums->base_url}&act=Shoutbox{$this->viewreg}{$this->sbs}");
			exit();
		}
		else if ($sbfunc->member['g_dshoutbox_mod'] == 1)
		{
			$mid = $ibforums->input['mid'];
			$DB->query("SELECT use_dshoutbox FROM ibf_members WHERE id='{$mid}'");
			$r = $DB->fetch_row();
			if ($r['use_dshoutbox'] == 1)
			{
				$std->Error( array( 'LEVEL' => 1, 'MSG' => 'mod_already_unbanned') );
			}

			$DB->query("UPDATE ibf_members SET use_dshoutbox='1' WHERE id='{$mid}'");
			$sbfunc->refresh("{$ibforums->base_url}&act=Shoutbox{$this->viewreg}{$this->sbs}");
			exit();
		}
		else
		{
			$this->sberror($shoutbox['error_msg_4']);
		}
	}

	function delshout()
	{
		global $ibforums, $DB, $std, $sbfunc, $shoutbox;

		if ($sbfunc->member['dshoutbox_mod'] == 1)
		{
			$sid = $ibforums->input['sid'];
			if (!$sid)
			{
				$std->Error( array( 'LEVEL' => 1, 'MSG' => 'mod_invalid_id') );
			}
			$DB->query("SELECT * FROM ibf_shoutbox WHERE id='{$sid}'");
			if ($DB->get_num_rows() <= 0)
			{
				$std->Error( array( 'LEVEL' => 1, 'MSG' => 'mod_invalid_id') );
			}

			$DB->query("SELECT name FROM ibf_shoutbox WHERE id='{$sid}'");
			$dc = $DB->fetch_row();
			$DB->query("DELETE FROM ibf_shoutbox WHERE id='{$sid}'");
			$DB->query("UPDATE ibf_members SET dshouts=dshouts-1 WHERE name='{$dc['name']}'");
			$DB->query("UPDATE ibf_shoutbox_stats SET totalshouts=totalshouts-1");

			$sbfunc->refresh("{$ibforums->base_url}&act=Shoutbox{$this->viewreg}{$this->sbs}");
			exit();
		}
		else if ($sbfunc->member['g_dshoutbox_mod'] == 1)
		{
			$sid = $ibforums->input['sid'];
			if (!$sid)
			{
				$std->Error( array( 'LEVEL' => 1, 'MSG' => 'mod_invalid_id') );
			}
			$DB->query("SELECT * FROM ibf_shoutbox WHERE id='{$sid}'");
			if ($DB->get_num_rows() <= 0)
			{
				$std->Error( array( 'LEVEL' => 1, 'MSG' => 'mod_invalid_id') );
			}

			$DB->query("SELECT name FROM ibf_shoutbox WHERE id='{$sid}'");
			$dc = $DB->fetch_row();
			$DB->query("DELETE FROM ibf_shoutbox WHERE id='{$sid}'");
			$DB->query("UPDATE ibf_members SET dshouts=dshouts-1 WHERE name='{$dc['name']}'");
			$DB->query("UPDATE ibf_shoutbox_stats SET totalshouts=totalshouts-1");

			$sbfunc->refresh("{$ibforums->base_url}&act=Shoutbox{$this->viewreg}{$this->sbs}");
			exit();
		}
		else
		{
			$this->sberror($shoutbox['error_msg_4']);
		}
	}
  
	function closewindow()
	{
		global $ibforums, $DB, $std, $print, $shoutbox, $sbfunc;

		$print->pop_up_window('Close Window', $this->html->mod_closewindow());
	}
  
	function delmulti()
	{
		global $ibforums, $DB, $std, $sbfunc, $shoutbox;

		if ($sbfunc->member['dshoutbox_mod'] == 1)
		{
			$sids = array();

 			foreach ($ibforums->input as $key => $value)
 			{
 				if ( preg_match( "/^shoutid_(\d+)$/", $key, $match ) )
 				{
 					if ($ibforums->input[$match[0]])
 					{
 						$sids[] = $match[1];
 					}
 				}
 			}

			$affected_ids = count($sids);

 			if ( $affected_ids > 0 )
 			{
 				foreach($sids as $id)
 				{
 					$DB->query("SELECT name FROM ibf_shoutbox WHERE id='{$id}'");
 					$b = $DB->fetch_row();
 					$DB->query("DELETE FROM ibf_shoutbox WHERE id='{$id}'");
 					$DB->query("UPDATE ibf_members SET dshouts=dshouts-1 WHERE name='{$b['name']}'");
 				}
				$sbfunc->refresh("{$ibforums->base_url}&act=Shoutbox{$this->viewreg}{$this->sbs}");
				$DB->query("UPDATE ibf_shoutbox_stats SET totalshouts=totalshouts-$affected_ids");
				exit();
 			}
 		}
		else if ($sbfunc->member['g_dshoutbox_mod'] == 1)
		{
			$sids = array();

 			foreach ($ibforums->input as $key => $value)
 			{
 				if ( preg_match( "/^shoutid_(\d+)$/", $key, $match ) )
 				{
 					if ($ibforums->input[$match[0]])
 					{
 						$sids[] = $match[1];
 					}
 				}
 			}

 			$affected_ids = count($sids);

 			if ( $affected_ids > 0 )
 			{
 				$id_string = implode( ",", $sids );

				$DB->query("DELETE FROM ibf_shoutbox WHERE id IN ($id_string)");
				$sbfunc->refresh("{$ibforums->base_url}&act=Shoutbox{$this->viewreg}{$this->sbs}");
				exit();
 			}
		}
		else
		{
			$this->sberror($shoutbox['error_msg_4']);
		}
	}

	function editshout()
	{
		global $ibforums, $DB, $std, $print, $sbfunc, $shoutbox;

		if ($sbfunc->member['dshoutbox_mod'] == 1)
		{
			$sid = $ibforums->input['sid'];
			if (!$sid)
			{
				$std->Error( array( 'LEVEL' => 1, 'MSG' => 'mod_invalid_id') );
			}
			$DB->query("SELECT * FROM ibf_shoutbox WHERE id='{$sid}'");
			if ($DB->get_num_rows() <= 0)
			{
				$std->Error( array( 'LEVEL' => 1, 'MSG' => 'mod_invalid_id') );
			}

			$parser = new post_parser(1);
			$DB->query("SELECT * FROM ibf_shoutbox WHERE id='{$sid}'");
			$es = $DB->fetch_row();
			$es['message'] = $parser->unconvert($es['message']);
			$DB->query("SELECT * FROM ibf_shoutbox_colors");
			while ($co = $DB->fetch_row())
			{
				$colors .= ($es['color'] == $co['color']) ? "<option value='{$co['color']}' style='color: {$co['color']}' selected>{$co['color']}</option>\n" : "<option value='{$co['color']}' style='color: {$co['color']}'>{$co['color']}</option>\n";
			}
			$print->pop_up_window('Editing Shout', $this->html->mod_edit_shout($es, "<select name='Color' class='forminput'>{$colors}</select>"));
			exit();
		}
		else if ($sbfunc->member['g_dshoutbox_mod'] == 1)
		{
			$sid = $ibforums->input['sid'];
			if (!$sid)
			{
				$std->Error( array( 'LEVEL' => 1, 'MSG' => 'mod_invalid_id') );
			}
			$DB->query("SELECT * FROM ibf_shoutbox WHERE id='{$sid}'");
			if ($DB->get_num_rows() <= 0)
			{
				$std->Error( array( 'LEVEL' => 1, 'MSG' => 'mod_invalid_id') );
			}

			$parser = new post_parser(1);
			$DB->query("SELECT * FROM ibf_shoutbox WHERE id='{$sid}'");
			$es = $DB->fetch_row();
			$es['message'] = $parser->unconvert($es['message']);
			$DB->query("SELECT * FROM ibf_shoutbox_colors");
			while ($co = $DB->fetch_row())
			{
				$colors .= ($es['color'] == $co['color']) ? "<option value='{$co['color']}' style='color: {$co['color']}' selected>{$co['color']}</option>\n" : "<option value='{$co['color']}' style='color: {$co['color']}'>{$co['color']}</option>\n";
			}
			$print->pop_up_window('Editing Shout', $this->html->mod_edit_shout($es, "<select name='Color' class='forminput'>{$colors}</select>"));
			exit();
		}
		else
		{
			$this->sberror($shoutbox['error_msg_4']);
		}
	}

	function doeditshout()
	{
		global $ibforums, $DB, $std, $sbfunc, $shoutbox;

		if ($sbfunc->member['dshoutbox_mod'] == 1)
		{
			$sid = $ibforums->input['sid'];
			$shout = $ibforums->input['Post'];
			$color = $ibforums->input['Color'];
			if (!$sid)
			{
				$std->Error( array( 'LEVEL' => 1, 'MSG' => 'mod_invalid_id') );
			}
			$DB->query("SELECT * FROM ibf_shoutbox WHERE id='{$sid}'");
			if ($DB->get_num_rows() <= 0)
			{
				$std->Error( array( 'LEVEL' => 1, 'MSG' => 'mod_invalid_id') );
			}
			if (!$shout)
			{
				$std->Error( array( 'LEVEL' => 1, 'MSG' => 'mod_empty_shout') );
			}
			if (!$color)
			{
				$DB->query("SELECT name FROM ibf_shoutbox WHERE id='{$sid}'");
				$a = $DB->fetch_row();
				$DB->query("SELECT sb_defaultcolor FROM ibf_members WHERE name='{$a['name']}'");
				$b = $DB->fetch_row();
				$color = $b['sb_defaultcolor'];
			}

			$parser2 = new post_parser(1);

			$shout = $parser2->unconvert($shout);
			$shout = preg_replace('/\[img]/i', '', $shout);
			$shout = preg_replace('/\[\/img]/i', '', $shout);
			$shout = preg_replace('/<img/i', '', $shout);
			$shout = trim($parser2->convert( array( 	TEXT    => $shout,
														SMILIES => $shoutbox['allowsmilies'],
														CODE    => $shoutbox['allowbbcodes'],
														HTML    => 0
											)	)	);
			$shout = addslashes($shout);

			$DB->query("UPDATE ibf_shoutbox SET message='{$shout}', color='{$color}' WHERE id='{$sid}'");
			$sbfunc->refresh("{$ibforums->base_url}&act=Shoutbox&sbmod=06{$this->viewreg}{$this->sbs}");
		}
		else if ($sbfunc->member['g_dshoutbox_mod'] == 1)
		{
			$sid = $ibforums->input['sid'];
			$shout = $ibforums->input['Post'];
			$color = $ibforums->input['Color'];
			if (!$sid)
			{
				$std->Error( array( 'LEVEL' => 1, 'MSG' => 'mod_invalid_id') );
			}
			$DB->query("SELECT * FROM ibf_shoutbox WHERE id='{$sid}'");
			if ($DB->get_num_rows() <= 0)
			{
				$std->Error( array( 'LEVEL' => 1, 'MSG' => 'mod_invalid_id') );
			}
			if (!$shout)
			{
				$std->Error( array( 'LEVEL' => 1, 'MSG' => 'mod_empty_shout') );
			}
			if (!$color)
			{
				$DB->query("SELECT name FROM ibf_shoutbox WHERE id='{$sid}'");
				$a = $DB->fetch_row();
				$DB->query("SELECT sb_defaultcolor FROM ibf_members WHERE name='{$a['name']}'");
				$b = $DB->fetch_row();
				$color = $b['sb_defaultcolor'];
			}
				
			$parser3 = new post_parser(1);
		
			$shout = $parser3->unconvert($shout);
			$shout = preg_replace('/\[img]/i', '', $shout);
			$shout = preg_replace('/\[\/img]/i', '', $shout);
			$shout = preg_replace('/<img/i', '', $shout);
			$shout = trim($parser3->convert( array( 	TEXT    => $shout,
														SMILIES => $shoutbox['allowsmilies'],
														CODE    => $shoutbox['allowbbcodes'],
														HTML    => 0
											)	)	);
			$shout = addslashes($shout);

			$DB->query("UPDATE ibf_shoutbox SET message='{$shout}', color='{$color}' WHERE id='{$sid}'");
			$sbfunc->refresh("{$ibforums->base_url}&act=Shoutbox&sbmod=06{$this->viewreg}{$this->sbs}");
		}
		else
		{
			$this->sberror($shoutbox['error_msg_4']);
		}
	}
  
	function userdelshout()
	{
		global $ibforums, $DB, $std, $print, $sbfunc, $shoutbox;

		$sid = $ibforums->input['sid'];
		$DB->query("SELECT * FROM ibf_shoutbox WHERE id='{$sid}'");
		$sh = $DB->fetch_row();
		$mname = $sh['name'];
		if ($sbfunc->member['name'] == $mname)
		{
			$DB->query("SELECT * FROM ibf_shoutbox WHERE id='{$sid}'");
			if ($DB->get_num_rows() <= 0)
			{
				$std->Error( array( 'LEVEL' => 1, 'MSG' => 'mod_invalid_id') );
			}

			$DB->query("DELETE FROM ibf_shoutbox WHERE id='{$sid}'");
			$DB->query("UPDATE ibf_members SET dshouts=dshouts-1 WHERE name='{$sbfunc->member['name']}'");
			$DB->query("UPDATE ibf_shoutbox_stats SET totalshouts=totalshouts-1");

			$sbfunc->refresh("{$ibforums->base_url}&act=Shoutbox{$this->viewreg}{$this->sbs}");
			exit();
		}
		else
		{
			$this->sberror($shoutbox['error_msg_8']);
		}
	}

	//------------------------------------------------
	// Render iframe shouts
	//------------------------------------------------
  
	function Render_Iframe_Shouts()
	{
  		global $INFO, $ibforums, $DB, $std, $sbfunc, $shoutbox;

		$shouts = "";
		$DB->query("SELECT g.prefix, g.suffix, m.id AS mid, m.use_dshoutbox, s.* FROM ibf_shoutbox s, ibf_members m, ibf_groups g WHERE s.name=m.name AND m.mgroup=g.g_id ORDER BY s.id DESC LIMIT 0, {$shoutbox['postspp']}");
		while($r= $DB->fetch_row())
		{
			$r['prefix']	=	stripslashes($r['prefix']);
			$r['suffix']	=	stripslashes($r['suffix']);
			$r['message'] 	= 	stripslashes($r[message]);
			$r['message'] 	=	preg_replace("/([^\n\r ?&\.\/<>\"\\-]{15})/i"," \\1<br>",$r['message']);
			$r['message']	=	"<span style='color: ".$r['color']."'>".$r['message']."</span>";

			$r['message'] = $sbfunc->bad_words($r['message']);

			if ( $shoutbox['wordwrap'] > 0 )
			{
				$r['message'] = $sbfunc->wordwrap($r['message'], $shoutbox['wordwrap']);
			}

			if ($sbfunc->member['sb_showshouttime'] == 1)
			{
				if ($r['time_time']<>'0')
				{
					$std->time_options['SB'] = 'H:i';
					$r['time'] = $std->get_date( $r[time_time], 'SB');
				}
			}
			$shouts .= $this->html->iframe_shout($r);
		}

		return $shouts;
	}
}
?>