<?php
/*
+--------------------------------------------------------------------------
|   D-Shoutbox -- The High-Tech Shoutbox
|   =======================================================
|   By Dean
|    2003-2004 Dean
|   http://www.dscripting.com
|   ========================================================
|   Web: http://www.dscripting.com
|   Email: dean@dscripting.com
+--------------------------------------------------------------------------
*/


$idx = new sbextras;

class sbextras {

    var $output    = "";
    var $base_url  = "";
    var $html      = "";

    function sbextras() {
    
    	//------------------------------------------------------
    	// $is_sub is a boolean operator.
    	// If set to 1, we don't show the "topic subscribed" page
    	// we simply end the subroutine and let the caller finish
    	// up for us.
    	//------------------------------------------------------
    
        global $ibforums, $DB, $std, $print, $skin_universal;
        
        $ibforums->lang    = $std->load_words($ibforums->lang, 'lang_shoutbox', $ibforums->lang_id );

    	$this->html = $std->load_template('skin_shoutbox');
    	
    	$this->base_url        = $ibforums->base_url;
    	
    	//--------------------------------------------
    	// What to do?
    	//--------------------------------------------
    	
    	switch($ibforums->input['CODE'])
    	{
    		case 'emoticons':
    			$this->show_emoticons();
    			break;
    			
    		case 'bbcode':
    			$this->show_bbcode();
    			break;

    		case 'emoticons2':
    			$this->show_emoticons2();
    			break;
    			
    		default:
    			$this->show_emoticons();
    			break;
    	}
    	
        $print->pop_up_window( $this->page_title, $this->output );
 	}

 	//--------------------------------------------------------------
 	
 	function show_emoticons()
 	{
 		global $ibforums, $DB, $std;
 		
 		$this->page_title = $ibforums->lang['emo_title'];
 		
 		$this->output .= $this->html->emoticon_javascript();
 		
 		$this->output .= $this->html->extras_header( $ibforums->lang['emo_title'], $ibforums->lang['emo_type'], $ibforums->lang['emo_img'] );
 		
 		$DB->query("SELECT typed, image from ibf_emoticons");
			
		if ( $DB->get_num_rows() )
		{
			while ( $r = $DB->fetch_row() )
			{
				if (strstr( $r['typed'], "&quot;" ) )
				{
					$in_delim  = "'";
					$out_delim = '"';
				}
				else
				{
					$in_delim  = '"';
					$out_delim = "'";
				}
			
				$this->output .= $this->html->emoticons_row( stripslashes($r['typed']), stripslashes($r['image']), $in_delim, $out_delim );
			}
		}
		$this->output .= $this->html->extras_footer();
 	}
 	
 	//--------------------------------------------------------------
 	// Show BBCode Helpy file
 	//--------------------------------------------------------------
 	
 	function show_bbcode()
 	{
 		global $ibforums, $DB, $std;
 		
 		require './sources/lib/post_parser.php';
 		
 		$this->parser = new post_parser();
 		
 		//-------------------------------------------
 		// Array out or stuff here
 		//-------------------------------------------
 		
 		$bbcode = array(
 		
 		0  => array( '[b]', '[/b]', $ibforums->lang['bbc_ex1'] ),
 		1  => array('[s]', '[/s]', $ibforums->lang['bbc_ex1'] ),
 		2  => array('[i]', '[/i]', $ibforums->lang['bbc_ex1'] ),
 		3  => array('[u]', '[/u]', $ibforums->lang['bbc_ex1'] ),
 		4  => array('[email]', '[/email]', 'user@domain.com' ),
 		5  => array('[email=user@domain.com]', '[/email]', $ibforums->lang['bbc_ex2'] ),
 		6  => array('[url]', '[/url]', 'http://www.domain.com' ),
 		7  => array('[url=http://www.domain.com]', '[/url]', $ibforums->lang['bbc_ex2'] ),
 		8  => array('[size=7]', '[/size]'    , $ibforums->lang['bbc_ex1'] ),
 		9  => array('[font=times]', '[/font]', $ibforums->lang['bbc_ex1'] ),
 		10 => array('[color=red]', '[/color]', $ibforums->lang['bbc_ex1'] ),
 		11 => array('[img]', '[/img]', $ibforums->vars['img_url'].'/icon11.gif' ),
 		12 => array('[list]', '[/list]', '[*]List Item [*]List Item' ),
 		13 => array('[list=1]', '[/list]', '[*]List Item [*]List Item' ),
 		14 => array('[list=a]', '[/list]', '[*]List Item [*]List Item' ),
 		15 => array('[list=i]', '[/list]', '[*]List Item [*]List Item' ),
 		16 => array('[quote]', '[/quote]', $ibforums->lang['bbc_ex1'] ),
 		17 => array('[code]', '[/code]', '$this_var = "Hello World!";' ),
 		18 => array('[sql]', '[/sql]', 'SELECT t.tid FROM a_table t WHERE t.val="This Value"' ),
 		19 => array('[html]', '[/html]', '&lt;a href=&quot;test/page.html&quot;&gt;A Test Page&lt;/a&gt;' ),
 		
 		);
 		
 		$this->page_title = $ibforums->lang['bbc_title'];
 		
 		$this->output .= $this->html->bbcode_header();
 		
 		$this->output .= $this->html->extras_header( $ibforums->lang['bbc_title'], $ibforums->lang['bbc_before'], $ibforums->lang['bbc_after'] );
 		
		foreach( $bbcode as $bbc )
		{
			$open    = $bbc[0];
			$close   = $bbc[1];
			$content = $bbc[2];
		
			$before = $this->html->wrap_tag($open) . $content . $this->html->wrap_tag($close);
			
			$after = $this->parser->convert( array( 'TEXT' => $open.$content.$close, 'CODE' => 1 ) );
		
			$this->output .= $this->html->bbcode_row( $before, stripslashes($after) );
		}
		
		$this->output .= $this->html->extras_footer();
 	}

 	//--------------------------------------------------------------
 	
 	function show_emoticons2()
 	{
 		global $ibforums, $DB, $std;
 		
 		$this->page_title = $ibforums->lang['emo_title'];
 		
 		$this->output .= $this->html->emoticon_javascript2();
 		
 		$this->output .= $this->html->extras_header( $ibforums->lang['emo_title'], $ibforums->lang['emo_type'], $ibforums->lang['emo_img'] );
 		
 		$DB->query("SELECT typed, image from ibf_emoticons");
			
		if ( $DB->get_num_rows() )
		{
			while ( $r = $DB->fetch_row() )
			{
				if (strstr( $r['typed'], "&quot;" ) )
				{
					$in_delim  = "'";
					$out_delim = '"';
				}
				else
				{
					$in_delim  = '"';
					$out_delim = "'";
				}
			
				$this->output .= $this->html->emoticons_row( stripslashes($r['typed']), stripslashes($r['image']), $in_delim, $out_delim );
			}
		}
		$this->output .= $this->html->extras_footer();
 	}
}

?>