<?php
/*
+--------------------------------------------------------------------------
|   D-Shoutbox -- The High-Tech Shoutbox
|   =======================================================
|   By Dean
|    2003-2004 Dean
|   http://www.dscripting.com
|   ========================================================
|   Web: http://www.dscripting.com
|   Email: dean@dscripting.com
+--------------------------------------------------------------------------
*/

$idx = new ad_Shoutbox();

class ad_Shoutbox {
	var $base_url;
	var $ver = "5.7.4";
	function ad_Shoutbox() {
		global $IN, $root_path, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $ibforums;
		$this->base_url = $INFO['board_url']."/admin.".$INFO['php_ext']."?adsess=".$IN['AD_SESS'];
		
		$ibforums->skin  = $std->load_skin();
		$INFO['img_url'] = "{$INFO['board_url']}/style_images/".$ibforums->skin['img_dir'];
		
		switch($IN['code']) {
			case '01':
				$this->delete();
				break;
			case '02':
				$this->dodelete();
				break;
			//-------------------------
			case '03':
				$this->userdelete();
				break;
			case '04':
				$this->douserdelete();
				break;
			//-------------------------
			case '05':
				$this->ban();
				break;
			case '06':
				$this->doban();
				break;
			//-------------------------
			case '07':
				$this->unban();
				break;
			case '08':
				$this->dounban();
				break;
			//-------------------------
			case '09':
				$this->settings();
				break;
			case '10':
				$this->save_settings();
				break;
			//-------------------------
			case '11':
				$this->deleteshout();
				break;
			//-------------------------
			case '12':
				$this->stats();
				break;
			//-------------------------
			case '13':
				$this->clearsb();
				break;
			case '14':
				$this->doclearsb();
				break;
			//-------------------------
			case '15':
				$this->updater();
				break;
			//-------------------------
			case '16':
				$this->sbcolors();
				break;
			case '17':
				$this->add_color();
				break;
			case '39':
				$this->mdcolors();
				break;
			//-------------------------
			case '18':
				$this->edit();
				break;
			case '19':
				$this->do_edit();
				break;
			//-------------------------
			case '20':
				$this->recount();
				break;
			case '21':
				$this->do_recount();
				break;
			//-------------------------
			case '22':
				$this->domulti();
				break;
			case '23':
				$this->domultiunban();
				break;
			//-------------------------
			case '24':
				$this->rules();
				break;
			case '25':
				$this->dorules();
				break;
			//-------------------------
			case '26':
				$this->groups();
				break;
			case '27':
				$this->editgroup();
				break;
			case '28':
				$this->dogroups();
				break;
			case '29':
				$this->resetgroups();
				break;
			case '30':
				$this->doresetgroups();
				break;
			case '31':
				$this->domultigroups();
				break;
			case '32':
				$this->doresetallgroups();
				break;
			//-------------------------
			case '33':
				$this->member_search();
				break;
			case '34':
				$this->domember_search();
				break;
			case '35':
				$this->edit_member();
				break;
			case '36':
				$this->doedit_member();
				break;
			//-------------------------
			case '37':
				$this->error_msg();
				break;
			case '38':
				$this->doerror_msg();
				break;
			//-------------------------
			case '40':
				$this->badwords();
				break;
			case '41':
				$this->add_badword();
				break;
			case '42':
				$this->multibadwords();
				break;
			//-------------------------			
			default:
				$this->main_screen();
				break;
		}
	}


	//+---------------------------------------------------------------------------------
	// Displays some stats from your shoutbox
	//+---------------------------------------------------------------------------------

	function stats() {
		global $IN, $root_path, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		//-------------------------------------------------------------------------------\\
		$SKIN->td_header[] = array( "&nbsp;"     , "70%" );
		$SKIN->td_header[] = array( "&nbsp;"     , "30%" );
		//-------------------------------------------------------------------------------\\

		$ADMIN->page_title = "D-Shoutbox: Statistics";
		$ADMIN->page_detail = "View stats from your Shoutbox";
		
		$DB->query("SELECT * FROM ibf_shoutbox_stats");
		$shoutb = $DB->fetch_row();
		$shouts = $shoutb['totalshouts'];
		
		$DB->query("SELECT * FROM ibf_members WHERE use_dshoutbox=0");
		$busers = $DB->get_num_rows();
		
		$time = date("jS F Y");
		$DB->query("SELECT * FROM ibf_shoutbox WHERE time='$time'");
		$shoutst = $DB->get_num_rows();

		$DB->query("SELECT * FROM ibf_members WHERE dshoutbox_mod=1");
		$smmod = $DB->get_num_rows();

		$DB->query("SELECT * FROM ibf_groups WHERE g_dshoutbox_mod=1");
		$sgmod = $DB->get_num_rows();

		$DB->query("SELECT g.prefix, g.suffix, s.*, COUNT(s.name) as count, m.*, m.id AS mid FROM ibf_shoutbox s, ibf_members m, ibf_groups g WHERE s.name=m.name AND m.mgroup=g.g_id AND time='$time' GROUP BY s.name ORDER by count DESC LIMIT 1");
		if ($r = $DB->fetch_row())
		{
			$topst = "<a href='{$INFO['board_url']}/index.php?act=Profile&CODE=03&MID={$r['mid']}' target='_blank'>{$r['prefix']}<b>{$r['name']}</b>{$r['suffix']}</a> &nbsp; - &nbsp; <a href='{$this->base_url}&act=Shoutbox&author={$r['name']}' target='body'>{$r['count']}</a>";
		}
		else
		{
			$topst = "<i>None</i>";
		}
		
		$DB->query("SELECT g.prefix, g.suffix, s.*, m.*, m.id AS mid FROM ibf_shoutbox s, ibf_members m, ibf_groups g WHERE s.name=m.name AND m.mgroup=g.g_id GROUP BY s.name ORDER by m.dshouts DESC LIMIT 1");
		$t = $DB->fetch_row();
		$topso = "<a href='{$INFO['board_url']}/index.php?act=Profile&CODE=03&MID={$t['mid']}' target='_blank'>{$t['prefix']}<b>{$t['name']}</b>{$t['suffix']}</a> &nbsp; - &nbsp; <a href='{$this->base_url}&act=Shoutbox&author={$t['name']}' target='body'>{$t['dshouts']}</a>";
		
		$DB->query("SELECT * FROM ibf_members WHERE sb_shoutboxtype=0 && id>0");
		$sps1 = $DB->get_num_rows();
		$DB->query("SELECT * FROM ibf_members WHERE sb_shoutboxtype=1 && id>0");
		$sps2 = $DB->get_num_rows();
		$DB->query("SELECT * FROM ibf_members WHERE sb_shoutboxtype=2 && id>0");
		$sps3 = $DB->get_num_rows();
		$DB->query("SELECT * FROM ibf_members WHERE sb_showavatars=1 && id>0");
		$sps4 = $DB->get_num_rows();
		$DB->query("SELECT * FROM ibf_members WHERE sb_showshouttime=1 && id>0");
		$sps5 = $DB->get_num_rows();
		$DB->query("SELECT * FROM ibf_members WHERE sb_showsmiliest=1 && id>0");
		$sps7 = $DB->get_num_rows();
		$DB->query("SELECT * FROM ibf_members WHERE sb_showtdshouters=1 && id>0");
		$sps8 = $DB->get_num_rows();
		$DB->query("SELECT * FROM ibf_members WHERE sb_showtpshouters=1 && id>0");
		$sps9 = $DB->get_num_rows();
		
		$ADMIN->html .= $SKIN->start_table( "D-Shoutbox Stats" );

		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Total Shouts</b>"                           , $shouts	 )	);
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Total Shouts Today</b>"                     , $shoutst	 )	);
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Total Banned Users</b>"                     , $busers	 )	);
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Top Shouter Today</b>"                      , $topst	 )	);
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Top Shouter Overall</b>"                    , $topso	 )	);
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Top Shouter Overall</b>"                    , $topso	 )	);
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Total D-Shoutbox Member Moderators</b>"     , $smmod	 )	);
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Total D-Shoutbox Group Moderators</b>"      , $sgmod	 )	);

		$ADMIN->html .= $SKIN->add_td_basic('D-Shoutbox Preference Stats', 'center', 'catrow2');
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Members using Regular shoutbox type</b>"    , $sps1	 )	);
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Members using Iframe shoutbox type</b>"     , $sps2	 )	);
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Members using Popup shoutbox type</b>"      , $sps3	 )	);
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Members showing avatars on shoutbox</b>"    , $sps4	 )	);
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Members showing shout time when posted</b>" , $sps5	 )	);
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Members showing smilie table</b>"           , $sps7	 )	);
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Members showing todays shouters</b>"        , $sps8	 )	);
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Members showing overall top shouters</b>"   , $sps9	 )	);
				
		$ADMIN->html .= $SKIN->end_table() . "<div align='center' style='width:100%;border:1px solid #BCD0ED;background-color: #DFE6EF;font-size:10px;margin:3px 0px 3px 0px;color:#3A4F6C;font-weight:bold;padding:8px'><input type='button' name='b2sb' value='Back To Main Page' onclick=\"window.location='{$SKIN->base_url}&act=Shoutbox'\" id='button'></div>" . $this->sbcopyright();

		$ADMIN->output();
	}

	//+---------------------------------------------------------------------------------
	// Shoutbox Color Settings
	//+---------------------------------------------------------------------------------
	
	function sbcolors() {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;

		$ADMIN->page_title = "D-Shoutbox: Colors";
		$ADMIN->page_detail = "Add/Edit/Delete the colors for your Shoutbox";

		//+-------------------------------
		$SKIN->td_header[] = array( "Color"   , "45%" );
		$SKIN->td_header[] = array( "Preview" , "45%" );
		$SKIN->td_header[] = array( "<input type='checkbox' id='button' name='sall' value='sall' onclick='SA()'>" , "10%" );
		//+-------------------------------

		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , '39'  ),
												  2 => array( 'act'   , 'Shoutbox' ),
						 )      );

		$ADMIN->html .= "<script language='Javascript'>
				function SA(v)
				{
					for (var i=0;i<document.theAdminForm.elements.length;i++)
					{
						 var e = document.theAdminForm.elements[i];
						 if(e.type=='checkbox')
						 {
						 	e.checked = document.all.sall.checked;
						 }
					}
				}
				</script>";
				
		$ADMIN->html .= $SKIN->start_table( "D-Shoutbox: Colors" );

		$DB->query("SELECT * FROM ibf_shoutbox_colors");
		while($color = $DB->fetch_row())
		{
			$ADMIN->html .= $SKIN->add_td_row( array( "<center>{$color['color']}</center>",
													  "<center><span style='color: {$color['color']}'>{$color['color']}</span></center>",
													  "<center><input type='checkbox' id='button' name='color_{$color['id']}' value='color_{$color['id']}'></center>"
											 )      );
		}

		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->html .= "<div align='center' style='width:100%;border:1px solid #BCD0ED;background-color: #DFE6EF;font-size:10px;margin:3px 0px 3px 0px;color:#3A4F6C;font-weight:bold;padding:8px'>" . $SKIN->end_form("Delete Selected") . "<input type='button' name='b2sb' value='Back To Main Page' onclick=\"window.location='{$SKIN->base_url}&act=Shoutbox'\"  id='button'></div><p>";

		$ADMIN->html .= "<form action='{$SKIN->base_url}&act=Shoutbox&code=17' method='post'><input type='hidden' name='adsess' value='{$IN['AD_SESS']}'>";
				
		$ADMIN->html .= $SKIN->start_table( "Add A Color" );

		$ADMIN->html .= $SKIN->add_td_row( array( "<center>Color:</center>",
												  $SKIN->form_input("color", "")
										 )      );

		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->html .= "<div align='center' style='width:100%;border:1px solid #BCD0ED;background-color: #DFE6EF;font-size:10px;margin:3px 0px 3px 0px;color:#3A4F6C;font-weight:bold;padding:8px'>" . $SKIN->end_form("Add Color") . "<input type='button' name='b2sb' value='Back To Main Page' onclick=\"window.location='{$SKIN->base_url}&act=Shoutbox'\"  id='button'></div><p>" . $this->sbcopyright();

		$ADMIN->output();

	}

	function add_color()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;
		
		$color = $IN['color'];
		if (!$color || $color == "")
		{
			$ADMIN->error("Please provide a valid color to add!");
		}
		
		$DB->query("INSERT INTO ibf_shoutbox_colors (color) VALUES ('{$color}')");
		$ADMIN->save_log("D-Shoutbox: Added A New Color");
		$std->boink_it("{$SKIN->base_url}&act=Shoutbox&code=16");
	}
	
	function mdcolors()
	{
		global $IN, $root_path, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;

		$cids = array();
 		foreach ($IN as $key => $value)
 		{
 			if ( preg_match( "/^color_(\d+)$/", $key, $match ) )
 			{
 				if ($IN[$match[0]])
 				{
 					$cids[] = $match[1];
 				}
 			}
 		}
 		
 		$affected_cids = count($cids);
		if ( $affected_cids > 0 )
		{
			$cid_string = implode( ",", $cids );
			
			$DB->query("DELETE FROM ibf_shoutbox_colors WHERE id IN ($cid_string)");
			$ADMIN->save_log("D-Shoutbox: Deleted Colors");
			$std->boink_it($SKIN->base_url."&act=Shoutbox&code=16");
		}
		else
 		{
 			$std->boink_it($SKIN->base_url."&act=Shoutbox&code=16");
			exit();
		}
 	}
 	
	//+---------------------------------------------------------------------------------
	// Shoutbox Badwords Filter
	//+---------------------------------------------------------------------------------
	
	function badwords() {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;

		$ADMIN->page_title = "D-Shoutbox: Badwords";
		$ADMIN->page_detail = "Add/Edit/Delete the badwords for your Shoutbox";

		//+-------------------------------
		$SKIN->td_header[] = array( "Badword"     , "40%" );
		$SKIN->td_header[] = array( "Replacement" , "40%" );
		$SKIN->td_header[] = array( "Matching"    , "10%" );
		$SKIN->td_header[] = array( "<input type='checkbox' id='button' name='ball' value='ball' onclick='SA()'>" , "10%" );
		//+-------------------------------

		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , '42'  ),
												  2 => array( 'act'   , 'Shoutbox' ),
						 )      );

		$ADMIN->html .= "<script language='Javascript'>
				function SA(v)
				{
					for (var i=0;i<document.theAdminForm.elements.length;i++)
					{
						 var e = document.theAdminForm.elements[i];
						 if(e.type=='checkbox')
						 {
						 	e.checked = document.all.ball.checked;
						 }
					}
				}
				</script>";
				
		$ADMIN->html .= $SKIN->start_table( "D-Shoutbox: Badwords" );

		$DB->query("SELECT * FROM ibf_shoutbox_badwords");	
		if ( $DB->get_num_rows() )
		{
			while ( $r = $DB->fetch_row() )
			{
				$words[] = $r;
			}
			
			usort($words, array( 'ad_Shoutbox', 'word_sort' ) );
			
			foreach($words as $idx => $r)
			{
				$replace = $r['switch'] ? stripslashes($r['switch']) : '*~*~*';
				$exact  = $r['exact'] ? 'Exact' : 'Loose';
				$ADMIN->html .= $SKIN->add_td_row( array( stripslashes($r['bword']),
														  $replace,
														  $exact,
														  "<center><input type='checkbox' id='button' name='bw_{$r['id']}' value='bw_{$r['id']}'></center>",
												 )      );
			}
			
		}

		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->html .= "<div align='center' style='width:100%;border:1px solid #BCD0ED;background-color: #DFE6EF;font-size:10px;margin:3px 0px 3px 0px;color:#3A4F6C;font-weight:bold;padding:8px'>" . $SKIN->end_form("Delete Selected") . "<input type='button' name='b2sb' value='Back To Main Page' onclick=\"window.location='{$SKIN->base_url}&act=Shoutbox'\"  id='button'></div><p>";

		//+-------------------------------
		$SKIN->td_header[] = array( "Badword"     , "40%" );
		$SKIN->td_header[] = array( "Replacement" , "40%" );
		$SKIN->td_header[] = array( "Option"      , "20%" );
		//+-------------------------------

		$ADMIN->html .= "<form action='{$SKIN->base_url}&act=Shoutbox&code=41' method='post'><input type='hidden' name='adsess' value='{$IN['AD_SESS']}'>";
				
		$ADMIN->html .= $SKIN->start_table( "D-Shoutbox: Add A Badword" );

		$ADMIN->html .= $SKIN->add_td_row( array( $SKIN->form_input("badword", ""),
												  $SKIN->form_input("replace", ""),
												  $SKIN->form_dropdown( 'exact', array( 0 => array( 1, 'Exact'  ), 1 => array( 0, 'Loose' ) ) )
										 )      );

		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->html .= "<div align='center' style='width:100%;border:1px solid #BCD0ED;background-color: #DFE6EF;font-size:10px;margin:3px 0px 3px 0px;color:#3A4F6C;font-weight:bold;padding:8px'>" . $SKIN->end_form("Add Badword") . "<input type='button' name='b2sb' value='Back To Main Page' onclick=\"window.location='{$SKIN->base_url}&act=Shoutbox'\"  id='button'></div><p>" . $this->sbcopyright();

		$ADMIN->output();

	}

	function add_badword()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;
		
		$bw = $IN['badword'];
		$rp = $IN['replace'];
		$ex = $IN['exact'];
		if (!$bw || $bw  == "")
		{
			$ADMIN->error("Please fill in a badword to add!");
		}
		if (!$rp || $rp == "")
		{
			$rp = "*~*~*";
		}
		
		$ex = $ex ? 1 : 0;
		strlen($bw) > 1 ? $bw : "";
		
		$db_string = $DB->compile_db_insert_string( array( 'bword'   => $bw,
														   'switch'  => $rp,
														   'exact'   => $ex,
												  )      );
												  
		$DB->query("INSERT INTO ibf_shoutbox_badwords (".$db_string['FIELD_NAMES'].") VALUES(".$db_string['FIELD_VALUES'].")");		
		$ADMIN->save_log("D-Shoutbox: Added A Badword");
		$std->boink_it("{$SKIN->base_url}&act=Shoutbox&code=40");
	}
	
	function multibadwords()
	{
		global $IN, $root_path, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;

		$bids = array();
 		foreach ($IN as $key => $value)
 		{
 			if ( preg_match( "/^bw_(\d+)$/", $key, $match ) )
 			{
 				if ($IN[$match[0]])
 				{
 					$bids[] = $match[1];
 				}
 			}
 		}
 		
 		$affected_bids = count($bids);
		if ( $affected_bids > 0 )
		{
			$bid_string = implode( ",", $bids );
			
			$DB->query("DELETE FROM ibf_shoutbox_badwords WHERE id IN ($bid_string)");
			$ADMIN->save_log("D-Shoutbox: Deleted Badwords");
			$std->boink_it($SKIN->base_url."&act=Shoutbox&code=40");
		}
		else
 		{
 			$std->boink_it($SKIN->base_url."&act=Shoutbox&code=40");
			exit();
		}
 	}
 	
	function word_sort($a, $b)
	{
		if ( strlen($a['type']) == strlen($b['type']) )
		{
			return 0;
		}
		return ( strlen($a['type']) > strlen($b['type']) ) ? -1 : 1;
	}
	
	//+---------------------------------------------------------------------------------
	// Shoutbox Settings
	//+---------------------------------------------------------------------------------

	function settings() {
		global $IN, $root_path, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
									     
		//+-------------------------------
		$SKIN->td_header[] = array( "Description" , "70%" );
		$SKIN->td_header[] = array( "Option"      , "30%" );
		//+-------------------------------
		
		$DB->query("SELECT * FROM ibf_shoutbox_settings");
		$sb = $DB->fetch_row();
		
		$ADMIN->page_title  = "D-Shoutbox: Settings";
		$ADMIN->page_detail = "Edit the Shoutbox settings";
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code' , '10'       ),
												  2 => array( 'act'  , 'Shoutbox' ),
									     )      );
		
	
		$ADMIN->html .= $SKIN->start_table( "D-Shoutbox: Settings" );
		
		$ADMIN->html .= $SKIN->add_td_basic('Start Settings', 'center', 'catrow2');
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Shoutbox Name?</b>" ,
												  $SKIN->form_input("sbname",$sb['sbname'],"text")
											    )		);

		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Number of shouts per page?</b>" ,
												  $SKIN->form_input("postspp",$sb['postspp'],"text")
											    )		);

		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Flood number for shouters?</b>(<small><i>This is the number of shouts in a row. (Ex: 10))</i></small>" ,
												  $SKIN->form_input("flood",$sb['flood'],"text")
											    )		);
											    
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Flood time?</b>(<small><i>This number needs to be in seconds. (Ex: 30))</i></small>" ,
												  $SKIN->form_input("flood_seconds",$sb['flood_seconds'],"text")
											    )		);
											    
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Minimum refresh time for members</b><br>(In seconds)" ,
												  $SKIN->form_input("minimum_refresh",$sb['minimum_refresh'],"text")
											    )		);
											    
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Wordwrap limit?</b>" ,
												  $SKIN->form_input("wordwrap",$sb['wordwrap'],"text")
											    )		);
											    
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Shoutbox Online?</b>" ,
												  $SKIN->form_yes_no("online",$sb['online'])
											    )		);
											    
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Guests ables to view the shoutbox?</b>" ,
												  $SKIN->form_yes_no("guestviewsb",$sb['guestviewsb']),
											    )		);
											    
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Guests ables to post to the shoutbox?</b>" ,
												  $SKIN->form_yes_no("guestposting",$sb['guestposting']),
											    )		);
											    
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Shoutbox Skin</b>" ,
										  $SKIN->form_dropdown( 'skin_selection', 
										  						 array(
										  						 		0 => array( 'new', 'New' ),
										  						 		1 => array( 'old', 'Old' ),
										  						 	  ),
										  						 $sb['skin_selection']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Shoutbox Display</b>" ,
										  $SKIN->form_dropdown( 'sbdisplay', 
										  						 array(
										  						 		0 => array( 'L', 'Left' ),
										  						 		1 => array( 'R', 'Right' ),
										  						 	  ),
										  						 $sb['sbdisplay']  )
								 )      );
											    
		$ADMIN->html .= $SKIN->add_td_basic('Global Shout Options', 'center', 'catrow2');
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Show latest global shouts on top of forums?</b>" ,
												  $SKIN->form_yes_no("showglobal",$sb['showglobal']),
											    )		);
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Global shouts number?<br /></b><i><small>(Max is 15!)</small></i>" ,
												  $SKIN->form_input("gsnum",$sb['gsnum'],"text")
											    )		);
											    
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Global Shoutbox Effect?</b>" ,
										  $SKIN->form_dropdown( 'gseffect', 
										  						 array(
										  						 		0 => array( '0', 'None'          ),
										  						 		1 => array( '1', 'Marquee Left'  ),
										  						 		2 => array( '2', 'Marquee Right' ),
										  						 		3 => array( '3', 'Fading'        ),
										  						 		4 => array( '4', 'Scrolling'     ),
										  						 	  ),
										  						 $sb['gseffect']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Remove line breaks?</b><br /><i><small>(This is only appearance, will not replace whole shout)</small></i>" ,
												  $SKIN->form_yes_no("global_rlb",$sb['global_rlb']),
											    )		);

		$ADMIN->html .= $SKIN->add_td_basic('Avatar Options', 'center', 'catrow2');
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Show avatars?</b>" ,
												  $SKIN->form_yes_no("showava",$sb['showava'])
											    )		);

		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Maximum avatar dimensions<br /></b>(Width<B>x</B>Height)" ,
												  $SKIN->form_input("avatar_dims",$sb['avatar_dims'],"text")
											    )		);	

		$ADMIN->html .= $SKIN->add_td_row( array( "<b>What is the filename for a member that has no avatar?<br /></b>(Ex: noavatar.gif)" ,
												  $SKIN->form_input("noavatar_name",$sb['noavatar_name'],"text")
											    )		);						    

		$ADMIN->html .= $SKIN->add_td_basic('Banner Options', 'center', 'catrow2');
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Use A Banner On Top Of Shoutbox?</b>" ,
												  $SKIN->form_yes_no("banner",$sb['banner'])
											    )		);

		$ADMIN->html .= $SKIN->add_td_row( array( "<b>What is the url to the banner?<br /></b>(Only is show banner is set to yes)" ,
												  $SKIN->form_input("bannerurl",$sb['bannerurl'],"text")
											    )		);

		$ADMIN->html .= $SKIN->add_td_basic('Autodelete Options', 'center', 'catrow2');
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Autodelete shouts after a certain amount of time?</b>" ,
												  $SKIN->form_yes_no("autodelete",$sb['autodelete']),
											    )		);
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>How many days to delete posts after?<br /></b><small>(Only if autodelete is set to yes)</small>" ,
												  $SKIN->form_input("addays",$sb['addays'],"text")
											    )		);
											    
		$ADMIN->html .= $SKIN->add_td_basic('Iframe Settings', 'center', 'catrow2');	
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Iframe shoutbox type on?</b>" ,
												  $SKIN->form_yes_no("iframe",$sb['iframe']),
											    )		);
											    
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Iframe Width</b><br>(In pixels or percent)" ,
												  $SKIN->form_input("iframew",$sb['iframew'],"text")
											    )		);
											    							    
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Iframe Height</b><br>(In pixels or percent)" ,
												  $SKIN->form_input("iframeh",$sb['iframeh'],"text")
											    )		);
											    
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Iframe Autorefresh Time</b><br>(In seconds)" ,
												  $SKIN->form_input("refresh",$sb['refresh'],"text")
											    )		);	

		$ADMIN->html .= $SKIN->add_td_basic('Posting Options', 'center', 'catrow2');;
													    											    
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Show the smilies table?<br /></b>(Shows clickable smilies under posting box)" ,
												  $SKIN->form_yes_no("smiliestable",$sb['smiliestable'])
											    )		);
											    
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Allow smilies in shouts?</b>" ,
												  $SKIN->form_yes_no("allowsmilies",$sb['allowsmilies'])
											    )		);
											    
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Allow bbcodes in shouts?</b>" ,
												  $SKIN->form_yes_no("allowbbcodes",$sb['allowbbcodes'])
											    )		);
									    								     		
		if ($INFO['shop_status'] == 'shopon')
		{
			$ADMIN->html .= $SKIN->add_td_row( array( "<b>Reward IBShop points for each shout in shoutbox?<br /></b><small>(Only if <i><b><a href='http://mods.ibplanet.com/db/?mod=1714' target='_blank'>IBShop</a></b></i> is installed)</small>" ,
													  $SKIN->form_yes_no("useshopp",$sb['useshopp']),
											    )		);
		}
		if ($INFO['store_on'] == 1)
		{
			$ADMIN->html .= $SKIN->add_td_row( array( "<b>Reward IBStore points for each shout in shoutbox?<br /></b><small>(Only if <i><b><a href='http://mods.ibplanet.com/db/?mod=2143' target='_blank'>IBStore</a></b></i> is installed)</small>" ,
													  $SKIN->form_yes_no("usestorep",$sb['usestorep']),
											    )		);
		}
		if ($INFO['shop_status'] == 'shopon')
		{
			$ADMIN->html .= $SKIN->add_td_row( array( "<b>How many IBShop points to reward for each post?<br /></b><small>(Only if <i><b><a href='http://mods.ibplanet.com/db/?mod=1714' target='_blank'>IBShop</a></b></i> is installed)</small>" ,
													  $SKIN->form_input("shoppoints",$sb['shoppoints'],"text")
											    )		);
		}
		if ($INFO['store_on'] == 1)
		{
			$ADMIN->html .= $SKIN->add_td_row( array( "<b>How many IBStore points to reward for each post?<br /></b><small>(Only if <i><b><a href='http://mods.ibplanet.com/db/?mod=2143' target='_blank'>IBStore</a></b></i> is installed)</small>" ,
													  $SKIN->form_input("storepoints",$sb['storepoints'],"text")
											    )		);

			$ADMIN->html .= $SKIN->add_td_row( array( "<b>Require the use of a D-Shoutbox Card to post?<br /></b><small>(Must Have <i><b><a href='http://mods.ibplanet.com/db/?mod=2143' target='_blank'>IBStore</a></b></i> installed!)</small>" ,
													  $SKIN->form_yes_no("usesbcard",$sb['usesbcard']),
											    )		);
											    
			$ADMIN->html .= $SKIN->add_td_row( array( "<b>How much {$sb['currency_name']} to charge for each post<br /></b><small>(Must Have <i><b><a href='http://mods.ibplanet.com/db/?mod=2143' target='_blank'>IBStore</a></b></i> installed!)</small>" ,
													  $SKIN->form_input("chargeperpost",$sb['chargeperpost'],"text")
											    )		);
		}
		
		$ADMIN->html .= $SKIN->add_td_basic('Stats Options', 'center', 'catrow2');
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Show online users currently at shoutbox?</b>" ,
												  $SKIN->form_yes_no("showou",$sb['showou']),
											    )		);
											    
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Show today's shouters?</b>" ,
												  $SKIN->form_yes_no("showtods",$sb['showtods']),
											    )		);

		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Show top shouters overal?</b>" ,
												  $SKIN->form_yes_no("showtops",$sb['showtops']),
											    )		);
											    
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Number of shouts to show on todays shouter?</b>" ,
												  $SKIN->form_input("todsnum",$sb['todsnum'],"text")
											    )		);
											    
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Number of shouts to show on top shouter?</b>" ,
												  $SKIN->form_input("topsnum",$sb['topsnum'],"text")
											    )		);
											    
		$ADMIN->html .= $SKIN->add_td_basic('Extra Options', 'center', 'catrow2');
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Website Extras</b><br>This is where you can enter whatever you want to appear in the &lt;head&gt;&lt;/head&gt; tags. This is mainly for CSS." ,
												  $SKIN->form_textarea( 'website_extra', $sb['website_extra'], '45', '5' )
											 )      );
																	    
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->html .= "<div align='center' style='width:100%;border:1px solid #BCD0ED;background-color: #DFE6EF;font-size:10px;margin:3px 0px 3px 0px;color:#3A4F6C;font-weight:bold;padding:8px'>" . $SKIN->end_form("Save Settings") . "<input type='button' name='b2sb' value='Back To Main Page' onclick=\"window.location='{$SKIN->base_url}&act=Shoutbox'\" id='button'></div>" . $this->sbcopyright();
		
		$ADMIN->output();

	}
	
	function save_settings()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;
		
		if ($IN['gsnum'] > 15)
		{
			$IN['gsnum'] = 15;
		}
		
		$db_string = $DB->compile_db_update_string( array(
															'online'			=>	$IN['online'],
															'sbname'			=>	$IN['sbname'],
															'postspp'			=>	$IN['postspp'],
															'flood'				=>	$IN['flood'],
															'flood_seconds'		=>	$IN['flood_seconds'],
															'guestviewsb'		=>	$IN['guestviewsb'],
															'guestposting'		=>	$IN['guestposting'],
															'minimum_refresh'	=>	$IN['minimum_refresh'],
															'refresh'			=>	$IN['refresh'],
															'banner'			=>	$IN['banner'],
															'bannerurl'			=>	$IN['bannerurl'],
															'autodelete'		=>	$IN['autodelete'],
															'addays'			=>	$IN['addays'],
															'showava'			=>	$IN['showava'],
															'showglobal'		=>	$IN['showglobal'],
															'showou'			=>	$IN['showou'],
															'showtods'			=>	$IN['showtods'],
															'showtops'			=>	$IN['showtops'],
															'todsnum'			=>	$IN['todsnum'],
															'topsnum'			=>	$IN['topsnum'],
															'smiliestable'		=>	$IN['smiliestable'],
															'iframe'			=>	$IN['iframe'],
															'iframew'			=>	$IN['iframew'],
															'iframeh'			=>	$IN['iframeh'],
															'noavatar_name'		=>	$IN['noavatar_name'],
															'avatar_dims'		=>	$IN['avatar_dims'],
															'allowsmilies'		=>	$IN['allowsmilies'],
															'allowbbcodes'		=>	$IN['allowbbcodes'],
															'usestorep'			=>	$IN['usestorep'],
															'useshopp'			=>	$IN['useshopp'],
															'usesbcard'			=>	$IN['usesbcard'],
															'chargeperpost'		=>	$IN['chargeperpost'],
															'shoppoints'		=>	$IN['shoppoints'],
															'storepoints'		=>	$IN['storepoints'],
															'website_extra'		=>	$std->txt_UNhtmlspecialchars(addslashes($IN['website_extra'])),
															'gsnum'				=>	$IN['gsnum'],
															'gseffect'			=>	$IN['gseffect'],
															'wordwrap'			=>	$IN['wordwrap'],
															'skin_selection'	=>	$IN['skin_selection'],
															'sbdisplay'			=>	$IN['sbdisplay'],
															'global_rlb'		=>  $IN['global_rlb'],
													)	);
													
		
		$DB->query("UPDATE ibf_shoutbox_settings SET {$db_string}");
		$ADMIN->save_log("D-Shoutbox: Save Settings");
		$std->boink_it("{$SKIN->base_url}&act=Shoutbox&code=09");
	}
	
	//+---------------------------------------------------------------------------------
	// Edit a shout posted in the shotubox
	//+---------------------------------------------------------------------------------
	
	function edit() {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;

		$ADMIN->page_title = "D-Shoutbox:  Edit Shout";
		$ADMIN->page_detail = "Edit a shout in the shoutbox";

		require "./sources/lib/post_parser.php";
		$parser = new post_parser(1);
		
		$DB->query("SELECT * FROM ibf_shoutbox WHERE id='{$IN['id']}'");
		$shout = $DB->fetch_row();
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , '19'  ),
												  2 => array( 'act'   , 'Shoutbox'       ),
												  3 => array( 'id'    , $IN['id']  ),
									     )      );
									     
		//+-------------------------------
		
		$SKIN->td_header[] = array( "&nbsp;"     , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"     , "60%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "D-Shoutbox: Edit Shout" );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Posted By:</b>" , "<a href='{$this->base_url}&act=mem&code=doform&MEMBER_ID={$shout['uid']}'>{$shout['name']}</a> &nbsp; [ <a href='{$this->base_url}&act=Shoutbox&code=06&ban={$shout['name']}'>Ban Member</a> | <a href='{$this->base_url}&act=Shoutbox&code=11&id={$shout['id']}'>Delete Shout</a> ]")	);
												
		$scolor = "<select name=color>";
		$a = $DB->query("SELECT * FROM ibf_shoutbox_colors");
		while ($color = $DB->fetch_row($a))
		{
			$scolor .= "<option value='{$color['color']}' style='color:{$color['color']}' ";
			$scolor .= $color['color'] == $shout['color'] ? "selected>{$color['color']}</option>" : ">{$color['color']}</option>";
		}
		$scolor .= "</select>";
				
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Shout Color:</b>" , $scolor)	);
											    		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Shout:</b>" ,
												  $SKIN->form_textarea( 'message', $parser->unconvert($shout['message']) )
										 )      );
											 
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->html .= "<center>" . $SKIN->end_form("Edit Shout") . "<input type='button' name='b2sb' value='Back To Main Page' onclick=\"window.location='{$SKIN->base_url}&act=Shoutbox'\"  id='button'></center>" . $this->sbcopyright();
		
		$ADMIN->output();

	}
	
	function do_edit() {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;
		
		if ($IN['message'] == '') 
		{
			$ADMIN->error("You must fill in a message.");
		}
		$color = $IN['color'];
		$message = $IN['message'];
		
		$sb = $DB->query("SELECT * FROM ibf_shoutbox_settings");
		$shoutbox = $DB->fetch_row();
		
		require "./sources/lib/post_parser.php";
		$parser = new post_parser(1);

		$message = $parser->unconvert($message);
		$message = preg_replace('/\[img]/i', '', $message);
		$message = preg_replace('/\[\/img]/i', '', $message);
		$message = preg_replace('/<img/i', '', $message);
		$message = trim($parser->convert( array( 	TEXT    => $message,
													SMILIES => $shoutbox['allowsmilies'],
													CODE    => $shoutbox['allowbbcodes'],
													HTML    => 0
												)
						   						));
		$message = addslashes($message);
		$DB->query("UPDATE ibf_shoutbox SET message='{$message}', color='{$color}' WHERE id='{$IN['id']}'");
		
		$ADMIN->save_log("D-Shoutbox: Edited Shout #{$IN['id']}");
		$std->boink_it($SKIN->base_url."&act=Shoutbox");
		exit();
	}
	

	//+---------------------------------------------------------------------------------
	// Delete Shouts From to End
	//+---------------------------------------------------------------------------------

	function delete() {
		global $IN, $root_path, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		$ADMIN->page_title = "D-Shoutbox:  Delete Shouts From to End";
		$ADMIN->page_detail = "Delete shouts from a start # to an end #";
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , '02' ),
												  2 => array( 'act'   , 'Shoutbox'     ),
									     )      );
		
		$ADMIN->html .= $SKIN->start_table( "D-Shoutbox: Delete Shouts From-End" );

		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Starting Number To Delete</b>" ,
												  $SKIN->form_input("from","","text")
											    )		);
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Ending Number To Delete</b>" ,
												  $SKIN->form_input("end","","text")
											    )		);
		$ADMIN->html .= $SKIN->end_table();
		$ADMIN->html .= "<div align='center' style='width:100%;border:1px solid #BCD0ED;background-color: #DFE6EF;font-size:10px;margin:3px 0px 3px 0px;color:#3A4F6C;font-weight:bold;padding:8px'>" . $SKIN->end_form("Delete Shouts") . "<input type='button' name='b2sb' value='Back To Main Page' onclick=\"window.location='{$SKIN->base_url}&act=Shoutbox'\"  id='button'></div>" . $this->sbcopyright();
		$ADMIN->output();
		
	}
		
	function dodelete() {
		global $IN, $root_path, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;
		
		if ($IN['from'] == "" AND $IN['end'] == "") {
			$ADMIN->error("You must enter a number to start from and end at.");
		}
		$from = $IN['from'];
		$end = $IN['end'];

		$DB->query("DELETE FROM ibf_shoutbox WHERE id >= $end AND id <= $from");
		$ADMIN->save_log("D-Shoutbox: Shouts Deleted From $from To $end");
		$std->boink_it("{$SKIN->base_url}&act=Shoutbox");
	}
	
	//+---------------------------------------------------------------------------------
	// Delete Multiple Shouts OR Ban Multiple Members At One Time
	//+---------------------------------------------------------------------------------
	
	function domulti() {
		global $IN, $root_path, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;

		$sids = array();
		$mids = array();
			
 		foreach ($IN as $key => $value)
 		{
 			if ( preg_match( "/^sid_(\d+)_smid_(\d+)$/", $key, $match ) )
 			{
 				if ($IN[$match[0]])
 				{
 					$sids[] = $match[1];
 					$mids[] = $match[2];
 				}
 			}
 		}
 		
 		$affected_sids = count($sids);
 		$affected_mids = count($mids);
 	
 		if ($IN['delsel'])
		{
			if ( $affected_sids > 0 )
 			{
 				$sid_string = implode( ",", $sids );
 		
				$DB->query("DELETE FROM ibf_shoutbox WHERE id IN ($sid_string)");
				$ADMIN->save_log("D-Shoutbox: Deleted Multiple Shouts");
				$std->boink_it($SKIN->base_url."&act=Shoutbox");
				exit();
			}
			else
 			{
 				$std->boink_it($SKIN->base_url."&act=Shoutbox");
				exit();
			}
		}
		else if ($IN['bansel'])
		{
			if ( $affected_mids > 0 )
			{
				$mid_string = implode( ",", $mids );
				
				$DB->query("UPDATE {$INFO['sql_tbl_prefix']}members SET use_dshoutbox='0' WHERE id IN ($mid_string)");
				$ADMIN->save_log("D-Shoutbox: Banned Multiple Members");
				$std->boink_it($SKIN->base_url."&act=Shoutbox");
				exit();
			}
			else
 			{
 				$std->boink_it($SKIN->base_url."&act=Shoutbox");
				exit();
			}
 		}
 		else
 		{
 			$std->boink_it($SKIN->base_url."&act=Shoutbox");
			exit();
		}
 	}
	//+---------------------------------------------------------------------------------
	// Delete Shouts By User
	//+---------------------------------------------------------------------------------

	function userdelete() {
		global $IN, $root_path, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;
		
		$ADMIN->page_title = "D-Shoutbox:  Delete Shouts By Member";
		$ADMIN->page_detail = "Delete all shouts by a certain member";

		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , '04' ),
												  2 => array( 'act'   , 'Shoutbox'     ),
									     )      );
		
		$ADMIN->html .= $SKIN->start_table( "D-Shoutbox: Delete Shouts By Member" );

		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Delete All Shouts By</b>" ,
												  $SKIN->form_input("user","","text")
											    )		);
		
		$ADMIN->html .= $SKIN->end_table();
		$ADMIN->html .= "<div align='center' style='width:100%;border:1px solid #BCD0ED;background-color: #DFE6EF;font-size:10px;margin:3px 0px 3px 0px;color:#3A4F6C;font-weight:bold;padding:8px'>" . $SKIN->end_form("Delete Shouts") . "<input type='button' name='b2sb' value='Back To Main Page' onclick=\"window.location='{$SKIN->base_url}&act=Shoutbox'\"  id='button'></div>" . $this->sbcopyright();
		$ADMIN->output();
		
	}
	
	function douserdelete() {
		global $IN, $root_path, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;

		if ($IN['user'] == "") {
			$ADMIN->error("You must enter a user to delete the shouts.");
		}
		
		$user = $IN['user'];

		$DB->query("DELETE FROM ibf_shoutbox where name='$user'");
		$ADMIN->save_log("D-Shoutbox: Deleted All Shouts By $user");
		$std->boink_it("{$SKIN->base_url}&act=Shoutbox&code=03");
		exit();
	}

	//+---------------------------------------------------------------------------------
	// Ban A User From Posting
	//+---------------------------------------------------------------------------------

	function ban() {
		global $IN, $root_path, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;
		
		$ADMIN->page_title = "D-Shoutbox:  Ban Members";
		$ADMIN->page_detail = "Ban members from the Shoutbox";
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , '06' ),
												  2 => array( 'act'   , 'Shoutbox'     ),
									     )      );
		
		$ADMIN->html .= $SKIN->start_table( "D-Shoutbox: Ban Members" );

		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Username To Ban</b>" ,
												  $SKIN->form_input("ban","","text")
											    )		);
		
		$ADMIN->html .= $SKIN->end_table();
		$ADMIN->html .= "<div align='center' style='width:100%;border:1px solid #BCD0ED;background-color: #DFE6EF;font-size:10px;margin:3px 0px 3px 0px;color:#3A4F6C;font-weight:bold;padding:8px'>" . $SKIN->end_form("Ban User") . "<input type='button' name='b2sb' value='Back To Main Page' onclick=\"window.location='{$SKIN->base_url}&act=Shoutbox'\" onmouseover=\"window.status='D-Shoutbox:  Back To D-Shoutbox Main Page'; return true\" onmouseout=\"window.status=''; return true\" id='button'></div>" . $this->sbcopyright();
		$ADMIN->output();
		
	}
	
	function doban() {
		global $IN, $root_path, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;

		if ($IN['ban'] == "")
		{
			$ADMIN->error("You must enter a user to ban.");
		}
		
		$user = $IN['ban'];
		$DB->query("UPDATE {$INFO['sql_tbl_prefix']}members SET use_dshoutbox='0' WHERE name='$user'");
		$ADMIN->save_log("D-Shoutbox: Banned User $user");
		$std->boink_it($SKIN->base_url."&act=Shoutbox&code=05");
		exit();
	}
	
	//+---------------------------------------------------------------------------------
	// Unan A User From Posting
	//+---------------------------------------------------------------------------------

	function unban() {
		global $IN, $root_path, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;

		$ADMIN->page_title = "D-Shoutbox:  Unban Members";
		$ADMIN->page_detail = "Unban members from the Shoutbox";
		
		//+-------------------------------
		$SKIN->td_header[] = array( "Member", "70%" );
		$SKIN->td_header[] = array( "<input type='checkbox' id='button' name='uall' value='uall' onclick='SA()'>", "30%" );
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , '23' ),
												  2 => array( 'act'   , 'Shoutbox'     ),
									     )      );
									     
		$ADMIN->html .= "<script language='Javascript'>
						function SA()
						{
							for (var i=0;i<document.theAdminForm.elements.length;i++)
							{
								 var e = document.theAdminForm.elements[i];
								 if(e.type=='checkbox')
								 {
								 	e.checked = document.all.uall.checked;
								 }
							}
						}
						</script>";
		
		$ADMIN->html .= $SKIN->start_table( "D-Shoutbox: Unban Members" );

		$DB->query("SELECT * FROM {$INFO['sql_tbl_prefix']}members WHERE use_dshoutbox='0'");
		
		while ($sb = $DB->fetch_row())
		{
			$uname = $sb['name'];
			$uid   = $sb['id'];
			$ADMIN->html .= $SKIN->add_td_row( array( $uname,
													  "<input type='button' value='Unban' id='button' onclick=\"window.location='{$SKIN->base_url}&act=Shoutbox&code=08&user={$uname}'\"> <input type='checkbox' id='button' name='sbmid_{$uid}' value='sbmid_{$uid}'>"
											 )		);
		}
		
		$ADMIN->html .= $SKIN->end_table();
		$ADMIN->html .= "<div align='center' style='width:100%;border:1px solid #BCD0ED;background-color: #DFE6EF;font-size:10px;margin:3px 0px 3px 0px;color:#3A4F6C;font-weight:bold;padding:8px'>" . $SKIN->end_form("Unban Selected Users") . " <input type='button' name='b2sb' value='Back To Main Page' onclick=\"window.location='{$SKIN->base_url}&act=Shoutbox'\"  id='button'></div>" . $this->sbcopyright();
		$ADMIN->output();
	}
	
	function dounban() {
		global $IN, $root_path, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;
	
		if ($IN['user'] == "") {
			$ADMIN->error("You must a user to unban.");
		}
		
		$DB->query("UPDATE {$INFO['sql_tbl_prefix']}members SET use_dshoutbox='1' WHERE name='".$IN['user']."'");
		$ADMIN->save_log("D-Shoutbox: Unbanned User ".$IN['user']."");
		$std->boink_it($SKIN->base_url."&act=Shoutbox&code=07");
		exit();
	}
	
	function domultiunban() {
		global $IN, $root_path, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;

		$mids = array();
			
 		foreach ($IN as $key => $value)
 		{
 			if ( preg_match( "/^sbmid_(\d+)$/", $key, $match ) )
 			{
 				if ($IN[$match[0]])
 				{
 					$mids[] = $match[1];
 				}
 			}
 		}
 		
 		$affected_mids = count($mids);
 	
		if ( $affected_mids > 0 )
		{
			$mid_string = implode( ",", $mids );
			
			$DB->query("UPDATE {$INFO['sql_tbl_prefix']}members SET use_dshoutbox='1' WHERE id IN ($mid_string)");
			$ADMIN->save_log("D-Shoutbox: Unbanned Multiple Members");
			$std->boink_it($SKIN->base_url."&act=Shoutbox&code=07");
			exit();
		}
		else
 		{
 			$std->boink_it($SKIN->base_url."&act=Shoutbox&code=07");
			exit();
		}
 	}
	
	//+---------------------------------------------------------------------------------
	// Delete a single shout post
	//+---------------------------------------------------------------------------------
	
	function deleteshout() {
		global $IN, $root_path, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;
	
		if ($IN['id'] == "") {
			$ADMIN->error("You must a shout post id to delete.");
		}
		
		$id = $IN['id'];
		$DB->query("SELECT name FROM ibf_shoutbox WHERE id='$id'");
		$dc = $DB->fetch_row();
		$DB->query("DELETE FROM ibf_shoutbox WHERE id='$id'");
		$DB->query("UPDATE {$INFO['sql_tbl_prefix']}members SET dshouts=dshouts-1 WHERE name='{$dc['name']}'");
		
		$ADMIN->save_log("D-Shoutbox: Deleted Shout # {$id}");
		$std->boink_it($SKIN->base_url."&act=Shoutbox");
		exit();
	}
	
	//+---------------------------------------------------------------------------------
	// Clear the entire shoutbox out
	//+---------------------------------------------------------------------------------
	
	function clearsb() {
		global $IN, $root_path, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;

		$ADMIN->page_title = "D-Shoutbox: Clear Shoutbox";
		$ADMIN->page_detail = "Clear your entire Shoutbox";
						
		//+-------------------------------
		$SKIN->td_header[] = array( "&nbsp;", "70%" );
		$SKIN->td_header[] = array( "&nbsp;", "30%" );
		//+-------------------------------
		
		$clearv = 0;
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , '14' ),
												  2 => array( 'act'   , 'Shoutbox'     ),
									     )      );
		
		$ADMIN->html .= $SKIN->start_table( "D-Shoutbox: Clear Shoutbox" );

		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Are you sure you want to clear the shoutbox?</b><br>This will clear out the entire shoutbox and delete all current shouts in the shoutbox." ,
												  $SKIN->form_yes_no("csh",$clearv),
											    )		);
		
		$ADMIN->html .= $SKIN->end_table();
		$ADMIN->html .= "<div align='center' style='width:100%;border:1px solid #BCD0ED;background-color: #DFE6EF;font-size:10px;margin:3px 0px 3px 0px;color:#3A4F6C;font-weight:bold;padding:8px'>" . $SKIN->end_form("Clear Shoutbox") . "<input type='button' name='b2sb' value='Back To Main Page' onclick=\"window.location='{$SKIN->base_url}&act=Shoutbox'\" onmouseover=\"window.status='D-Shoutbox:  Back To D-Shoutbox Main Page'; return true\" onmouseout=\"window.status=''; return true\" id='button'></div>" . $this->sbcopyright();
		$ADMIN->output();	
	}
		
	function doclearsb() {
		global $IN, $root_path, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;
		
		if ($IN['act'] == "") {
			$ADMIN->error("You must select yes or no to clear the shoutbox.");
		}
		$csh = $IN['csh'];
		
		if ($csh == 1)
		{
			$DB->query("TRUNCATE ibf_shoutbox");
			$DB->query("UPDATE ibf_members SET dshouts='0'");
			$DB->query("UPDATE ibf_shoutbox_stats SET totalshouts='0'");
			$ADMIN->save_log("D-Shoutbox: Cleared The Shoutbox");
			$std->boink_it("{$SKIN->base_url}&act=Shoutbox");
		}
		else if ($csh == 0)
		{
			$std->boink_it("{$SKIN->base_url}&act=Shoutbox");
			exit();
		}
	}

  	//+---------------------------------------------------------------------------------
	// Main Shoutbox Adminstration Screen
	//+---------------------------------------------------------------------------------

	function main_screen()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;

		$ADMIN->page_title = "D-Shoutbox";
		$ADMIN->page_detail = "Your Shoutbox with Admin Options";
		
		//+-------------------------------
		$SKIN->td_header[] = array( "Shouts", "97%" );
		$SKIN->td_header[] = array( "<input type='checkbox' id='button' name='sall' value='sall' onclick='SA()'>" , "3%" );
		//+-------------------------------
		
		$DB->query("SELECT * FROM ibf_shoutbox_settings");
		$sb = $DB->fetch_row();
		
		$start  = $IN['start'];
		$author = $IN['author'];
		$shout  = $IN['shout'];
		$ppp    = $sb['postspp'];

		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , '22'  ),
												  2 => array( 'act'   , 'Shoutbox' ),
						 )      );

		$ADMIN->html .= "<script language='Javascript'>
						function SA(v)
						{
							for (var i=0;i<document.theAdminForm.elements.length;i++)
							{
								 var e = document.theAdminForm.elements[i];
								 if(e.type=='checkbox')
								 {
								 	e.checked = document.all.sall.checked;
								 }
							}
						}
						</script>";

		$ADMIN->html .= $SKIN->start_table( "D-Shoutbox" );

		if ($shout<>"" && $author<>"")
		{
			$sa_q = "WHERE name='".$author."' AND id='".$shout."'";
			$saq = "&author=" . $author . "&shout=" . $shout;
		}
		else if ($shout<>"" && $author=="")
		{
			$sa_q = "WHERE id='".$shout."'";
			$saq = "&shout=" . $shout;
		}
		else if ($shout=="" && $author<>"")
		{
			$sa_q = "WHERE name='".$author."'";
			$saq = "&author=" . $author;
		}

		$DB->query("SELECT count(*) as count FROM ibf_shoutbox $sa_q");
		$stuff = $DB->fetch_row();

		if ($start >= $ppp)
		{
			$buttons .= "<input type='button' name='prevp' value='Previous Page' onclick=\"window.location='{$SKIN->base_url}&act=Shoutbox&start=".($start-$ppp)."$saq'\" onmouseover=\"window.status='Shoutbox: Go Back A Previous Page Of Shouts'; return true\" onmouseout=\"window.status=''; return true\" id='button'> ";
		}
		if ($start+$ppp < $stuff['count'])
		{
			$buttons .= "<input type='button' name='nextp' value='Next Page' onclick=\"window.location='{$SKIN->base_url}&act=Shoutbox&start=".($start+$ppp)."$saq'\" onmouseover=\"window.status='Shoutbox: Go On To The Next Page Of Shouts'; return true\" onmouseout=\"window.status=''; return true\" id='button'> ";
		}
		
		if ($shout<>"" && $author<>"")
		{
			$sa_query = "WHERE name='".$author."' AND id='".$shout."'";
			$sa_query2 = "&author=" . $author . "&shout=" . $shout;
			$sa_query3 = "AND s.name='".$author."' AND s.id='".$shout."'";
		}
		else if ($shout<>"" && $author=="")
		{
			$sa_query = "WHERE id='".$shout."'";
			$sa_query2 = "&shout=" . $shout;
			$sa_query3 = "AND s.id='".$shout."'";
		}
		else if ($shout=="" && $author<>"")
		{
			$sa_query = "WHERE name='".$author."'";
			$sa_query2 = "&author=" . $author;
			$sa_query3 = "AND s.name='".$author."'";
		}
		
		if ($start=="" or $start <= 0)
		{
			$start=0;
		}

		$db = $DB->query("SELECT g.prefix, g.suffix, m.*, m.id AS mid, s.* FROM ibf_shoutbox s, ibf_members m, ibf_groups g WHERE s.name=m.name AND m.mgroup=g.g_id $sa_query3 ORDER BY s.id DESC LIMIT $start, $ppp");
		while ($r = $DB->fetch_row($db))
		{
			$r['message']	= 	stripslashes($r['message']);
			$r['message']	=	"<span style='color: {$r['color']}'>{$r['message']}</span>";

			if ($r['time_time']<>'0')
			{
				$r['time'] = $std->get_date( $r[time_time], 'LONG');
			}

			if ($sb['showava'] == 1)
			{
				$r['ava'] = $this->get_avatar( $r['avatar'], 1, $r['avatar_size'] );
			}

			if ($r['use_dshoutbox'] == 1)
			{
				$ban = "(<a href='{$SKIN->base_url}&act=Shoutbox&code=06&ban={$r['name']}' onmouseover=\"window.status='Shoutbox: Ban {$r['name']} From The Shoutbox'; return true\" onmouseout=\"window.status=''; return true\">Ban Member</a>)";
			}
			else if ($r['use_dshoutbox'] == 0)
			{
				$ban = "(<a href='{$SKIN->base_url}&act=Shoutbox&code=08&user={$r['name']}' onmouseover=\"window.status='Shoutbox: Unban {$r['name']} From the Shoutbox'; return true\" onmouseout=\"window.status=''; return true\">Unban Member</a>)";
			}
				  
			$ADMIN->html .= $SKIN->add_td_row( array( "<table width='100%'><tr><td width='1%'>{$r['ava']}</td>
													  <td align='left' width='99%'><b>Posted By:</b> <a href='{$SKIN->base_url}&act=Shoutbox&code=35&mid={$r['uid']}' onmouseover=\"window.status='Shoutbox: View {$r['name']}\'s Account'; return true\" onmouseout=\"window.status=''; return true\">{$r['prefix']}<b>{$r['name']}</b>{$r['suffix']}</a> - <b>{$r['time']}</b><br>
										 			  Total Shouts: <a href='{$SKIN->base_url}&act=Shoutbox&author={$r['name']}' onmouseover=\"window.status='Shoutbox: View All Of {$r['name']}\'s Shouts'; return true\" onmouseout=\"window.status=''; return true\">{$r['dshouts']}</a> &nbsp; Shout #<a href='{$SKIN->base_url}&act=Shoutbox&shout={$r['id']}' onmouseover=\"window.status='Shoutbox: View Shoutbox #{$r['id']}'; return true\" onmouseout=\"window.status=''; return true\">{$r['id']}</a><br>
													  {$ban} (<a href='{$SKIN->base_url}&act=Shoutbox&code=18&id={$r['id']}' onmouseover=\"window.status='Shoutbox: Edit Shout #{$r['id']}'; return true\" onmouseout=\"window.status=''; return true\">Edit Shout</a>) (<a href='{$SKIN->base_url}&act=Shoutbox&code=11&id={$r['id']}' onmouseover=\"window.status='Shoutbox: Delete Shout #{$r['id']}'; return true\" onmouseout=\"window.status=''; return true\">Delete Shout</a>)</td>
													  </tr><tr><td colspan='2'>{$r['message']}</td></tr></table>\n",
													  "<input type='checkbox' id='button' name='sid_{$r['id']}_smid_{$r['mid']}' value='sid_{$r['id']}_smid_{$r['mid']}'>"
											 )		);
		}

		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->html .= "<div align='center' style='width:100%;border:1px solid #BCD0ED;background-color: #DFE6EF;font-size:10px;margin:3px 0px 3px 0px;color:#3A4F6C;font-weight:bold;padding:8px'>" . $buttons . "<input type='submit' name='delsel' value='Delete Selected' onmouseover=\"window.status='Shoutbox: Delete Selected Shouts From The Shoutbox'; return true\" onmouseout=\"window.status=''; return true\" id='button'> <input type='submit' name='bansel' value='Ban Selected' onmouseover=\"window.status='Shoutbox: Ban Posters Of Selected Shouts'; return true\" onmouseout=\"window.status=''; return true\" id='button'></form></div>" . $this->sbcopyright();
								
		$ADMIN->output();
		
	}
	
  	//+---------------------------------------------------------------------------------
	// Check For Any New Releases
	//+---------------------------------------------------------------------------------
	
	function updater() {
		global $IN, $root_path, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;

		$ADMIN->page_title = "D-Shoutbox: Status Checker";
		$ADMIN->page_detail = "Check the status on your D-Shoutbox";
		
		$cv = $this->status_check();
				
		$ADMIN->html .= $SKIN->start_table( "<center>D-Shoutbox: Status Checker</center>" );
		
		$ADMIN->html .= $SKIN->add_td_basic("Current Version" , "center", "catrow2");
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<center>{$cv}</center>")	);	
		
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->html .= "<div align='center' style='width:100%;border:1px solid #BCD0ED;background-color: #DFE6EF;font-size:10px;margin:3px 0px 3px 0px;color:#3A4F6C;font-weight:bold;padding:8px'><input type='button' name='b2sb' value='Back To Main Page' onclick=\"window.location='{$SKIN->base_url}&act=Shoutbox'\" onmouseover=\"window.status='D-Shoutbox:  Back To D-Shoutbox Main Page'; return true\" onmouseout=\"window.status=''; return true\" id='button'></div>" . $this->sbcopyright();
		
		$ADMIN->output();
	}

 	//+---------------------------------------------------------------------------------
	// D-Shoutbox Recounter
	//+---------------------------------------------------------------------------------
	
	function recount() {
		global $IN, $root_path, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;

		$ADMIN->page_title = "D-Shoutbox: Recounter";
		$ADMIN->page_detail = "Recount the current Shoutbox and members shouts";
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , '21'  ),
												  2 => array( 'act'   , 'Shoutbox'       ),
									     )      );
									     
		//+-------------------------------
		$SKIN->td_header[] = array( "&nbsp;", "70%" );
		$SKIN->td_header[] = array( "&nbsp;", "30%" );
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "D-Shoutbox: Recounter" );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Recount the current shouts?</b><br>This will recount the members number of shouts prior to the number in the shoutbox database." ,
												  $SKIN->form_yes_no("rcurrent"),
											    )		);
											    
		$ADMIN->html .= $SKIN->end_table();
		$ADMIN->html .= "<div align='center' style='width:100%;border:1px solid #BCD0ED;background-color: #DFE6EF;font-size:10px;margin:3px 0px 3px 0px;color:#3A4F6C;font-weight:bold;padding:8px'>" . $SKIN->end_form("Do Recount") . "<input type='button' name='b2sb' value='Back To Main Page' onclick=\"window.location='{$SKIN->base_url}&act=Shoutbox'\"  id='button'></div>" . $this->sbcopyright();	
		$ADMIN->output();
	}
	
	function do_recount() {
		global $IN, $root_path, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		$ADMIN->page_title = "D-Shoutbox: Recounter";
		$ADMIN->page_detail = "Recount the current Shoutbox and members shouts";
										     
		//+-------------------------------
		$SKIN->td_header[] = array( "&nbsp;", "70%" );
		$SKIN->td_header[] = array( "&nbsp;", "30%" );
		//+-------------------------------
		
		if ($IN['rcurrent'] == 1)
		{
			$ADMIN->html .= $SKIN->start_table( "D-Shoutbox Recounter" );
		
			$ADMIN->html .= $SKIN->add_td_basic("Recounter is complete.  Below are the recounted number for every member that has shouted.", "center", "pformstrip");
		
			$DB->query("SELECT *, COUNT(name) as count FROM ibf_shoutbox GROUP BY name ORDER BY count DESC");
			while ( $num = $DB->fetch_row() )
			{
				$ADMIN->html .= $SKIN->add_td_row( array( $num['name'] , $num['count'] )	);
				mysql_query("UPDATE ibf_members SET dshouts='{$num['count']}' WHERE name='{$num['name']}'");
			}
		
			$ADMIN->html .= $SKIN->end_table() . "<div align='center' style='width:100%;border:1px solid #BCD0ED;background-color: #DFE6EF;font-size:10px;margin:3px 0px 3px 0px;color:#3A4F6C;font-weight:bold;padding:8px'><input type='button' name='b2sb' value='Back To Main Page' onclick=\"window.location='{$SKIN->base_url}&act=Shoutbox'\" id='button'></div>" . $this->sbcopyright();
			$ADMIN->output();
		}
		else
		{
			$std->boink_it("{$SKIN->base_url}&act=Shoutbox");
			exit();
		}

	}
	
	//+---------------------------------------------------------------------------------
	// Shoutbox Rules
	//+---------------------------------------------------------------------------------
	function rules()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$ADMIN->page_title = "D-Shoutbox: Rules";
		$ADMIN->page_detail = "Edit the rules for your Shoutbox";
										     
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , '25'  ),
												  2 => array( 'act'   , 'Shoutbox'       ),
									     )      );
									     
		$DB->query("SELECT * FROM ibf_shoutbox_settings");
		$sb = $DB->fetch_row();
		
		$DB->query("SELECT * FROM ibf_cache_store WHERE cs_key='sbrules'");
		$row = $DB->fetch_row();
		
		//+-------------------------------
		$SKIN->td_header[] = array( "&nbsp;", "70%" );
		$SKIN->td_header[] = array( "&nbsp;", "30%" );
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "D-Shoutbox: Rules" );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Show Shoutbox Rules link?</b>" ,
										  $SKIN->form_yes_no( "showrules", $sb['showrules'] )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>D-Shoutbox Rules</b><br><i>HTML Enabled</i>" ,
										  $SKIN->form_textarea( "sb_rules", $std->my_br2nl($row['cs_value']), 65, 20  )
								 )      );
 
		$ADMIN->html .= $SKIN->end_table();
		$ADMIN->html .= "<div align='center' style='width:100%;border:1px solid #BCD0ED;background-color: #DFE6EF;font-size:10px;margin:3px 0px 3px 0px;color:#3A4F6C;font-weight:bold;padding:8px'>" . $SKIN->end_form("Save Rules") . "<input type='button' name='b2sb' value='Back To Main Page' onclick=\"window.location='{$SKIN->base_url}&act=Shoutbox'\" id='button'></div>" . $this->sbcopyright();	
		$ADMIN->output();
	}
	
	function dorules()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;
		
		$DB->query("UPDATE ibf_shoutbox_settings SET showrules='{$IN['showrules']}'");

		$sbrules = stripslashes($HTTP_POST_VARS['sb_rules']);
		$sbrules = str_replace( "\n", "<br>", $sbrules);
		$sbrules = str_replace( "<br>", "<br />", $sbrules);
		
		$DB->query("SELECT * FROM ibf_cache_store WHERE cs_key='sbrules'");

		if ( $row = $DB->fetch_row() )
		{
			$DB->query("UPDATE ibf_cache_store SET cs_value='".addslashes($sbrules)."' WHERE cs_key='sbrules'");
		}
		else
		{
			$db_string = $DB->compile_db_insert_string( array(
															   'cs_key'   => 'sbrules',
															   'cs_value' => $sbrules,
										  ) );

			$DB->query("INSERT INTO ibf_cache_store (".$db_string['FIELD_NAMES'].") VALUES(".$db_string['FIELD_VALUES'].")");
		}

		$ADMIN->save_log("D-Shoutbox: Shoutbox Rules Saved");
		$std->boink_it("{$SKIN->base_url}&act=Shoutbox&code=24");
	}

	//+---------------------------------------------------------------------------------
	// D-Shoutbox Error Messages
	//+---------------------------------------------------------------------------------
	
	function error_msg() {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		$ADMIN->page_title = "D-Shoutbox: Error Messages";
		$ADMIN->page_detail = "Edit the custom error messages for the Shoutbox";
				
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , '38' ),
												  2 => array( 'act'   , 'Shoutbox'     ),
									     )      );
		//+-------------------------------
		$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
		//+-------------------------------
		
		$sb = $DB->query("SELECT * FROM ibf_shoutbox_settings");
		$shoutbox = $DB->fetch_row($sb);
		
		$ADMIN->html .= $SKIN->start_table( "D-Shoutbox: Error Messages" );

		$ADMIN->html .= $SKIN->add_td_basic("D-Shoutbox Not Online", "center", "pformstrip");
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Message</b>" ,
												  $SKIN->form_textarea( 'error_msg_2', stripslashes($shoutbox['error_msg_2']) )
											 )      );
											 
		$ADMIN->html .= $SKIN->add_td_basic("Not A D-Shoutbox Moderator", "center", "pformstrip");
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Message</b>" ,
												  $SKIN->form_textarea( 'error_msg_4', stripslashes($shoutbox['error_msg_4']) )
											 )      );

		$ADMIN->html .= $SKIN->add_td_basic("Banned From The D-Shoutbox", "center", "pformstrip");
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Message</b>" ,
												  $SKIN->form_textarea( 'error_msg_7', stripslashes($shoutbox['error_msg_7']) )
											 )      );
											 
		$ADMIN->html .= $SKIN->add_td_basic("Not Allowed To View D-Shoutbox", "center", "pformstrip");
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Message</b>" ,
												  $SKIN->form_textarea( 'error_msg_3', stripslashes($shoutbox['error_msg_3']) )
											 )      );
											 
		$ADMIN->html .= $SKIN->add_td_basic("Not Allowed To Post To D-Shoutbox", "center", "pformstrip");
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Message</b>" ,
												  $SKIN->form_textarea( 'error_msg_5', stripslashes($shoutbox['error_msg_5']) )
											 )      );
											 
		$ADMIN->html .= $SKIN->add_td_basic("Guest No View D-Shoutbox", "center", "pformstrip");
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Message</b>" ,
												  $SKIN->form_textarea( 'error_msg_1', stripslashes($shoutbox['error_msg_1']) )
											 )      );
											 
		$ADMIN->html .= $SKIN->add_td_basic("No Guest Posting In D-Shoutbox", "center", "pformstrip");
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Message</b>" ,
												  $SKIN->form_textarea( 'error_msg_6', stripslashes($shoutbox['error_msg_6']) )
											 )      );
											 
		$ADMIN->html .= $SKIN->add_td_basic("Not Your Shout To Delete", "center", "pformstrip");
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Message</b>" ,
												  $SKIN->form_textarea( 'error_msg_8', stripslashes($shoutbox['error_msg_8']) )
											 )      );
											 
		$ADMIN->html .= $SKIN->add_td_basic("Reached Daily Shouting Limit", "center", "pformstrip");
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Message</b>" ,
												  $SKIN->form_textarea( 'error_msg_9', stripslashes($shoutbox['error_msg_9']) )
											 )      );
											 
		$ADMIN->html .= $SKIN->end_table();
		$ADMIN->html .= "<div align='center' style='width:100%;border:1px solid #BCD0ED;background-color: #DFE6EF;font-size:10px;margin:3px 0px 3px 0px;color:#3A4F6C;font-weight:bold;padding:8px'>" . $SKIN->end_form("Save Messages") . "<input type='button' name='b2sb' value='Back To Main Page' onclick=\"window.location='{$SKIN->base_url}&act=Shoutbox'\" id='button'></div>" . $this->sbcopyright();	
		$ADMIN->output();		
	}
	
	function doerror_msg()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;
		
		$db_string = $DB->compile_db_update_string( array(
															'error_msg_1'	=>	$IN['error_msg_1'],
															'error_msg_2'	=>	$IN['error_msg_2'],
															'error_msg_3'	=>	$IN['error_msg_3'],
															'error_msg_4'	=>	$IN['error_msg_4'],
															'error_msg_5'	=>	$IN['error_msg_5'],
															'error_msg_6'	=>	$IN['error_msg_6'],
															'error_msg_7'	=>	$IN['error_msg_7'],
															'error_msg_8'	=>	$IN['error_msg_8'],
															'error_msg_9'	=>	$IN['error_msg_9'],
													)	);
													
		
		$DB->query("UPDATE ibf_shoutbox_settings SET {$db_string}");
		$ADMIN->save_log("D-Shoutbox: Custom Error Messages Saved");
		$std->boink_it("{$SKIN->base_url}&act=Shoutbox&code=37");
	}
	
	//+---------------------------------------------------------------------------------
	// Shoutbox Group Permissions
	//+---------------------------------------------------------------------------------
	function groups()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		//+-------------------------------
		$SKIN->td_header[] = array( "Groups", "70%" );
		$SKIN->td_header[] = array( "<input type='checkbox' id='button' name='gall' value='gall' onclick='SA()'>", "30%" );
		//+-------------------------------

		$ADMIN->page_title = "D-Shoutbox: Group Permissions";
		$ADMIN->page_detail = "Edit the Shoutbox permissions for the groups";

		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code' , '31'       ),
												  2 => array( 'act'  , 'Shoutbox' ),
									     )      );
									     
		$ADMIN->html .= "<script language='Javascript'>
						function SA(v)
						{
							for (var i=0;i<document.theAdminForm.elements.length;i++)
							{
								 var e = document.theAdminForm.elements[i];
								 if(e.type=='checkbox')
								 {
								 	e.checked = document.all.gall.checked;
								 }
							}
						}
						</script>";

		$ADMIN->html .= $SKIN->start_table( "D-Shoutbox: Group Permissions" );
		
		$DB->query("SELECT * FROM {$INFO['sql_tbl_prefix']}groups WHERE g_id!=2");
		while ($group = $DB->fetch_row())
		{
			$ADMIN->html .= $SKIN->add_td_row( array( "<b>{$group['prefix']}{$group['g_title']}{$group['suffix']}</b>" ,
										  	"<input type='button' value='Edit' id='button' onmouseover=\"window.status='Shoutbox:  Edit ".$group['g_title']." Permissions'; return true\" onmouseout=\"window.status=''; return true\" onclick=\"window.location='{$SKIN->base_url}&act=Shoutbox&code=27&gid={$group['g_id']}'\"> <input type='button' value='Reset' id='button' onmouseover=\"window.status='Shoutbox:  Reset ".$group['g_title']." Permissions'; return true\" onmouseout=\"window.status=''; return true\" onclick=\"window.location='{$SKIN->base_url}&act=Shoutbox&code=29&gid={$group['g_id']}'\"> <input type='checkbox' id='button' name='gid_{$group['g_id']}' value='gid_{$group['g_id']}'>"
								 	)      );
 		}
 		
		$ADMIN->html .= $SKIN->end_table();
		$ADMIN->html .= "<div align='center' style='width:100%;border:1px solid #BCD0ED;background-color: #DFE6EF;font-size:10px;margin:3px 0px 3px 0px;color:#3A4F6C;font-weight:bold;padding:8px'>". $SKIN->end_form("Reset Selected") . "<input type='button' value='Reset All' id='button' onclick=\"window.location='{$SKIN->base_url}&act=Shoutbox&code=32'\"> <input type='button' name='b2sb' value='Back To Main Page' onclick=\"window.location='{$SKIN->base_url}&act=Shoutbox'\" id='button'></div>" . $this->sbcopyright();	
		$ADMIN->output();
	}
	
	function editgroup()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;
		
		$ADMIN->page_title = "D-Shoutbox: Group Permissions";

		$ADMIN->page_detail = "Edit the Shoutbox permissions for the groups";

		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code' , '28'       ),
												  2 => array( 'act'  , 'Shoutbox' ),
												  3 => array( 'gid'  , $IN['gid'] ),
									     )      );

		$DB->query("SELECT * FROM {$INFO['sql_tbl_prefix']}groups WHERE g_id='{$IN['gid']}'");
		$group = $DB->fetch_row();
		
		//+-------------------------------
		$SKIN->td_header[] = array( "&nbsp;", "70%" );
		$SKIN->td_header[] = array( "&nbsp;", "30%" );
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "D-Shoutbox Group Permissions: {$group['g_title']}" );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Can view the shoutbox?</b>" ,
												  $SKIN->form_yes_no("g_view_dshoutbox", $group['g_view_dshoutbox'] )
									     )      );

		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Can post to the shoutbox?</b>" ,
												  $SKIN->form_yes_no("g_post_dshoutbox", $group['g_post_dshoutbox'] )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>D-Shoutbox Moderator?</b>" ,
												  $SKIN->form_yes_no("g_dshoutbox_mod", $group['g_dshoutbox_mod'] )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Daily Shout Limit?</b>" ,
												  $SKIN->form_input("g_dshout_limit", $group['g_dshout_limit'] )
									     )      );
									      		
		$ADMIN->html .= $SKIN->end_table();
		$ADMIN->html .= "<div align='center' style='width:100%;border:1px solid #BCD0ED;background-color: #DFE6EF;font-size:10px;margin:3px 0px 3px 0px;color:#3A4F6C;font-weight:bold;padding:8px'>" . $SKIN->end_form("Save Permissions") . "<input type='button' name='b2sb' value='Back To Main Page' onclick=\"window.location='{$SKIN->base_url}&act=Shoutbox'\" id='button'></div>" . $this->sbcopyright();	
		$ADMIN->output();

	}
	
	function dogroups()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;
		
		$DB->query("UPDATE {$INFO['sql_tbl_prefix']}groups SET g_view_dshoutbox='{$IN['g_view_dshoutbox']}', g_post_dshoutbox='{$IN['g_post_dshoutbox']}', g_dshoutbox_mod='{$IN['g_dshoutbox_mod']}', g_dshout_limit='{$IN['g_dshout_limit']}' WHERE g_id='{$IN['gid']}'");

		$ADMIN->save_log("D-Shoutbox: Group Permissions Saved");
		
		$std->boink_it("{$SKIN->base_url}&act=Shoutbox&code=26");
	}
	
	function resetgroups() {
		global $IN, $root_path, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
				
		$ADMIN->page_title = "D-Shoutbox: Group Permissions";
		$ADMIN->page_detail = "Reset the selected group's Shoutbox permissions";

		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code' , '30'       ),
												  2 => array( 'act'  , 'Shoutbox' ),
												  3 => array( 'gid'  , $IN['gid'] ),
									     )      );

		//+-------------------------------
		$SKIN->td_header[] = array( "&nbsp;", "70%" );
		$SKIN->td_header[] = array( "&nbsp;", "30%" );
		//+-------------------------------
		
		$DB->query("SELECT * FROM {$INFO['sql_tbl_prefix']}groups WHERE g_id='{$IN['gid']}'");
		$group = $DB->fetch_row();
				
		$ADMIN->html .= $SKIN->start_table( "D-Shoutbox: Reset {$group['g_title']} D-Shoutbox Permissions" );

		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Are you sure you want to reset the D-Shoutbox permissions for {$group['g_title']}?</b><br>This will clear out the entire shoutbox and delete all current shouts in the shoutbox." ,
												  $SKIN->form_yes_no("rgp","0"),
											    )		);
		
		$ADMIN->html .= $SKIN->end_table();
		$ADMIN->html .= "<div align='center' style='width:100%;border:1px solid #BCD0ED;background-color: #DFE6EF;font-size:10px;margin:3px 0px 3px 0px;color:#3A4F6C;font-weight:bold;padding:8px'>" . $SKIN->end_form("Reset") . "<input type='button' name='b2sb' value='Back To Main Page' onclick=\"window.location='{$SKIN->base_url}&act=Shoutbox'\" id='button'></div>" . $this->sbcopyright();
		$ADMIN->output();	
	}
		
	function doresetgroups() {
		global $IN, $root_path, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;
		
		if ($IN['act'] == "") {
			$ADMIN->error("You must select yes or no to reset the groups permissions.");
		}
		$rgp = $IN['rgp'];
		
		if ($rgp == 1)
		{
			$DB->query("UPDATE {$INFO['sql_tbl_prefix']}groups SET g_view_dshoutbox='0', g_post_dshoutbox='0', g_dshoutbox_mod='0', g_dshout_limit='0' WHERE g_id='{$IN['gid']}'");
			$ADMIN->save_log("D-Shoutbox: Reset A Groups Permissions");
			$std->boink_it($SKIN->base_url."&act=Shoutbox&code=26");
			exit();
		}
		else if ($rgp == 0)
		{
			$std->boink_it($SKIN->base_url."&act=Shoutbox&code=26");
			exit();
		}
	}
	
	function domultigroups() {
		global $IN, $root_path, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;

		$gids = array();
			
 		foreach ($IN as $key => $value)
 		{
 			if ( preg_match( "/^gid_(\d+)$/", $key, $match ) )
 			{
 				if ($IN[$match[0]])
 				{
 					$gids[] = $match[1];
 				}
 			}
 		}
 		
 		$affected_gids = count($gids);
 	
		if ( $affected_gids > 0 )
		{
			$gid_string = implode( ",", $gids );
			
			$DB->query("UPDATE {$INFO['sql_tbl_prefix']}groups SET g_view_dshoutbox='0', g_post_dshoutbox='0', g_dshoutbox_mod='0', g_dshout_limit='0' WHERE g_id IN ($gid_string)");
			$ADMIN->save_log("D-Shoutbox: Reset Multiple Groups Permissions");
			$std->boink_it($SKIN->base_url."&act=Shoutbox&code=26");
			exit();
		}
		else
 		{
 			$std->boink_it($SKIN->base_url."&act=Shoutbox&code=26");
			exit();
		}
 	}
 	
 	function doresetallgroups() {
		global $IN, $root_path, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;
				
		$DB->query("UPDATE {$INFO['sql_tbl_prefix']}groups SET g_view_dshoutbox='0', g_post_dshoutbox='0', g_dshoutbox_mod='0', g_dshout_limit='0'");
		$ADMIN->save_log("D-Shoutbox: Reset All Groups Permissions");
		$std->boink_it($SKIN->base_url."&act=Shoutbox&code=26");
		exit();
	}
	
	//+---------------------------------------------------------------------------------
	// D-Shoutbox Member Search
	//+---------------------------------------------------------------------------------
	
	function member_search() {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		$ADMIN->page_title = "D-Shoutbox: Member Search";
		$ADMIN->page_detail = "Edit a members Shoutbox settings";
				
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , '34' ),
												  2 => array( 'act'   , 'Shoutbox'     ),
									     )      );
		//+-------------------------------
		$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "D-Shoutbox: Member Search" );
											     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Enter part or all of the usersname</b>" ,
												  $SKIN->form_input( "USER_NAME" )
									     )      );

		$ADMIN->html .= $SKIN->end_table();
		$ADMIN->html .= "<div align='center' style='width:100%;border:1px solid #BCD0ED;background-color: #DFE6EF;font-size:10px;margin:3px 0px 3px 0px;color:#3A4F6C;font-weight:bold;padding:8px'>" . $SKIN->end_form("Search Member") . "<input type='button' name='b2sb' value='Back To Main Page' onclick=\"window.location='{$SKIN->base_url}&act=Shoutbox'\" id='button'></div>" . $this->sbcopyright();	
		$ADMIN->output();		
	}
	
	function domember_search() {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		$page_query = "";
		$un_all = "";

		$IN['USER_NAME'] = trim($IN['USER_NAME']);
				
		if ($IN['USER_NAME'] == "")
		{
			$ADMIN->error("You didn't choose a member name to look for!");
		}
				
		$page_query = "&USER_NAME=".urlencode($IN['USER_NAME']);
			
		$rq = "name LIKE '".$IN['USER_NAME']."%'";
		
		$st = intval($IN['st']);
		
		if ($st < 1)
		{
			$st = 0;
		}
		
		$query = "SELECT m.*, g.*
		          FROM ibf_members m
		           LEFT JOIN ibf_groups g ON (g.g_id=m.mgroup)
		          WHERE $rq ORDER BY m.name LIMIT $st,50";
		
		//+-------------------------------
		// Get the number of results
		//+-------------------------------
		
		$DB->query("SELECT COUNT(m.id) as count FROM ibf_members m WHERE $rq");
		
		$count = $DB->fetch_row();
		
		if ($count['count'] < 1)
		{
			$ADMIN->error("Your search query did not return any matches from the member database. Please go back and try again");
		}
		
		$ADMIN->page_title = "D-Shoutbox: Member Search Results";
		$ADMIN->page_detail = "Results from your member search";
		
		//+-------------------------------
		
		$pages = $std->build_pagelinks( array( 'TOTAL_POSS'  => $count['count'],
											   'PER_PAGE'    => 50,
											   'CUR_ST_VAL'  => $IN['st'],
											   'L_SINGLE'    => $un_all."Single Page",
											   'L_MULTI'     => $un_all."Multi Page",
											   'BASE_URL'    => $SKIN->base_url."&act=Shoutbox&code={$IN['code']}".$page_query,
											 )
									  );
		
		//+-------------------------------
		
		$SKIN->td_header[] = array( "IP Address "  , "15%" );
		$SKIN->td_header[] = array( "Group"        , "10%" );
		$SKIN->td_header[] = array( "Shouts"       , "10%" );
		$SKIN->td_header[] = array( "Email"        , "15%" );
		$SKIN->td_header[] = array( "Edit"         , "16%" );
		
		//+-------------------------------
				
		$ADMIN->html .= $SKIN->start_table( "D-Shoutbox: {$count['count']} Search Results" );
		
		//+-------------------------------
		// Run the query
		//+-------------------------------
		
		$DB->query($query);
		
		while ( $r = $DB->fetch_row() )
		{
			$tban = "";
			$sus_link = "";
						
			$ADMIN->html .= $SKIN->add_td_basic( "<img src='html/sys-img/item.gif' border='0'>&nbsp;<a title='View this members profile' href='{$INFO['board_url']}/index.php?act=Profile&MID={$r['id']}' target='_blank'>{$r['name']}</a>", "left", "pformstrip" );
			$ADMIN->html .= $SKIN->add_td_row( array( "{$r['ip_address']}",
													  "<center><b>".$r['prefix'].$r['g_title'].$r['suffix']."</b></center>",
													  "<center><a href='{$SKIN->base_url}&act=Shoutbox&author={$r['name']}'>".$r['dshouts']."</a></center>",
													  "<center>".$r['email']."</center>",
													  "<center><strong><a href='{$SKIN->base_url}&act=Shoutbox&code=35&mid={$r['id']}' title='Edit this members settings'>Edit Settings</a></strong></center>"
									     	 )      );
			
		}
		
		$ADMIN->html .= $SKIN->add_td_basic($pages, 'right', 'pformstrip');				 
		$ADMIN->html .= $SKIN->end_table();
		$ADMIN->output();
	}
	
	function edit_member()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;
		
		$ADMIN->page_title = "D-Shoutbox: Member Settings";
		$ADMIN->page_detail = "Edit memers Shoutbox settings";

		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code' , '36'       ),
												  2 => array( 'act'  , 'Shoutbox' ),
												  3 => array( 'mid'  , $IN['mid'] ),
									     )      );

		$DB->query("SELECT m.*, g.* FROM
				  {$INFO['sql_tbl_prefix']}members m
				  LEFT JOIN {$INFO['sql_tbl_prefix']}groups g ON (g_id=m.mgroup)
				  WHERE m.id='{$IN['mid']}'");
		$mem = $DB->fetch_row();
		
		//+-------------------------------
		$SKIN->td_header[] = array( "&nbsp;", "70%" );
		$SKIN->td_header[] = array( "&nbsp;", "30%" );
		//+-------------------------------
		
		$DB->query("SELECT * FROM ibf_shoutbox_colors");
		while ($color = $DB->fetch_row())
		{
			$dcolors .= "<option value='{$color['color']}' style='color:{$color['color']}'";
			$dcolors .= $mem['sb_defaultcolor'] == $color['color'] ? " selected>{$color['color']}</option>\n" : ">{$color['color']}</option>/n";
		}
		
		$snames[] = array();
 		for ($i=1; $i<13; $i++)
 		{
 			$snames[$i] = "Style {$i}";
 		}
 		for ( $i = 1 ; $i < 13 ; $i++ )
		{
			$dsbstyles .= "<option value='$i'";
			$dsbstyles .= $i == $mem['sb_sbcardstyle'] ? "selected>$snames[$i]</option>" : ">$snames[$i]</option>";
		}
		
		$ADMIN->html .= $SKIN->start_table( " D-Shoutbox: Member Settings" );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Shout Count</b>" ,
												  $SKIN->form_input("dshouts", $mem['dshouts'])
									     )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>D-Shoutbox Moderator?</b>" ,
												  $SKIN->form_yes_no("dshoutbox_mod", $mem['dshoutbox_mod'] )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Daily Shout Limit?</b>" ,
												  $SKIN->form_input("dshout_limit", $mem['dshout_limit'] )
									     )      );
		
		$ADMIN->html .= $SKIN->add_td_basic("Personal Settings", "center", "pformstrip");
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>D-Shoutbox Type</b>" ,
												  $SKIN->form_dropdown( 'sb_shoutboxtype', 
										  						 array(
										  						 		0 => array( '0', 'Regular' ),
										  						 		1 => array( '1', 'Iframe'  ),
										  						 		2 => array( '2', 'Popup'   ),
										  						 	  ),
										  						 $mem['sb_shoutboxtype']  )
								 				)      );
									    								     		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Show Shouters Avatars</b>" ,
												  $SKIN->form_dropdown( 'sb_showavatars', 
										  						 array(
										  						 		0 => array( '1', 'Yes' ),
										  						 		1 => array( '0', 'No'  ),
										  						 	  ),
										  						 $mem['sb_showavatars']  )
								 				)      );
											    
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Show Shout Time</b>" ,
												  $SKIN->form_dropdown( 'sb_showshouttime', 
										  						 array(
										  						 		0 => array( '1', 'Yes' ),
										  						 		1 => array( '0', 'No'  ),
										  						 	  ),
										  						 $mem['sb_showshouttime']  )
								 				)      );
											    
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Default Shouting Color</b>" ,
												  "<select name='sb_defaultcolor' class='dropdown'>\n{$dcolors}</select>\n"
								 				)      );
								 															    
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Show Smilies Table</b>" ,
												  $SKIN->form_dropdown( 'sb_showsmiliest', 
										  						 array(
										  						 		0 => array( '1', 'Yes' ),
										  						 		1 => array( '0', 'No'  ),
										  						 	  ),
										  						 $mem['sb_showsmiliest']  )
								 				)      );
								 				
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Show Todays Shouters</b>" ,
												  $SKIN->form_dropdown( 'sb_showtdshouters', 
										  						 array(
										  						 		0 => array( '1', 'Yes' ),
										  						 		1 => array( '0', 'No'  ),
										  						 	  ),
										  						 $mem['sb_showtdshouters']  )
								 				)      );
								 				
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Show Overall Shouters</b>" ,
												  $SKIN->form_dropdown( 'sb_showtpshouters', 
										  						 array(
										  						 		0 => array( '1', 'Yes' ),
										  						 		1 => array( '0', 'No'  ),
										  						 	  ),
										  						 $mem['sb_showtpshouters']  )
								 				)      );
								 				
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>D-Shoutbox Refresh Time</b>" ,
												  $SKIN->form_input( 'sb_refresh', $mem['sb_refresh'], 'text')
								 				)      );
								 				
		$sb = $DB->query("SELECT * FROM ibf_shoutbox_settings");
		$shoutbox = $DB->fetch_row($sb);
		if ($shoutbox['usesbcard'] == 1)
		{
			$ADMIN->html .= $SKIN->add_td_row( array( "<b>D-Shoutbox Card Style</b>" ,
												  "<select name='sb_sbcardstyle' class='dropdown'>\n{$dsbstyles}</select>\n"
								 				)      );
		}
		
		$ADMIN->html .= $SKIN->end_table();
		$ADMIN->html .= "<div align='center' style='width:100%;border:1px solid #BCD0ED;background-color: #DFE6EF;font-size:10px;margin:3px 0px 3px 0px;color:#3A4F6C;font-weight:bold;padding:8px'>" . $SKIN->end_form("Edit Settings") . "<input type='button' name='b2sb' value='Back To Main Page' onclick=\"window.location='{$SKIN->base_url}&act=Shoutbox'\" id='button'></div>" . $this->sbcopyright();	
		$ADMIN->output();
	}
	
	function doedit_member() {
		global $IN, $root_path, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;
				
		if ($IN['mid'] == "")
		{
			$ADMIN->error("You have entered a valid member id to change the settings for!");
		}
		if ($INFO['sb_usesbcard'] == 1)
		{
			$db_string = $DB->compile_db_update_string(  array (
																  'dshouts'           => $IN['dshouts'],
																  'dshoutbox_mod'     => $IN['dshoutbox_mod'],
																  'dshout_limit'      => $IN['dshout_limit'],
															      'sb_shoutboxtype'   => $IN['sb_shoutboxtype'],
															      'sb_showavatars'    => $IN['sb_showavatars'],
															      'sb_showshouttime'  => $IN['sb_showshouttime'],
															      'sb_showsmiliest'   => $IN['sb_showsmiliest'],
															      'sb_showtdshouters' => $IN['sb_showtdshouters'],
															      'sb_showtpshouters' => $IN['sb_showtpshouters'],
															      'sb_refresh'        => $IN['sb_refresh'],
															      'sb_sbcardstyle'    => $IN['sb_sbcardstyle'],
															      'sb_defaultcolor'   => $IN['sb_defaultcolor'],
												      )         );
		}
		else
		{
			$db_string = $DB->compile_db_update_string(  array (
																  'dshouts'           => $IN['dshouts'],
																  'dshoutbox_mod'     => $IN['dshoutbox_mod'],
																  'dshout_limit'      => $IN['dshout_limit'],
															      'sb_shoutboxtype'   => $IN['sb_shoutboxtype'],
															      'sb_showavatars'    => $IN['sb_showavatars'],
															      'sb_showshouttime'  => $IN['sb_showshouttime'],
															      'sb_showsmiliest'   => $IN['sb_showsmiliest'],
															      'sb_showtdshouters' => $IN['sb_showtdshouters'],
															      'sb_showtpshouters' => $IN['sb_showtpshouters'],
															      'sb_refresh'        => $IN['sb_refresh'],
															      'sb_defaultcolor'   => $IN['sb_defaultcolor'],
												      )         );
		}
		
		$DB->query("UPDATE {$INFO['sql_tbl_prefix']}members SET $db_string WHERE id='{$IN['mid']}'");
		$ADMIN->save_log("D-Shoutbox: Members Settings Saved");
		$std->boink_it("{$SKIN->base_url}&act=Shoutbox&code=33");
		exit();
	}

	//+---------------------------------------------------------------------------------
	// Saves Config To File
	//+---------------------------------------------------------------------------------
	
	function save_config( $new )
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;
		
		$master = array();
		
		if ( is_array($new) )
		{
			if ( count($new) > 0 )
			{
				foreach( $new as $field )
				{
					if ($field == 'img_ext' or $field == 'avatar_ext' or $field == 'photo_ext')
					{
						$HTTP_POST_VARS[ $field ] = preg_replace( "/[\.\s]/", "" , $HTTP_POST_VARS[ $field ] );
						$HTTP_POST_VARS[ $field ] = str_replace('|', "&#124;", $HTTP_POST_VARS[ $field ]);
						$HTTP_POST_VARS[ $field ] = preg_replace( "/,/"     , '|', $HTTP_POST_VARS[ $field ] );
					}
					else if ($field == 'coppa_address')
					{
						$HTTP_POST_VARS[ $field ] = nl2br( $HTTP_POST_VARS[ $field ] );
					}
					
					if ( $field == 'gd_font' OR $field == 'html_dir' OR $field == 'upload_dir')
					{
						$HTTP_POST_VARS[ $field ] = preg_replace( "/'/", "&#39;", $HTTP_POST_VARS[ $field ] );
					}
					else
					{
						$HTTP_POST_VARS[ $field ] = preg_replace( "/'/", "&#39;", stripslashes($HTTP_POST_VARS[ $field ]) );
					}
					
					$master[ $field ] = stripslashes($HTTP_POST_VARS[ $field ]);
				}
				$ADMIN->rebuild_config($master);
			}
		}
		
		$ADMIN->save_log("D-Shoutbox Settings Saved");
		$ADMIN->done_screen("D-Shoutbox Settings Saved", "D-Shoutbox Settings", "act=Shoutbox&code=09" );
		
	}

	function sbcopyright()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		$copyr = "<p><center><div align='center' style='width:60%;border:1px solid #BCD0ED;background-color: #DFE6EF;font-size:10px;margin:3px 0px 3px 0px;color:#3A4F6C;font-weight:bold;padding:8px'><small>Powered By:&nbsp; D-Shoutbox {$this->ver}</small></center></div>";
		return $copyr;
	}
	    
	function status_check() {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		$a = fopen("http://www.dscripting.com/dsb/status/cv.php?ver={$this->ver}","r");
		$b = fread($a, 9000);
		
		return $b;
	}

	//------------------------------------------------
	// Get the members avatar size
	//------------------------------------------------
  
	function get_avatar($member_avatar="", $member_view_avatars=0, $avatar_dims="x")
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $ibforums, $MEMBER, $GROUP, $HTTP_POST_VARS;
    	
		$DB->query("SELECT * FROM ibf_shoutbox_settings");
		$shoutbox = $DB->fetch_row();
    	
		$ibforums->skin  = $std->load_skin();
		$INFO['img_url'] = "{$INFO['board_url']}/style_images/".$ibforums->skin['img_dir'];

		if (!$member_avatar or $member_view_avatars == 0 or $MEMBER['sb_showavatars'] == 0)
		{
			return "";
		}
    	
		if (preg_match ( "/^noavatar/", $member_avatar ))
		{
			$img = "<img src='{$INFO['img_url']}/{$shoutbox['noavatar_name']}' border='0' alt='No Avatar'>";
			return $img;
    	}
    	
		if ( (preg_match ( "/\.swf/", $member_avatar)) and ($INFO['allow_flash'] != 1) )
		{
			return "";
		}
    	
		$davatar_dims   = explode( "x", $shoutbox['avatar_dims'] );
		$default_a_dims = explode( "x", $INFO['avatar_def'] );
    	
    	//---------------------------------------
		// Have we enabled URL / Upload avatars?
		//---------------------------------------
		
		$this_dims = explode( "x", $avatar_dims );
		if (!$this_dims[0]) $this_dims[0] = $davatar_dims[0];
		if (!$this_dims[1]) $this_dims[1] = $davatar_dims[1];
		
		if ( preg_match( "/^http:\/\//", $member_avatar ) )
		{
			// Ok, it's a URL..
			
			if (preg_match ( "/\.swf/", $member_avatar))
			{
				return "<object classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\" width='{$this_dims[0]}' height='{$this_dims[1]}'>
						<param name='movie' value='{$member_avatar}'><param name='play' value='true'>
						<param name='loop' value='true'><param name='quality' value='high'>
						<embed src='{$member_avatar}' width='{$this_dims[0]}' height='{$this_dims[1]}' play='true' loop='true' quality='high'></embed></object>";
			}
			else
			{
				return "<img src='{$member_avatar}' border='0' width='{$this_dims[0]}' height='{$this_dims[1]}' alt='' />";
			}
			
			//---------------------------------------
			// Not a URL? Is it an uploaded avatar?
			//---------------------------------------
		}
		else if ( ($INFO['avup_size_max'] > 1) and ( preg_match( "/^upload:av-(?:\d+)\.(?:\S+)/", $member_avatar ) ) )
		{
			$member_avatar = preg_replace( "/^upload:/", "", $member_avatar );
			
			if ( preg_match ( "/\.swf/", $member_avatar) )
			{
				return "<object classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\" width='{$this_dims[0]}' height='{$this_dims[1]}'>
						<param name='movie' value='{$INFO['upload_url']}/$member_avatar'><param name='play' value='true'>
						<param name='loop' value='true'><param name='quality' value='high'>
					    <embed src='{$INFO['upload_url']}/$member_avatar\' width='{$this_dims[0]}' height='{$this_dims[1]}' play='true' loop='true' quality='high'></embed></object>";
			}
			else
			{
				return "<img src='{$INFO['upload_url']}/$member_avatar' border='0' width='{$this_dims[0]}' height='{$this_dims[1]}' alt='' />";
			}
		}
		
		//---------------------------------------
		// No, it's not a URL or an upload, must
		// be a normal avatar then
		//---------------------------------------
		
		else if ($member_avatar != "")
		{
			//---------------------------------------
			// Do we have an avatar still ?
		   	//---------------------------------------
		   	
			return "<img src='{$INFO['AVATARS_URL']}/{$member_avatar}' width='{$this_dims[0]}' height='{$this_dims[1]}' border='0' alt='' />";
		}
		else
		{
			//---------------------------------------
			// No, ok - return blank
			//---------------------------------------
			
			$img = "<img src='{$INFO['img_url']}/{$shoutbox['noavatar_name']}' border='0' alt='No Avatar'>";
			return $img;
		}
	}
}
?>