<?php
/*
+--------------------------------------------------------------------------
|   D-Shoutbox -- The High-Tech Shoutbox
|   =======================================================
|   By Dean
|    2003-2004 Dean
|   http://www.dscripting.com
|   ========================================================
|   Web: http://www.dscripting.com
|   Email: dean@dscripting.com
+--------------------------------------------------------------------------
*/

//+-------------------------------------------------
//+  You may edit these settings below
//+-------------------------------------------------
$burl    = "forums/"; // This is the short url to your forums (Ex: forums/) INCLUDE A TRALING SLASH (/)!!
$iwidth  = "92%";     // This is the width of the iframe that displays the shouts
$iheight = "300";     // This is the height of the iframe that displays the shouts
$showsab = "Yes";     // Set this (Yes | No) to show the Smilies & BBCodes links
$guestv  = "Yes";     // Set this (Yes | No) to allow guest viewing of the shoutbox
//+-------------------------------------------------
//+  NO MORE EDITING BELOW!
//+-------------------------------------------------

define( 'ROOT_PATH', "./".$burl );
set_magic_quotes_runtime(0);
error_reporting  (E_ERROR | E_WARNING | E_PARSE);
require(ROOT_PATH.'conf_global.php');

class info
{
	var $member			= array();
	var $input			= array();
	var $session_id		= "";
	var $base_url		= "";
	var $vars			= "";
	var $skin_id		= "0";
	var $skin_rid		= "";
	var $lang_id		= "en";
	var $skin			= "";
	var $lang			= "";
	var $server_load	= 0;
	var $ver			= "5.7.4";
	var $lastclick		= "";
	var $location		= "";

	function info()
	{
		global $sess, $std, $DB, $root_path, $INFO;

		$this->vars = &$INFO;
		$this->vars['TEAM_ICON_URL']   = $INFO['html_url'] . '/team_icons';
		$this->vars['AVATARS_URL']     = $INFO['html_url'] . '/avatars';
		$this->vars['EMOTICONS_URL']   = $INFO['html_url'] . '/emoticons';
		$this->vars['mime_img']        = $INFO['html_url'] . '/mime_types';
	}
}

require ROOT_PATH."sources/functions.php";

$std   = new FUNC;
$print = new display();
$sess  = new session();

$INFO['sql_driver'] = !$INFO['sql_driver'] ? 'mySQL' : $INFO['sql_driver'];

$to_require = ROOT_PATH."sources/Drivers/".$INFO['sql_driver'].".php";
require ($to_require);

$DB = new db_driver;
$DB->obj['sql_database']     = $INFO['sql_database'];
$DB->obj['sql_user']         = $INFO['sql_user'];
$DB->obj['sql_pass']         = $INFO['sql_pass'];
$DB->obj['sql_host']         = $INFO['sql_host'];
$DB->obj['sql_tbl_prefix']   = $INFO['sql_tbl_prefix'];

$DB->connect();

$ibforums             = new info();
$ibforums->input      = $std->parse_incoming();
$ibforums->member     = $sess->authorise();
$ibforums->skin       = $std->load_skin();
$ibforums->lastclick  = $sess->last_click;
$ibforums->location   = $sess->location;
$ibforums->session_id = $sess->session_id;

$ibforums->base_url   = $ibforums->vars['board_url'].'/index.'.$ibforums->vars['php_ext'].'?s='.$ibforums->session_id;

$ibforums->skin_rid   = $ibforums->skin['set_id'];
$ibforums->skin_id    = 's'.$ibforums->skin['set_id'];
$ibforums->copy       = "Powered By: <a href='http://mods.invisionize.com/db/index.php/f/1287' target='_blank'>D-Shoutbox</a>";

$ibforums->vars['img_url']   = 'style_images/'.$ibforums->skin['img_dir'];

//--------------------------------
//  Set up our language choice
//--------------------------------

$ibforums->lang_id = $ibforums->member['language'] ? $ibforums->member['language'] : 'en';
if (($ibforums->lang_id != 'en') and (!is_dir( $root_path."lang/".$ibforums->lang_id )))
{
	$ibforums->lang_id = 'en';
}

require ROOT_PATH."lang/".$ibforums->lang_id."/lang_global.php";
$ibforums->lang = $lang;
unset($lang);

//--------------------------------

require ROOT_PATH."Skin/".$ibforums->skin_id."/skin_global.php";
$skin_universal = new skin_global();

require ROOT_PATH."sources/Shoutbox/sbfuncs.php";
$sbfunc = new SBFUNC;

$DB->query("SELECT * FROM ibf_shoutbox_settings");
$shoutbox = $DB->fetch_row();
$ibforums->sbcolors = $sbfunc->get_sbcolors();

$TAGS = $DB->query("SELECT macro_value, macro_replace FROM ibf_macro WHERE macro_set='{$ibforums->skin['macro_id']}'");


$Shoutbox = new Shoutbox;
class Shoutbox
{
	var $html;
	var $output   = "";
	var $base_url = "";
	var $ver      = "5.7.4";
	var $nav;
	
	function Shoutbox()
	{
		global $ibforums, $DB, $std, $iwidth, $iheight, $scolors, $showsab, $guestv, $sbfunc;
		
		$sbfunc->run_update();
		
		if($ibforums->input['Post']<>"")
		{
			$this->post_shout();
		}
		
		if ($ibforums->member['id'] && $ibforums->member['name'])
		{
		    $data = "<input type='submit' name='submit' class='forminput' value='Shout'> ";
		}
		else
		{
		    $data = "<input type='button' value='Login' class='forminput' onclick=\"parent.location='{$ibforums->base_url}&act=Login&CODE=00'\"> ";
		}
		
		if ($showsab == "Yes")
		{
			$links = "[<a href='javascript:' onclick='emo_pop()'>Smilies</a>|<a href='javascript:' onclick='bbc_pop()'>BBCodes</a>]";
		}
		
		if ($guestv == 'No' && ($ibforums->member['id']=="" || $ibforums->member['name']=="")) 
		{
			$iframe = "<iframe name='SB_WEB' src='{$ibforums->vars['board_url']}/sb_iframe.php?step=noview' width='{$iwidth}' height='{$iheight}' scrolling='no' align='center' frameborder='0' marginwidth='0' marginheight='0'></iframe>";		
		}
		else
		{
			$iframe = "<iframe name='SB_WEB' src='{$ibforums->vars['board_url']}/sb_iframe.php?step=three&view=web' width='{$iwidth}' height='{$iheight}' scrolling='no' align='center' frameborder='0' marginwidth='0' marginheight='0'></iframe>";
		}

		print "{$iframe}<br><center>
		<script language='Javascript'>
		function emo_pop()
		{
			window.open('forums/index.php?act=legends&CODE=emoticons','Legends','width=250,height=500,resizable=yes,scrollbars=yes'); 
		}
		function bbc_pop()
		{
			window.open('forums/index.php?act=legends&CODE=bbcode','Legends','width=700,height=500,resizable=yes,scrollbars=yes'); 
		}
		</script>
		<form target='SB_WEB' action='sb_web.php' name='REPLIER' method='post'>
		<table align='center'><tr><td align='center'>{$links}
		<textarea rows='3' cols='20' name='Post' onclick='this.select()' class='forminput'></textarea><br>
		{$data}<input type='button' value='Refresh' class='forminput' onclick='document.SB_WEB.location.reload()'>
		<br><select name='Color' class='codebuttons'>{$ibforums->sbcolors}</select></td></tr></table></form>{$ibforums->copy}";
	}
	
	function Post_Shout()
	{
		global $ibforums, $DB, $std, $sbfunc, $shoutbox;
        
		$name	 = $ibforums->member['name'];
		$uid	 = $ibforums->member['id'];
		$message = $ibforums->input['Post'];
		$color   = $ibforums->input['Color'];
        
		$this->flood_check($name);
	
		if ($ibforums->member['g_post_dshoutbox'] != 1)
		{
			print "You are not allowed to post to the shoutbox";
			exit;
		}
	
		$ma = explode( "|", $ibforums->member['dshouts_today'] );
		$ms = $ma[0];
		$ga = explode( "|", $ibforums->member['g_dshouts_today'] );
		$gs = $ga[0];
	
		if ($ibforums->member['dshout_limit'] != 0 || $ibforums->member['g_dshout_limit'] != 0)
		{
			if ($ms > $ibforums->member['dshout_limit'] || $gs > $ibforums->member['g_dshout_limit'])
			{
				print "You have used up your daily shout limit for today";
				exit;
			}
		}

		if($shoutbox['guestposting'] == 0 AND $ibforums->member['name']=="Guest" OR $ibforums->member['id'] == 0)
		{
			print "Guests are not allowed to use the shoutbox";
			exit;
		}

		if ($shoutbox['usesbcard']==1 && ($shoutbox['chargeperpost'] > $ibforums->member['sb_sbcard_value']))
		{
			print "You don't have enough D-Shoutbox Card Value to shout";
			exit;
		}

		if(trim($message)=="")
		{
			print "Please insert a shout";
			exit;
		}

		if ($color == "")
		{
			$color = $ibforums->member['sb_defaultcolor'];
		}

		$parser = new post_parser(1);
	
		$message = $parser->unconvert($message);
		$message = preg_replace('/\[img]/i', '', $message);
		$message = preg_replace('/\[\/img]/i', '', $message);
		$message = preg_replace('/<img/i', '', $message);
		$message = trim($parser->convert( array( 	TEXT    => $message,
													SMILIES => $shoutbox['allowsmilies'],
													CODE    => $shoutbox['allowbbcodes'],
													HTML    => 0
												)));
		$message = addslashes($message);

		$time = date("jS F Y");
		$DB->query("INSERT INTO ibf_shoutbox (name, uid, message, time, time_time, color) VALUES ('$name','$uid','$message','$time','".time()."','$color')");

		if ($shoutbox['usesbcard'] == 1 && $shoutbox['chargeperpost'] != "")
		{
			$DB->query("UPDATE {$ibforums->vars['sql_tbl_prefix']}members SET sb_sbcard_value = sb_sbcard_value - ".$shoutbox['chargeperpost']." WHERE id='".$ibforums->member['id']."'");
		}
		if ($shoutbox['useshopp'] == 1)
		{
	    	if ($shoutbox['shoppoints'] == "")
	    	{
				$shoutbox['shoppoints'] = '0';
			}
			$DB->query("UPDATE {$ibforums->vars['sql_tbl_prefix']}members SET points = points + ".$shoutbox['shoppoints']." WHERE id='".$ibforums->member['id']."'");
		}
		if ($shoutbox['usestorep'] == 1)
		{
	    	if ($shoutbox['storepoints'] == "")
	    	{
				$shoutbox['storepoints'] = '0';
			}
			$DB->query("UPDATE {$ibforums->vars['sql_tbl_prefix']}members SET points = points + ".$shoutbox['storepoints']." WHERE id='".$ibforums->member['id']."'");
		}
		$a = explode("|", $ibforums->member['dshouts_today'] );
		$b = $a[0]+1;
		$c = explode("|", $ibforums->member['g_dshouts_today'] );
		$d = $c[0]+1;
		$dstoday = $b."|".$time;
		$dstodayg = $d."|".$time;
		$DB->query("UPDATE ibf_members SET dshouts=dshouts+1, dshouts_alltime=dshouts_alltime+1, last_shout_time='".time()."', dshouts_today='{$dstoday}' WHERE id='{$ibforums->member['id']}'");
		$DB->query("UPDATE ibf_groups SET g_dshouts_today='{$dstoday}' WHERE g_id='".$ibforums->member['mgroup']."'");
		$DB->query("UPDATE ibf_shoutbox_stats SET totalshouts=totalshouts+1, shouts_alltime=shouts_alltime+1");
		
		$std->boink_it("{$ibforums->vars['board_url']}/sb_iframe.php?step=three&view=web");
	}
  
  	function flood_check($member)
	{
		global $iforums, $DB, $std, $shoutbox;

		$DB->query("SELECT * FROM ibf_members WHERE name='{$member}'");
		$mem = $DB->fetch_row();

		if ( $shoutbox['flood_seconds'] > 0 )
		{
			if ( time() - $mem['last_shout_time'] < $shoutbox['flood_seconds'] )
			{
				$check = "Please wait some time before shouting again!";
			}
			else
			{
				$num1 = 0;
				$DB->query("SELECT name FROM ibf_shoutbox ORDER BY id DESC LIMIT {$shoutbox['flood']}");
				while ($namearray = $DB->fetch_row())
				{
					$name1 = $namearray['name'];
					if ($name1 == $mem['name'])
					{
						$num1++;
					}
						
					if ($num1 >= $shoutbox['flood'])
					{
						$check = "Please wait some time before shouting again!";
					}
				}	
			}
		}
		else
		{
			$check = "";
		}

		if ($check != "")
		{
			print $check;
			exit;
		}
		else
		{
			return true;
		}
	}
}
?>