<?php
/*
+--------------------------------------------------------------------------
|   D-Shoutbox -- The High-Tec Shoutbox
|   =======================================================
|   By Dean
|    2003-2004 Dean
|   http://www.dscripting.com
|   ========================================================
|   Web: http://www.dscripting.com
|   Email: dean@dscripting.com
+--------------------------------------------------------------------------
*/

define( 'ROOT_PATH', "./" );
set_magic_quotes_runtime(0);
error_reporting  (E_ERROR | E_WARNING | E_PARSE);

require(ROOT_PATH.'conf_global.php');

class Debug
{
    function startTimer()
    {
        global $starttime;
        $mtime = microtime ();
        $mtime = explode (' ', $mtime);
        $mtime = $mtime[1] + $mtime[0];
        $starttime = $mtime;
    }
    function endTimer()
    {
        global $starttime;
        $mtime = microtime ();
        $mtime = explode (' ', $mtime);
        $mtime = $mtime[1] + $mtime[0];
        $endtime = $mtime;
        $totaltime = round (($endtime - $starttime), 5);
        return $totaltime;
	}
}

class info
{
	var $member     = array();
	var $input      = array();
	var $session_id = "";
	var $base_url   = "";
	var $vars       = "";
	var $skin_id    = "0";
	var $skin_rid   = "";
	var $lang_id    = "en";
	var $skin       = "";
	var $lang       = "";
	var $server_load = 0;
	var $version    = "5.7.4";
	var $lastclick  = "";
	var $location   = "";

	function info()
	{
		global $sess, $std, $DB, $root_path, $INFO;
		
		$this->vars = &$INFO;
		$this->vars['TEAM_ICON_URL']   = $INFO['html_url'] . '/team_icons';
		$this->vars['AVATARS_URL']     = $INFO['html_url'] . '/avatars';
		$this->vars['EMOTICONS_URL']   = $INFO['html_url'] . '/emoticons';
		$this->vars['mime_img']        = $INFO['html_url'] . '/mime_types';
	}
}

require ROOT_PATH."sources/functions.php";
	
$std   = new FUNC;
$print = new display();
$sess  = new session();

$Debug = new Debug;
$Debug->startTimer();

$INFO['sql_driver'] = !$INFO['sql_driver'] ? 'mySQL' : $INFO['sql_driver'];
require ROOT_PATH."sources/Drivers/".$INFO['sql_driver'].".php";

$DB = new db_driver;
$DB->obj['sql_database']     = $INFO['sql_database'];
$DB->obj['sql_user']         = $INFO['sql_user'];
$DB->obj['sql_pass']         = $INFO['sql_pass'];
$DB->obj['sql_host']         = $INFO['sql_host'];
$DB->obj['sql_tbl_prefix']   = $INFO['sql_tbl_prefix'];
$DB->connect();

$ibforums             = new info();
$ibforums->input      = $std->parse_incoming();
$ibforums->member     = $sess->authorise();
$ibforums->skin       = $std->load_skin();
$ibforums->lastclick  = $sess->last_click;
$ibforums->location   = $sess->location;
$ibforums->session_id = $sess->session_id;

$ibforums->base_url   = $ibforums->vars['board_url'].'/index.'.$ibforums->vars['php_ext'].'?s='.$ibforums->session_id;
$ibforums->skin_rid   = $ibforums->skin['set_id'];
$ibforums->skin_id    = 's'.$ibforums->skin['set_id'];

$ibforums->vars['img_url']   = 'style_images/' . $ibforums->skin['img_dir'];

require ROOT_PATH."sources/Shoutbox/sbfuncs.php";
$sbfunc = new SBFUNC;

$ibforums->sbcolors = $sbfunc->get_sbcolors();
$DB->query("SELECT * FROM ibf_shoutbox_settings");
$shoutbox = $DB->fetch_row();

//--------------------------------
//  Set up our language choice
//--------------------------------
$ibforums->lang_id = $ibforums->member['language'] ? $ibforums->member['language'] : 'en';
if (($ibforums->lang_id != 'en') && (!is_dir( ROOT_PATH."lang/".$ibforums->lang_id )))
{
	$ibforums->lang_id = 'en';
}

require ROOT_PATH."lang/".$ibforums->lang_id."/lang_global.php";
$ibforums->lang = $lang;
unset($lang);

require ROOT_PATH."Skin/".$ibforums->skin_id."/skin_global.php";
$skin_universal = new skin_global();

$Shoutbox = new Shoutbox;

class Shoutbox
{
	var $html;
	var $output   = "";
	var $base_url = "";
	var $member   = array();
	var $nav;

	function Shoutbox()
	{
		global $ibforums, $DB, $std, $shoutbox, $sbfunc;

		$ibforums->lang = $std->load_words($ibforums->lang, 'lang_shoutbox', $ibforums->lang_id);
		if ($shoutbox['skin_selection'] == 'new')
		{
			$this->html = $std->load_template('skin_shoutbox');
		}
		else if ($shoutbox['skin_selection'] == 'old')
		{
			$this->html = $std->load_template('skin_shoutbox2');
		}

		$sbfunc->run_update();
	
		$DB->query("SELECT m.*, g.*
					FROM ibf_members m
					LEFT JOIN ibf_groups g ON (m.mgroup=g.g_id)
					WHERE m.id='{$ibforums->member['id']}'");
		$this->member = $DB->fetch_row();
		
		if (!$this->member['id'])
		{
			$ibforums->input['last_visit'] = time();
		}

		$this->base_url = "{$ibforums->vars['board_url']}";
		$this->iframe();
	}
	
	function Post_Shout()
	{
		global $ibforums, $DB, $std, $sbfunc, $shoutbox;
		
		$name    = $this->member['name'];
		$uid     = $this->member['id'];
		$message = $ibforums->input['Post'];
		$color   = $ibforums->input['Color'];
		
		$sbfunc->flood_check($member);
		if($this->member['g_post_dshoutbox'] != 1)
		{
			$this->iframe_error('no_post_shoutbox');
		}
		
		if(($shoutbox['guestposting'] == 0) && ($this->member['name'] == "" || $this->member['id'] == "0"))
		{
			$this->iframe_error('guest_no_post');
		}
		
		if ($color == "")
		{
			$color = $this->member['sb_defaultcolor'];
		}

		if(trim($message) == "")
		{
			$this->iframe_error('no_message');
		}
		
		require ROOT_PATH."sources/lib/post_parser.php";
		$parser = new post_parser(1);
		
		$message = $parser->unconvert($message);
		$message = preg_replace('/\[img]/i', '', $message);
		$message = preg_replace('/\[\/img]/i', '', $message);
		$message = preg_replace('/<img/i', '', $message);
		$message = trim($parserd->convert( array( 	TEXT    => $message,
													SMILIES => $shoutbox['allowsmilies'],
													CODE    => $shoutbox['allowbbcodes'],
													HTML    => 0
										) ) );

		$message = addslashes($message);
		$time = date("jS F Y");
		$DB->query("INSERT INTO ibf_shoutbox (name, uid, message, time, time_time, color) VALUES ('{$name}','{$uid}','{$message}','{$time}','".time()."','{$color}')");
		
		if ($shoutbox['usesbcard'] == 1 && $shoutbox['chargeperpost'] != "")
		{
			$DB->query("UPDATE ibf_members SET sb_sbcard_value=sb_sbcard_value-{$shoutbox['chargeperpost']} WHERE id='{$this->member['id']}'");
		}
		if ($shoutbox['useshopp'] == 1)
		{
			if ($shoutbox['shoppoints'] == "")
			{
				$shoutbox['shoppoints'] = 0;
			}
			$DB->query("UPDATE ibf_members SET points=points+{$shoutbox['shoppoints']} WHERE id='{$this->member['id']}'");
		}
		if ($shoutbox['usestorep'] == 1)
		{
			if ($shoutbox['storepoints'] == "")
			{
				$shoutbox['storepoints'] = 0;
			}
			$DB->query("UPDATE ibf_members SET points=points+{$shoutbox['storepoints']} WHERE id='{$this->member['id']}'");
		}

		$a = explode( "|", $this->member['dshouts_today'] );
		$b = $a[0]+1;
		$c = explode( "|", $this->member['g_dshouts_today'] );
		$d = $c[0]+1;
		$dstoday = $b."|".$time;
		$dstodayg = $d."|".$time;

		$DB->query("UPDATE ibf_members SET dshouts=dshouts+1, dshouts_alltime=dshouts_alltime+1, last_shout_time='".time()."', dshouts_today='{$dstoday}' WHERE id='{$this->member['id']}'");
		$DB->query("UPDATE ibf_groups SET g_dshouts_today='{$dstoday}' WHERE g_id='{$this->member['mgroup']}'");
		$DB->query("UPDATE ibf_shoutbox_stats SET totalshouts=totalshouts+1, shouts_alltime=shouts_alltime+1");
	}
	
	function Render_Shouts()
	{
		global $ibforums, $DB, $std, $shoutbox, $sbfunc;
		
		$DB->query("SELECT g.prefix, g.suffix, m.id AS mid, m.use_dshoutbox, s.* FROM ibf_shoutbox s, ibf_members m, ibf_groups g WHERE s.name=m.name AND m.mgroup=g.g_id ORDER BY s.id DESC LIMIT 0," . $shoutbox['postspp']);
		while($r= $DB->fetch_row())
		{
			$r['prefix']  = stripslashes($r['prefix']);
			$r['suffix']  = stripslashes($r['suffix']);
			$r['message'] = stripslashes($r[message]);
			$r['message'] = "<span style='color: {$r['color']}'>{$r['message']}</span>";
			$r['message'] = $sbfunc->bad_words($r['message']);
			
			if ($shoutbox['wordwrap'] > 0)
			{
				$r['message'] = $sbfunc->wordwrap($r['message'], $shoutbox['wordwrap']);
			}
			
			if ($this->member['sb_showshouttime'] == 1)
			{
				if ($r['time_time']<>'0')
				{
					$std->time_options['SB'] = 'H:i';
					$r['time'] = $std->get_date($r[time_time], 'SB');
				}
			}
			
			$shouts .= $this->html->iframe_shout($r);
		}
		
		return $shouts;
	}
	
	function iframe()
	{
		global $ibforums, $DB, $shoutbox, $sbfunc;
		
		$refreshurl = "{$ibforums->vars['board_url']}/sb_iframe.php&step=three";
		
		if ($ibforums->input['step'] == "")
		{
			$this->output($this->html->iframe_step_one($shoutbox['iframew'], $shoutbox['iframeh']));
			return;
		}
		
		if ($ibforums->input['step'] == "noview")
		{
			$this->iframe_web_error('no_view_shoutbox');
		}
		
		if ($ibforums->input['step']=="two")
		{
			if (($this->member['id'] == 0 || $this->member['name'] == "") && ($shoutbox['guestviewsb'] == 0))
			{
				$data = $this->html->sb_iframe_login();
				$this->output($this->html->iframe_step_two($data));
				return;
			}
			else
			{
				$data = $this->html->sb_iframe_btop();
				$this->output($this->html->iframe_step_two($data));
				return;
			}
		}
		
		if ($ibforums->input['step'] == "three")
		{
			if ($this->member['g_view_board'] != 1)
			{
				$this->iframe_error('no_view_shoutbox');
			}
			
			if ($ibforums->vars['board_offline'] == 1)
			{
				if ($this->member['g_access_offline'] != 1)
				{
					$this->iframe_error('board_offline');
				}
			}
			
			if ((!$this->member['id']) && ($ibforums->vars['force_login'] == 1))
			{
				$this->iframe_error('please_login');
			}
			
			if ($this->member['g_view_dshoutbox'] != 1 || $this->member['use_dshoutbox'] != 1)
			{
				$this->iframe_error('no_view_shoutbox');
			}
			
			if ($this->member['id'] == 0 && $shoutbox['guestviewsb']==0)
			{
				$this->iframe_error('no_guest_view_shoutbox');
			}
			
			if ($shoutbox['online'] != 1)
			{
				$this->iframe_error('no_shoutbox_online');
			}
			
			if ($shoutbox['autodelete'] == 1)
			{
				$time_del = $shoutbox['addays'] * 24 * 60 * 60;
				$ttime = (time() - $time_del);
				$DB->query("DELETE FROM ibf_shoutbox WHERE time_time<'{$ttime}'");
			}
			
			if($ibforums->input['Post']<>"" && $ibforums->input['step'] == "two" && $this->member['use_dshoutbox'] != 1)
			{
				$this->iframe_error('banned_shoutbox');
			}
			
			if($ibforums->input['Post']<>"" && $this->member['use_dshoutbox'] != 1)
			{
				$this->iframe_error('banned_shoutbox');
			}
			
			if($ibforums->input['Post']<>"")
			{
				$this->Post_Shout();
				$sbfunc->refresh($refreshurl);
			}
			
			if($ibforums->input['Post']<>"" && $ibforums->input['step'] == "two")
			{
				$this->Post_Shout();
				$sbfunc->refresh($refreshurl);
			}
			
			$refresh = ($this->member['sb_refresh'] != "") ? $this->member['sb_refresh'] : $shoutbox['refresh'];
			$shouts = $this->Render_Shouts();
			$this->output($this->html->iframe_step_three($shouts, $refresh));
			return;
		}
	}
	
	function iframe_error($error)
	{
		global $ibforums, $shoutbox;
		
		if ($this->member['id'] == 0)
		{
			$refresh = $shoutbox['refresh'];
		}
		else
		{
			$refresh = $this->member['sb_refresh'];
		}
		print $this->html->iframe_error("<tr valign='top'><td class='tablebasic'>{$ibforums->lang[$error]}<br><a href='javascript:history.go(-1)'>Back</a></td></tr>", $refresh);
		exit;
	}
	
	function output($data)
	{
		global $std, $ibforums, $DB;

		$DB->query("SELECT macro_value, macro_replace FROM ibf_macro WHERE macro_set='{$ibforums->skin['macro_id']}'");
		while ($row = $DB->fetch_row())
		{
			if ($row['macro_value'] != "")
			{
				$data = str_replace( "<{".$row['macro_value']."}>", $row['macro_replace'], $data );
			}
		}
		
		print $data;
	}
}
?>