<?php
//***************************************************************************//
//                                                                           //
//  Program Name    	: vCard PRO                                          //
//  Program Version     : 3.0 Build 9                                        //
//  Program Author      : Joao Kikuchi,  Belchior Foundry                    //
//  Home Page           : http://www.belchiorfoundry.com                     //
//  Supplied by         : WTN-WDYL Team                                      //
//  Nullified By        : WTN-WDYL Team                                      //
//  Distribution        : via WebForum, ForumRU and associated file dumps    //
//                                                                           //
//                (C) Copyright 2001-2004 Belchior Foundry                   //
//***************************************************************************//
function remove_remarks($sql)
{
	$lines = explode("\n", $sql);
	$sql = '';
	$linecount = count($lines);
	$output = '';
	for ($i = 0; $i < $linecount; $i++)
	{
		if (($i != ($linecount - 1)) || (strlen($lines[$i]) > 0))
		{
			$output .= ($lines[$i][0] != "#")? $lines[$i] . "\n" : "\n";
			$lines[$i] = '';
		}
	}
	
	return $output;
	
}

function split_sql_file($sql, $delimiter)
{
	$tokens = explode($delimiter, $sql);
	$sql = '';
	$output = array();
	$matches = array();
	$token_count = count($tokens);
	for ($i = 0; $i < $token_count; $i++)
	{
		if (($i != ($token_count - 1)) || (strlen($tokens[$i] > 0)))
		{
			$total_quotes = preg_match_all("/'/", $tokens[$i], $matches);
			$escaped_quotes = preg_match_all("/(?<!\\\\)(\\\\\\\\)*\\\\'/", $tokens[$i], $matches);
			$unescaped_quotes = $total_quotes - $escaped_quotes;
			if (($unescaped_quotes % 2) == 0)
			{
				$output[] = $tokens[$i];
				$tokens[$i] = '';
			} else {
				$temp = $tokens[$i] . $delimiter;
				$tokens[$i] = '';
				$complete_stmt = false;
				for ($j = $i + 1; (!$complete_stmt && ($j < $token_count)); $j++)
				{
					$total_quotes = preg_match_all("/'/", $tokens[$j], $matches);
					$escaped_quotes = preg_match_all("/(?<!\\\\)(\\\\\\\\)*\\\\'/", $tokens[$j], $matches);
					$unescaped_quotes = $total_quotes - $escaped_quotes;
					if (($unescaped_quotes % 2) == 1)
					{
						$output[] = $temp . $tokens[$j];
						$tokens[$j] = '';
						$temp = '';
						$complete_stmt = true;
						$i = $j;
					} else {
						$temp .= $tokens[$j] . $delimiter;
						$tokens[$j] = '';
					}
				}
			}
		}
	}
	return $output;
}


function split_sql($sql) {

	$sql = trim($sql);
	$sql = ereg_replace("\n#[^\n]*\n", "", $sql);
	/* I ran into some problems if there were #'s in my data
	* so I just count \n# as commented lines
	* if you wish to count them all, use the following line:
	* $sql = ereg_replace("#[^\n]*\n", "", $sql);
	*/
	$buffer = array();
	$ret = array();
	$in_string = false;
	for ($i=0; $i<strlen($sql)-1; $i++)
	{
		if ($sql[$i] == ";" && !$in_string)
		{
			$ret[] = substr($sql, 0, $i);
			$sql = substr($sql, $i + 1);
			$i = 0;
		}
		if ($in_string && ($sql[$i] == $in_string) && $buffer[0] != '\\') {
			$in_string = false;
		} elseif (!$in_string && ($sql[$i] =='"' || $sql[$i] == "'") && (!isset($buffer[0]) || $buffer[0] != '\\')) {
			$in_string = $sql[$i];
		}
		if (isset($buffer[1])) {
			$buffer[0] = $buffer[1];
		}
		$buffer[1] = $sql[$i];
	}
	if (!empty($sql)) {
		$ret[] = $sql;
	}
	return($ret);
}

function exec_sql_lines($sql_file, $old_string='', $new_string='') {

	if (!empty($sql_file) && $sql_file != 'none') {
		$sql_query = addslashes(fread(fopen($sql_file, 'rb'), filesize($sql_file)));
		if ($old_string != '') {
			$sql_query = ereg_replace($old_string,$new_string,$sql_query);
		}
	}
	$pieces = split_sql($sql_query);
	if (count($pieces) == 1 && !empty($pieces[0])) {
		$sql_query = trim($pieces[0]);
		exit;
	}
	for ($i=0; $i<count($pieces); $i++) {
		$pieces[$i] = stripslashes(trim($pieces[$i]));
		if (!empty($pieces[$i]) && $pieces[$i] != '#') {
			$result = mysql_query ($pieces[$i]);
		}
	}
	$sql_query = stripslashes($sql_query);
	return true;
}

?>