<?
/*
** =============================================================================================
** Class wrote by teekai everything please contact him at teekai@teekai.info, thanks!
**
** Class name: thumb
** Version: 1.0
** Author: Teekai (teekai@teekai.info)
** Date: Dec 10 2002
**
** define class: $thumb=new thumb;
**
** class varibles:
**   $errWidthImg: the width of error image
**   $errHeightImg: the height of error image
**   $saveDir: true | false (true save to $saveDir, false not save just show)
**   $errReturn: set error, true (return false), false (return true)
**   $cpercent: the compress percent when output
**   $fontSize: font size
**   $bgRGBColor: background color (RGB color)
**   $msgRGBColor: message color (RGB color)
**
** (file 1 if you would like to get query varibles)
** =============================================================================================
*/
class thumb
{
	var $errWidthImg=103;
	var $errHeightImg=73;
	var $saveDir;
	var $saveImg;
	var $errReturn=false;
	var $cPercent=100;
	var $fontSize=1;
	var $bgRGBColor=array(0,128,255);
	var $msgRGBColor=array(0,0,160);

	/*
	** $msg: the message you would like to show in error image
	** $offset: the space of left to right (higher to right and lower to left | 0 all left)
	*/
	function setErr($msg,$offset)
	{
		if($this->saveImg) $this->errReturn=true;
		else 
		{
			$bgRGBColor=$this->bgRGBColor;
			$msgRGBColor=$this->msgRGBColor;

			$im = @imagecreate ($this->errWidthImg, $this->errHeightImg);
			$bgColor = imagecolorallocate ($im, $bgRGBColor[0], $bgRGBColor[1], $bgRGBColor[2]);
			$msgColor = imagecolorallocate ($im, $msgRGBColor[0], $msgRGBColor[1], $msgRGBColor[2]);
			imagefilledrectangle ($im, 0, 0, 90, 70, $bgColor);
			imagestring ($im, $this->fontSize, $offset, 28, $msg, $msgColor);
			header ("Content-type: image/jpeg");
			imagejpeg ($im,'',$this->cPercent);
			imagedestroy ($im);

			return false;
		}
	}

	/*
	** $gdver: the version of GD lib (1 | 2)
	** $src: the path to your image source
	** $desiredw: the width you would like to resize from image source
	** $desiredh: the height you would like to resize from image source
	*/
	function resized($gdver,$src,$desiredw,$desiredh)
	{
		if(!$desiredw||!$desiredh)
			$this->setErr("WIDTH|HIGHT ERR",6);

		$gdarr=array(1,2);
		for($i=0;$i<count($gdarr);$i++)
		{
			if($gdver!=$gdarr[$i])
				$test.="|";
		}
		$exp=explode("|",$test);

		(count($exp)==3)?$this->setErr("GD VER NOT FOUND",5):"";

		$size = @getimagesize($src);

		if (!$size)
		{
			$this->setErr("SRC ERR",30);
			if($this->errReturn) return false;
		}
		else
		{
			(is_string($this->saveImg))?$this->setErr("VAR ERR",30):"";

			($this->saveImg&&!isset($this->saveDir))?$this->setErr("VAR ERR",30):"";

			if ($size[0]>=$size[1]*((float)($desiredw/$desiredh)))
			{
				$newy = round(($size[1] * (float)($desiredw/$size[0])),0);
				$newx = $desiredw;
			}
			else
			{
				$newy = $desiredh;
				$newx = round(($size[0] * (float)($desiredh/$size[1])),0);
			}

			($gdver==1)?$destimg = @imagecreate($newx, $newy ) or die("GD ERR"):$destimg = @imagecreatetruecolor($newx, $newy ) or $this->setErr("GD2 ERR",30);

			if($this->errReturn) return false;

			if ($size[2]==1)
			{
				$sourceimg = imagecreatefromgif ($src);

				($gdver==1)?imagecopyresized($destimg, $sourceimg, 0,0,0,0, $newx, $newy, $size[0], $size[1]):@imagecopyresampled($destimg, $sourceimg, 0,0,0,0, $newx, $newy, $size[0], $size[1]);

				header("content-type: image/gif");

				($this->saveImg)?imagegif($destimg,$this->saveDir."/".$src,100):imagegif($destimg,'',$this->cPercent);

				return true;
			}
			elseif ($size[2]==2)
			{
				$sourceimg = imagecreatefromjpeg ($src);

				($gdver==1)?imagecopyresized($destimg, $sourceimg, 0,0,0,0, $newx, $newy, $size[0], $size[1]):@imagecopyresampled($destimg, $sourceimg, 0,0,0,0, $newx, $newy, $size[0], $size[1]);

				header("content-type: image/jpeg");

				($this->saveImg)?imagejpeg($destimg,$this->saveDir."/".$src,100):imagejpeg($destimg,'',$this->cPercent);

				return true;
			}
			elseif ($size[2]==3)
			{
				$sourceimg = imagecreatefrompng ($src);

				($gdver==1)?imagecopyresized($destimg, $sourceimg, 0,0,0,0, $newx, $newy, $size[0], $size[1]):@imagecopyresampled($destimg, $sourceimg, 0,0,0,0, $newx, $newy, $size[0], $size[1]);

				header("content-type: image/png");

				($this->saveImg)?imagepng($destimg,$this->saveDir."/".$src,100):imagepng($destimg,'',$this->cPercent);
				return true;
			}
			else
				$this->setErr("TYPE ERR",30);

		}

		imagedestroy($destimg);
		imagedestroy($sourceimg);
	}

}


/*
** use class
** (file 2 if you would like to get query varibles)
*/

// defind a class
$thumb=new thumb;

// the dir to save thumb (do not include '/' char at the end)
$thumb->saveDir="thumb";

// true for save thumb image | false just resize image
$thumb->saveImg=false;

/* you can get the query varibles
** save two files, one for class and one for use
** if you save file 2 to resize.php then your query must be:
** resize.php?gdver=2&src=filename.jpg&width=103&height=73
**
** if($thumb->resized($_GET[gdver],$_GET[src],$_GET[width],$_GET[height])) echo"image have saved"; else echo "image haven't saved";
**
*/
#if($thumb->resized(2,"web.png",500,73)) echo"image have saved"; else echo "image haven't saved";
if($thumb->resized($_GET[gdver],$_GET[src],$_GET[width],$_GET[height])) echo"image have saved"; else echo "image haven't saved";
?>