<?php
# Helpdesk software Hesk
# Version: 0.93b from July 5, 2005
# File name: install.php
# File last modified: May 4, 2005
# Written 23rd April 2005 by Klemen Stirn (info@phpjunkyard.com)
# http://www.PHPJunkYard.com

##############################################################################
# COPYRIGHT NOTICE                                                           #
# Copyright 2005 PHPJunkYard All Rights Reserved.                            #
#                                                                            #
# The Hesk may be used and modified free of charge by anyone AS LONG AS      #
# THIS COPYRIGHT NOTICE AND ALL THE COMMENTS REMAIN INTACT. By using this    #
# code you agree to indemnify Klemen Stirn from any liability that might     #
# arise from it's use.                                                       #
#                                                                            #
# Selling the code for this program or any portion of it without prior       #
# written consent is expressly forbidden.                                    #
#                                                                            #
# Obtain permission before redistributing this software over the Internet or #
# in any other medium. In all cases copyright and header must remain intact. #
# This Copyright is in full effect in any country that has International     #
# Trade Agreements with the United States of America or with                 #
# the European Union.                                                        #
##############################################################################

#############################
#     DO NOT EDIT BELOW     #
#############################

define('IN_SCRIPT',1);

/* Get all the required files and functions */
require_once('hesk_settings.inc.php');
require_once('inc/common.inc.php');

?>
<html>
<head>
<title>Hesk Installation</title>
<style type="text/css">
BODY,P,TD {
	background-color: #FFFFFF;
	color : black;
	font-family : Verdana, Geneva, Arial, Helvetica, sans-serif;
	font-size: 12px;
}
.code {
	background-color: #FFFFFF;
	color : black;
	font-family : Courier, 'Courier New', sans-serif;
	font-size: 12px;
}
.important {
	color : #FF0000;
}
</style>
</head>
<body>
<?php

/* What should we do? */
if ($_SERVER['REQUEST_METHOD']=="POST") {
	if ($_POST['a']=="dbtest") {dbtest();}
    else {start_install();}
} else
{
?>
<p class="smaller">Hesk database installation script<br>&nbsp;</p>
</td>
</tr>
<tr>
<td>

<h3 align="center">Welcome to Hesk</h3>

<p>This script will help you install Hesk.</p>

<hr>

<p>This path should be used for <b>$hesk_settings['server_path']</b>:<br>
<?php
$a=preg_match("/(.*?)install\.php$/",$_SERVER['SCRIPT_FILENAME'],$path);
echo <<<EOC
<b>$path[1]</b><br><br>
Correct server_path setting:</p>
<p class="code">\$hesk_settings['server_path'] = '$path[1]';</p>
<p>&nbsp;</p>

EOC;
?>

<hr>

<p><b>Database settings</b></p>

<form action="install.php" method="POST">
<table>
<tr>
<td>Host:</td>
<td><input type="text" name="host" value="<?php echo $hesk_settings['database_host']; ?>"></td>
</tr>
<tr>
<td>Database name:</td>
<td><input type="text" name="name" value="<?php echo $hesk_settings['database_name']; ?>"></td>
</tr>
<tr>
<td>Database user (login):</td>
<td><input type="text" name="user" value="<?php echo $hesk_settings['database_user']; ?>"></td>
</tr>
<tr>
<td>User password:</td>
<td><input type="text" name="pass" value="<?php echo $hesk_settings['database_pass']; ?>"></td>
</tr>
</table>

<p><input type="hidden" name="a" value="dbtest"><input type="submit" value="Test database connection"></p>
</form>

<hr>

<p><font class="important">Before running database table installation read the <b>readme.htm</b>
file for important instructions and setup your <b>hesk_settings.inc.php</b> file!</font></p>

<p><b>Install database tables</b></p>

<form action="install.php" method="POST">
<input type="hidden" name="a" value="install">
<input type="submit" value="Install MySQL tables" class="button">
</form>

<hr>

<p>&nbsp;</p>
<?php
} // End else

?>
<hr>
<p align="center">Hesk Install script (c) Copyright 2005 Klemen Stirn<br>
<a href="http://www.phpjunkyard.com">PHPJunkyard free PHP scripts</a></p>
</body>
</html>
<?php
exit();


/*** START FUNCTIONS ***/

function dbtest() {

$hesk_settings['database_host']=hesk_Input($_POST['host'],"Please enter your MySQL server host name");
$hesk_settings['database_name']=hesk_Input($_POST['name'],"Please enter your MySQL database name");
$hesk_settings['database_user']=hesk_Input($_POST['user'],"Please enter your MySQL user name");
$hesk_settings['database_pass']=hesk_Input($_POST['pass'],"Please enter your MySQL user password");

/* Connect to database */
$hesk_db_link = mysql_connect($hesk_settings['database_host'],$hesk_settings['database_user'], $hesk_settings['database_pass'])
or die("<p>&nbsp;</p><font color=\"#FF0000\">Cannot connect to database, please check your database settings.</font>");

if (!mysql_select_db ($hesk_settings['database_name'], $hesk_db_link))
{die("<p>&nbsp;</p><font color=\"#FF0000\">Cannot select database: $hesk_settings[database_name]</font>");}
?>
<p><b>We've got connection!</b></p>
<p>These are the correct database settings:</p>
<p class="code">
<?php
echo <<<EOC
\$hesk_settings['database_host']  =   "$hesk_settings[database_host]";<br>
\$hesk_settings['database_name']  =   "$hesk_settings[database_name]";<br>
\$hesk_settings['database_user']  =   "$hesk_settings[database_user]";<br>
\$hesk_settings['database_pass']  =   "$hesk_settings[database_pass]";<br>

<p align="center"><a href="install.php">Continue</a></p>

EOC;



} // End dbtest()


function start_install() {
global $hesk_settings;

require_once('inc/database.inc.php');
hesk_dbConnect() or hesk_error("Can't connect to MySQL database!
Please make sure all database settings in hesk_settings.inc.php are correct!");

$sql="CREATE TABLE `hesk_categories` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `name` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM";
$result = hesk_dbQuery($sql) or hesk_error("Couldn't execute SQL: $sql. Please make sure you delete any old installations of Hesk before installing this version!");

$sql="INSERT INTO `hesk_categories` VALUES (1, 'Default')";
$result = hesk_dbQuery($sql) or hesk_error("Couldn't execute SQL: $sql. Please make sure you delete any old installations of Hesk before installing this version!");

$sql=" CREATE TABLE `hesk_replies` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `replyto` varchar(10) NOT NULL default '',
  `name` varchar(30) NOT NULL default '',
  `message` text NOT NULL,
  `dt` datetime default NULL,
  PRIMARY KEY  (`id`),
  KEY `replyto` (`replyto`)
) TYPE=MyISAM";
$result = hesk_dbQuery($sql) or hesk_error("Couldn't execute SQL: $sql. Please make sure you delete any old installations of Hesk before installing this version!");

$sql="CREATE TABLE `hesk_tickets` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `trackid` varchar(10) NOT NULL default '',
  `name` varchar(30) NOT NULL default '',
  `email` varchar(50) NOT NULL default '',
  `category` tinyint(4) NOT NULL default '1',
  `priority` tinyint(4) NOT NULL default '3',
  `subject` varchar(50) NOT NULL default '',
  `message` text NOT NULL,
  `dt` datetime NOT NULL default '0000-00-00 00:00:00',
  `ip` varchar(20) NOT NULL default '',
  `status` char(1) default '1',
  PRIMARY KEY  (`id`),
  KEY `trackid` (`trackid`)
) TYPE=MyISAM";
$result = hesk_dbQuery($sql) or hesk_error("Couldn't execute SQL: $sql. Please make sure you delete any old installations of Hesk before installing this version!");

$sql="CREATE TABLE `hesk_users` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `user` varchar(20) NOT NULL default '',
  `pass` varchar(20) NOT NULL default '',
  `isadmin` char(1) NOT NULL default '0',
  `name` varchar(50) NOT NULL default '',
  `email` varchar(255) NOT NULL default '',
  `signature` varchar(255) NOT NULL default '',
  `categories` varchar(255) NOT NULL default '',
  `notify` char(1) NOT NULL default '1',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM";
$result = hesk_dbQuery($sql) or hesk_error("Couldn't execute SQL: $sql. Please make sure you delete any old installations of Hesk before installing this version!");

$sql="INSERT INTO `hesk_users` VALUES (1, 'Administrator', 'admin', '1', 'Your name', 'you@yourwebsite.com', 'Best regards,\r\n\r\nYour name\r\nYour website\r\nhttp://www.yourwebsite.com', '', '1');";
$result = hesk_dbQuery($sql) or hesk_error("Couldn't execute SQL: $sql. Please make sure you delete any old installations of Hesk before installing this version!");

?>

<p>&nbsp;</p>
<h3 align="center">Install successful</h3>
<p>&nbsp;</p>

<p align="center">You have successfully installed Hesk!</p>
<p>&nbsp;</p>
<p align="center"><font class="important">IMPORTANT: Before continuing DELETE the
<b>install.php</b> and <b>upgrade.php</b> files from your server!</font></p>
<p>&nbsp;<?php
if (!empty($_SERVER['HTTP_HOST'])) {
$u=urlencode($_SERVER['HTTP_HOST']);
} elseif (!empty($_SERVER['SERVER_NAME'])) {
$u=urlencode($_SERVER['SERVER_NAME']);
} else {$u="N/A";}

echo "<img src=\"http://www.phpjunkyard.com/track/t.php?h=$u&s=hesk\" width=1 height=1 border=0></p>";

} // End start_install()

?>